/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.DimenRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.util.ExtensionsKt;
import com.mikepenz.materialdrawer.util.UtilsKt;
import com.mikepenz.materialdrawer.widget.AccountHeaderView;
import com.mikepenz.materialdrawer.widget.MaterialDrawerSliderView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a3\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\u0010\u001f\u001a\u001c\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010!H\u0007\u001a\u0010\u0010$\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u000e\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u001c\u001a`\u0010'\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\b\b\u0003\u0010,\u001a\u00020\u00132\b\b\u0003\u0010-\u001a\u00020\u00132\b\b\u0003\u0010.\u001a\u00020\u00132\b\b\u0003\u0010/\u001a\u00020\u00132\b\b\u0002\u00100\u001a\u00020\u001e\u00a8\u00061"}, d2={"addStickyFooterDivider", "", "ctx", "Landroid/content/Context;", "footerView", "Landroid/view/ViewGroup;", "buildStickyDrawerItemFooter", "sliderView", "Lcom/mikepenz/materialdrawer/widget/MaterialDrawerSliderView;", "onClickListener", "Landroid/view/View$OnClickListener;", "fillStickyDrawerItemFooter", "container", "getIconStateList", "Landroid/graphics/drawable/StateListDrawable;", "icon", "Landroid/graphics/drawable/Drawable;", "selectedIcon", "getOptimalDrawerWidth", "", "context", "getPlaceHolder", "handleFooterView", "handleHeaderView", "onFooterDrawerItemClick", "drawerItem", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "v", "Landroid/view/View;", "fireOnClick", "", "(Lcom/mikepenz/materialdrawer/widget/MaterialDrawerSliderView;Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;Landroid/view/View;Ljava/lang/Boolean;)V", "processDrawerLayoutParams", "Landroidx/drawerlayout/widget/DrawerLayout$LayoutParams;", "drawer", "params", "rebuildStickyFooterView", "setDrawerVerticalPadding", "view", "themeDrawerItem", "selectedColor", "animate", "shapeAppearanceModel", "Lcom/google/android/material/shape/ShapeAppearanceModel;", "paddingTopBottomRes", "paddingStartRes", "paddingEndRes", "highlightColorRes", "isSelected", "materialdrawer"})
@JvmName(name="DrawerUtils")
public final class DrawerUtils {
    /*
     * WARNING - void declaration
     */
    public static final void onFooterDrawerItemClick(@NotNull MaterialDrawerSliderView sliderView, @NotNull IDrawerItem<?> drawerItem, @NotNull View v, @Nullable Boolean fireOnClick) {
        Intrinsics.checkNotNullParameter((Object)((Object)sliderView), (String)"sliderView");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean checkable = drawerItem.isSelectable();
        if (checkable) {
            sliderView.resetStickyFooterSelection$materialdrawer();
            v.setActivated(true);
            v.setSelected(true);
            sliderView.getSelectExtension().deselect();
            if (sliderView.getStickyFooterView() != null && sliderView.getStickyFooterView() instanceof LinearLayout) {
                ViewGroup viewGroup = sliderView.getStickyFooterView();
                if (viewGroup == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout");
                }
                LinearLayout footer = (LinearLayout)viewGroup;
                int n = 0;
                int n2 = footer.getChildCount();
                while (n < n2) {
                    void i;
                    if (footer.getChildAt((int)i) == v) {
                        sliderView.setCurrentStickyFooterSelection$materialdrawer((int)i);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (fireOnClick != null) {
            boolean consumed = false;
            if (fireOnClick.booleanValue()) {
                if (drawerItem instanceof AbstractDrawerItem && ((AbstractDrawerItem)drawerItem).getOnDrawerItemClickListener() != null) {
                    Object object = ((AbstractDrawerItem)drawerItem).getOnDrawerItemClickListener();
                    boolean bl = object != null && (object = (Boolean)object.invoke((Object)v, drawerItem, (Object)-1)) != null ? (Boolean)object : (consumed = false);
                }
                if (sliderView.getOnDrawerItemClickListener() != null) {
                    Object object = sliderView.getOnDrawerItemClickListener();
                    boolean bl = object != null && (object = (Boolean)object.invoke((Object)v, drawerItem, (Object)-1)) != null ? (Boolean)object : (consumed = false);
                }
            }
            if (!consumed) {
                sliderView.closeDrawerDelayed$materialdrawer();
            }
        }
    }

    public static final void handleHeaderView(@NotNull MaterialDrawerSliderView sliderView) {
        block10: {
            AccountHeaderView it;
            boolean bl;
            boolean bl2;
            AccountHeaderView accountHeaderView;
            Intrinsics.checkNotNullParameter((Object)((Object)sliderView), (String)"sliderView");
            AccountHeaderView accountHeaderView2 = sliderView.getAccountHeader();
            if (accountHeaderView2 != null) {
                accountHeaderView = accountHeaderView2;
                bl2 = false;
                bl = false;
                it = accountHeaderView;
                boolean bl3 = false;
                if (sliderView.getAccountHeaderSticky()) {
                    sliderView.setStickyHeaderView((View)it);
                } else {
                    sliderView.set_headerDivider$materialdrawer(it.getDividerBelowHeader());
                    sliderView.set_headerPadding$materialdrawer(it.getPaddingBelowHeader());
                    sliderView.setHeaderView((View)it);
                }
            }
            View view = sliderView.getStickyHeaderView();
            if (view == null) break block10;
            accountHeaderView = view;
            bl2 = false;
            bl = false;
            it = accountHeaderView;
            boolean bl4 = false;
            View view2 = sliderView.findViewById(R.id.material_drawer_sticky_header);
            if (view2 != null) {
                View view3 = view2;
                boolean bl5 = false;
                boolean bl6 = false;
                View header = view3;
                boolean bl7 = false;
                sliderView.removeView(header);
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(10, 1);
            it.setId(R.id.material_drawer_sticky_header);
            sliderView.addView((View)it, 0, (ViewGroup.LayoutParams)layoutParams);
            ViewGroup.LayoutParams layoutParams2 = sliderView.getRecyclerView().getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            RelativeLayout.LayoutParams layoutParamsListView = (RelativeLayout.LayoutParams)layoutParams2;
            layoutParamsListView.addRule(3, R.id.material_drawer_sticky_header);
            sliderView.getRecyclerView().setLayoutParams((ViewGroup.LayoutParams)layoutParamsListView);
            if (sliderView.getStickyHeaderShadow()) {
                if (Build.VERSION.SDK_INT >= 21) {
                    it.setBackground((Drawable)new ColorDrawable(-1));
                    Context context = sliderView.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"sliderView.context");
                    it.setElevation(context.getResources().getDimensionPixelSize(R.dimen.material_drawer_sticky_header_elevation));
                } else {
                    View view4 = new View(sliderView.getContext());
                    view4.setBackgroundResource(R.drawable.material_drawer_shadow_bottom);
                    Context context = sliderView.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"sliderView.context");
                    sliderView.addView(view4, -1, context.getResources().getDimensionPixelSize(R.dimen.material_drawer_sticky_header_elevation));
                    ViewGroup.LayoutParams layoutParams3 = view4.getLayoutParams();
                    if (layoutParams3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                    }
                    RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)layoutParams3;
                    lps.addRule(3, R.id.material_drawer_sticky_header);
                    view4.setLayoutParams((ViewGroup.LayoutParams)lps);
                }
            }
            if (Build.VERSION.SDK_INT >= 21) {
                sliderView.setElevation(0.0f);
            }
            sliderView.getRecyclerView().setPadding(0, 0, 0, 0);
        }
    }

    public static final void rebuildStickyFooterView(@NotNull MaterialDrawerSliderView sliderView) {
        Intrinsics.checkNotNullParameter((Object)((Object)sliderView), (String)"sliderView");
        ViewGroup viewGroup = sliderView.getStickyFooterView();
        if (viewGroup != null) {
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            it.removeAllViews();
            if (sliderView.getStickyFooterDivider()) {
                Context context = it.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"it.context");
                DrawerUtils.addStickyFooterDivider(context, it);
            }
            DrawerUtils.fillStickyDrawerItemFooter(sliderView, it, new View.OnClickListener(sliderView){
                final /* synthetic */ MaterialDrawerSliderView $sliderView$inlined;
                {
                    this.$sliderView$inlined = materialDrawerSliderView;
                }

                public final void onClick(View v) {
                    Object object = v.getTag(R.id.material_drawer_item);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                    }
                    IDrawerItem drawerItem = (IDrawerItem)object;
                    View view = v;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"v");
                    DrawerUtils.onFooterDrawerItemClick(this.$sliderView$inlined, drawerItem, view, true);
                }
            });
            it.setVisibility(0);
        } else {
            boolean bl = false;
            boolean bl4 = false;
            boolean bl5 = false;
            DrawerUtils.handleFooterView(sliderView, new View.OnClickListener(sliderView){
                final /* synthetic */ MaterialDrawerSliderView $sliderView$inlined;
                {
                    this.$sliderView$inlined = materialDrawerSliderView;
                }

                public final void onClick(View v) {
                    Object object = v.getTag(R.id.material_drawer_item);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                    }
                    IDrawerItem drawerItem = (IDrawerItem)object;
                    View view = v;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"v");
                    DrawerUtils.onFooterDrawerItemClick(this.$sliderView$inlined, drawerItem, view, true);
                }
            });
        }
        ExtensionsKt.setStickyFooterSelection(sliderView, sliderView.getCurrentStickyFooterSelection$materialdrawer(), false);
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleFooterView(@NotNull MaterialDrawerSliderView sliderView, @NotNull View.OnClickListener onClickListener) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)sliderView), (String)"sliderView");
            Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
            Context ctx = sliderView.getContext();
            if (sliderView.getStickyDrawerItems().size() > 0) {
                sliderView.set_stickyFooterView$materialdrawer(DrawerUtils.buildStickyDrawerItemFooter(sliderView, onClickListener));
            }
            ViewGroup viewGroup = sliderView.getStickyFooterView();
            if (viewGroup == null) break block4;
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(12, 1);
            it.setId(R.id.material_drawer_sticky_footer);
            sliderView.addView((View)it, (ViewGroup.LayoutParams)layoutParams);
            ViewGroup.LayoutParams layoutParams2 = sliderView.getRecyclerView().getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            RelativeLayout.LayoutParams layoutParamsListView = (RelativeLayout.LayoutParams)layoutParams2;
            layoutParamsListView.addRule(2, R.id.material_drawer_sticky_footer);
            sliderView.getRecyclerView().setLayoutParams((ViewGroup.LayoutParams)layoutParamsListView);
            if (sliderView.getStickyFooterShadow()) {
                void stickyFooterShadowView;
                View view = new View(ctx);
                boolean bl4 = false;
                boolean bl5 = false;
                View view2 = view;
                MaterialDrawerSliderView materialDrawerSliderView = sliderView;
                boolean bl6 = false;
                stickyFooterShadowView.setBackgroundResource(R.drawable.material_drawer_shadow_top);
                Context context = ctx;
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
                sliderView.addView((View)stickyFooterShadowView, -1, context.getResources().getDimensionPixelSize(R.dimen.material_drawer_sticky_footer_elevation));
                ViewGroup.LayoutParams layoutParams3 = stickyFooterShadowView.getLayoutParams();
                if (layoutParams3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                }
                RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)layoutParams3;
                lps.addRule(2, R.id.material_drawer_sticky_footer);
                stickyFooterShadowView.setLayoutParams((ViewGroup.LayoutParams)lps);
                Unit unit = Unit.INSTANCE;
                materialDrawerSliderView.setStickyFooterShadowView(view);
            }
            RecyclerView recyclerView = sliderView.getRecyclerView();
            int n = sliderView.getRecyclerView().getPaddingLeft();
            int n2 = sliderView.getRecyclerView().getPaddingTop();
            int n3 = sliderView.getRecyclerView().getPaddingRight();
            Context context = ctx;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
            recyclerView.setPadding(n, n2, n3, context.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding));
        }
    }

    @NotNull
    public static final ViewGroup buildStickyDrawerItemFooter(@NotNull MaterialDrawerSliderView sliderView, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)sliderView), (String)"sliderView");
        Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
        LinearLayout linearLayout = new LinearLayout(sliderView.getContext());
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(1);
        if (sliderView.getStickyFooterDivider()) {
            Context context = sliderView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"sliderView.context");
            DrawerUtils.addStickyFooterDivider(context, (ViewGroup)linearLayout);
        }
        DrawerUtils.fillStickyDrawerItemFooter(sliderView, (ViewGroup)linearLayout, onClickListener);
        return (ViewGroup)linearLayout;
    }

    private static final void addStickyFooterDivider(Context ctx, ViewGroup footerView) {
        LinearLayout divider = new LinearLayout(ctx);
        LinearLayout.LayoutParams dividerParams = new LinearLayout.LayoutParams(-1, -2);
        divider.setMinimumHeight(ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_sticky_footer_divider));
        divider.setOrientation(1);
        divider.setBackgroundColor(UtilsKt.getDividerColor(ctx));
        footerView.addView((View)divider, (ViewGroup.LayoutParams)dividerParams);
    }

    public static final void fillStickyDrawerItemFooter(@NotNull MaterialDrawerSliderView sliderView, @NotNull ViewGroup container, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)sliderView), (String)"sliderView");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
        for (IDrawerItem<?> drawerItem : sliderView.getStickyDrawerItems()) {
            Context context = container.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"container.context");
            View view = drawerItem.generateView(context, container);
            view.setTag(drawerItem);
            if (drawerItem.isEnabled()) {
                view.setOnClickListener(onClickListener);
            }
            container.addView(view);
            DrawerUtils.setDrawerVerticalPadding(view);
        }
        container.setPadding(0, 0, 0, 0);
    }

    @SuppressLint(value={"RtlHardcoded"})
    @Nullable
    public static final DrawerLayout.LayoutParams processDrawerLayoutParams(@NotNull MaterialDrawerSliderView drawer, @Nullable DrawerLayout.LayoutParams params) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawer), (String)"drawer");
        if (params != null) {
            int customWidth;
            DrawerLayout drawerLayout = drawer.getDrawerLayout();
            if (drawerLayout == null) {
                return null;
            }
            DrawerLayout drawerLayout2 = drawerLayout;
            Context ctx = drawerLayout2.getContext();
            ViewGroup.LayoutParams layoutParams = drawerLayout2.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.drawerlayout.widget.DrawerLayout.LayoutParams");
            }
            DrawerLayout.LayoutParams lp = (DrawerLayout.LayoutParams)layoutParams;
            if (lp.gravity == 5 || lp.gravity == 0x800005) {
                params.rightMargin = 0;
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginEnd(0);
                }
                Context context = ctx;
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
                params.leftMargin = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_margin);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginEnd(ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_margin));
                }
            }
            Integer n = drawer.getCustomWidth();
            int n2 = customWidth = n != null ? n : -1;
            if (customWidth > -1) {
                params.width = customWidth;
            } else {
                Context context = ctx;
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
                params.width = DrawerUtils.getOptimalDrawerWidth(context);
            }
        }
        return params;
    }

    @NotNull
    public static final Drawable getPlaceHolder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable2 = AppCompatResources.getDrawable((Context)context, (int)R.drawable.material_drawer_ico_account_layer);
        if (drawable2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }
        LayerDrawable accountDrawable = (LayerDrawable)drawable2;
        int placeholderSize = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_profile_icon_placeholder);
        if (Build.VERSION.SDK_INT >= 23) {
            accountDrawable.setLayerWidth(0, placeholderSize);
            accountDrawable.setLayerHeight(0, placeholderSize);
        }
        Drawable drawable3 = DrawableCompat.wrap((Drawable)accountDrawable.getDrawable(0));
        boolean bl = false;
        boolean bl2 = false;
        Drawable it = drawable3;
        boolean bl3 = false;
        DrawableCompat.setTint((Drawable)it, (int)UtilsKt.getThemeColor$default(context, R.attr.colorPrimary, 0, 2, null));
        accountDrawable.setDrawableByLayerId(R.id.background, it);
        int iconSize = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_profile_icon_placeholder_icon);
        if (Build.VERSION.SDK_INT >= 23) {
            accountDrawable.setLayerWidth(1, iconSize);
            accountDrawable.setLayerHeight(1, iconSize);
            accountDrawable.setLayerGravity(1, 17);
        }
        Drawable drawable4 = DrawableCompat.wrap((Drawable)accountDrawable.getDrawable(1));
        bl2 = false;
        boolean bl4 = false;
        Drawable it2 = drawable4;
        boolean bl5 = false;
        DrawableCompat.setTint((Drawable)it2, (int)UtilsKt.getThemeColor$default(context, R.attr.colorAccent, 0, 2, null));
        accountDrawable.setDrawableByLayerId(R.id.account, it2);
        return (Drawable)accountDrawable;
    }

    public static final void setDrawerVerticalPadding(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        int verticalPadding = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        view.setPadding(verticalPadding, 0, verticalPadding, 0);
    }

    public static final void themeDrawerItem(@NotNull Context ctx, @NotNull View view, int selectedColor, boolean animate, @NotNull ShapeAppearanceModel shapeAppearanceModel, @DimenRes int paddingTopBottomRes, @DimenRes int paddingStartRes, @DimenRes int paddingEndRes, @AttrRes int highlightColorRes, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
        Drawable selected = null;
        Drawable unselected = null;
        int paddingTopBottom = ctx.getResources().getDimensionPixelSize(paddingTopBottomRes);
        int paddingStart = ctx.getResources().getDimensionPixelSize(paddingStartRes);
        int paddingEnd = ctx.getResources().getDimensionPixelSize(paddingEndRes);
        MaterialShapeDrawable gradientDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
        gradientDrawable.setFillColor(ColorStateList.valueOf((int)selectedColor));
        selected = (Drawable)new InsetDrawable((Drawable)gradientDrawable, paddingStart, paddingTopBottom, paddingEnd, paddingTopBottom);
        if (Build.VERSION.SDK_INT >= 21) {
            MaterialShapeDrawable gradientMask = new MaterialShapeDrawable(shapeAppearanceModel);
            gradientMask.setFillColor(ColorStateList.valueOf((int)-16777216));
            InsetDrawable mask = new InsetDrawable((Drawable)gradientMask, paddingStart, paddingTopBottom, paddingEnd, paddingTopBottom);
            unselected = (Drawable)new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{UtilsKt.getThemeColor$default(ctx, highlightColorRes, 0, 2, null)}), null, (Drawable)mask);
        } else {
            MaterialShapeDrawable touchDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
            touchDrawable.setFillColor(ColorStateList.valueOf((int)UtilsKt.getThemeColor$default(ctx, highlightColorRes, 0, 2, null)));
            InsetDrawable touchInsetDrawable = new InsetDrawable((Drawable)touchDrawable, paddingStart, paddingTopBottom, paddingEnd, paddingTopBottom);
            StateListDrawable unselectedStates = new StateListDrawable();
            if (animate) {
                int duration = ctx.getResources().getInteger(0x10E0000);
                unselectedStates.setEnterFadeDuration(duration);
                unselectedStates.setExitFadeDuration(duration);
            }
            unselectedStates.addState(new int[]{16842919}, (Drawable)touchInsetDrawable);
            unselectedStates.addState(new int[0], (Drawable)new ColorDrawable(0));
            unselected = (Drawable)unselectedStates;
        }
        StateListDrawable states = new StateListDrawable();
        if (animate) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            states.addState(new int[]{0x10100A1}, selected);
            states.addState(new int[0], (Drawable)new ColorDrawable(0));
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)states));
            view.setForeground(unselected);
        } else {
            states.addState(new int[]{0x10100A1}, selected);
            states.addState(new int[0], unselected);
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)states));
        }
        if (isSelected && animate) {
            states.setState(new int[]{0x10100A1});
            states.jumpToCurrentState();
        }
    }

    public static /* synthetic */ void themeDrawerItem$default(Context context, View view, int n, boolean bl, ShapeAppearanceModel shapeAppearanceModel, int n2, int n3, int n4, int n5, boolean bl2, int n6, Object object) {
        if ((n6 & 0x20) != 0) {
            n2 = R.dimen.material_drawer_item_background_padding_top_bottom;
        }
        if ((n6 & 0x40) != 0) {
            n3 = R.dimen.material_drawer_item_background_padding_start;
        }
        if ((n6 & 0x80) != 0) {
            n4 = R.dimen.material_drawer_item_background_padding_end;
        }
        if ((n6 & 0x100) != 0) {
            n5 = R.attr.colorControlHighlight;
        }
        if ((n6 & 0x200) != 0) {
            bl2 = false;
        }
        DrawerUtils.themeDrawerItem(context, view, n, bl, shapeAppearanceModel, n2, n3, n4, n5, bl2);
    }

    @NotNull
    public static final StateListDrawable getIconStateList(@NotNull Drawable icon, @NotNull Drawable selectedIcon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)selectedIcon, (String)"selectedIcon");
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        iconStateListDrawable.addState(new int[0], icon);
        return iconStateListDrawable;
    }

    public static final int getOptimalDrawerWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int possibleMinDrawerWidth = UtilsKt.getScreenWidth(context) - UtilsKt.getActionBarHeight(context);
        int maxDrawerWidth = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_width);
        return RangesKt.coerceAtMost((int)possibleMinDrawerWidth, (int)maxDrawerWidth);
    }
}

