/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.util.UtilsKt;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR2\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/mikepenz/materialdrawer/util/DrawerItemViewHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "divider", "", "getDivider", "()Z", "setDivider", "(Z)V", "drawerItems", "Ljava/util/ArrayList;", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "getDrawerItems", "()Ljava/util/ArrayList;", "onDrawerItemClickListener", "Lkotlin/Function2;", "Landroid/view/View;", "", "getOnDrawerItemClickListener", "()Lkotlin/jvm/functions/Function2;", "setOnDrawerItemClickListener", "(Lkotlin/jvm/functions/Function2;)V", "build", "materialdrawer"})
public class DrawerItemViewHelper {
    @NotNull
    private final ArrayList<IDrawerItem<?>> drawerItems;
    private boolean divider;
    @Nullable
    private Function2<? super View, ? super IDrawerItem<?>, Unit> onDrawerItemClickListener;
    private final Context context;

    @NotNull
    public final ArrayList<IDrawerItem<?>> getDrawerItems() {
        return this.drawerItems;
    }

    public final boolean getDivider() {
        return this.divider;
    }

    public final void setDivider(boolean bl) {
        this.divider = bl;
    }

    @Nullable
    public final Function2<View, IDrawerItem<?>, Unit> getOnDrawerItemClickListener() {
        return this.onDrawerItemClickListener;
    }

    public final void setOnDrawerItemClickListener(@Nullable Function2<? super View, ? super IDrawerItem<?>, Unit> function2) {
        this.onDrawerItemClickListener = function2;
    }

    @NotNull
    public final View build() {
        LinearLayout linearLayout = new LinearLayout(this.context);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(1);
        if (this.divider) {
            LinearLayout divider = new LinearLayout(this.context);
            divider.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            divider.setMinimumHeight(this.context.getResources().getDimensionPixelSize(R.dimen.material_drawer_sticky_footer_divider));
            divider.setOrientation(1);
            divider.setBackgroundColor(UtilsKt.getDividerColor(this.context));
            linearLayout.addView((View)divider);
        }
        for (IDrawerItem<?> drawerItem : this.drawerItems) {
            View view = drawerItem.generateView(this.context);
            view.setTag(drawerItem);
            if (drawerItem.isEnabled()) {
                view.setBackgroundResource(UtilsKt.getSelectableBackgroundRes(this.context));
                view.setOnClickListener(new View.OnClickListener(this){
                    final /* synthetic */ DrawerItemViewHelper this$0;

                    public final void onClick(View v) {
                        block1: {
                            Function2<View, IDrawerItem<?>, Unit> function2 = this.this$0.getOnDrawerItemClickListener();
                            if (function2 == null) break block1;
                            View view = v;
                            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"v");
                            Object object = v.getTag(R.id.material_drawer_item);
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                            }
                            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)view, (Object)((IDrawerItem)object));
                        }
                    }
                    {
                        this.this$0 = drawerItemViewHelper;
                    }
                });
            }
            linearLayout.addView(view);
        }
        return (View)linearLayout;
    }

    public DrawerItemViewHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.drawerItems = new ArrayList();
        this.divider = true;
    }
}

