/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DimenRes;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUtils;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00022\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0010\u00101\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\"H\u0007J\u0010\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\"H\u0007J\u0012\u00106\u001a\u00020\u00002\b\b\u0001\u00107\u001a\u00020\"H\u0007J\u0010\u00108\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006:"}, d2={"Lcom/mikepenz/materialdrawer/model/MiniDrawerItem;", "Lcom/mikepenz/materialdrawer/model/BaseDrawerItem;", "Lcom/mikepenz/materialdrawer/model/MiniDrawerItem$ViewHolder;", "primaryDrawerItem", "Lcom/mikepenz/materialdrawer/model/PrimaryDrawerItem;", "(Lcom/mikepenz/materialdrawer/model/PrimaryDrawerItem;)V", "secondaryDrawerItem", "Lcom/mikepenz/materialdrawer/model/SecondaryDrawerItem;", "(Lcom/mikepenz/materialdrawer/model/SecondaryDrawerItem;)V", "badge", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getBadge", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setBadge", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "badgeStyle", "Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "getBadgeStyle", "()Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "setBadgeStyle", "(Lcom/mikepenz/materialdrawer/holder/BadgeStyle;)V", "customHeight", "Lcom/mikepenz/materialdrawer/holder/DimenHolder;", "getCustomHeight", "()Lcom/mikepenz/materialdrawer/holder/DimenHolder;", "setCustomHeight", "(Lcom/mikepenz/materialdrawer/holder/DimenHolder;)V", "enableSelectedBackground", "", "getEnableSelectedBackground", "()Z", "setEnableSelectedBackground", "(Z)V", "layoutRes", "", "getLayoutRes", "()I", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "v", "Landroid/view/View;", "unbindView", "withCustomHeight", "withCustomHeightDp", "customHeightDp", "withCustomHeightPx", "customHeightPx", "withCustomHeightRes", "customHeightRes", "withEnableSelectedBackground", "ViewHolder", "materialdrawer"})
public class MiniDrawerItem
extends BaseDrawerItem<MiniDrawerItem, ViewHolder> {
    @Nullable
    private StringHolder badge;
    @Nullable
    private BadgeStyle badgeStyle;
    private boolean enableSelectedBackground;
    @Nullable
    private DimenHolder customHeight;

    @Nullable
    public final StringHolder getBadge() {
        return this.badge;
    }

    public final void setBadge(@Nullable StringHolder stringHolder) {
        this.badge = stringHolder;
    }

    @Nullable
    public final BadgeStyle getBadgeStyle() {
        return this.badgeStyle;
    }

    public final void setBadgeStyle(@Nullable BadgeStyle badgeStyle) {
        this.badgeStyle = badgeStyle;
    }

    public final boolean getEnableSelectedBackground() {
        return this.enableSelectedBackground;
    }

    public final void setEnableSelectedBackground(boolean bl) {
        this.enableSelectedBackground = bl;
    }

    @Nullable
    public final DimenHolder getCustomHeight() {
        return this.customHeight;
    }

    public final void setCustomHeight(@Nullable DimenHolder dimenHolder) {
        this.customHeight = dimenHolder;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_mini;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_mini;
    }

    @Deprecated(message="Please consider to replace with the actual property setter")
    @NotNull
    public final MiniDrawerItem withCustomHeightRes(@DimenRes int customHeightRes) {
        this.customHeight = DimenHolder.Companion.fromResource(customHeightRes);
        return this;
    }

    @Deprecated(message="Please consider to replace with the actual property setter")
    @NotNull
    public final MiniDrawerItem withCustomHeightDp(int customHeightDp) {
        this.customHeight = DimenHolder.Companion.fromDp(customHeightDp);
        return this;
    }

    @Deprecated(message="Please consider to replace with the actual property setter")
    @NotNull
    public final MiniDrawerItem withCustomHeightPx(int customHeightPx) {
        this.customHeight = DimenHolder.Companion.fromPixel(customHeightPx);
        return this;
    }

    @Deprecated(message="Please consider to replace with the actual property setter")
    @NotNull
    public final MiniDrawerItem withCustomHeight(@NotNull DimenHolder customHeight) {
        Intrinsics.checkNotNullParameter((Object)customHeight, (String)"customHeight");
        this.customHeight = customHeight;
        return this;
    }

    @Deprecated(message="Please consider to replace with the actual property setter")
    @NotNull
    public final MiniDrawerItem withEnableSelectedBackground(boolean enableSelectedBackground) {
        this.enableSelectedBackground = enableSelectedBackground;
        return this;
    }

    @Override
    public void bindView(@NotNull ViewHolder holder, @NotNull List<? extends Object> payloads) {
        boolean loaded;
        boolean bl;
        ImageHolder imageHolder;
        boolean badgeVisible;
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        View view = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
        Context ctx = view.getContext();
        DimenHolder dimenHolder = this.customHeight;
        if (dimenHolder != null) {
            DimenHolder dimenHolder2 = dimenHolder;
            boolean bl2 = false;
            boolean bl3 = false;
            DimenHolder it = dimenHolder2;
            boolean bl4 = false;
            View view2 = holder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"holder.itemView");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView.LayoutParams");
            }
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)layoutParams;
            Context context = ctx;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
            lp.height = it.asPixel(context);
            View view3 = holder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"holder.itemView");
            view3.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        View view4 = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"holder.itemView");
        view4.setId(this.hashCode());
        View view5 = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"holder.itemView");
        view5.setEnabled(this.isEnabled());
        holder.getIcon$materialdrawer().setEnabled(this.isEnabled());
        View view6 = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"holder.itemView");
        view6.setSelected(this.isSelected());
        holder.getIcon$materialdrawer().setSelected(this.isSelected());
        View view7 = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"holder.itemView");
        view7.setTag((Object)this);
        Context context = ctx;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
        ColorStateList iconColor = this.getIconColor(context);
        ShapeAppearanceModel shapeAppearanceModel = this.getShapeAppearanceModel(ctx);
        if (this.enableSelectedBackground) {
            int selectedColor = this.getSelectedColor(ctx);
            DrawerUtils.themeDrawerItem$default(ctx, holder.getView$materialdrawer(), selectedColor, this.isSelectedBackgroundAnimated(), shapeAppearanceModel, 0, 0, 0, 0, this.isSelected(), 480, null);
        }
        if (badgeVisible = StringHolder.Companion.applyToOrHide(this.badge, holder.getBadge$materialdrawer())) {
            BadgeStyle badgeStyle = this.badgeStyle;
            if (badgeStyle != null) {
                BadgeStyle.style$default(badgeStyle, holder.getBadge$materialdrawer(), null, 2, null);
            }
        }
        if ((imageHolder = this.getIcon()) != null && (imageHolder = imageHolder.getUri()) != null) {
            ImageHolder bl4 = imageHolder;
            boolean lp = false;
            boolean bl5 = false;
            ImageHolder it = bl4;
            boolean bl6 = false;
            bl = DrawerImageLoader.Companion.getInstance().setImage(holder.getIcon$materialdrawer(), (Uri)it, DrawerImageLoader.Tags.MINI_ITEM.name());
        } else {
            bl = loaded = false;
        }
        if (!loaded) {
            Drawable icon = ImageHolder.Companion.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1);
            Drawable selectedIcon = ImageHolder.Companion.decideIcon(this.getSelectedIcon(), ctx, iconColor, this.isIconTinted(), 1);
            ImageHolder.Companion.applyMultiIconTo(icon, selectedIcon, iconColor, this.isIconTinted(), holder.getIcon$materialdrawer());
        }
        int verticalPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
        int topBottomPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_mini_drawer_item_padding);
        holder.itemView.setPadding(verticalPadding, topBottomPadding, verticalPadding, topBottomPadding);
        IDrawerItem iDrawerItem = this;
        View view8 = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"holder.itemView");
        this.onPostBindView(iDrawerItem, view8);
    }

    @Override
    public void unbindView(@NotNull ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.unbindView((RecyclerView.ViewHolder)holder);
        DrawerImageLoader.Companion.getInstance().cancelImage(holder.getIcon$materialdrawer());
        holder.getIcon$materialdrawer().setImageBitmap(null);
    }

    @Override
    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    public MiniDrawerItem(@NotNull PrimaryDrawerItem primaryDrawerItem) {
        Intrinsics.checkNotNullParameter((Object)primaryDrawerItem, (String)"primaryDrawerItem");
        this.badgeStyle = new BadgeStyle();
        this.setIdentifier(primaryDrawerItem.getIdentifier());
        this.setTag(primaryDrawerItem.getTag());
        this.badge = primaryDrawerItem.getBadge();
        this.badgeStyle = primaryDrawerItem.getBadgeStyle();
        this.setEnabled(primaryDrawerItem.isEnabled());
        this.setSelectable(primaryDrawerItem.isSelectable());
        this.setSelected(primaryDrawerItem.isSelected());
        this.setIcon(primaryDrawerItem.getIcon());
        this.setSelectedIcon(primaryDrawerItem.getSelectedIcon());
        this.setIconTinted(primaryDrawerItem.isIconTinted());
        this.setSelectedColor(primaryDrawerItem.getSelectedColor());
        this.setIconColor(primaryDrawerItem.getIconColor());
    }

    public MiniDrawerItem(@NotNull SecondaryDrawerItem secondaryDrawerItem) {
        Intrinsics.checkNotNullParameter((Object)secondaryDrawerItem, (String)"secondaryDrawerItem");
        this.badgeStyle = new BadgeStyle();
        this.setIdentifier(secondaryDrawerItem.getIdentifier());
        this.setTag(secondaryDrawerItem.getTag());
        this.badge = secondaryDrawerItem.getBadge();
        this.badgeStyle = secondaryDrawerItem.getBadgeStyle();
        this.setEnabled(secondaryDrawerItem.isEnabled());
        this.setSelectable(secondaryDrawerItem.isSelectable());
        this.setSelected(secondaryDrawerItem.isSelected());
        this.setIcon(secondaryDrawerItem.getIcon());
        this.setSelectedIcon(secondaryDrawerItem.getSelectedIcon());
        this.setIconTinted(secondaryDrawerItem.isIconTinted());
        this.setSelectedColor(secondaryDrawerItem.getSelectedColor());
        this.setIconColor(secondaryDrawerItem.getIconColor());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/mikepenz/materialdrawer/model/MiniDrawerItem$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "badge", "Landroid/widget/TextView;", "getBadge$materialdrawer", "()Landroid/widget/TextView;", "icon", "Landroid/widget/ImageView;", "getIcon$materialdrawer", "()Landroid/widget/ImageView;", "getView$materialdrawer", "()Landroid/view/View;", "materialdrawer"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView icon;
        @NotNull
        private final TextView badge;
        @NotNull
        private final View view;

        @NotNull
        public final ImageView getIcon$materialdrawer() {
            return this.icon;
        }

        @NotNull
        public final TextView getBadge$materialdrawer() {
            return this.badge;
        }

        @NotNull
        public final View getView$materialdrawer() {
            return this.view;
        }

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
            this.view = view;
            View view2 = this.view.findViewById(R.id.material_drawer_icon);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById<ImageV\u2026.id.material_drawer_icon)");
            this.icon = (ImageView)view2;
            View view3 = this.view.findViewById(R.id.material_drawer_badge);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.findViewById<TextVi\u2026id.material_drawer_badge)");
            this.badge = (TextView)view3;
        }
    }
}

