/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.Describable;
import com.mikepenz.materialdrawer.model.interfaces.DescribableColor;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUtils;
import com.mikepenz.materialdrawer.util.ExtensionsKt;
import com.mikepenz.materialdrawer.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\u00020\u00052\u00020\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0003H\u0004J\u0015\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010$R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/mikepenz/materialdrawer/model/BaseDescribeableDrawerItem;", "T", "VH", "Lcom/mikepenz/materialdrawer/model/BaseViewHolder;", "Lcom/mikepenz/materialdrawer/model/BaseDrawerItem;", "Lcom/mikepenz/materialdrawer/model/interfaces/Describable;", "Lcom/mikepenz/materialdrawer/model/interfaces/DescribableColor;", "()V", "description", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getDescription", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setDescription", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "descriptionTextColor", "Landroid/content/res/ColorStateList;", "getDescriptionTextColor", "()Landroid/content/res/ColorStateList;", "setDescriptionTextColor", "(Landroid/content/res/ColorStateList;)V", "applyDrawerItemTheme", "", "ctx", "Landroid/content/Context;", "view", "Landroid/view/View;", "selected_color", "", "animate", "", "shapeAppearanceModel", "Lcom/google/android/material/shape/ShapeAppearanceModel;", "bindViewHelper", "viewHolder", "unbindView", "holder", "(Lcom/mikepenz/materialdrawer/model/BaseViewHolder;)V", "materialdrawer"})
public abstract class BaseDescribeableDrawerItem<T, VH extends BaseViewHolder>
extends BaseDrawerItem<T, VH>
implements Describable,
DescribableColor {
    @Nullable
    private StringHolder description;
    @Nullable
    private ColorStateList descriptionTextColor;

    @Override
    @Nullable
    public StringHolder getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(@Nullable StringHolder stringHolder) {
        this.description = stringHolder;
    }

    @Override
    @Nullable
    public ColorStateList getDescriptionTextColor() {
        return this.descriptionTextColor;
    }

    @Override
    public void setDescriptionTextColor(@Nullable ColorStateList colorStateList) {
        this.descriptionTextColor = colorStateList;
    }

    protected final void bindViewHelper(@NotNull BaseViewHolder viewHolder) {
        boolean loaded;
        boolean bl;
        ImageHolder imageHolder;
        ColorStateList colorStateList;
        ColorStateList textColorSecondary;
        ColorStateList colorStateList2;
        ColorStateList textColor;
        ColorStateList colorStateList3;
        int selectedColor;
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        View view = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewHolder.itemView");
        Context ctx = view.getContext();
        View view2 = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"viewHolder.itemView");
        view2.setId(this.hashCode());
        ColorHolder colorHolder = this.getSelectedColor();
        if (colorHolder != null) {
            Context context = ctx;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
            n = colorHolder.color(context);
        } else {
            Context context = ctx;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ctx");
            n = selectedColor = this.getSelectedColor(context);
        }
        if ((colorStateList3 = this.getTextColor()) == null) {
            colorStateList3 = textColor = this.getColor(ctx);
        }
        if ((colorStateList2 = this.getDescriptionTextColor()) == null) {
            colorStateList2 = textColorSecondary = UtilsKt.getSecondaryDrawerTextColor(ctx);
        }
        if ((colorStateList = this.getIconColor()) == null) {
            colorStateList = this.getIconColor(ctx);
        }
        ColorStateList iconColor = colorStateList;
        ShapeAppearanceModel shapeAppearanceModel = this.getShapeAppearanceModel(ctx);
        this.applyDrawerItemTheme(ctx, viewHolder.getView$materialdrawer(), selectedColor, this.isSelectedBackgroundAnimated(), shapeAppearanceModel);
        StringHolder.Companion.applyTo(this.getName(), viewHolder.getName$materialdrawer());
        StringHolder.Companion.applyToOrHide(this.getDescription(), viewHolder.getDescription$materialdrawer());
        viewHolder.getName$materialdrawer().setTextColor(textColor);
        viewHolder.getDescription$materialdrawer().setTextColor(textColorSecondary);
        if (this.getTypeface() != null) {
            viewHolder.getName$materialdrawer().setTypeface(this.getTypeface());
            viewHolder.getDescription$materialdrawer().setTypeface(this.getTypeface());
        }
        if ((imageHolder = this.getIcon()) != null && (imageHolder = imageHolder.getUri()) != null) {
            ImageHolder imageHolder2 = imageHolder;
            boolean bl2 = false;
            boolean bl3 = false;
            ImageHolder it = imageHolder2;
            boolean bl4 = false;
            bl = DrawerImageLoader.Companion.getInstance().setImage(viewHolder.getIcon$materialdrawer(), (Uri)it, DrawerImageLoader.Tags.PRIMARY_ITEM.name());
        } else {
            bl = loaded = false;
        }
        if (!loaded) {
            Drawable icon = ImageHolder.Companion.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1);
            Drawable selectedIcon = ImageHolder.Companion.decideIcon(this.getSelectedIcon(), ctx, iconColor, this.isIconTinted(), 1);
            ImageHolder.Companion.applyMultiIconTo(icon, selectedIcon, iconColor, this.isIconTinted(), viewHolder.getIcon$materialdrawer());
        }
        ExtensionsKt.setDrawerVerticalPadding(viewHolder.getView$materialdrawer(), this.getLevel());
        View view3 = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"viewHolder.itemView");
        view3.setSelected(this.isSelected());
        viewHolder.getName$materialdrawer().setSelected(this.isSelected());
        viewHolder.getDescription$materialdrawer().setSelected(this.isSelected());
        viewHolder.getIcon$materialdrawer().setSelected(this.isSelected());
        View view4 = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"viewHolder.itemView");
        view4.setEnabled(this.isEnabled());
        viewHolder.getName$materialdrawer().setEnabled(this.isEnabled());
        viewHolder.getDescription$materialdrawer().setEnabled(this.isEnabled());
        viewHolder.getIcon$materialdrawer().setEnabled(this.isEnabled());
    }

    @Override
    public void unbindView(@NotNull VH holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.unbindView((RecyclerView.ViewHolder)holder);
        DrawerImageLoader.Companion.getInstance().cancelImage(((BaseViewHolder)((Object)holder)).getIcon$materialdrawer());
        ((BaseViewHolder)((Object)holder)).getIcon$materialdrawer().setImageBitmap(null);
    }

    protected void applyDrawerItemTheme(@NotNull Context ctx, @NotNull View view, int selected_color, boolean animate, @NotNull ShapeAppearanceModel shapeAppearanceModel) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
        DrawerUtils.themeDrawerItem$default(ctx, view, selected_color, animate, shapeAppearanceModel, 0, 0, 0, 0, this.isSelected(), 480, null);
    }
}

