/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.holder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUtils;
import com.mikepenz.materialdrawer.util.FixStateListDrawable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0011\b\u0016\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0011\b\u0016\u0012\b\b\u0001\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0004H\u0017J,\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020 2\b\b\u0002\u0010*\u001a\u00020\u0010H\u0016R(\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u000eR(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u000bR$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0011R(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\b\u00a8\u0006,"}, d2={"Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "", "()V", "url", "", "(Ljava/lang/String;)V", "uri", "Landroid/net/Uri;", "(Landroid/net/Uri;)V", "icon", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "iconRes", "", "(I)V", "<set-?>", "getBitmap", "()Landroid/graphics/Bitmap;", "setBitmap$materialdrawer", "getIcon", "()Landroid/graphics/drawable/Drawable;", "setIcon$materialdrawer", "getIconRes", "()I", "setIconRes$materialdrawer", "getUri", "()Landroid/net/Uri;", "setUri$materialdrawer", "applyTo", "", "imageView", "Landroid/widget/ImageView;", "tag", "decideIcon", "ctx", "Landroid/content/Context;", "iconColor", "Landroid/content/res/ColorStateList;", "tint", "paddingDp", "Companion", "materialdrawer"})
public class ImageHolder {
    @Nullable
    private Uri uri;
    @Nullable
    private Drawable icon;
    @Nullable
    private Bitmap bitmap;
    private int iconRes;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Uri getUri() {
        return this.uri;
    }

    public final void setUri$materialdrawer(@Nullable Uri uri) {
        this.uri = uri;
    }

    @Nullable
    public final Drawable getIcon() {
        return this.icon;
    }

    public final void setIcon$materialdrawer(@Nullable Drawable drawable2) {
        this.icon = drawable2;
    }

    @Nullable
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    public final void setBitmap$materialdrawer(@Nullable Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public final int getIconRes() {
        return this.iconRes;
    }

    public final void setIconRes$materialdrawer(int n) {
        this.iconRes = n;
    }

    @JvmOverloads
    public boolean applyTo(@NotNull ImageView imageView, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Uri uri = this.uri;
        if (uri != null) {
            boolean consumed = DrawerImageLoader.Companion.getInstance().setImage(imageView, uri, tag);
            if (!consumed) {
                imageView.setImageURI(uri);
            }
        } else if (this.icon != null) {
            imageView.setImageDrawable(this.icon);
        } else if (this.bitmap != null) {
            imageView.setImageBitmap(this.bitmap);
        } else if (this.iconRes != -1) {
            imageView.setImageResource(this.iconRes);
        } else {
            imageView.setImageBitmap(null);
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean applyTo$default(ImageHolder imageHolder, ImageView imageView, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyTo");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return imageHolder.applyTo(imageView, string2);
    }

    @JvmOverloads
    public final boolean applyTo(@NotNull ImageView imageView) {
        return ImageHolder.applyTo$default(this, imageView, null, 2, null);
    }

    @Nullable
    public Drawable decideIcon(@NotNull Context ctx, @NotNull ColorStateList iconColor, boolean tint, int paddingDp) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        Drawable icon = this.icon;
        if (this.iconRes != -1) {
            icon = ContextCompat.getDrawable((Context)ctx, (int)this.iconRes);
        } else if (this.uri != null) {
            try {
                ContentResolver contentResolver = ctx.getContentResolver();
                Uri uri = this.uri;
                Intrinsics.checkNotNull((Object)uri);
                InputStream inputStream = contentResolver.openInputStream(uri);
                Uri uri2 = this.uri;
                Intrinsics.checkNotNull((Object)uri2);
                icon = Drawable.createFromStream((InputStream)inputStream, (String)uri2.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (this.bitmap != null) {
            icon = (Drawable)new BitmapDrawable(ctx.getResources(), this.bitmap);
        }
        if (icon != null && tint) {
            icon = icon.mutate();
            icon.setColorFilter(iconColor.getDefaultColor(), PorterDuff.Mode.SRC_IN);
        }
        return icon;
    }

    public static /* synthetic */ Drawable decideIcon$default(ImageHolder imageHolder, Context context, ColorStateList colorStateList, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decideIcon");
        }
        if ((n2 & 8) != 0) {
            n = 1;
        }
        return imageHolder.decideIcon(context, colorStateList, bl, n);
    }

    protected ImageHolder() {
        this.iconRes = -1;
    }

    public ImageHolder(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.iconRes = -1;
        this.uri = Uri.parse((String)url);
    }

    public ImageHolder(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.iconRes = -1;
        this.uri = uri;
    }

    public ImageHolder(@Nullable Drawable icon) {
        this.iconRes = -1;
        this.icon = icon;
    }

    public ImageHolder(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.iconRes = -1;
        this.bitmap = bitmap;
    }

    public ImageHolder(@DrawableRes int iconRes) {
        this.iconRes = -1;
        this.iconRes = iconRes;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ2\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\u0014\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J&\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J(\u0010\u0018\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J4\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u001c"}, d2={"Lcom/mikepenz/materialdrawer/holder/ImageHolder$Companion;", "", "()V", "applyDecidedIconOrSetGone", "", "imageHolder", "Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "imageView", "Landroid/widget/ImageView;", "iconColor", "Landroid/content/res/ColorStateList;", "tint", "", "paddingDp", "", "applyMultiIconTo", "icon", "Landroid/graphics/drawable/Drawable;", "selectedIcon", "tinted", "applyTo", "tag", "", "applyToOrSetGone", "applyToOrSetInvisible", "decideIcon", "ctx", "Landroid/content/Context;", "materialdrawer"})
    public static final class Companion {
        @JvmOverloads
        public final boolean applyTo(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView, @Nullable String tag) {
            return imageHolder != null && imageView != null ? imageHolder.applyTo(imageView, tag) : false;
        }

        public static /* synthetic */ boolean applyTo$default(Companion companion, ImageHolder imageHolder, ImageView imageView, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.applyTo(imageHolder, imageView, string2);
        }

        @JvmOverloads
        public final boolean applyTo(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView) {
            return com.mikepenz.materialdrawer.holder.ImageHolder$Companion.applyTo$default(this, imageHolder, imageView, null, 4, null);
        }

        @JvmOverloads
        public final void applyToOrSetInvisible(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView, @Nullable String tag) {
            boolean imageSet = this.applyTo(imageHolder, imageView, tag);
            if (imageView != null) {
                if (imageSet) {
                    imageView.setVisibility(0);
                } else {
                    imageView.setVisibility(4);
                }
            }
        }

        public static /* synthetic */ void applyToOrSetInvisible$default(Companion companion, ImageHolder imageHolder, ImageView imageView, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            companion.applyToOrSetInvisible(imageHolder, imageView, string2);
        }

        @JvmOverloads
        public final void applyToOrSetInvisible(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView) {
            com.mikepenz.materialdrawer.holder.ImageHolder$Companion.applyToOrSetInvisible$default(this, imageHolder, imageView, null, 4, null);
        }

        @JvmOverloads
        public final void applyToOrSetGone(@NotNull ImageHolder imageHolder, @Nullable ImageView imageView, @Nullable String tag) {
            Intrinsics.checkNotNullParameter((Object)imageHolder, (String)"imageHolder");
            boolean imageSet = this.applyTo(imageHolder, imageView, tag);
            if (imageView != null) {
                if (imageSet) {
                    imageView.setVisibility(0);
                } else {
                    imageView.setVisibility(8);
                }
            }
        }

        public static /* synthetic */ void applyToOrSetGone$default(Companion companion, ImageHolder imageHolder, ImageView imageView, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            companion.applyToOrSetGone(imageHolder, imageView, string2);
        }

        @JvmOverloads
        public final void applyToOrSetGone(@NotNull ImageHolder imageHolder, @Nullable ImageView imageView) {
            com.mikepenz.materialdrawer.holder.ImageHolder$Companion.applyToOrSetGone$default(this, imageHolder, imageView, null, 4, null);
        }

        @Nullable
        public final Drawable decideIcon(@Nullable ImageHolder imageHolder, @NotNull Context ctx, @NotNull ColorStateList iconColor, boolean tint, int paddingDp) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
            ImageHolder imageHolder2 = imageHolder;
            return imageHolder2 != null ? imageHolder2.decideIcon(ctx, iconColor, tint, paddingDp) : null;
        }

        public static /* synthetic */ Drawable decideIcon$default(Companion companion, ImageHolder imageHolder, Context context, ColorStateList colorStateList, boolean bl, int n, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = 1;
            }
            return companion.decideIcon(imageHolder, context, colorStateList, bl, n);
        }

        public final void applyDecidedIconOrSetGone(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView, @NotNull ColorStateList iconColor, boolean tint, int paddingDp) {
            Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
            if (imageHolder != null && imageView != null) {
                Context context = imageView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"imageView.context");
                Drawable drawable2 = this.decideIcon(imageHolder, context, iconColor, tint, paddingDp);
                if (drawable2 != null) {
                    imageView.setImageDrawable(drawable2);
                    imageView.setVisibility(0);
                } else if (imageHolder.getBitmap() != null) {
                    imageView.setImageBitmap(imageHolder.getBitmap());
                    imageView.setVisibility(0);
                } else {
                    imageView.setVisibility(8);
                }
            } else if (imageView != null) {
                imageView.setVisibility(8);
            }
        }

        public static /* synthetic */ void applyDecidedIconOrSetGone$default(Companion companion, ImageHolder imageHolder, ImageView imageView, ColorStateList colorStateList, boolean bl, int n, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = 1;
            }
            companion.applyDecidedIconOrSetGone(imageHolder, imageView, colorStateList, bl, n);
        }

        public final void applyMultiIconTo(@Nullable Drawable icon, @Nullable Drawable selectedIcon, @NotNull ColorStateList iconColor, boolean tinted, @NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
            if (icon != null) {
                if (selectedIcon != null) {
                    if (tinted) {
                        imageView.setImageDrawable((Drawable)new FixStateListDrawable(icon, selectedIcon, iconColor));
                    } else {
                        imageView.setImageDrawable((Drawable)DrawerUtils.getIconStateList(icon, selectedIcon));
                    }
                } else if (tinted) {
                    imageView.setImageDrawable((Drawable)new FixStateListDrawable(icon, iconColor));
                } else {
                    imageView.setImageDrawable(icon);
                }
                imageView.setVisibility(0);
            } else {
                imageView.setVisibility(8);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

