/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.itemanimators;

import android.view.View;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.itemanimators.DefaultAnimator;

public class SlideInOutTopAnimator
extends DefaultAnimator<SlideInOutTopAnimator> {
    private float mDeltaY;
    private RecyclerView mRecyclerView;

    public SlideInOutTopAnimator(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
    }

    @Override
    public void addAnimationPrepare(RecyclerView.ViewHolder holder) {
        this.retrieveItemPosition(holder);
        ViewCompat.setTranslationY((View)holder.itemView, (float)this.mDeltaY);
        ViewCompat.setTranslationZ((View)holder.itemView, (float)100.0f);
    }

    @Override
    public ViewPropertyAnimatorCompat addAnimation(RecyclerView.ViewHolder holder) {
        View view = holder.itemView;
        return ViewCompat.animate((View)view).translationY(0.0f).alpha(1.0f).setDuration(this.getAddDuration());
    }

    @Override
    public void addAnimationCleanup(RecyclerView.ViewHolder holder) {
        ViewCompat.setAlpha((View)holder.itemView, (float)1.0f);
        ViewCompat.setTranslationY((View)holder.itemView, (float)0.0f);
        ViewCompat.setTranslationZ((View)holder.itemView, (float)1.0f);
    }

    @Override
    public ViewPropertyAnimatorCompat removeAnimation(RecyclerView.ViewHolder holder) {
        ViewCompat.setTranslationZ((View)holder.itemView, (float)100.0f);
        ViewPropertyAnimatorCompat animation = ViewCompat.animate((View)holder.itemView);
        return animation.setDuration(this.getRemoveDuration()).alpha(0.0f).translationY(this.mDeltaY);
    }

    @Override
    public void removeAnimationCleanup(RecyclerView.ViewHolder holder) {
        ViewCompat.setTranslationY((View)holder.itemView, (float)0.0f);
        ViewCompat.setAlpha((View)holder.itemView, (float)1.0f);
        ViewCompat.setTranslationZ((View)holder.itemView, (float)1.0f);
    }

    private void retrieveItemPosition(RecyclerView.ViewHolder holder) {
        this.mDeltaY = this.mRecyclerView.getHeight() - this.mRecyclerView.getLayoutManager().getDecoratedTop(holder.itemView);
    }

    @Override
    public long getAddDelay(long remove, long move, long change) {
        return 0L;
    }

    @Override
    public long getRemoveDelay(long remove, long move, long change) {
        return remove / 2L;
    }
}

