/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.animation;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import androidx.annotation.IntRange;
import com.mikepenz.iconics.IconicsBrush;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 52\u00020\u0001:\u00015BK\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJH\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020/2\f\u00103\u001a\b\u0012\u0004\u0012\u0002020/2\f\u00104\u001a\b\u0012\u0004\u0012\u0002020/H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00066"}, d2={"Lcom/mikepenz/iconics/animation/BlinkAlphaProcessor;", "Lcom/mikepenz/iconics/animation/IconicsAnimationProcessor;", "minimumAlpha", "", "maximumAlpha", "interpolator", "Landroid/animation/TimeInterpolator;", "duration", "", "repeatCount", "repeatMode", "Lcom/mikepenz/iconics/animation/IconicsAnimationProcessor$RepeatMode;", "isStartImmediately", "", "(IILandroid/animation/TimeInterpolator;JILcom/mikepenz/iconics/animation/IconicsAnimationProcessor$RepeatMode;Z)V", "animationTag", "", "getAnimationTag", "()Ljava/lang/String;", "getDuration", "()J", "setDuration", "(J)V", "getInterpolator", "()Landroid/animation/TimeInterpolator;", "setInterpolator", "(Landroid/animation/TimeInterpolator;)V", "()Z", "setStartImmediately", "(Z)V", "getMaximumAlpha", "()I", "setMaximumAlpha", "(I)V", "getMinimumAlpha", "setMinimumAlpha", "getRepeatCount", "setRepeatCount", "getRepeatMode", "()Lcom/mikepenz/iconics/animation/IconicsAnimationProcessor$RepeatMode;", "setRepeatMode", "(Lcom/mikepenz/iconics/animation/IconicsAnimationProcessor$RepeatMode;)V", "processPreDraw", "", "canvas", "Landroid/graphics/Canvas;", "iconBrush", "Lcom/mikepenz/iconics/IconicsBrush;", "Landroid/text/TextPaint;", "iconContourBrush", "Landroid/graphics/Paint;", "backgroundBrush", "backgroundContourBrush", "Companion", "iconics-core"})
public class BlinkAlphaProcessor
extends IconicsAnimationProcessor {
    @NotNull
    private final String animationTag = "blink_alpha";
    private int minimumAlpha;
    private int maximumAlpha;
    @NotNull
    private TimeInterpolator interpolator;
    private long duration;
    private int repeatCount;
    @NotNull
    private IconicsAnimationProcessor.RepeatMode repeatMode;
    private boolean isStartImmediately;
    @JvmField
    public static long DEFAULT_DURATION;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getAnimationTag() {
        return this.animationTag;
    }

    @Override
    public void processPreDraw(@NotNull Canvas canvas, @NotNull IconicsBrush<TextPaint> iconBrush, @NotNull IconicsBrush<Paint> iconContourBrush, @NotNull IconicsBrush<Paint> backgroundBrush, @NotNull IconicsBrush<Paint> backgroundContourBrush) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull(iconBrush, (String)"iconBrush");
        Intrinsics.checkParameterIsNotNull(iconContourBrush, (String)"iconContourBrush");
        Intrinsics.checkParameterIsNotNull(backgroundBrush, (String)"backgroundBrush");
        Intrinsics.checkParameterIsNotNull(backgroundContourBrush, (String)"backgroundContourBrush");
        int alphaByPercent = (this.getMaximumAlpha() - this.getMinimumAlpha()) / 100;
        int alpha = (int)(this.getAnimatedPercent() * (float)alphaByPercent);
        iconBrush.setAlpha(alpha);
        iconContourBrush.setAlpha(alpha);
        backgroundBrush.setAlpha(alpha);
        backgroundContourBrush.setAlpha(alpha);
    }

    public int getMinimumAlpha() {
        return this.minimumAlpha;
    }

    public void setMinimumAlpha(int n) {
        this.minimumAlpha = n;
    }

    public int getMaximumAlpha() {
        return this.maximumAlpha;
    }

    public void setMaximumAlpha(int n) {
        this.maximumAlpha = n;
    }

    @Override
    @NotNull
    public TimeInterpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public void setInterpolator(@NotNull TimeInterpolator timeInterpolator) {
        Intrinsics.checkParameterIsNotNull((Object)timeInterpolator, (String)"<set-?>");
        this.interpolator = timeInterpolator;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(long l) {
        this.duration = l;
    }

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    @Override
    @NotNull
    public IconicsAnimationProcessor.RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    @Override
    public void setRepeatMode(@NotNull IconicsAnimationProcessor.RepeatMode repeatMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)repeatMode), (String)"<set-?>");
        this.repeatMode = repeatMode;
    }

    @Override
    public boolean isStartImmediately() {
        return this.isStartImmediately;
    }

    @Override
    public void setStartImmediately(boolean bl) {
        this.isStartImmediately = bl;
    }

    public BlinkAlphaProcessor(@IntRange(from=0L, to=255L) int minimumAlpha, @IntRange(from=0L, to=255L) int maximumAlpha, @NotNull TimeInterpolator interpolator, long duration, int repeatCount, @NotNull IconicsAnimationProcessor.RepeatMode repeatMode, boolean isStartImmediately) {
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        Intrinsics.checkParameterIsNotNull((Object)((Object)repeatMode), (String)"repeatMode");
        super(interpolator, duration, repeatCount, repeatMode, isStartImmediately);
        this.minimumAlpha = minimumAlpha;
        this.maximumAlpha = maximumAlpha;
        this.interpolator = interpolator;
        this.duration = duration;
        this.repeatCount = repeatCount;
        this.repeatMode = repeatMode;
        this.isStartImmediately = isStartImmediately;
        this.animationTag = "blink_alpha";
    }

    public /* synthetic */ BlinkAlphaProcessor(int n, int n2, TimeInterpolator timeInterpolator, long l, int n3, IconicsAnimationProcessor.RepeatMode repeatMode, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 255;
        }
        if ((n4 & 4) != 0) {
            timeInterpolator = (TimeInterpolator)IconicsAnimationProcessor.DEFAULT_INTERPOLATOR;
        }
        if ((n4 & 8) != 0) {
            l = DEFAULT_DURATION;
        }
        if ((n4 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x20) != 0) {
            repeatMode = IconicsAnimationProcessor.RepeatMode.REVERSE;
        }
        if ((n4 & 0x40) != 0) {
            bl = true;
        }
        this(n, n2, timeInterpolator, l, n3, repeatMode, bl);
    }

    public BlinkAlphaProcessor() {
        this(0, 0, null, 0L, 0, null, false, 127, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_DURATION = 500L;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mikepenz/iconics/animation/BlinkAlphaProcessor$Companion;", "", "()V", "DEFAULT_DURATION", "", "iconics-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

