/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import com.mikepenz.fastadapter.IAdapterNotifier;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.utils.DefaultItemList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultItemListImpl<Item extends IItem>
extends DefaultItemList<Item> {
    protected List<Item> mItems;

    public DefaultItemListImpl() {
        this(new ArrayList());
    }

    public DefaultItemListImpl(List<Item> items) {
        this.mItems = items;
    }

    @Override
    public Item get(int position) {
        return (Item)((IItem)this.mItems.get(position));
    }

    @Override
    public List<Item> getItems() {
        return this.mItems;
    }

    @Override
    public int getAdapterPosition(long identifier) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            if (((IItem)this.mItems.get(i)).getIdentifier() != identifier) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove(int position, int preItemCount) {
        this.mItems.remove(position - preItemCount);
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemRemoved(position);
        }
    }

    @Override
    public void removeRange(int position, int itemCount, int preItemCount) {
        int length = this.mItems.size();
        int saveItemCount = Math.min(itemCount, length - position + preItemCount);
        for (int i = 0; i < saveItemCount; ++i) {
            this.mItems.remove(position - preItemCount);
        }
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemRangeRemoved(position, saveItemCount);
        }
    }

    @Override
    public void move(int fromPosition, int toPosition, int preItemCount) {
        IItem item = (IItem)this.mItems.get(fromPosition - preItemCount);
        this.mItems.remove(fromPosition - preItemCount);
        this.mItems.add(toPosition - preItemCount, item);
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemMoved(fromPosition, toPosition);
        }
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public void clear(int preItemCount) {
        int size = this.mItems.size();
        this.mItems.clear();
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemRangeRemoved(preItemCount, size);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    public void set(int position, Item item, int preItemCount) {
        this.mItems.set(position - preItemCount, item);
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemChanged(position);
        }
    }

    @Override
    public void addAll(List<Item> items, int preItemCount) {
        int countBefore = this.mItems.size();
        this.mItems.addAll(items);
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemRangeInserted(preItemCount + countBefore, items.size());
        }
    }

    @Override
    public void addAll(int position, List<Item> items, int preItemCount) {
        this.mItems.addAll(position - preItemCount, items);
        if (this.getFastAdapter() != null) {
            this.getFastAdapter().notifyAdapterItemRangeInserted(position, items.size());
        }
    }

    @Override
    public void set(List<Item> items, int preItemCount, @Nullable IAdapterNotifier adapterNotifier) {
        int newItemsCount = items.size();
        int previousItemsCount = this.mItems.size();
        if (items != this.mItems) {
            if (!this.mItems.isEmpty()) {
                this.mItems.clear();
            }
            this.mItems.addAll(items);
        }
        if (this.getFastAdapter() == null) {
            return;
        }
        if (adapterNotifier == null) {
            adapterNotifier = IAdapterNotifier.DEFAULT;
        }
        adapterNotifier.notify(this.getFastAdapter(), newItemsCount, previousItemsCount, preItemCount);
    }

    @Override
    public void setNewList(List<Item> items, boolean notify) {
        this.mItems = new ArrayList<Item>(items);
        if (this.getFastAdapter() != null && notify) {
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
    }
}

