/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.widget.Filter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.adapters.ModelAdapter;
import com.mikepenz.fastadapter.listeners.ItemFilterListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class ItemFilter<Model, Item extends IItem>
extends Filter {
    private List<Item> mOriginalItems;
    private CharSequence mConstraint;
    private ModelAdapter<?, Item> mItemAdapter;
    protected ItemFilterListener<Item> mItemFilterListener;
    private IItemAdapter.Predicate<Item> mFilterPredicate;

    public ItemFilter(ModelAdapter<?, Item> itemAdapter) {
        this.mItemAdapter = itemAdapter;
    }

    public ItemFilter<Model, Item> withItemFilterListener(ItemFilterListener<Item> listener) {
        this.mItemFilterListener = listener;
        return this;
    }

    public ItemFilter<Model, Item> withFilterPredicate(IItemAdapter.Predicate<Item> filterPredicate) {
        this.mFilterPredicate = filterPredicate;
        return this;
    }

    public Filter.FilterResults performFiltering(@Nullable CharSequence constraint) {
        Filter.FilterResults results = new Filter.FilterResults();
        if (this.mOriginalItems == null && (constraint == null || constraint.length() == 0)) {
            return results;
        }
        for (IAdapterExtension ext : this.mItemAdapter.getFastAdapter().getExtensions()) {
            ext.performFiltering(constraint);
        }
        this.mConstraint = constraint;
        if (this.mOriginalItems == null) {
            this.mOriginalItems = new ArrayList<Item>(this.mItemAdapter.getAdapterItems());
        }
        if (constraint == null || constraint.length() == 0) {
            results.values = this.mOriginalItems;
            results.count = this.mOriginalItems.size();
            this.mOriginalItems = null;
            if (this.mItemFilterListener != null) {
                this.mItemFilterListener.onReset();
            }
        } else {
            List<Object> filteredItems = new ArrayList();
            if (this.mFilterPredicate != null) {
                for (IItem item : this.mOriginalItems) {
                    if (!this.mFilterPredicate.filter(item, constraint)) continue;
                    filteredItems.add(item);
                }
            } else {
                filteredItems = this.mItemAdapter.getAdapterItems();
            }
            results.values = filteredItems;
            results.count = filteredItems.size();
        }
        return results;
    }

    public CharSequence getConstraint() {
        return this.mConstraint;
    }

    protected void publishResults(@Nullable CharSequence constraint, Filter.FilterResults results) {
        if (results.values != null) {
            this.mItemAdapter.setInternal((List)results.values, false, null);
        }
        if (this.mItemFilterListener != null && this.mOriginalItems != null) {
            this.mItemFilterListener.itemsFiltered(constraint, (List)results.values);
        }
    }

    public Set<Integer> getSelections() {
        if (this.mOriginalItems != null) {
            HashSet<Integer> selections = new HashSet<Integer>();
            int adapterOffset = this.mItemAdapter.getFastAdapter().getPreItemCountByOrder(this.mItemAdapter.getOrder());
            int size = this.mOriginalItems.size();
            for (int i = 0; i < size; ++i) {
                IItem item = (IItem)this.mOriginalItems.get(i);
                if (!item.isSelected()) continue;
                selections.add(i + adapterOffset);
            }
            return selections;
        }
        return this.mItemAdapter.getFastAdapter().getSelections();
    }

    public Set<Item> getSelectedItems() {
        if (this.mOriginalItems != null) {
            HashSet<IItem> selections = new HashSet<IItem>();
            int size = this.mOriginalItems.size();
            for (int i = 0; i < size; ++i) {
                IItem item = (IItem)this.mOriginalItems.get(i);
                if (!item.isSelected()) continue;
                selections.add(item);
            }
            return selections;
        }
        return this.mItemAdapter.getFastAdapter().getSelectedItems();
    }

    public int getAdapterPosition(Item item) {
        return this.getAdapterPosition(item.getIdentifier());
    }

    public int getAdapterPosition(long identifier) {
        int size = this.mOriginalItems.size();
        for (int i = 0; i < size; ++i) {
            if (((IItem)this.mOriginalItems.get(i)).getIdentifier() != identifier) continue;
            return i;
        }
        return -1;
    }

    @SafeVarargs
    public final ModelAdapter<?, Item> add(Item ... items) {
        return this.add(Arrays.asList(items));
    }

    public ModelAdapter<?, Item> add(List<Item> items) {
        if (this.mOriginalItems != null && items.size() > 0) {
            if (this.mItemAdapter.isUseIdDistributor()) {
                this.mItemAdapter.getIdDistributor().checkIds(items);
            }
            this.mOriginalItems.addAll(items);
            this.publishResults(this.mConstraint, this.performFiltering(this.mConstraint));
            return this.mItemAdapter;
        }
        return this.mItemAdapter.addInternal((List)items);
    }

    @SafeVarargs
    public final ModelAdapter<?, Item> add(int position, Item ... items) {
        return this.add(position, Arrays.asList(items));
    }

    public ModelAdapter<?, Item> add(int position, List<Item> items) {
        if (this.mOriginalItems != null && items.size() > 0) {
            if (this.mItemAdapter.isUseIdDistributor()) {
                this.mItemAdapter.getIdDistributor().checkIds(items);
            }
            this.mOriginalItems.addAll(this.getAdapterPosition((IItem)this.mItemAdapter.getAdapterItems().get(position)) - this.mItemAdapter.getFastAdapter().getPreItemCount(position), items);
            this.publishResults(this.mConstraint, this.performFiltering(this.mConstraint));
            return this.mItemAdapter;
        }
        return this.mItemAdapter.addInternal(position, (List)items);
    }

    public ModelAdapter<?, Item> set(int position, Item item) {
        if (this.mOriginalItems != null) {
            if (this.mItemAdapter.isUseIdDistributor()) {
                this.mItemAdapter.getIdDistributor().checkId(item);
            }
            this.mOriginalItems.set(this.getAdapterPosition((IItem)this.mItemAdapter.getAdapterItems().get(position)) - this.mItemAdapter.getFastAdapter().getPreItemCount(position), item);
            this.publishResults(this.mConstraint, this.performFiltering(this.mConstraint));
            return this.mItemAdapter;
        }
        return this.mItemAdapter.setInternal(position, (IItem)item);
    }

    public ModelAdapter<?, Item> move(int fromPosition, int toPosition) {
        if (this.mOriginalItems != null) {
            int preItemCount = this.mItemAdapter.getFastAdapter().getPreItemCount(fromPosition);
            int adjustedFrom = this.getAdapterPosition((IItem)this.mItemAdapter.getAdapterItems().get(fromPosition));
            int adjustedTo = this.getAdapterPosition((IItem)this.mItemAdapter.getAdapterItems().get(toPosition));
            IItem item = (IItem)this.mOriginalItems.get(adjustedFrom - preItemCount);
            this.mOriginalItems.remove(adjustedFrom - preItemCount);
            this.mOriginalItems.add(adjustedTo - preItemCount, item);
            this.performFiltering(this.mConstraint);
            return this.mItemAdapter;
        }
        return this.mItemAdapter.move(fromPosition, toPosition);
    }

    public ModelAdapter<?, Item> remove(int position) {
        if (this.mOriginalItems != null) {
            this.mOriginalItems.remove(this.getAdapterPosition((IItem)this.mItemAdapter.getAdapterItems().get(position)) - this.mItemAdapter.getFastAdapter().getPreItemCount(position));
            this.publishResults(this.mConstraint, this.performFiltering(this.mConstraint));
            return this.mItemAdapter;
        }
        return this.mItemAdapter.remove(position);
    }

    public ModelAdapter<?, Item> removeRange(int position, int itemCount) {
        if (this.mOriginalItems != null) {
            int length = this.mOriginalItems.size();
            int preItemCount = this.mItemAdapter.getFastAdapter().getPreItemCount(position);
            int saveItemCount = Math.min(itemCount, length - position + preItemCount);
            for (int i = 0; i < saveItemCount; ++i) {
                this.mOriginalItems.remove(position - preItemCount);
            }
            this.publishResults(this.mConstraint, this.performFiltering(this.mConstraint));
            return this.mItemAdapter;
        }
        return this.mItemAdapter.removeRange(position, itemCount);
    }

    public ModelAdapter<?, Item> clear() {
        if (this.mOriginalItems != null) {
            this.mOriginalItems.clear();
            this.publishResults(this.mConstraint, this.performFiltering(this.mConstraint));
            return this.mItemAdapter;
        }
        return this.mItemAdapter.clear();
    }
}

