/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import com.mikepenz.fastadapter.FastAdapter;

public interface IAdapterNotifier {
    public static final IAdapterNotifier DEFAULT = new IAdapterNotifier(){

        @Override
        public boolean notify(FastAdapter fastAdapter, int newItemsCount, int previousItemsCount, int itemsBeforeThisAdapter) {
            if (newItemsCount > previousItemsCount) {
                if (previousItemsCount > 0) {
                    fastAdapter.notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, previousItemsCount);
                }
                fastAdapter.notifyAdapterItemRangeInserted(itemsBeforeThisAdapter + previousItemsCount, newItemsCount - previousItemsCount);
            } else if (newItemsCount > 0) {
                fastAdapter.notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, newItemsCount);
                if (newItemsCount < previousItemsCount) {
                    fastAdapter.notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter + newItemsCount, previousItemsCount - newItemsCount);
                }
            } else if (newItemsCount == 0) {
                fastAdapter.notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter, previousItemsCount);
            } else {
                fastAdapter.notifyAdapterDataSetChanged();
            }
            return false;
        }
    };
    public static final IAdapterNotifier LEGACY_DEFAULT = new IAdapterNotifier(){

        @Override
        public boolean notify(FastAdapter fastAdapter, int newItemsCount, int previousItemsCount, int itemsBeforeThisAdapter) {
            if (newItemsCount > previousItemsCount) {
                if (previousItemsCount > 0) {
                    fastAdapter.notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, previousItemsCount);
                }
                fastAdapter.notifyAdapterItemRangeInserted(itemsBeforeThisAdapter + previousItemsCount, newItemsCount - previousItemsCount);
            } else if (newItemsCount > 0 && newItemsCount < previousItemsCount) {
                fastAdapter.notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, newItemsCount);
                fastAdapter.notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter + newItemsCount, previousItemsCount - newItemsCount);
            } else if (newItemsCount == 0) {
                fastAdapter.notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter, previousItemsCount);
            } else {
                fastAdapter.notifyAdapterDataSetChanged();
            }
            return false;
        }
    };

    public boolean notify(FastAdapter var1, int var2, int var3, int var4);
}

