/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.listeners.ClickEventHook;
import com.mikepenz.fastadapter.listeners.CustomEventHook;
import com.mikepenz.fastadapter.listeners.EventHook;
import com.mikepenz.fastadapter.listeners.LongClickEventHook;
import com.mikepenz.fastadapter.listeners.TouchEventHook;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ClickListenerHelper<Item extends IItem> {
    private FastAdapter<Item> mFastAdapter;
    private List<EventHook<Item>> eventHooks = new LinkedList<EventHook<Item>>();

    public ClickListenerHelper(FastAdapter<Item> fastAdapter) {
        this.mFastAdapter = fastAdapter;
    }

    public ClickListenerHelper(FastAdapter<Item> fastAdapter, List<EventHook<Item>> eventHooks) {
        this.mFastAdapter = fastAdapter;
        this.eventHooks = eventHooks;
    }

    public List<EventHook<Item>> getEventHooks() {
        return this.eventHooks;
    }

    public ClickListenerHelper<Item> setEventHooks(List<EventHook<Item>> eventHooks) {
        this.eventHooks = eventHooks;
        return this;
    }

    public ClickListenerHelper<Item> addEventHook(EventHook<Item> eventHook) {
        this.eventHooks.add(eventHook);
        return this;
    }

    public void bind(@NonNull RecyclerView.ViewHolder viewHolder) {
        for (EventHook<Item> event : this.eventHooks) {
            List<View> views;
            View view = event.onBind(viewHolder);
            if (view != null) {
                this.attachToView(event, viewHolder, view);
            }
            if ((views = event.onBindMany(viewHolder)) == null) continue;
            for (View v : views) {
                this.attachToView(event, viewHolder, v);
            }
        }
    }

    public void attachToView(final EventHook<Item> event, final RecyclerView.ViewHolder viewHolder, View view) {
        if (event instanceof ClickEventHook) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = ClickListenerHelper.this.mFastAdapter.getHolderAdapterPosition(viewHolder);
                    if (pos != -1) {
                        ((ClickEventHook)event).onClick(v, pos, ClickListenerHelper.this.mFastAdapter, ClickListenerHelper.this.mFastAdapter.getItem(pos));
                    }
                }
            });
        } else if (event instanceof LongClickEventHook) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    int pos = ClickListenerHelper.this.mFastAdapter.getHolderAdapterPosition(viewHolder);
                    if (pos != -1) {
                        return ((LongClickEventHook)event).onLongClick(v, pos, ClickListenerHelper.this.mFastAdapter, ClickListenerHelper.this.mFastAdapter.getItem(pos));
                    }
                    return false;
                }
            });
        } else if (event instanceof TouchEventHook) {
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent e) {
                    int pos = ClickListenerHelper.this.mFastAdapter.getHolderAdapterPosition(viewHolder);
                    if (pos != -1) {
                        return ((TouchEventHook)event).onTouch(v, e, pos, ClickListenerHelper.this.mFastAdapter, ClickListenerHelper.this.mFastAdapter.getItem(pos));
                    }
                    return false;
                }
            });
        } else if (event instanceof CustomEventHook) {
            ((CustomEventHook)event).onEvent(view, viewHolder, this.mFastAdapter);
        }
    }

    public static List<View> toList(View ... views) {
        return Arrays.asList(views);
    }
}

