/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import com.mikepenz.fastadapter.R;

public class FastAdapterUIUtils {
    public static StateListDrawable getSelectableBackground(Context ctx, @ColorInt int selected_color, boolean animate) {
        StateListDrawable states = new StateListDrawable();
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        states.addState(new int[0], ContextCompat.getDrawable((Context)ctx, (int)FastAdapterUIUtils.getSelectableBackground(ctx)));
        int duration = ctx.getResources().getInteger(0x10E0000);
        states.setEnterFadeDuration(duration);
        states.setExitFadeDuration(duration);
        return states;
    }

    public static StateListDrawable getSelectablePressedBackground(Context ctx, @ColorInt int selected_color, int pressed_alpha, boolean animate) {
        StateListDrawable states = FastAdapterUIUtils.getSelectableBackground(ctx, selected_color, animate);
        ColorDrawable clrPressed = new ColorDrawable(FastAdapterUIUtils.adjustAlpha(selected_color, pressed_alpha));
        states.addState(new int[]{16842919}, (Drawable)clrPressed);
        return states;
    }

    public static int adjustAlpha(@ColorInt int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int getSelectableBackground(Context ctx) {
        TypedValue outValue = new TypedValue();
        ctx.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        return outValue.resourceId;
    }
}

