/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import android.os.Bundle;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.utils.AdapterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class FastAdapter<Item extends IItem>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected static final String BUNDLE_SELECTIONS = "bundle_selections";
    protected static final String BUNDLE_EXPANDED = "bundle_expanded";
    private final ArrayMap<Integer, IAdapter<Item>> mAdapters = new ArrayMap();
    private final ArrayMap<Integer, Item> mTypeInstances = new ArrayMap();
    private final NavigableMap<Integer, IAdapter<Item>> mAdapterSizes = new TreeMap<Integer, IAdapter<Item>>();
    private int mGlobalSize = 0;
    private boolean mSelectWithItemUpdate = false;
    private boolean mMultiSelect = false;
    private boolean mSelectOnLongClick = false;
    private boolean mAllowDeselection = true;
    private boolean mSelectable = false;
    private boolean mOnlyOneExpandedItem = false;
    private boolean mPositionBasedStateManagement = true;
    private boolean mLegacyBindViewMode = false;
    private SortedSet<Integer> mSelections = new TreeSet<Integer>();
    private SparseIntArray mExpanded = new SparseIntArray();
    private OnClickListener<Item> mOnPreClickListener;
    private OnClickListener<Item> mOnClickListener;
    private OnLongClickListener<Item> mOnPreLongClickListener;
    private OnLongClickListener<Item> mOnLongClickListener;
    private OnTouchListener<Item> mOnTouchListener;
    private OnCreateViewHolderListener mOnCreateViewHolderListener = new OnCreateViewHolderListenerImpl();
    private OnBindViewHolderListener mOnBindViewHolderListener = new OnBindViewHolderListenerImpl();

    public FastAdapter() {
        this.setHasStableIds(true);
    }

    public FastAdapter<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreClickListener(OnClickListener<Item> onPreClickListener) {
        this.mOnPreClickListener = onPreClickListener;
        return this;
    }

    public FastAdapter<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mOnLongClickListener = onLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreLongClickListener(OnLongClickListener<Item> onPreLongClickListener) {
        this.mOnPreLongClickListener = onPreLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mOnTouchListener = onTouchListener;
        return this;
    }

    public FastAdapter<Item> withOnCreateViewHolderListener(OnCreateViewHolderListener onCreateViewHolderListener) {
        this.mOnCreateViewHolderListener = onCreateViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withOnBindViewHolderListener(OnBindViewHolderListener onBindViewHolderListener) {
        this.mOnBindViewHolderListener = onBindViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectWithItemUpdate = selectWithItemUpdate;
        return this;
    }

    public FastAdapter<Item> withMultiSelect(boolean multiSelect) {
        this.mMultiSelect = multiSelect;
        return this;
    }

    public FastAdapter<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectOnLongClick = selectOnLongClick;
        return this;
    }

    public FastAdapter<Item> withAllowDeselection(boolean allowDeselection) {
        this.mAllowDeselection = allowDeselection;
        return this;
    }

    public FastAdapter<Item> withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return this;
    }

    public FastAdapter<Item> withPositionBasedStateManagement(boolean mPositionBasedStateManagement) {
        this.mPositionBasedStateManagement = mPositionBasedStateManagement;
        return this;
    }

    public FastAdapter<Item> withLegacyBindViewMode(boolean legacyBindViewMode) {
        this.mLegacyBindViewMode = legacyBindViewMode;
        return this;
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    public boolean isPositionBasedStateManagement() {
        return this.mPositionBasedStateManagement;
    }

    public FastAdapter<Item> withOnlyOneExpandedItem(boolean mOnlyOneExpandedItem) {
        this.mOnlyOneExpandedItem = mOnlyOneExpandedItem;
        return this;
    }

    public boolean isOnlyOneExpandedItem() {
        return this.mOnlyOneExpandedItem;
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState, String prefix) {
        block6: {
            block7: {
                int[] selections;
                int n;
                if (savedInstanceState == null) break block6;
                this.deselect();
                if (!this.mPositionBasedStateManagement) break block7;
                int[] expandedItems = savedInstanceState.getIntArray(BUNDLE_EXPANDED + prefix);
                if (expandedItems != null) {
                    int[] nArray = expandedItems;
                    int n2 = nArray.length;
                    for (n = 0; n < n2; ++n) {
                        Integer expandedItem = nArray[n];
                        this.expand(expandedItem);
                    }
                }
                if ((selections = savedInstanceState.getIntArray(BUNDLE_SELECTIONS + prefix)) == null) break block6;
                int[] nArray = selections;
                n = nArray.length;
                for (int expandedItem = 0; expandedItem < n; ++expandedItem) {
                    Integer selection = nArray[expandedItem];
                    this.select(selection);
                }
                break block6;
            }
            ArrayList expandedItems = savedInstanceState.getStringArrayList(BUNDLE_EXPANDED + prefix);
            ArrayList selectedItems = savedInstanceState.getStringArrayList(BUNDLE_SELECTIONS + prefix);
            for (int i = 0; i < this.getItemCount(); ++i) {
                Item item = this.getItem(i);
                String id = String.valueOf(item.getIdentifier());
                if (expandedItems != null && expandedItems.contains(id)) {
                    this.expand(i);
                }
                if (selectedItems != null && selectedItems.contains(id)) {
                    this.select(i);
                }
                AdapterUtil.restoreSubItemSelectionStatesForAlternativeStateManagement(item, selectedItems);
            }
        }
        return this;
    }

    public <A extends AbstractAdapter<Item>> void registerAdapter(A adapter) {
        if (!this.mAdapters.containsKey((Object)adapter.getOrder())) {
            this.mAdapters.put((Object)adapter.getOrder(), adapter);
            this.cacheSizes();
        }
    }

    public void registerTypeInstance(Item item) {
        if (!this.mTypeInstances.containsKey((Object)item.getType())) {
            this.mTypeInstances.put((Object)item.getType(), item);
        }
    }

    public Item getTypeInstance(int type) {
        return (Item)((IItem)this.mTypeInstances.get((Object)type));
    }

    public int getHolderAdapterPosition(RecyclerView.ViewHolder holder) {
        return holder.getAdapterPosition();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        final RecyclerView.ViewHolder holder = this.mOnCreateViewHolderListener.onPreCreateViewHolder(parent, viewType);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = FastAdapter.this.getHolderAdapterPosition(holder);
                if (pos != -1) {
                    boolean consumed = false;
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    Object item = relativeInfo.item;
                    if (item != null && item.isEnabled()) {
                        if (item instanceof IClickable && ((IClickable)item).getOnPreItemClickListener() != null) {
                            consumed = ((IClickable)item).getOnPreItemClickListener().onClick(v, relativeInfo.adapter, item, pos);
                        }
                        if (!consumed && FastAdapter.this.mOnPreClickListener != null) {
                            consumed = FastAdapter.this.mOnPreClickListener.onClick(v, relativeInfo.adapter, item, pos);
                        }
                        if (!consumed && item instanceof IExpandable && ((IExpandable)item).isAutoExpanding() && ((IExpandable)item).getSubItems() != null) {
                            FastAdapter.this.toggleExpandable(pos);
                        }
                        if (FastAdapter.this.mOnlyOneExpandedItem) {
                            int[] expandedItems = FastAdapter.this.getExpandedItems();
                            for (int i = expandedItems.length - 1; i >= 0; --i) {
                                if (expandedItems[i] == pos) continue;
                                FastAdapter.this.collapse(expandedItems[i], true);
                            }
                        }
                        if (!consumed && !FastAdapter.this.mSelectOnLongClick && FastAdapter.this.mSelectable) {
                            FastAdapter.this.handleSelection(v, item, pos);
                        }
                        if (item instanceof IClickable && ((IClickable)item).getOnItemClickListener() != null) {
                            consumed = ((IClickable)item).getOnItemClickListener().onClick(v, relativeInfo.adapter, item, pos);
                        }
                        if (!consumed && FastAdapter.this.mOnClickListener != null) {
                            FastAdapter.this.mOnClickListener.onClick(v, relativeInfo.adapter, item, pos);
                        }
                    }
                }
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                int pos = FastAdapter.this.getHolderAdapterPosition(holder);
                if (pos != -1) {
                    boolean consumed = false;
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    if (relativeInfo.item != null && relativeInfo.item.isEnabled()) {
                        if (FastAdapter.this.mOnPreLongClickListener != null) {
                            consumed = FastAdapter.this.mOnPreLongClickListener.onLongClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                        }
                        if (!consumed && FastAdapter.this.mSelectOnLongClick && FastAdapter.this.mSelectable) {
                            FastAdapter.this.handleSelection(v, relativeInfo.item, pos);
                        }
                        if (FastAdapter.this.mOnLongClickListener != null) {
                            consumed = FastAdapter.this.mOnLongClickListener.onLongClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                        }
                    }
                    return consumed;
                }
                return false;
            }
        });
        holder.itemView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int pos;
                if (FastAdapter.this.mOnTouchListener != null && (pos = FastAdapter.this.getHolderAdapterPosition(holder)) != -1) {
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    return FastAdapter.this.mOnTouchListener.onTouch(v, event, relativeInfo.adapter, relativeInfo.item, pos);
                }
                return false;
            }
        });
        return this.mOnCreateViewHolderListener.onPostCreateViewHolder(holder);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.mLegacyBindViewMode) {
            this.onBindViewHolder(holder, position, Collections.EMPTY_LIST);
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List payloads) {
        super.onBindViewHolder(holder, position, payloads);
        this.mOnBindViewHolderListener.onBindViewHolder(holder, position, payloads);
    }

    public int getPosition(Item item) {
        if (item.getIdentifier() == -1L) {
            Log.e((String)"FastAdapter", (String)"You have to define an identifier for your item to retrieve the position via this method");
            return -1;
        }
        int position = 0;
        int length = this.mAdapters.size();
        for (int i = 0; i < length; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            int relativePosition = adapter.getAdapterPosition(item);
            if (relativePosition != -1) {
                return position + relativePosition;
            }
            position = adapter.getAdapterItemCount();
        }
        return -1;
    }

    public Item getItem(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        Map.Entry<Integer, IAdapter<Item>> entry = this.mAdapterSizes.floorEntry(position);
        return entry.getValue().getAdapterItem(position - entry.getKey());
    }

    public RelativeInfo<Item> getRelativeInfo(int position) {
        if (position < 0) {
            return new RelativeInfo();
        }
        RelativeInfo relativeInfo = new RelativeInfo();
        Map.Entry<Integer, IAdapter<Item>> entry = this.mAdapterSizes.floorEntry(position);
        if (entry != null) {
            relativeInfo.item = entry.getValue().getAdapterItem(position - entry.getKey());
            relativeInfo.adapter = entry.getValue();
            relativeInfo.position = position;
        }
        return relativeInfo;
    }

    public IAdapter<Item> getAdapter(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        return this.mAdapterSizes.floorEntry(position).getValue();
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getIdentifier();
    }

    public int getItemCount() {
        return this.mGlobalSize;
    }

    public int getPreItemCountByOrder(int order) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        int size = 0;
        for (IAdapter adapter : this.mAdapters.values()) {
            if (adapter.getOrder() == order) {
                return size;
            }
            size += adapter.getAdapterItemCount();
        }
        return size;
    }

    public int getPreItemCount(int position) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        return this.mAdapterSizes.floorKey(position);
    }

    public int getExpandedItemsCount(int from, int position) {
        int totalAddedItems = 0;
        if (this.mPositionBasedStateManagement) {
            int length = this.mExpanded.size();
            for (int i = 0; i < length; ++i) {
                if (this.mExpanded.keyAt(i) >= from && this.mExpanded.keyAt(i) < position) {
                    totalAddedItems += this.mExpanded.get(this.mExpanded.keyAt(i));
                    continue;
                }
                if (this.mExpanded.keyAt(i) < position) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = from; i < position; ++i) {
                IExpandable tmpExpandable;
                Item tmp = this.getItem(i);
                if (!(tmp instanceof IExpandable) || (tmpExpandable = (IExpandable)tmp).getSubItems() == null || !tmpExpandable.isExpanded()) continue;
                totalAddedItems += tmpExpandable.getSubItems().size();
            }
        }
        return totalAddedItems;
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null) {
            if (this.mPositionBasedStateManagement) {
                int[] selections = new int[this.mSelections.size()];
                int index = 0;
                for (Integer selection : this.mSelections) {
                    selections[index] = selection;
                    ++index;
                }
                savedInstanceState.putIntArray(BUNDLE_SELECTIONS + prefix, selections);
                savedInstanceState.putIntArray(BUNDLE_EXPANDED + prefix, this.getExpandedItems());
            } else {
                ArrayList<String> selections = new ArrayList<String>();
                ArrayList<String> expandedItems = new ArrayList<String>();
                int length = this.getItemCount();
                for (int i = 0; i < length; ++i) {
                    Item item = this.getItem(i);
                    if (item instanceof IExpandable && ((IExpandable)item).isExpanded()) {
                        expandedItems.add(String.valueOf(item.getIdentifier()));
                    }
                    if (item.isSelected()) {
                        selections.add(String.valueOf(item.getIdentifier()));
                    }
                    AdapterUtil.findSubItemSelections(item, selections);
                }
                savedInstanceState.putStringArrayList(BUNDLE_SELECTIONS + prefix, selections);
                savedInstanceState.putStringArrayList(BUNDLE_EXPANDED + prefix, expandedItems);
            }
        }
        return savedInstanceState;
    }

    private void cacheSizes() {
        this.mAdapterSizes.clear();
        int size = 0;
        if (this.mAdapters.size() > 0) {
            this.mAdapterSizes.put(0, (IAdapter<Item>)this.mAdapters.valueAt(0));
        }
        for (IAdapter adapter : this.mAdapters.values()) {
            if (adapter.getAdapterItemCount() <= 0) continue;
            this.mAdapterSizes.put(size, adapter);
            size += adapter.getAdapterItemCount();
        }
        this.mGlobalSize = size;
    }

    public Set<Integer> getSelections() {
        if (this.mPositionBasedStateManagement) {
            return this.mSelections;
        }
        HashSet<Integer> selections = new HashSet<Integer>();
        int length = this.getItemCount();
        for (int i = 0; i < length; ++i) {
            Item item = this.getItem(i);
            if (!item.isSelected()) continue;
            selections.add(i);
        }
        return selections;
    }

    public Set<Item> getSelectedItems() {
        HashSet<Item> items = new HashSet<Item>();
        for (Integer position : this.getSelections()) {
            items.add(this.getItem(position));
        }
        return items;
    }

    public void toggleSelection(int position) {
        if (this.mPositionBasedStateManagement) {
            if (this.mSelections.contains(position)) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else if (this.getItem(position).isSelected()) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    private void handleSelection(View view, Item item, int position) {
        if (!item.isSelectable()) {
            return;
        }
        if (item.isSelected() && !this.mAllowDeselection) {
            return;
        }
        boolean selected = false;
        selected = this.mPositionBasedStateManagement ? this.mSelections.contains(position) : item.isSelected();
        if (this.mSelectWithItemUpdate || view == null) {
            if (!this.mMultiSelect) {
                this.deselect();
            }
            if (selected) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else {
            if (!this.mMultiSelect) {
                if (this.mPositionBasedStateManagement) {
                    Iterator<Integer> entries = this.mSelections.iterator();
                    while (entries.hasNext()) {
                        Integer pos = (Integer)entries.next();
                        if (pos == position) continue;
                        this.deselect(pos, entries);
                    }
                } else {
                    Set<Integer> selections = this.getSelections();
                    for (int pos : selections) {
                        if (pos == position) continue;
                        this.deselect(pos);
                    }
                }
            }
            item.withSetSelected(!selected);
            view.setSelected(!selected);
            if (this.mPositionBasedStateManagement) {
                if (selected) {
                    if (this.mSelections.contains(position)) {
                        this.mSelections.remove(position);
                    }
                } else {
                    this.mSelections.add(position);
                }
            }
        }
    }

    public void select(Iterable<Integer> positions) {
        for (Integer position : positions) {
            this.select(position);
        }
    }

    public void select(int position) {
        this.select(position, false);
    }

    public void select(int position, boolean fireEvent) {
        this.select(position, fireEvent, false);
    }

    public void select(int position, boolean fireEvent, boolean considerSelectableFlag) {
        Item item = this.getItem(position);
        if (item == null) {
            return;
        }
        if (considerSelectableFlag && !item.isSelectable()) {
            return;
        }
        item.withSetSelected(true);
        if (this.mPositionBasedStateManagement) {
            this.mSelections.add(position);
        }
        this.notifyItemChanged(position);
        if (this.mOnClickListener != null && fireEvent) {
            this.mOnClickListener.onClick(null, this.getAdapter(position), item, position);
        }
    }

    public void deselect() {
        if (this.mPositionBasedStateManagement) {
            this.deselect(this.mSelections);
        } else {
            for (IItem item : AdapterUtil.getAllItems(this)) {
                item.withSetSelected(false);
            }
            this.notifyDataSetChanged();
        }
    }

    public void select() {
        this.select(false);
    }

    public void select(boolean considerSelectableFlag) {
        if (this.mPositionBasedStateManagement) {
            int length = this.getItemCount();
            for (int i = 0; i < length; ++i) {
                this.select(i, false, considerSelectableFlag);
            }
        } else {
            for (IItem item : AdapterUtil.getAllItems(this)) {
                if (considerSelectableFlag && !item.isSelectable()) continue;
                item.withSetSelected(true);
            }
            this.notifyDataSetChanged();
        }
    }

    public void deselect(Iterable<Integer> positions) {
        Iterator<Integer> entries = positions.iterator();
        while (entries.hasNext()) {
            this.deselect(entries.next(), entries);
        }
    }

    public void deselect(int position) {
        this.deselect(position, null);
    }

    private void deselect(int position, Iterator<Integer> entries) {
        Item item = this.getItem(position);
        if (item != null) {
            item.withSetSelected(false);
        }
        if (entries == null) {
            if (this.mPositionBasedStateManagement && this.mSelections.contains(position)) {
                this.mSelections.remove(position);
            }
        } else {
            entries.remove();
        }
        this.notifyItemChanged(position);
    }

    public List<Item> deleteAllSelectedItems() {
        LinkedList<Item> deletedItems = new LinkedList<Item>();
        if (this.mPositionBasedStateManagement) {
            Set<Integer> selections = this.getSelections();
            while (selections.size() > 0) {
                Iterator<Integer> iterator = selections.iterator();
                int position = iterator.next();
                IAdapter<Item> adapter = this.getAdapter(position);
                if (adapter != null && adapter instanceof IItemAdapter) {
                    deletedItems.add(this.getItem(position));
                    ((IItemAdapter)adapter).remove(position);
                } else {
                    iterator.remove();
                }
                selections = this.getSelections();
            }
        } else {
            int length = this.getItemCount();
            for (int i = length - 1; i >= 0; --i) {
                RelativeInfo<Item> ri = this.getRelativeInfo(i);
                if (!ri.item.isSelected() || ri.adapter == null || !(ri.adapter instanceof IItemAdapter)) continue;
                ((IItemAdapter)ri.adapter).remove(i);
            }
        }
        return deletedItems;
    }

    public SparseIntArray getExpanded() {
        if (this.mPositionBasedStateManagement) {
            return this.mExpanded;
        }
        SparseIntArray expandedItems = new SparseIntArray();
        int length = this.getItemCount();
        for (int i = 0; i < length; ++i) {
            Item item = this.getItem(i);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            expandedItems.put(i, ((IExpandable)item).getSubItems().size());
        }
        return expandedItems;
    }

    public int[] getExpandedItems() {
        int[] expandedItems;
        if (this.mPositionBasedStateManagement) {
            int length = this.mExpanded.size();
            expandedItems = new int[length];
            for (int i = 0; i < length; ++i) {
                expandedItems[i] = this.mExpanded.keyAt(i);
            }
        } else {
            ArrayList<Integer> expandedItemsList = new ArrayList<Integer>();
            int length = this.getItemCount();
            for (int i = 0; i < length; ++i) {
                Item item = this.getItem(i);
                if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
                expandedItemsList.add(i);
            }
            int expandedItemsListLength = expandedItemsList.size();
            expandedItems = new int[expandedItemsListLength];
            for (int i = 0; i < expandedItemsListLength; ++i) {
                expandedItems[i] = (Integer)expandedItemsList.get(i);
            }
        }
        return expandedItems;
    }

    public void toggleExpandable(int position) {
        if (this.mPositionBasedStateManagement) {
            if (this.mExpanded.indexOfKey(position) >= 0) {
                this.collapse(position);
            } else {
                this.expand(position);
            }
        } else {
            Item item = this.getItem(position);
            if (item instanceof IExpandable && ((IExpandable)item).isExpanded()) {
                this.collapse(position);
            } else {
                this.expand(position);
            }
        }
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapse(boolean notifyItemChanged) {
        int[] expandedItems = this.getExpandedItems();
        for (int i = expandedItems.length - 1; i >= 0; --i) {
            this.collapse(expandedItems[i], notifyItemChanged);
        }
    }

    public void collapse(int position) {
        this.collapse(position, false);
    }

    public void collapse(int position, boolean notifyItemChanged) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            if (this.mPositionBasedStateManagement) {
                int totalAddedItems = expandable.getSubItems().size();
                int length = this.mExpanded.size();
                for (int i = 0; i < length; ++i) {
                    if (this.mExpanded.keyAt(i) <= position || this.mExpanded.keyAt(i) > position + totalAddedItems) continue;
                    totalAddedItems += this.mExpanded.get(this.mExpanded.keyAt(i));
                }
                Iterator<Integer> selectionsIterator = this.mSelections.iterator();
                while (selectionsIterator.hasNext()) {
                    Integer value = (Integer)selectionsIterator.next();
                    if (value <= position || value > position + totalAddedItems) continue;
                    this.deselect(value, selectionsIterator);
                }
                for (int i = length - 1; i >= 0; --i) {
                    if (this.mExpanded.keyAt(i) <= position || this.mExpanded.keyAt(i) > position + totalAddedItems) continue;
                    totalAddedItems -= this.mExpanded.get(this.mExpanded.keyAt(i));
                    this.internalCollapse(this.mExpanded.keyAt(i), notifyItemChanged);
                }
                this.internalCollapse(expandable, position, notifyItemChanged);
            } else {
                IExpandable tmpExpandable;
                Item tmp;
                int i;
                int totalAddedItems = expandable.getSubItems().size();
                for (i = position + 1; i < position + totalAddedItems; ++i) {
                    tmp = this.getItem(i);
                    if (!(tmp instanceof IExpandable) || (tmpExpandable = (IExpandable)tmp).getSubItems() == null || !tmpExpandable.isExpanded()) continue;
                    totalAddedItems += tmpExpandable.getSubItems().size();
                }
                for (i = position + totalAddedItems - 1; i > position; --i) {
                    tmp = this.getItem(i);
                    if (!(tmp instanceof IExpandable) || !(tmpExpandable = (IExpandable)tmp).isExpanded()) continue;
                    this.collapse(i);
                    if (tmpExpandable.getSubItems() == null) continue;
                    i -= tmpExpandable.getSubItems().size();
                }
                this.internalCollapse(expandable, position, notifyItemChanged);
            }
        }
    }

    private void internalCollapse(int position, boolean notifyItemChanged) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            this.internalCollapse(expandable, position, notifyItemChanged);
        }
    }

    private void internalCollapse(IExpandable expandable, int position, boolean notifyItemChanged) {
        int indexOfKey;
        IAdapter<Item> adapter = this.getAdapter(position);
        if (adapter != null && adapter instanceof IItemAdapter) {
            ((IItemAdapter)adapter).removeRange(position + 1, expandable.getSubItems().size());
        }
        expandable.withIsExpanded(false);
        if (this.mPositionBasedStateManagement && (indexOfKey = this.mExpanded.indexOfKey(position)) >= 0) {
            this.mExpanded.removeAt(indexOfKey);
        }
        if (notifyItemChanged) {
            this.notifyItemChanged(position);
        }
    }

    public void expand(int position) {
        this.expand(position, false);
    }

    public void expand(int position, boolean notifyItemChanged) {
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable) {
            IExpandable expandable = (IExpandable)item;
            if (this.mPositionBasedStateManagement) {
                if (this.mExpanded.indexOfKey(position) < 0 && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
                    IAdapter<Item> adapter = this.getAdapter(position);
                    if (adapter != null && adapter instanceof IItemAdapter) {
                        ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
                    }
                    expandable.withIsExpanded(true);
                    if (notifyItemChanged) {
                        this.notifyItemChanged(position);
                    }
                    this.mExpanded.put(position, expandable.getSubItems() != null ? expandable.getSubItems().size() : 0);
                }
            } else if (!expandable.isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
                IAdapter<Item> adapter = this.getAdapter(position);
                if (adapter != null && adapter instanceof IItemAdapter) {
                    ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
                }
                expandable.withIsExpanded(true);
                if (notifyItemChanged) {
                    this.notifyItemChanged(position);
                }
            }
        }
    }

    public void notifyAdapterDataSetChanged() {
        if (this.mPositionBasedStateManagement) {
            this.mSelections.clear();
            this.mExpanded.clear();
        }
        this.cacheSizes();
        this.notifyDataSetChanged();
        if (this.mPositionBasedStateManagement) {
            AdapterUtil.handleStates(this, 0, this.getItemCount() - 1);
        }
    }

    public void notifyAdapterItemInserted(int position) {
        this.notifyAdapterItemRangeInserted(position, 1);
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
        if (this.mPositionBasedStateManagement) {
            this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount);
            this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, itemCount);
        }
        this.cacheSizes();
        this.notifyItemRangeInserted(position, itemCount);
        if (this.mPositionBasedStateManagement) {
            AdapterUtil.handleStates(this, position, position + itemCount - 1);
        }
    }

    public void notifyAdapterItemRemoved(int position) {
        this.notifyAdapterItemRangeRemoved(position, 1);
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
        if (this.mPositionBasedStateManagement) {
            this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount * -1);
            this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, itemCount * -1);
        }
        this.cacheSizes();
        this.notifyItemRangeRemoved(position, itemCount);
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        this.collapse(fromPosition);
        this.collapse(toPosition);
        if (this.mPositionBasedStateManagement) {
            if (!this.mSelections.contains(fromPosition) && this.mSelections.contains(toPosition)) {
                this.mSelections.remove(toPosition);
                this.mSelections.add(fromPosition);
            } else if (this.mSelections.contains(fromPosition) && !this.mSelections.contains(toPosition)) {
                this.mSelections.remove(fromPosition);
                this.mSelections.add(toPosition);
            }
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyAdapterItemChanged(int position) {
        this.notifyAdapterItemChanged(position, null);
    }

    public void notifyAdapterItemChanged(int position, Object payload) {
        this.notifyAdapterItemRangeChanged(position, 1, payload);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount) {
        this.notifyAdapterItemRangeChanged(position, itemCount, null);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, Object payload) {
        for (int i = position; i < position + itemCount; ++i) {
            if (this.mPositionBasedStateManagement) {
                if (this.mExpanded.indexOfKey(i) < 0) continue;
                this.collapse(i);
                continue;
            }
            Item item = this.getItem(position);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            this.collapse(position);
        }
        if (payload == null) {
            this.notifyItemRangeChanged(position, itemCount);
        } else {
            this.notifyItemRangeChanged(position, itemCount, payload);
        }
        if (this.mPositionBasedStateManagement) {
            AdapterUtil.handleStates(this, position, position + itemCount - 1);
        }
    }

    public void notifyAdapterSubItemsChanged(int position) {
        if (this.mPositionBasedStateManagement) {
            if (this.mExpanded.indexOfKey(position) > -1) {
                int previousCount = this.mExpanded.get(position);
                int itemsCount = this.notifyAdapterSubItemsChanged(position, previousCount);
                this.mExpanded.put(position, itemsCount);
            }
        } else {
            Log.e((String)"FastAdapter", (String)"please use the notifyAdapterSubItemsChanged(int position, int previousCount) method instead in the PositionBasedStateManagement mode, as we are not able to calculate the previous count ");
        }
    }

    public int notifyAdapterSubItemsChanged(int position, int previousCount) {
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable) {
            IExpandable expandable = (IExpandable)item;
            IAdapter<Item> adapter = this.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).removeRange(position + 1, previousCount);
                ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
            }
            return expandable.getSubItems().size();
        }
        return 0;
    }

    public static class RelativeInfo<Item extends IItem> {
        public IAdapter<Item> adapter = null;
        public Item item = null;
        public int position = -1;
    }

    public class OnBindViewHolderListenerImpl
    implements OnBindViewHolderListener {
        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position, List payloads) {
            FastAdapter.this.getItem(position).bindView((RecyclerView.ViewHolder)viewHolder, payloads);
        }
    }

    public static interface OnBindViewHolderListener {
        public void onBindViewHolder(RecyclerView.ViewHolder var1, int var2, List var3);
    }

    public class OnCreateViewHolderListenerImpl
    implements OnCreateViewHolderListener {
        @Override
        public RecyclerView.ViewHolder onPreCreateViewHolder(ViewGroup parent, int viewType) {
            return FastAdapter.this.getTypeInstance(viewType).getViewHolder(parent);
        }

        @Override
        public RecyclerView.ViewHolder onPostCreateViewHolder(RecyclerView.ViewHolder viewHolder) {
            return viewHolder;
        }
    }

    public static interface OnCreateViewHolderListener {
        public RecyclerView.ViewHolder onPreCreateViewHolder(ViewGroup var1, int var2);

        public RecyclerView.ViewHolder onPostCreateViewHolder(RecyclerView.ViewHolder var1);
    }

    public static interface OnLongClickListener<Item extends IItem> {
        public boolean onLongClick(View var1, IAdapter<Item> var2, Item var3, int var4);
    }

    public static interface OnClickListener<Item extends IItem> {
        public boolean onClick(View var1, IAdapter<Item> var2, Item var3, int var4);
    }

    public static interface OnTouchListener<Item extends IItem> {
        public boolean onTouch(View var1, MotionEvent var2, IAdapter<Item> var3, Item var4, int var5);
    }
}

