/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.support.annotation.NonNull;
import com.mikepenz.fastadapter.IIdentifyable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class IdDistributor {
    private static AtomicLong idDistributor = new AtomicLong(9000000000000000000L);

    public static <T extends IIdentifyable> List<T> checkIds(@NonNull List<T> items) {
        for (IIdentifyable item : items) {
            IdDistributor.checkId(item);
        }
        return items;
    }

    public static <T extends IIdentifyable> T[] checkIds(T ... items) {
        for (T item : items) {
            IdDistributor.checkId(item);
        }
        return items;
    }

    public static <T extends IIdentifyable> T checkId(@NonNull T item) {
        if (item.getIdentifier() == -1L) {
            item.withIdentifier(idDistributor.incrementAndGet());
        }
        return item;
    }
}

