/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.support.annotation.IdRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;

public class ClickListenerHelper<Item extends IItem> {
    private FastAdapter<Item> mFastAdapter;

    public ClickListenerHelper(FastAdapter<Item> fastAdapter) {
        this.mFastAdapter = fastAdapter;
    }

    public void listen(final RecyclerView.ViewHolder viewHolder, View view, final OnClickListener onClickListener) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = viewHolder.getAdapterPosition();
                if (pos != -1) {
                    Object item = ClickListenerHelper.this.mFastAdapter.getItem(pos);
                    onClickListener.onClick(v, pos, item);
                }
            }
        });
    }

    public void listen(final RecyclerView.ViewHolder viewHolder, @IdRes int viewId, final OnClickListener onClickListener) {
        viewHolder.itemView.findViewById(viewId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = viewHolder.getAdapterPosition();
                if (pos != -1) {
                    Object item = ClickListenerHelper.this.mFastAdapter.getItem(pos);
                    onClickListener.onClick(v, pos, item);
                }
            }
        });
    }

    public static interface OnClickListener<Item extends IItem> {
        public void onClick(View var1, int var2, Item var3);
    }
}

