/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import android.os.Bundle;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.utils.AdapterUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class FastAdapter<Item extends IItem>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected static final String BUNDLE_SELECTIONS = "bundle_selections";
    protected static final String BUNDLE_EXPANDED = "bundle_expanded";
    private ArrayMap<Integer, IAdapter<Item>> mAdapters = new ArrayMap();
    private ArrayMap<Integer, Item> mTypeInstances = new ArrayMap();
    private NavigableMap<Integer, IAdapter<Item>> mAdapterSizes = new TreeMap<Integer, IAdapter<Item>>();
    private int mGlobalSize = 0;
    private boolean mSelectWithItemUpdate = false;
    private boolean mMultiSelect = false;
    private boolean mSelectOnLongClick = false;
    private boolean mAllowDeselection = true;
    private SortedSet<Integer> mSelections = new TreeSet<Integer>();
    private SparseIntArray mExpanded = new SparseIntArray();
    private OnClickListener<Item> mOnPreClickListener;
    private OnClickListener<Item> mOnClickListener;
    private OnLongClickListener<Item> mOnPreLongClickListener;
    private OnLongClickListener<Item> mOnLongClickListener;
    private OnTouchListener<Item> mOnTouchListener;
    private OnCreateViewHolderListener mOnCreateViewHolderListener = new OnCreateViewHolderListenerImpl();
    private OnBindViewHolderListener mOnBindViewHolderListener = new OnBindViewHolderListenerImpl();

    public FastAdapter() {
        this.setHasStableIds(true);
    }

    public FastAdapter<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreClickListener(OnClickListener<Item> OnPreClickListener) {
        this.mOnPreClickListener = OnPreClickListener;
        return this;
    }

    public FastAdapter<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mOnLongClickListener = onLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreLongClickListener(OnLongClickListener<Item> OnPreLongClickListener) {
        this.mOnPreLongClickListener = OnPreLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mOnTouchListener = onTouchListener;
        return this;
    }

    public FastAdapter<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectWithItemUpdate = selectWithItemUpdate;
        return this;
    }

    public FastAdapter<Item> withMultiSelect(boolean multiSelect) {
        this.mMultiSelect = multiSelect;
        return this;
    }

    public FastAdapter<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectOnLongClick = selectOnLongClick;
        return this;
    }

    public FastAdapter<Item> withAllowDeselection(boolean allowDeselection) {
        this.mAllowDeselection = allowDeselection;
        return this;
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null) {
            int[] selections;
            int n;
            this.deselect();
            int[] expandedItems = savedInstanceState.getIntArray(BUNDLE_EXPANDED + prefix);
            if (expandedItems != null) {
                int[] nArray = expandedItems;
                int n2 = nArray.length;
                for (n = 0; n < n2; ++n) {
                    Integer expandedItem = nArray[n];
                    this.expand(expandedItem);
                }
            }
            if ((selections = savedInstanceState.getIntArray(BUNDLE_SELECTIONS + prefix)) != null) {
                int[] nArray = selections;
                n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer selection = nArray[i];
                    this.select(selection);
                }
            }
        }
        return this;
    }

    public <A extends AbstractAdapter<Item>> void registerAdapter(A adapter) {
        if (!this.mAdapters.containsKey((Object)adapter.getOrder())) {
            this.mAdapters.put((Object)adapter.getOrder(), adapter);
            this.cacheSizes();
        }
    }

    public void registerTypeInstance(Item item) {
        if (!this.mTypeInstances.containsKey((Object)item.getType())) {
            this.mTypeInstances.put((Object)item.getType(), item);
        }
    }

    public Map<Integer, Item> getTypeInstances() {
        return this.mTypeInstances;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        final RecyclerView.ViewHolder holder = this.mOnCreateViewHolderListener.onPreCreateViewHolder(parent, viewType);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = holder.getAdapterPosition();
                if (pos != -1) {
                    boolean consumed = false;
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    if (relativeInfo.item != null && relativeInfo.item.isEnabled()) {
                        if (FastAdapter.this.mOnPreClickListener != null) {
                            consumed = FastAdapter.this.mOnPreClickListener.onClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                        }
                        if (!consumed && !FastAdapter.this.mSelectOnLongClick) {
                            FastAdapter.this.handleSelection(v, relativeInfo.item, pos);
                        }
                        if (FastAdapter.this.mOnClickListener != null) {
                            FastAdapter.this.mOnClickListener.onClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                        }
                    }
                }
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                int pos = holder.getAdapterPosition();
                if (pos != -1) {
                    boolean consumed = false;
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    if (relativeInfo.item != null && relativeInfo.item.isEnabled()) {
                        if (FastAdapter.this.mOnPreLongClickListener != null) {
                            consumed = FastAdapter.this.mOnPreLongClickListener.onLongClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                        }
                        if (!consumed && FastAdapter.this.mSelectOnLongClick) {
                            FastAdapter.this.handleSelection(v, relativeInfo.item, pos);
                        }
                        if (FastAdapter.this.mOnLongClickListener != null) {
                            consumed = FastAdapter.this.mOnLongClickListener.onLongClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                        }
                    }
                    return consumed;
                }
                return false;
            }
        });
        holder.itemView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int pos;
                if (FastAdapter.this.mOnTouchListener != null && (pos = holder.getAdapterPosition()) != -1) {
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    return FastAdapter.this.mOnTouchListener.onTouch(v, event, relativeInfo.adapter, relativeInfo.item, pos);
                }
                return false;
            }
        });
        return this.mOnCreateViewHolderListener.onPostCreateViewHolder(holder);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.mOnBindViewHolderListener.onBindViewHolder(holder, position);
    }

    public int getPosition(Item item) {
        if (item.getIdentifier() == -1L) {
            Log.e((String)"FastAdapter", (String)"You have to define an identifier for your item to retrieve the position via this method");
            return -1;
        }
        int position = 0;
        int length = this.mAdapters.size();
        for (int i = 0; i < length; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            int relativePosition = adapter.getAdapterPosition(item);
            if (relativePosition != -1) {
                return position + relativePosition;
            }
            position = adapter.getAdapterItemCount();
        }
        return -1;
    }

    public Item getItem(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        Map.Entry<Integer, IAdapter<Item>> entry = this.mAdapterSizes.floorEntry(position);
        return entry.getValue().getAdapterItem(position - entry.getKey());
    }

    public RelativeInfo<Item> getRelativeInfo(int position) {
        if (position < 0) {
            return new RelativeInfo();
        }
        RelativeInfo relativeInfo = new RelativeInfo();
        Map.Entry<Integer, IAdapter<Item>> entry = this.mAdapterSizes.floorEntry(position);
        if (entry != null) {
            relativeInfo.item = entry.getValue().getAdapterItem(position - entry.getKey());
            relativeInfo.adapter = entry.getValue();
        }
        return relativeInfo;
    }

    public IAdapter<Item> getAdapter(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        return this.mAdapterSizes.floorEntry(position).getValue();
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getIdentifier();
    }

    public int getItemCount() {
        return this.mGlobalSize;
    }

    public int getItemCount(int order) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        return this.mAdapterSizes.floorKey(order);
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null) {
            int[] selections = new int[this.mSelections.size()];
            int index = 0;
            for (Integer selection : this.mSelections) {
                selections[index] = selection;
                ++index;
            }
            savedInstanceState.putIntArray(BUNDLE_SELECTIONS + prefix, selections);
            savedInstanceState.putIntArray(BUNDLE_EXPANDED + prefix, this.getExpandedItems());
        }
        return savedInstanceState;
    }

    private void cacheSizes() {
        this.mAdapterSizes.clear();
        int size = 0;
        for (IAdapter adapter : this.mAdapters.values()) {
            if (adapter.getAdapterItemCount() <= 0) continue;
            this.mAdapterSizes.put(size, adapter);
            size += adapter.getAdapterItemCount();
        }
        this.mGlobalSize = size;
    }

    public Set<Integer> getSelections() {
        return this.mSelections;
    }

    public Set<Item> getSelectedItems() {
        HashSet<Item> items = new HashSet<Item>();
        for (Integer position : this.getSelections()) {
            items.add(this.getItem(position));
        }
        return items;
    }

    public void toggleSelection(int position) {
        if (this.mSelections.contains(position)) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    private void handleSelection(View view, Item item, int position) {
        if (!item.isSelectable()) {
            return;
        }
        if (item.isSelected() && !this.mAllowDeselection) {
            return;
        }
        boolean selected = this.mSelections.contains(position);
        if (this.mSelectWithItemUpdate || view == null) {
            if (!this.mMultiSelect) {
                this.deselect();
            }
            if (selected) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else {
            if (!this.mMultiSelect) {
                Iterator<Integer> entries = this.mSelections.iterator();
                while (entries.hasNext()) {
                    Integer pos = (Integer)entries.next();
                    if (pos == position) continue;
                    this.deselect(pos, entries);
                }
            }
            item.withSetSelected(!selected);
            view.setSelected(!selected);
            if (selected) {
                if (this.mSelections.contains(position)) {
                    this.mSelections.remove(position);
                }
            } else {
                this.mSelections.add(position);
            }
        }
    }

    public void select(Iterable<Integer> positions) {
        for (Integer position : positions) {
            this.select(position);
        }
    }

    public void select(int position) {
        this.select(position, false);
    }

    public void select(int position, boolean fireEvent) {
        Item item = this.getItem(position);
        if (item != null) {
            item.withSetSelected(true);
            this.mSelections.add(position);
        }
        this.notifyItemChanged(position);
        if (this.mOnClickListener != null && fireEvent) {
            this.mOnClickListener.onClick(null, this.getAdapter(position), item, position);
        }
    }

    public void deselect() {
        this.deselect(this.mSelections);
    }

    public void deselect(Iterable<Integer> positions) {
        Iterator<Integer> entries = positions.iterator();
        while (entries.hasNext()) {
            this.deselect(entries.next(), entries);
        }
    }

    public void deselect(int position) {
        this.deselect(position, null);
    }

    private void deselect(int position, Iterator<Integer> entries) {
        Item item = this.getItem(position);
        if (item != null) {
            item.withSetSelected(false);
        }
        if (entries == null) {
            if (this.mSelections.contains(position)) {
                this.mSelections.remove(position);
            }
        } else {
            entries.remove();
        }
        this.notifyItemChanged(position);
    }

    public List<Item> deleteAllSelectedItems() {
        LinkedList<Item> deletedItems = new LinkedList<Item>();
        Set<Integer> selections = this.getSelections();
        while (selections.size() > 0) {
            Iterator<Integer> iterator = selections.iterator();
            int position = iterator.next();
            IAdapter<Item> adapter = this.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                deletedItems.add(this.getItem(position));
                ((IItemAdapter)adapter).remove(position);
            } else {
                iterator.remove();
            }
            selections = this.getSelections();
        }
        return deletedItems;
    }

    public int[] getExpandedItems() {
        int[] expandedItems = new int[this.mExpanded.size()];
        int length = this.mExpanded.size();
        for (int i = 0; i < length; ++i) {
            expandedItems[i] = this.mExpanded.keyAt(i);
        }
        return expandedItems;
    }

    public void toggleExpandable(int position) {
        if (this.mExpanded.indexOfKey(position) >= 0) {
            this.collapse(position);
        } else {
            this.expand(position);
        }
    }

    public void collapse(int position) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            int totalAddedItems = expandable.getSubItems().size();
            int length = this.mExpanded.size();
            for (int i = 0; i < length; ++i) {
                if (this.mExpanded.keyAt(i) <= position || this.mExpanded.keyAt(i) > position + totalAddedItems) continue;
                totalAddedItems += this.mExpanded.get(this.mExpanded.keyAt(i));
            }
            for (Integer value : this.mSelections) {
                if (value <= position || value > position + totalAddedItems) continue;
                this.deselect(value);
            }
            for (int i = length - 1; i >= 0; --i) {
                if (this.mExpanded.keyAt(i) <= position || this.mExpanded.keyAt(i) > position + totalAddedItems) continue;
                totalAddedItems -= this.mExpanded.get(this.mExpanded.keyAt(i));
                this.internalCollapse(this.mExpanded.keyAt(i));
            }
            this.internalCollapse(expandable, position);
        }
    }

    private void internalCollapse(int position) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            this.internalCollapse(expandable, position);
        }
    }

    private void internalCollapse(IExpandable expandable, int position) {
        IAdapter<Item> adapter = this.getAdapter(position);
        if (adapter != null && adapter instanceof IItemAdapter) {
            ((IItemAdapter)adapter).removeRange(position + 1, expandable.getSubItems().size());
        }
        expandable.withIsExpanded(false);
        int indexOfKey = this.mExpanded.indexOfKey(position);
        if (indexOfKey >= 0) {
            this.mExpanded.removeAt(indexOfKey);
        }
    }

    public void expand(int position) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && !(expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            IAdapter<Item> adapter = this.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
            }
            expandable.withIsExpanded(true);
            this.mExpanded.put(position, expandable.getSubItems() != null ? expandable.getSubItems().size() : 0);
        }
    }

    public void notifyAdapterItemInserted(int position) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, 1);
        this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, 1);
        this.notifyItemInserted(position);
        this.cacheSizes();
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount);
        this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, itemCount);
        this.notifyItemRangeInserted(position, itemCount);
        this.cacheSizes();
    }

    public void notifyAdapterItemRemoved(int position) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, -1);
        this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, -1);
        this.notifyItemRemoved(position);
        this.cacheSizes();
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount * -1);
        this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, itemCount * -1);
        this.notifyItemRangeRemoved(position, itemCount);
        this.cacheSizes();
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        this.collapse(fromPosition);
        this.collapse(toPosition);
        if (!this.mSelections.contains(fromPosition) && this.mSelections.contains(toPosition)) {
            this.mSelections.remove(toPosition);
            this.mSelections.add(fromPosition);
        } else if (this.mSelections.contains(fromPosition) && !this.mSelections.contains(toPosition)) {
            this.mSelections.remove(fromPosition);
            this.mSelections.add(toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyAdapterItemChanged(int position) {
        this.notifyAdapterItemChanged(position, null);
    }

    public void notifyAdapterItemChanged(int position, Object payload) {
        Item updateItem = this.getItem(position);
        if (updateItem.isSelected()) {
            this.mSelections.add(position);
        } else if (this.mSelections.contains(position)) {
            this.mSelections.remove(position);
        }
        if (payload == null) {
            this.notifyItemChanged(position);
        } else {
            this.notifyItemChanged(position, payload);
        }
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount) {
        this.notifyAdapterItemRangeChanged(position, itemCount, null);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, Object payload) {
        for (int i = position; i < position + itemCount; ++i) {
            Item updateItem = this.getItem(position);
            if (updateItem.isSelected()) {
                this.mSelections.add(position);
                continue;
            }
            if (!this.mSelections.contains(position)) continue;
            this.mSelections.remove(position);
        }
        if (payload == null) {
            this.notifyItemRangeChanged(position, itemCount);
        } else {
            this.notifyItemRangeChanged(position, itemCount, payload);
        }
    }

    public static class RelativeInfo<Item extends IItem> {
        public IAdapter<Item> adapter = null;
        public Item item = null;
    }

    public class OnBindViewHolderListenerImpl
    implements OnBindViewHolderListener {
        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
            FastAdapter.this.getItem(position).bindView((RecyclerView.ViewHolder)viewHolder);
        }
    }

    public static interface OnBindViewHolderListener {
        public void onBindViewHolder(RecyclerView.ViewHolder var1, int var2);
    }

    public class OnCreateViewHolderListenerImpl
    implements OnCreateViewHolderListener {
        @Override
        public RecyclerView.ViewHolder onPreCreateViewHolder(ViewGroup parent, int viewType) {
            return ((IItem)FastAdapter.this.mTypeInstances.get((Object)viewType)).getViewHolder(parent);
        }

        @Override
        public RecyclerView.ViewHolder onPostCreateViewHolder(RecyclerView.ViewHolder viewHolder) {
            return viewHolder;
        }
    }

    public static interface OnCreateViewHolderListener {
        public RecyclerView.ViewHolder onPreCreateViewHolder(ViewGroup var1, int var2);

        public RecyclerView.ViewHolder onPostCreateViewHolder(RecyclerView.ViewHolder var1);
    }

    public static interface OnLongClickListener<Item extends IItem> {
        public boolean onLongClick(View var1, IAdapter<Item> var2, Item var3, int var4);
    }

    public static interface OnClickListener<Item extends IItem> {
        public boolean onClick(View var1, IAdapter<Item> var2, Item var3, int var4);
    }

    public static interface OnTouchListener<Item extends IItem> {
        public boolean onTouch(View var1, MotionEvent var2, IAdapter<Item> var3, Item var4, int var5);
    }
}

