/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.items.GenericAbstractItem;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GenericItemAdapter<Model, Item extends GenericAbstractItem>
extends ItemAdapter<Item> {
    private List<Model> mItems = new ArrayList<Model>();
    private Class<Model> modelClass;
    private Class<Item> itemClass;

    public GenericItemAdapter(Class<Item> itemClass, Class<Model> modelClass) {
        this.itemClass = itemClass;
        this.modelClass = modelClass;
    }

    public void setModel(List<Model> models) {
        super.set(this.toItems(models));
        this.mItems = models;
    }

    public void addModel(Model ... models) {
        super.add(this.toItems(models));
        Collections.addAll(this.mItems, models);
    }

    public void addModel(List<Model> models) {
        super.add(this.toItems(models));
        this.mItems.addAll(models);
    }

    public void addModel(int position, Model ... models) {
        super.add(position, this.toItems(models));
        this.mItems.addAll(position - this.getFastAdapter().getItemCount(this.getOrder()), Arrays.asList(models));
    }

    public void addModel(int position, List<Model> models) {
        super.add(position, this.toItems(models));
        this.mItems.addAll(position - this.getFastAdapter().getItemCount(this.getOrder()), models);
    }

    public void setModel(int position, Model model) {
        super.set(position, this.getAbstractItem(model));
        this.mItems.set(position - this.getFastAdapter().getItemCount(this.getOrder()), model);
    }

    public void addModel(Model model) {
        super.add(this.getAbstractItem(model));
        this.mItems.add(model);
    }

    public void addModel(int position, Model model) {
        super.add(position, this.getAbstractItem(model));
        this.mItems.add(position - this.getFastAdapter().getItemCount(this.getOrder()), model);
    }

    public void clearModel() {
        super.clear();
        this.mItems.clear();
    }

    public void removeModelRange(int position, int itemCount) {
        super.removeRange(position, itemCount);
        int length = this.mItems.size();
        int saveItemCount = Math.min(itemCount, length - position + this.getFastAdapter().getItemCount(this.getOrder()));
        for (int i = 0; i < saveItemCount; ++i) {
            this.mItems.remove(position - this.getFastAdapter().getItemCount(this.getOrder()));
        }
    }

    public void removeModel(int position) {
        super.remove(position);
        this.mItems.remove(position - this.getFastAdapter().getItemCount(this.getOrder()));
    }

    private List<Item> toItems(List<Model> models) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (models != null) {
            for (Model model : models) {
                items.add(this.getAbstractItem(model));
            }
        }
        return items;
    }

    private List<Item> toItems(Model ... models) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (models != null) {
            for (Model model : models) {
                items.add(this.getAbstractItem(model));
            }
        }
        return items;
    }

    private Item getAbstractItem(Model model) {
        try {
            return (Item)((GenericAbstractItem)this.itemClass.getDeclaredConstructor(this.modelClass).newInstance(model));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }
}

