/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.helpers.UndoHelper;
import com.mikepenz.fastadapter.select.SelectExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006*\u0001\u0017\u0018\u0000 )*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002j\u0002`\u00042\u00020\u0005:\u0003)*+B!\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J4\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&J*\u0010\u001e\u001a\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&2\u0006\u0010\"\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aJ\b\u0010'\u001a\u00020\u001cH\u0002J\u001c\u0010(\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0018\u00010\u000eR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/mikepenz/fastadapter/helpers/UndoHelper;", "Item", "Lcom/mikepenz/fastadapter/IItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/fastadapter/GenericItem;", "", "adapter", "Lcom/mikepenz/fastadapter/FastAdapter;", "undoListener", "Lcom/mikepenz/fastadapter/helpers/UndoHelper$UndoListener;", "(Lcom/mikepenz/fastadapter/FastAdapter;Lcom/mikepenz/fastadapter/helpers/UndoHelper$UndoListener;)V", "alreadyCommitted", "", "history", "Lcom/mikepenz/fastadapter/helpers/UndoHelper$History;", "<set-?>", "Lcom/google/android/material/snackbar/Snackbar;", "snackBar", "getSnackBar", "()Lcom/google/android/material/snackbar/Snackbar;", "snackBarActionText", "", "snackBarCallback", "com/mikepenz/fastadapter/helpers/UndoHelper$snackBarCallback$1", "Lcom/mikepenz/fastadapter/helpers/UndoHelper$snackBarCallback$1;", "snackbarBuilder", "Lkotlin/Function0;", "doChange", "", "notifyCommit", "remove", "view", "Landroid/view/View;", "text", "actionText", "duration", "", "positions", "", "undoChange", "withSnackBar", "Companion", "History", "UndoListener", "fastadapter-extensions-utils"})
public final class UndoHelper<Item extends IItem<? extends RecyclerView.ViewHolder>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FastAdapter<Item> adapter;
    @NotNull
    private final UndoListener<Item> undoListener;
    @Nullable
    private History history;
    @NotNull
    private String snackBarActionText;
    private boolean alreadyCommitted;
    @NotNull
    private final snackBarCallback.1 snackBarCallback;
    @Nullable
    private Snackbar snackBar;
    @Nullable
    private Function0<? extends Snackbar> snackbarBuilder;
    private static final int ACTION_REMOVE = 2;

    public UndoHelper(@NotNull FastAdapter<Item> adapter, @NotNull UndoListener<Item> undoListener) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(undoListener, (String)"undoListener");
        this.adapter = adapter;
        this.undoListener = undoListener;
        this.snackBarActionText = "";
        this.snackBarCallback = new Snackbar.Callback(this){
            final /* synthetic */ UndoHelper<Item> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onShown(@Nullable Snackbar sb) {
                super.onShown(sb);
                UndoHelper.access$setAlreadyCommitted$p(this.this$0, false);
            }

            public void onDismissed(@Nullable Snackbar transientBottomBar, int event) {
                super.onDismissed(transientBottomBar, event);
                if (event == 1 || UndoHelper.access$getAlreadyCommitted$p(this.this$0)) {
                    return;
                }
                UndoHelper.access$notifyCommit(this.this$0);
            }
        };
    }

    @Nullable
    public final Snackbar getSnackBar() {
        return this.snackBar;
    }

    public final void withSnackBar(@NotNull String actionText, @NotNull Function0<? extends Snackbar> snackbarBuilder) {
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        Intrinsics.checkNotNullParameter(snackbarBuilder, (String)"snackbarBuilder");
        this.snackBarActionText = actionText;
        this.snackbarBuilder = snackbarBuilder;
    }

    @Nullable
    public final Snackbar remove(@NotNull Set<Integer> positions) {
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        Function0<? extends Snackbar> function0 = this.snackbarBuilder;
        if (function0 == null) {
            return null;
        }
        Function0<? extends Snackbar> builder = function0;
        return this.remove(positions, this.snackBarActionText, builder);
    }

    @NotNull
    public final Snackbar remove(@NotNull View view, @NotNull String text, @NotNull String actionText, int duration, @NotNull Set<Integer> positions) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        return this.remove(positions, actionText, (Function0<Snackbar>)((Function0)new Function0<Snackbar>(view, text, duration){
            final /* synthetic */ View $view;
            final /* synthetic */ String $text;
            final /* synthetic */ int $duration;
            {
                this.$view = $view;
                this.$text = $text;
                this.$duration = $duration;
                super(0);
            }

            @NotNull
            public final Snackbar invoke() {
                Snackbar snackbar = Snackbar.make((View)this.$view, (CharSequence)this.$text, (int)this.$duration);
                Intrinsics.checkNotNullExpressionValue((Object)snackbar, (String)"make(view, text, duration)");
                return snackbar;
            }
        }));
    }

    @NotNull
    public final Snackbar remove(@NotNull Set<Integer> positions, @NotNull String actionText, @NotNull Function0<? extends Snackbar> snackbarBuilder) {
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        Intrinsics.checkNotNullParameter(snackbarBuilder, (String)"snackbarBuilder");
        if (this.history != null) {
            this.alreadyCommitted = true;
            this.notifyCommit();
        }
        History history = new History();
        history.setAction(2);
        Snackbar snackbar = positions.iterator();
        while (snackbar.hasNext()) {
            int position = ((Number)snackbar.next()).intValue();
            history.getItems().add(this.adapter.getRelativeInfo(position));
        }
        CollectionsKt.sortWith((List)history.getItems(), (arg_0, arg_1) -> UndoHelper.remove$lambda$0(remove.2.INSTANCE, arg_0, arg_1));
        this.history = history;
        this.doChange();
        Snackbar snackbar2 = ((Snackbar)((Snackbar)snackbarBuilder.invoke()).addCallback((BaseTransientBottomBar.BaseCallback)this.snackBarCallback)).setAction((CharSequence)actionText, arg_0 -> UndoHelper.remove$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)snackbar2, (String)"snackbarBuilder.invoke()\u2026ionText) { undoChange() }");
        Snackbar it = snackbar = snackbar2;
        boolean bl = false;
        it.show();
        this.snackBar = it;
        return snackbar;
    }

    private final void notifyCommit() {
        block2: {
            History history = this.history;
            if (history == null) break block2;
            History mHistory = history;
            boolean bl = false;
            if (mHistory.getAction() == 2) {
                TreeSet<Integer> positions = new TreeSet<Integer>(UndoHelper::notifyCommit$lambda$4$lambda$3);
                for (FastAdapter.RelativeInfo relativeInfo : mHistory.getItems()) {
                    positions.add(relativeInfo.getPosition());
                }
                this.undoListener.commitRemove((Set<Integer>)positions, mHistory.getItems());
                this.history = null;
            }
        }
    }

    private final void doChange() {
        block2: {
            int n;
            History history = this.history;
            if (history == null) break block2;
            History mHistory = history;
            boolean bl = false;
            if (mHistory.getAction() == 2 && 0 <= (n = mHistory.getItems().size() + -1)) {
                do {
                    FastAdapter.RelativeInfo relativeInfo;
                    int i = n--;
                    Intrinsics.checkNotNullExpressionValue(mHistory.getItems().get(i), (String)"mHistory.items[i]");
                    if (!(relativeInfo.getAdapter() instanceof IItemAdapter)) continue;
                    IAdapter iAdapter = relativeInfo.getAdapter();
                    Intrinsics.checkNotNull((Object)iAdapter, (String)"null cannot be cast to non-null type com.mikepenz.fastadapter.IItemAdapter<*, *>");
                    ((IItemAdapter)iAdapter).remove(relativeInfo.getPosition());
                } while (0 <= n);
            }
        }
    }

    private final void undoChange() {
        History history = this.history;
        if (history != null) {
            History mHistory = history;
            boolean bl = false;
            if (mHistory.getAction() == 2) {
                int size = mHistory.getItems().size();
                for (int i = 0; i < size; ++i) {
                    SelectExtension selectExtension;
                    FastAdapter.RelativeInfo relativeInfo;
                    Intrinsics.checkNotNullExpressionValue(mHistory.getItems().get(i), (String)"mHistory.items[i]");
                    if (!(relativeInfo.getAdapter() instanceof IItemAdapter)) continue;
                    IItemAdapter adapter = (IItemAdapter)relativeInfo.getAdapter();
                    if (relativeInfo.getItem() == null) continue;
                    boolean bl2 = false;
                    IItemAdapter iItemAdapter = adapter;
                    if (iItemAdapter != null) {
                        IItem it;
                        int n = relativeInfo.getPosition();
                        IItem[] iItemArray = new IItem[]{it};
                        List<IItem> list = Arrays.asList(iItemArray);
                        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(it)");
                        iItemAdapter.addInternal(n, list);
                    }
                    IItem iItem = relativeInfo.getItem();
                    boolean bl3 = iItem != null ? iItem.isSelected() : false;
                    if (!bl3) continue;
                    SelectExtension selectExtension2 = selectExtension = (SelectExtension)this.adapter.getExtension(SelectExtension.class);
                    if (selectExtension2 == null) continue;
                    SelectExtension.select$default((SelectExtension)selectExtension2, (int)relativeInfo.getPosition(), (boolean)false, (boolean)false, (int)6, null);
                }
            }
        }
        this.history = null;
    }

    private static final int remove$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void remove$lambda$1(UndoHelper this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.undoChange();
    }

    private static final int notifyCommit$lambda$4$lambda$3(Integer lhs, Integer rhs) {
        int n = lhs;
        Intrinsics.checkNotNullExpressionValue((Object)rhs, (String)"rhs");
        return Intrinsics.compare((int)n, (int)rhs);
    }

    public static final /* synthetic */ void access$setAlreadyCommitted$p(UndoHelper $this, boolean bl) {
        $this.alreadyCommitted = bl;
    }

    public static final /* synthetic */ boolean access$getAlreadyCommitted$p(UndoHelper $this) {
        return $this.alreadyCommitted;
    }

    public static final /* synthetic */ void access$notifyCommit(UndoHelper $this) {
        $this.notifyCommit();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0014\b\u0001\u0010\u0001*\u000e\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002j\u0002`\u00042\u00020\u0005J*\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\fH&\u00a8\u0006\u000e"}, d2={"Lcom/mikepenz/fastadapter/helpers/UndoHelper$UndoListener;", "Item", "Lcom/mikepenz/fastadapter/IItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/fastadapter/GenericItem;", "", "commitRemove", "", "positions", "", "", "removed", "Ljava/util/ArrayList;", "Lcom/mikepenz/fastadapter/FastAdapter$RelativeInfo;", "fastadapter-extensions-utils"})
    public static interface UndoListener<Item extends IItem<? extends RecyclerView.ViewHolder>> {
        public void commitRemove(@NotNull Set<Integer> var1, @NotNull ArrayList<FastAdapter.RelativeInfo<Item>> var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/mikepenz/fastadapter/helpers/UndoHelper$History;", "", "(Lcom/mikepenz/fastadapter/helpers/UndoHelper;)V", "action", "", "getAction", "()I", "setAction", "(I)V", "items", "Ljava/util/ArrayList;", "Lcom/mikepenz/fastadapter/FastAdapter$RelativeInfo;", "getItems", "()Ljava/util/ArrayList;", "setItems", "(Ljava/util/ArrayList;)V", "fastadapter-extensions-utils"})
    private final class History {
        private int action;
        @NotNull
        private ArrayList<FastAdapter.RelativeInfo<Item>> items = new ArrayList();

        public final int getAction() {
            return this.action;
        }

        public final void setAction(int n) {
            this.action = n;
        }

        @NotNull
        public final ArrayList<FastAdapter.RelativeInfo<Item>> getItems() {
            return this.items;
        }

        public final void setItems(@NotNull ArrayList<FastAdapter.RelativeInfo<Item>> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.items = arrayList;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mikepenz/fastadapter/helpers/UndoHelper$Companion;", "", "()V", "ACTION_REMOVE", "", "fastadapter-extensions-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

