/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.os.Bundle;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.FastItemAdapter;
import com.mikepenz.fastadapter.helpers.ActionModeHelper;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.fastadapter.utils.SubItemUtil;

public class RangeSelectorHelper<Item extends IItem<? extends RecyclerView.ViewHolder>> {
    protected static final String BUNDLE_LAST_LONG_PRESS = "bundle_last_long_press";
    private FastItemAdapter<Item> mFastAdapter;
    private ActionModeHelper mActionModeHelper;
    private boolean mSupportSubItems = false;
    private Object mPayload = null;
    private Integer mLastLongPressIndex;

    public RangeSelectorHelper(FastItemAdapter<Item> adapter) {
        this.mFastAdapter = adapter;
    }

    public RangeSelectorHelper withActionModeHelper(ActionModeHelper actionModeHelper) {
        this.mActionModeHelper = actionModeHelper;
        return this;
    }

    public RangeSelectorHelper withSupportSubItems(boolean supportSubItems) {
        this.mSupportSubItems = supportSubItems;
        return this;
    }

    public RangeSelectorHelper withPayload(Object payload) {
        this.mPayload = payload;
        return this;
    }

    public void onClick() {
        this.reset();
    }

    public void reset() {
        this.mLastLongPressIndex = null;
    }

    public boolean onLongClick(int index) {
        return this.onLongClick(index, true);
    }

    public boolean onLongClick(int index, boolean selectItem) {
        if (this.mLastLongPressIndex == null) {
            if (this.mFastAdapter.getAdapterItem(index).isSelectable()) {
                SelectExtension selectExtension;
                this.mLastLongPressIndex = index;
                if (selectItem && (selectExtension = (SelectExtension)this.mFastAdapter.getExtension(SelectExtension.class)) != null) {
                    selectExtension.select(index);
                }
                if (this.mActionModeHelper != null) {
                    this.mActionModeHelper.checkActionMode(null);
                }
                return true;
            }
        } else if (this.mLastLongPressIndex != index) {
            this.selectRange(this.mLastLongPressIndex, index, true);
            this.mLastLongPressIndex = null;
        }
        return false;
    }

    public <T extends IItem & IExpandable> void selectRange(int from, int to, boolean select) {
        this.selectRange(from, to, select, false);
    }

    public <T extends IItem & IExpandable> void selectRange(int from, int to, boolean select, boolean skipHeaders) {
        if (from > to) {
            int temp = from;
            from = to;
            to = temp;
        }
        for (int i = from; i <= to; ++i) {
            SelectExtension selectExtension;
            Item item = this.mFastAdapter.getAdapterItem(i);
            if (item.isSelectable() && (selectExtension = (SelectExtension)this.mFastAdapter.getExtension(SelectExtension.class)) != null) {
                if (select) {
                    selectExtension.select(i);
                } else {
                    selectExtension.deselect(i);
                }
            }
            if (!this.mSupportSubItems || skipHeaders || !(item instanceof IExpandable) || ((IExpandable)item).isExpanded()) continue;
            SubItemUtil.selectAllSubItems(this.mFastAdapter, this.mFastAdapter.getAdapterItem(i), (boolean)select, (boolean)true, (Object)this.mPayload);
        }
        if (this.mActionModeHelper != null) {
            this.mActionModeHelper.checkActionMode(null);
        }
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null && this.mLastLongPressIndex != null) {
            savedInstanceState.putInt(BUNDLE_LAST_LONG_PRESS, this.mLastLongPressIndex.intValue());
        }
        return savedInstanceState;
    }

    public RangeSelectorHelper withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public RangeSelectorHelper withSavedInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null && savedInstanceState.containsKey(BUNDLE_LAST_LONG_PRESS + prefix)) {
            this.mLastLongPressIndex = savedInstanceState.getInt(BUNDLE_LAST_LONG_PRESS + prefix);
        }
        return this;
    }
}

