/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin.util.parser;

import com.mikepenz.aboutlibraries.plugin.mapping.Developer;
import com.mikepenz.aboutlibraries.plugin.mapping.Funding;
import com.mikepenz.aboutlibraries.plugin.mapping.Library;
import com.mikepenz.aboutlibraries.plugin.mapping.Organization;
import com.mikepenz.aboutlibraries.plugin.mapping.Scm;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/util/parser/LibraryReader;", "", "()V", "LIBRARIES_DIR", "", "LOGGER", "Lorg/slf4j/Logger;", "readLibraries", "", "Lcom/mikepenz/aboutlibraries/plugin/mapping/Library;", "configDir", "Ljava/io/File;", "readLibrary", "name", "content", "Ljava/io/InputStream;", "plugin"})
@SourceDebugExtension(value={"SMAP\nLibraryReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryReader.kt\ncom/mikepenz/aboutlibraries/plugin/util/parser/LibraryReader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n11383#2,9:70\n13309#2:79\n13310#2:81\n11392#2:82\n1#3:80\n1855#4,2:83\n1855#4,2:85\n*S KotlinDebug\n*F\n+ 1 LibraryReader.kt\ncom/mikepenz/aboutlibraries/plugin/util/parser/LibraryReader\n*L\n14#1:70,9\n14#1:79\n14#1:81\n14#1:82\n14#1:80\n29#1:83,2\n44#1:85,2\n*E\n"})
public final class LibraryReader {
    @NotNull
    public static final LibraryReader INSTANCE = new LibraryReader();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String LIBRARIES_DIR = "libraries";

    private LibraryReader() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Library> readLibraries(@NotNull File configDir) {
        List list;
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        File librariesDir = new File(configDir, LIBRARIES_DIR);
        if (librariesDir.exists()) {
            File[] fileArray = librariesDir.listFiles();
            if (fileArray != null) {
                void $this$mapNotNullTo$iv$iv;
                File[] $this$mapNotNull$iv = fileArray;
                boolean $i$f$mapNotNull = false;
                File[] fileArray2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Library it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Intrinsics.checkNotNull((Object)it);
                    if (INSTANCE.readLibrary(string, new FileInputStream((File)it)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            LOGGER.debug("No custom libraries provided");
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Library readLibrary(String name, InputStream content) {
        Library library;
        try {
            Scm scm2;
            Organization organization2;
            Map it;
            Object $i$f$forEach2;
            Object object = new JsonSlurper().parse(content);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            Map c = (Map)object;
            List developers2 = new ArrayList();
            Object v = c.get("developers");
            List list = v instanceof List ? (List)v : null;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map it2 = (Map)element$iv;
                    boolean bl = false;
                    developers2.add(new Developer((String)it2.get("name"), (String)it2.get("organisationUrl")));
                }
            }
            Map map = ($i$f$forEach2 = c.get("organization")) instanceof Map ? (Map)$i$f$forEach2 : null;
            if (map != null) {
                it = map;
                boolean bl = false;
                String string = (String)it.get("name");
                if (string == null) {
                    string = "";
                }
                organization2 = new Organization(string, (String)it.get("url"));
            } else {
                organization2 = null;
            }
            Organization organization3 = organization2;
            it = c.get("scm");
            Map map2 = it instanceof Map ? it : null;
            if (map2 != null) {
                Map it3 = map2;
                boolean bl = false;
                scm2 = new Scm((String)it3.get("connection"), (String)it3.get("developerConnection"), (String)it3.get("url"));
            } else {
                scm2 = null;
            }
            Scm scm3 = scm2;
            Object v2 = c.get("licenses");
            Collection collection = v2 instanceof List ? (List)v2 : null;
            if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
                collection = SetsKt.emptySet();
            }
            Collection licenses2 = collection;
            Set funding = new LinkedHashSet();
            Object bl = c.get("funding");
            List list2 = bl instanceof List ? (List)bl : null;
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string;
                    Map it4 = (Map)element$iv;
                    boolean bl2 = false;
                    String string2 = (String)it4.get("platform");
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = (String)it4.get("url")) == null) {
                        string = "";
                    }
                    funding.add(new Funding(string2, string));
                }
            }
            Object v3 = c.get("uniqueId");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.String");
            v2 = c.get("artifactVersion");
            String string = v2 instanceof String ? (String)v2 : null;
            v2 = c.get("name");
            String string3 = v2 instanceof String ? (String)v2 : null;
            v2 = c.get("description");
            String string4 = v2 instanceof String ? (String)v2 : null;
            v2 = c.get("website");
            String string5 = v2 instanceof String ? (String)v2 : null;
            v2 = c.get("tag");
            library = new Library((String)v3, string, string3, string4, string5, developers2, organization3, scm3, (Set)licenses2, funding, v2 instanceof String ? (String)v2 : null, null, 2048, null);
        }
        catch (Throwable t) {
            LOGGER.error("Could not read the license (" + name + ")", t);
            library = null;
        }
        return library;
    }

    static {
        Logger logger = LoggerFactory.getLogger(LibraryReader.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }
}

