/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin;

import com.mikepenz.aboutlibraries.plugin.AboutLibrariesExtension;
import com.mikepenz.aboutlibraries.plugin.DuplicateMode;
import com.mikepenz.aboutlibraries.plugin.DuplicateRule;
import com.mikepenz.aboutlibraries.plugin.model.CollectedContainer;
import com.mikepenz.aboutlibraries.plugin.util.LibrariesProcessor;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020;H\u0004J\n\u0010<\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010=\u001a\u00020>H'J\b\u0010?\u001a\u00020;H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u00118\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\f8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001d\u0010\u000eR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020$8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020(8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020(8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0018\u0010-\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\u00020(8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010*R\u0016\u00102\u001a\n 3*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00104\u001a\u0004\u0018\u00010\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010/\"\u0004\b6\u00107\u00a8\u0006@"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/BaseAboutLibrariesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "additionalLicenses", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getAdditionalLicenses", "()Ljava/util/HashSet;", "allowedLicenses", "", "getAllowedLicenses", "()[Ljava/lang/String;", "[Ljava/lang/String;", "dependencyCache", "Ljava/io/File;", "getDependencyCache", "()Ljava/io/File;", "duplicationMode", "Lcom/mikepenz/aboutlibraries/plugin/DuplicateMode;", "getDuplicationMode", "()Lcom/mikepenz/aboutlibraries/plugin/DuplicateMode;", "duplicationRule", "Lcom/mikepenz/aboutlibraries/plugin/DuplicateRule;", "getDuplicationRule", "()Lcom/mikepenz/aboutlibraries/plugin/DuplicateRule;", "excludeFields", "getExcludeFields", "exclusionPatterns", "", "Ljava/util/regex/Pattern;", "getExclusionPatterns", "()Ljava/util/List;", "extension", "Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesExtension;", "getExtension", "()Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesExtension;", "fetchRemoteFunding", "", "getFetchRemoteFunding", "()Z", "fetchRemoteLicense", "getFetchRemoteLicense", "gitHubApiToken", "getGitHubApiToken", "()Ljava/lang/String;", "offlineMode", "getOfflineMode", "rootDir", "kotlin.jvm.PlatformType", "variant", "getVariant", "setVariant", "(Ljava/lang/String;)V", "createLibraryProcessor", "Lcom/mikepenz/aboutlibraries/plugin/util/LibrariesProcessor;", "collectedContainer", "Lcom/mikepenz/aboutlibraries/plugin/model/CollectedContainer;", "getConfigPath", "getDependencyHandler", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "readInCollectedDependencies", "plugin"})
public abstract class BaseAboutLibrariesTask
extends DefaultTask {
    @NotNull
    private final Logger LOGGER;
    private final File rootDir;
    @Internal
    @NotNull
    private final AboutLibrariesExtension extension;
    @Internal
    @Nullable
    private String variant;
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final File dependencyCache;
    @Input
    @NotNull
    private final List<Pattern> exclusionPatterns;
    @Input
    @NotNull
    private final DuplicateMode duplicationMode;
    @Input
    @NotNull
    private final DuplicateRule duplicationRule;
    @Input
    @NotNull
    private final String[] allowedLicenses;
    @Input
    private final boolean offlineMode;
    @Input
    private final boolean fetchRemoteLicense;
    @Input
    private final boolean fetchRemoteFunding;
    @Input
    @NotNull
    private final HashSet<String> additionalLicenses;
    @Input
    @Optional
    @Nullable
    private final String gitHubApiToken;
    @Input
    @NotNull
    private final String[] excludeFields;

    public BaseAboutLibrariesTask() {
        Logger logger = LoggerFactory.getLogger(BaseAboutLibrariesTask.class);
        Intrinsics.checkNotNull((Object)logger);
        this.LOGGER = logger;
        this.rootDir = this.getProject().getRootDir();
        Object object = this.getProject().getExtensions().getByName("aboutLibraries");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.mikepenz.aboutlibraries.plugin.AboutLibrariesExtension");
        this.extension = (AboutLibrariesExtension)object;
        this.dependencyCache = new File(this.getProject().getBuildDir(), "generated/aboutLibraries/dependency_cache.json");
        this.exclusionPatterns = this.extension.getExclusionPatterns();
        this.duplicationMode = this.extension.getDuplicationMode();
        this.duplicationRule = this.extension.getDuplicationRule();
        this.allowedLicenses = this.extension.getAllowedLicenses();
        this.offlineMode = this.extension.getOfflineMode();
        this.fetchRemoteLicense = this.extension.getFetchRemoteLicense() && !this.offlineMode;
        this.fetchRemoteFunding = this.extension.getFetchRemoteFunding() && !this.offlineMode;
        this.additionalLicenses = ArraysKt.toHashSet((Object[])this.extension.getAdditionalLicenses());
        this.gitHubApiToken = this.extension.getGitHubApiToken();
        this.excludeFields = this.extension.getExcludeFields();
    }

    @NotNull
    protected final AboutLibrariesExtension getExtension() {
        return this.extension;
    }

    @Nullable
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(@Nullable String string) {
        this.variant = string;
    }

    @Inject
    @NotNull
    public abstract DependencyHandler getDependencyHandler();

    @NotNull
    protected final File getDependencyCache() {
        return this.dependencyCache;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    @Nullable
    public final File getConfigPath() {
        String path = this.extension.getConfigPath();
        if (path != null) {
            File inputFile = new File(path);
            File absoluteFile = new File(this.rootDir, path);
            if (inputFile.isAbsolute() && inputFile.exists()) {
                return inputFile;
            }
            if (absoluteFile.exists()) {
                return absoluteFile;
            }
            this.LOGGER.warn("Couldn't find provided path in: '" + inputFile.getAbsolutePath() + "' or '" + absoluteFile.getAbsolutePath() + "'");
        }
        return null;
    }

    @NotNull
    public final List<Pattern> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    @NotNull
    public final DuplicateMode getDuplicationMode() {
        return this.duplicationMode;
    }

    @NotNull
    public final DuplicateRule getDuplicationRule() {
        return this.duplicationRule;
    }

    @NotNull
    public final String[] getAllowedLicenses() {
        return this.allowedLicenses;
    }

    public final boolean getOfflineMode() {
        return this.offlineMode;
    }

    public final boolean getFetchRemoteLicense() {
        return this.fetchRemoteLicense;
    }

    public final boolean getFetchRemoteFunding() {
        return this.fetchRemoteFunding;
    }

    @NotNull
    public final HashSet<String> getAdditionalLicenses() {
        return this.additionalLicenses;
    }

    @Nullable
    public final String getGitHubApiToken() {
        return this.gitHubApiToken;
    }

    @NotNull
    public final String[] getExcludeFields() {
        return this.excludeFields;
    }

    @NotNull
    protected final CollectedContainer readInCollectedDependencies() {
        try {
            Object object = new JsonSlurper().parse(this.dependencyCache);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            Object v = ((Map)object).get("dependencies");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.String>>>");
            return CollectedContainer.Companion.from((Map)v);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to parse the dependencyCache. Try to do a clean build", t);
        }
    }

    @NotNull
    protected final LibrariesProcessor createLibraryProcessor(@NotNull CollectedContainer collectedContainer) {
        Intrinsics.checkNotNullParameter((Object)collectedContainer, (String)"collectedContainer");
        return new LibrariesProcessor(this.getDependencyHandler(), collectedContainer, this.getConfigPath(), this.exclusionPatterns, this.offlineMode, this.fetchRemoteLicense, this.fetchRemoteFunding, this.additionalLicenses, this.duplicationMode, this.duplicationRule, this.getVariant(), this.gitHubApiToken);
    }

    public static /* synthetic */ LibrariesProcessor createLibraryProcessor$default(BaseAboutLibrariesTask baseAboutLibrariesTask, CollectedContainer collectedContainer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createLibraryProcessor");
        }
        if ((n & 1) != 0) {
            collectedContainer = baseAboutLibrariesTask.readInCollectedDependencies();
        }
        return baseAboutLibrariesTask.createLibraryProcessor(collectedContainer);
    }
}

