/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.core.content.ContextCompat;

@SuppressLint(value={"InlinedApi"})
public class UIUtils {
    public static int getThemeColor(Context ctx, int attr2) {
        TypedValue tv = new TypedValue();
        if (ctx.getTheme().resolveAttribute(attr2, tv, true)) {
            return tv.data;
        }
        return 0;
    }

    public static int getThemeColorFromAttrOrRes(Context ctx, int attr2, int res) {
        int color2 = UIUtils.getThemeColor(ctx, attr2);
        if (color2 == 0) {
            color2 = ContextCompat.getColor((Context)ctx, (int)res);
        }
        return color2;
    }

    @SuppressLint(value={"NewApi"})
    public static void setBackground(View v, Drawable d) {
        if (Build.VERSION.SDK_INT < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    public static void setBackground(View v, int drawableRes) {
        UIUtils.setBackground(v, ContextCompat.getDrawable((Context)v.getContext(), (int)drawableRes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThemeAttributeDimensionSize(Context context, int attr2) {
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            int n = a.getDimensionPixelSize(0, 0);
            return n;
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }
}

