/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;

public class RippleForegroundListener
implements View.OnTouchListener {
    private int rippleViewId = -1;

    public RippleForegroundListener(int rippleViewId) {
        this.rippleViewId = rippleViewId;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX() + (float)v.getLeft();
        float y = event.getY() + (float)v.getTop();
        View rippleView = this.findRippleView(v);
        if (rippleView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            rippleView.drawableHotspotChanged(x, y);
        }
        switch (event.getActionMasked()) {
            case 0: {
                rippleView.setPressed(true);
                break;
            }
            case 1: 
            case 3: {
                rippleView.setPressed(false);
            }
        }
        return false;
    }

    public View findRippleView(View view) {
        if (view.getId() == this.rippleViewId) {
            return view;
        }
        if (view.getParent() instanceof View) {
            return this.findRippleView((View)view.getParent());
        }
        return null;
    }
}

