/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MenuItem;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.ui.LibsSupportFragment;
import com.mikepenz.aboutlibraries.util.Colors;

public class LibsActivity
extends AppCompatActivity {
    public void onCreate(Bundle savedInstanceState) {
        boolean customTheme = false;
        Libs.ActivityStyle activityStyle = Libs.ActivityStyle.DARK;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            String style2;
            int themeId = bundle.getInt("ABOUT_LIBRARIES_THEME", -1);
            if (themeId != -1) {
                customTheme = true;
                this.setTheme(themeId);
            }
            if ((style2 = bundle.getString("ABOUT_LIBRARIES_STYLE")) != null) {
                activityStyle = Libs.ActivityStyle.valueOf(style2);
            }
        }
        if (!customTheme) {
            if (activityStyle == Libs.ActivityStyle.DARK) {
                this.setTheme(R.style.AboutLibrariesTheme);
            } else if (activityStyle == Libs.ActivityStyle.LIGHT) {
                this.setTheme(R.style.AboutLibrariesTheme_Light);
            } else if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR) {
                this.setTheme(R.style.AboutLibrariesTheme_Light_DarkToolbar);
            }
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_opensource);
        String title = "";
        if (bundle != null) {
            title = bundle.getString("ABOUT_LIBRARIES_TITLE", "");
        }
        LibsSupportFragment fragment = new LibsSupportFragment();
        fragment.setArguments(bundle);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR) {
            toolbar.setTitleTextColor(-1);
            toolbar.setSubtitleTextColor(-1);
        }
        this.setSupportActionBar(toolbar);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            if (bundle != null && bundle.containsKey("ABOUT_COLOR")) {
                Colors colors = (Colors)bundle.getSerializable("ABOUT_COLOR");
                if (colors != null) {
                    ab.setBackgroundDrawable((Drawable)new ColorDrawable(colors.appBarColor));
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.getWindow().setStatusBarColor(colors.statusBarColor);
                    }
                } else {
                    ab.setBackgroundDrawable(null);
                }
            }
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setDisplayShowTitleEnabled(!TextUtils.isEmpty((CharSequence)title));
            ab.setTitle((CharSequence)title);
        }
        this.getSupportFragmentManager().beginTransaction().replace(R.id.frame_container, (Fragment)fragment).commit();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return false;
    }
}

