/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.LibsConfiguration;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.ui.item.HeaderItem;
import com.mikepenz.aboutlibraries.ui.item.LibraryItem;
import com.mikepenz.aboutlibraries.ui.item.LoaderItem;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LibsFragmentCompat {
    private FastAdapter mAdapter;
    private ItemAdapter mItemAdapter;
    private LibsBuilder builder = null;
    private ArrayList<Library> libraries;
    private Comparator<Library> comparator;
    private LibraryTask mLibTask;

    public void setLibraryComparator(Comparator<Library> comparator) {
        this.comparator = comparator;
    }

    public View onCreateView(Context context, LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState, Bundle arguments) {
        if (arguments != null) {
            this.builder = (LibsBuilder)arguments.getSerializable("data");
        } else {
            Log.e((String)"AboutLibraries", (String)"The AboutLibraries fragment can't be build without the bundle containing the LibsBuilder");
        }
        View view = inflater.inflate(R.layout.fragment_opensource, container, false);
        if (LibsConfiguration.getInstance().getUiListener() != null) {
            view = LibsConfiguration.getInstance().getUiListener().preOnCreateView(view);
        }
        RecyclerView mRecyclerView = view.getId() == R.id.cardListView ? (RecyclerView)view : (RecyclerView)view.findViewById(R.id.cardListView);
        mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        if (LibsConfiguration.getInstance().getItemAnimator() != null) {
            mRecyclerView.setItemAnimator(LibsConfiguration.getInstance().getItemAnimator());
        } else {
            mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        }
        if (this.builder != null) {
            this.mAdapter = new FastAdapter();
            this.mItemAdapter = new ItemAdapter();
            mRecyclerView.setAdapter((RecyclerView.Adapter)this.mItemAdapter.wrap(this.mAdapter));
            this.mItemAdapter.add(new IItem[]{new LoaderItem()});
        }
        if (LibsConfiguration.getInstance().getUiListener() != null) {
            view = LibsConfiguration.getInstance().getUiListener().postOnCreateView(view);
        }
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (view.getContext() != null && this.builder != null) {
            this.mLibTask = new LibraryTask(view.getContext().getApplicationContext());
            this.executeLibTask(this.mLibTask);
        }
    }

    protected void executeLibTask(LibraryTask libraryTask) {
        if (libraryTask != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                switch (this.builder.libTaskExecutor) {
                    case THREAD_POOL_EXECUTOR: {
                        libraryTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
                        break;
                    }
                    case SERIAL_EXECUTOR: {
                        libraryTask.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new String[0]);
                        break;
                    }
                    default: {
                        libraryTask.execute(new String[0]);
                        break;
                    }
                }
            } else {
                libraryTask.execute(new String[0]);
            }
        }
    }

    public void onDestroyView() {
        if (this.mLibTask != null) {
            this.mLibTask.cancel(true);
            this.mLibTask.setCtx(null);
            this.mLibTask = null;
        }
    }

    private Boolean extractBooleanBundleOrResource(Context ctx, Libs libs, Boolean value, String resName) {
        Boolean result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(ctx, resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                try {
                    result = Boolean.parseBoolean(descriptionShowVersion);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String extractStringBundleOrResource(Context ctx, Libs libs, String value, String resName) {
        String result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(ctx, resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                result = descriptionShowVersion;
            }
        }
        return result;
    }

    public class LibraryTask
    extends AsyncTask<String, String, String> {
        Context ctx;
        String versionName;
        Integer versionCode;
        Drawable icon = null;

        public LibraryTask(Context ctx) {
            this.ctx = ctx;
        }

        public void setCtx(Context ctx) {
            this.ctx = ctx;
        }

        protected void onPreExecute() {
            if (LibsConfiguration.getInstance().getLibTaskCallback() != null) {
                LibsConfiguration.getInstance().getLibTaskCallback().onLibTaskStarted();
            }
        }

        protected String doInBackground(String ... strings) {
            Libs libs = ((LibsFragmentCompat)LibsFragmentCompat.this).builder.fields == null ? new Libs(this.ctx) : new Libs(this.ctx, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.fields);
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon, "aboutLibraries_description_showIcon");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion, "aboutLibraries_description_showVersion");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName, "aboutLibraries_description_showVersionName");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode, "aboutLibraries_description_showVersionCode");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppName = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppName, "aboutLibraries_description_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutDescription = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutDescription, "aboutLibraries_description_text");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1 = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1, "aboutLibraries_description_special1_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1Description = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1Description, "aboutLibraries_description_special1_text");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2 = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2, "aboutLibraries_description_special2_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2Description = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2Description, "aboutLibraries_description_special2_text");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3 = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3, "aboutLibraries_description_special3_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3Description = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3Description, "aboutLibraries_description_special3_text");
            libs.modifyLibraries(((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryModification);
            boolean doDefaultSort = ((LibsFragmentCompat)LibsFragmentCompat.this).builder.sort != false && null == ((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryComparator && null == LibsFragmentCompat.this.comparator;
            LibsFragmentCompat.this.libraries = libs.prepareLibraries(this.ctx, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.internalLibraries, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.excludeLibraries, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.autoDetect, doDefaultSort);
            if (LibsFragmentCompat.this.comparator != null) {
                Collections.sort(LibsFragmentCompat.this.libraries, LibsFragmentCompat.this.comparator);
            } else if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryComparator != null) {
                Collections.sort(LibsFragmentCompat.this.libraries, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryComparator);
            }
            if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon != null && (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode.booleanValue())) {
                PackageManager pm = this.ctx.getPackageManager();
                String packageName = this.ctx.getPackageName();
                ApplicationInfo appInfo = null;
                PackageInfo packageInfo = null;
                try {
                    appInfo = pm.getApplicationInfo(packageName, 0);
                    packageInfo = pm.getPackageInfo(packageName, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon.booleanValue() && appInfo != null) {
                    this.icon = appInfo.loadIcon(pm);
                }
                this.versionName = null;
                this.versionCode = null;
                if (packageInfo != null) {
                    this.versionName = packageInfo.versionName;
                    this.versionCode = packageInfo.versionCode;
                }
            }
            return null;
        }

        protected void onPostExecute(String s) {
            LibsFragmentCompat.this.mItemAdapter.clear();
            if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon != null && (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode.booleanValue())) {
                LibsFragmentCompat.this.mItemAdapter.add(new IItem[]{new HeaderItem().withLibsBuilder(LibsFragmentCompat.this.builder).withAboutVersionName(this.versionName).withAboutVersionCode(this.versionCode).withAboutIcon(this.icon)});
            }
            ArrayList<LibraryItem> libraryItems = new ArrayList<LibraryItem>();
            for (Library library : LibsFragmentCompat.this.libraries) {
                libraryItems.add(new LibraryItem().withLibrary(library).withLibsBuilder(LibsFragmentCompat.this.builder));
            }
            LibsFragmentCompat.this.mItemAdapter.add(libraryItems);
            super.onPostExecute((Object)s);
            if (LibsConfiguration.getInstance().getLibTaskCallback() != null) {
                LibsConfiguration.getInstance().getLibTaskCallback().onLibTaskFinished(LibsFragmentCompat.this.mItemAdapter);
            }
            this.ctx = null;
        }
    }
}

