/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.mikepenz.aboutlibraries.R;

@SuppressLint(value={"InlinedApi"})
public class UIUtils {
    public static int getSelectableBackground(Context ctx) {
        if (Build.VERSION.SDK_INT >= 11) {
            TypedValue outValue = new TypedValue();
            ctx.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
            return outValue.resourceId;
        }
        TypedValue outValue = new TypedValue();
        ctx.getTheme().resolveAttribute(0x1010130, outValue, true);
        return outValue.resourceId;
    }

    public static int getThemeColor(Context ctx, int attr2) {
        TypedValue tv = new TypedValue();
        if (ctx.getTheme().resolveAttribute(attr2, tv, true)) {
            return tv.data;
        }
        return 0;
    }

    public static int getThemeColorFromAttrOrRes(Context ctx, int attr2, int res) {
        int color2 = UIUtils.getThemeColor(ctx, attr2);
        if (color2 == 0) {
            color2 = ctx.getResources().getColor(res);
        }
        return color2;
    }

    @SuppressLint(value={"NewApi"})
    public static void setBackground(View v, Drawable d) {
        if (Build.VERSION.SDK_INT < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    public static void setBackground(View v, int drawableRes) {
        UIUtils.setBackground(v, UIUtils.getCompatDrawable(v.getContext(), drawableRes));
    }

    public static Drawable getCompatDrawable(Context c, int drawableRes) {
        Drawable d = null;
        try {
            d = Build.VERSION.SDK_INT < 21 ? c.getResources().getDrawable(drawableRes) : c.getResources().getDrawable(drawableRes, c.getTheme());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThemeAttributeDimensionSize(Context context, int attr2) {
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            int n = a.getDimensionPixelSize(0, 0);
            return n;
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }
}

