/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.animation.LayoutAnimationController;
import com.mikepenz.aboutlibraries.LibTaskCallback;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.ui.adapter.LibsRecyclerViewAdapter;

public class LibsConfiguration {
    private static LibsConfiguration SINGLETON = null;
    private LibsListener mListener = null;
    private LibsUIListener mUiListener = null;
    private LibsRecyclerViewListener mRecyclerViewListener = null;
    private LayoutAnimationController mLayoutAnimationController = null;
    private RecyclerView.ItemAnimator mItemAnimator;
    private LibTaskCallback mLibTaskCallback;

    private LibsConfiguration() {
    }

    public static LibsConfiguration getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new LibsConfiguration();
        }
        return SINGLETON;
    }

    public void setListener(LibsListener libsListener) {
        this.mListener = libsListener;
    }

    public LibsListener getListener() {
        return this.mListener;
    }

    public void removeListener() {
        this.mListener = null;
    }

    public LibsUIListener getUiListener() {
        return this.mUiListener;
    }

    public void setUiListener(LibsUIListener uiListener) {
        this.mUiListener = uiListener;
    }

    public void removeUiListener() {
        this.mUiListener = null;
    }

    public LibsRecyclerViewListener getLibsRecyclerViewListener() {
        return this.mRecyclerViewListener;
    }

    public void setLibsRecyclerViewListener(LibsRecyclerViewListener recyclerViewListener) {
        this.mRecyclerViewListener = recyclerViewListener;
    }

    public void removeLibsRecyclerViewListener() {
        this.mRecyclerViewListener = null;
    }

    public LayoutAnimationController getLayoutAnimationController() {
        return this.mLayoutAnimationController;
    }

    public void setLayoutAnimationController(LayoutAnimationController layoutAnimationController) {
        this.mLayoutAnimationController = layoutAnimationController;
    }

    public RecyclerView.ItemAnimator getItemAnimator() {
        return this.mItemAnimator;
    }

    public void setItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
        this.mItemAnimator = itemAnimator;
    }

    public LibTaskCallback getLibTaskCallback() {
        return this.mLibTaskCallback;
    }

    public void setLibTaskCallback(LibTaskCallback mLibTaskCallback) {
        this.mLibTaskCallback = mLibTaskCallback;
    }

    public void reset() {
        SINGLETON = null;
    }

    public abstract class LibsListenerImpl
    implements LibsListener {
        @Override
        public void onIconClicked(View v) {
        }

        @Override
        public boolean onLibraryAuthorClicked(View v, Library library) {
            return false;
        }

        @Override
        public boolean onLibraryContentClicked(View v, Library library) {
            return false;
        }

        @Override
        public boolean onLibraryBottomClicked(View v, Library library) {
            return false;
        }

        @Override
        public boolean onExtraClicked(View v, Libs.SpecialButton specialButton) {
            return false;
        }

        @Override
        public boolean onIconLongClicked(View v) {
            return true;
        }

        @Override
        public boolean onLibraryAuthorLongClicked(View v, Library library) {
            return true;
        }

        @Override
        public boolean onLibraryContentLongClicked(View v, Library library) {
            return true;
        }

        @Override
        public boolean onLibraryBottomLongClicked(View v, Library library) {
            return true;
        }
    }

    public abstract class LibsRecyclerViewListenerImpl
    implements LibsRecyclerViewListener {
        @Override
        public void OnBindViewHolder(LibsRecyclerViewAdapter.HeaderViewHolder headerViewHolder) {
        }

        @Override
        public void OnBindViewHolder(LibsRecyclerViewAdapter.ViewHolder headerViewHolder) {
        }
    }

    public static interface LibsListener {
        public void onIconClicked(View var1);

        public boolean onLibraryAuthorClicked(View var1, Library var2);

        public boolean onLibraryContentClicked(View var1, Library var2);

        public boolean onLibraryBottomClicked(View var1, Library var2);

        public boolean onExtraClicked(View var1, Libs.SpecialButton var2);

        public boolean onIconLongClicked(View var1);

        public boolean onLibraryAuthorLongClicked(View var1, Library var2);

        public boolean onLibraryContentLongClicked(View var1, Library var2);

        public boolean onLibraryBottomLongClicked(View var1, Library var2);
    }

    public static interface LibsRecyclerViewListener {
        public void OnBindViewHolder(LibsRecyclerViewAdapter.HeaderViewHolder var1);

        public void OnBindViewHolder(LibsRecyclerViewAdapter.ViewHolder var1);
    }

    public static interface LibsUIListener {
        public View preOnCreateView(View var1);

        public View postOnCreateView(View var1);
    }
}

