/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.LibsConfiguration;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.util.MovementCheck;
import com.mikepenz.aboutlibraries.util.RippleForegroundListener;
import com.mikepenz.aboutlibraries.util.UIUtils;
import java.util.LinkedList;
import java.util.List;

public class LibsRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_ITEM = 1;
    private List<Library> libs = new LinkedList<Library>();
    private boolean header = false;
    private LibsBuilder libsBuilder = null;
    private Integer aboutVersionCode;
    private String aboutVersionName;
    private Drawable aboutIcon;

    public LibsRecyclerViewAdapter(LibsBuilder libsBuilder) {
        this.libsBuilder = libsBuilder;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (viewType == 0) {
            View v = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.listheader_opensource, viewGroup, false);
            return new HeaderViewHolder(v);
        }
        View v = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.listitem_opensource, viewGroup, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        final Context ctx = viewHolder.itemView.getContext();
        if (viewHolder instanceof HeaderViewHolder) {
            HeaderViewHolder holder = (HeaderViewHolder)viewHolder;
            if (this.libsBuilder.aboutShowIcon.booleanValue() && this.aboutIcon != null) {
                holder.aboutIcon.setImageDrawable(this.aboutIcon);
                holder.aboutIcon.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            LibsConfiguration.getInstance().getListener().onIconClicked(v);
                        }
                    }
                });
            } else {
                holder.aboutIcon.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppName)) {
                holder.aboutAppName.setText((CharSequence)this.libsBuilder.aboutAppName);
            } else {
                holder.aboutAppName.setVisibility(8);
            }
            holder.aboutSpecialContainer.setVisibility(8);
            holder.aboutSpecial1.setVisibility(8);
            holder.aboutSpecial2.setVisibility(8);
            holder.aboutSpecial3.setVisibility(8);
            if (!TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppSpecial1) && !TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppSpecial1Description)) {
                holder.aboutSpecial1.setText((CharSequence)this.libsBuilder.aboutAppSpecial1);
                holder.aboutSpecial1.setVisibility(0);
                holder.aboutSpecial1.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        boolean consumed = false;
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            consumed = LibsConfiguration.getInstance().getListener().onExtraClicked(v, Libs.SpecialButton.SPECIAL1);
                        }
                        if (!consumed) {
                            try {
                                AlertDialog.Builder alert = new AlertDialog.Builder(ctx);
                                alert.setMessage((CharSequence)Html.fromHtml((String)((LibsRecyclerViewAdapter)LibsRecyclerViewAdapter.this).libsBuilder.aboutAppSpecial1Description));
                                alert.create().show();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                holder.aboutSpecialContainer.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppSpecial2) && !TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppSpecial2Description)) {
                holder.aboutSpecial2.setText((CharSequence)this.libsBuilder.aboutAppSpecial2);
                holder.aboutSpecial2.setVisibility(0);
                holder.aboutSpecial2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        boolean consumed = false;
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            consumed = LibsConfiguration.getInstance().getListener().onExtraClicked(v, Libs.SpecialButton.SPECIAL2);
                        }
                        if (!consumed) {
                            try {
                                AlertDialog.Builder alert = new AlertDialog.Builder(ctx);
                                alert.setMessage((CharSequence)Html.fromHtml((String)((LibsRecyclerViewAdapter)LibsRecyclerViewAdapter.this).libsBuilder.aboutAppSpecial2Description));
                                alert.create().show();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                holder.aboutSpecialContainer.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppSpecial3) && !TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutAppSpecial3Description)) {
                holder.aboutSpecial3.setText((CharSequence)this.libsBuilder.aboutAppSpecial3);
                holder.aboutSpecial3.setVisibility(0);
                holder.aboutSpecial3.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        boolean consumed = false;
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            consumed = LibsConfiguration.getInstance().getListener().onExtraClicked(v, Libs.SpecialButton.SPECIAL3);
                        }
                        if (!consumed) {
                            try {
                                AlertDialog.Builder alert = new AlertDialog.Builder(ctx);
                                alert.setMessage((CharSequence)Html.fromHtml((String)((LibsRecyclerViewAdapter)LibsRecyclerViewAdapter.this).libsBuilder.aboutAppSpecial3Description));
                                alert.create().show();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                holder.aboutSpecialContainer.setVisibility(0);
            }
            if (this.libsBuilder.aboutShowVersion != null && this.libsBuilder.aboutShowVersion.booleanValue()) {
                holder.aboutVersion.setText((CharSequence)(ctx.getString(R.string.version) + " " + this.aboutVersionName + " (" + this.aboutVersionCode + ")"));
            } else if (this.libsBuilder.aboutShowVersionName != null && this.libsBuilder.aboutShowVersionName.booleanValue()) {
                holder.aboutVersion.setText((CharSequence)(ctx.getString(R.string.version) + " " + this.aboutVersionName));
            } else if (this.libsBuilder.aboutShowVersionCode != null && this.libsBuilder.aboutShowVersionCode.booleanValue()) {
                holder.aboutVersion.setText((CharSequence)(ctx.getString(R.string.version) + " " + this.aboutVersionCode));
            } else {
                holder.aboutVersion.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutDescription)) {
                holder.aboutAppDescription.setText((CharSequence)Html.fromHtml((String)this.libsBuilder.aboutDescription));
                holder.aboutAppDescription.setMovementMethod(MovementCheck.getInstance());
            } else {
                holder.aboutAppDescription.setVisibility(8);
            }
            if (!this.libsBuilder.aboutShowIcon.booleanValue() && !this.libsBuilder.aboutShowVersion.booleanValue() || TextUtils.isEmpty((CharSequence)this.libsBuilder.aboutDescription)) {
                holder.aboutDivider.setVisibility(8);
            }
        } else if (viewHolder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewHolder;
            final Library library = this.getItem(position);
            RippleForegroundListener rippleForegroundListener = new RippleForegroundListener();
            rippleForegroundListener.setCardView(holder.card);
            holder.libraryName.setText((CharSequence)library.getLibraryName());
            holder.libraryCreator.setText((CharSequence)library.getAuthor());
            if (TextUtils.isEmpty((CharSequence)library.getLibraryDescription())) {
                holder.libraryDescription.setText((CharSequence)library.getLibraryDescription());
            } else {
                holder.libraryDescription.setText((CharSequence)Html.fromHtml((String)library.getLibraryDescription()));
            }
            if (TextUtils.isEmpty((CharSequence)library.getLibraryVersion()) && library.getLicense() != null && TextUtils.isEmpty((CharSequence)library.getLicense().getLicenseName()) || !this.libsBuilder.showVersion.booleanValue() && !this.libsBuilder.showLicense.booleanValue()) {
                holder.libraryBottomDivider.setVisibility(8);
                holder.libraryBottomContainer.setVisibility(8);
            } else {
                holder.libraryBottomDivider.setVisibility(0);
                holder.libraryBottomContainer.setVisibility(0);
                if (!TextUtils.isEmpty((CharSequence)library.getLibraryVersion()) && this.libsBuilder.showVersion.booleanValue()) {
                    holder.libraryVersion.setText((CharSequence)library.getLibraryVersion());
                } else {
                    holder.libraryVersion.setText((CharSequence)"");
                }
                if (library.getLicense() != null && !TextUtils.isEmpty((CharSequence)library.getLicense().getLicenseName()) && this.libsBuilder.showLicense.booleanValue()) {
                    holder.libraryLicense.setText((CharSequence)library.getLicense().getLicenseName());
                } else {
                    holder.libraryLicense.setText((CharSequence)"");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)library.getAuthorWebsite())) {
                holder.libraryCreator.setOnTouchListener((View.OnTouchListener)rippleForegroundListener);
                holder.libraryCreator.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        boolean consumed = false;
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            consumed = LibsConfiguration.getInstance().getListener().onLibraryAuthorClicked(view, library);
                        }
                        if (!consumed) {
                            LibsRecyclerViewAdapter.this.openAuthorWebsite(ctx, library.getAuthorWebsite());
                        }
                    }
                });
                holder.libraryCreator.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        LibsRecyclerViewAdapter.this.openAuthorWebsite(ctx, library.getAuthorWebsite());
                        return true;
                    }
                });
            } else {
                holder.libraryCreator.setOnTouchListener(null);
                holder.libraryCreator.setOnClickListener(null);
                holder.libraryCreator.setOnLongClickListener(null);
            }
            if (!TextUtils.isEmpty((CharSequence)library.getLibraryWebsite()) || !TextUtils.isEmpty((CharSequence)library.getRepositoryLink())) {
                holder.libraryDescription.setOnTouchListener((View.OnTouchListener)rippleForegroundListener);
                holder.libraryDescription.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        boolean consumed = false;
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            consumed = LibsConfiguration.getInstance().getListener().onLibraryContentClicked(v, library);
                        }
                        if (!consumed) {
                            LibsRecyclerViewAdapter.this.openLibraryWebsite(ctx, library.getLibraryWebsite() != null ? library.getLibraryWebsite() : library.getRepositoryLink());
                        }
                    }
                });
                holder.libraryDescription.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        LibsRecyclerViewAdapter.this.openLibraryWebsite(ctx, library.getLibraryWebsite() != null ? library.getLibraryWebsite() : library.getRepositoryLink());
                        return true;
                    }
                });
            } else {
                holder.libraryDescription.setOnTouchListener(null);
                holder.libraryDescription.setOnClickListener(null);
                holder.libraryDescription.setOnLongClickListener(null);
            }
            if (library.getLicense() != null && !TextUtils.isEmpty((CharSequence)library.getLicense().getLicenseWebsite())) {
                holder.libraryBottomContainer.setOnTouchListener((View.OnTouchListener)rippleForegroundListener);
                holder.libraryBottomContainer.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        boolean consumed = false;
                        if (LibsConfiguration.getInstance().getListener() != null) {
                            consumed = LibsConfiguration.getInstance().getListener().onLibraryBottomClicked(view, library);
                        }
                        if (!consumed) {
                            LibsRecyclerViewAdapter.this.openLicense(ctx, LibsRecyclerViewAdapter.this.libsBuilder, library);
                        }
                    }
                });
                holder.libraryBottomContainer.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        LibsRecyclerViewAdapter.this.openLicense(ctx, LibsRecyclerViewAdapter.this.libsBuilder, library);
                        return true;
                    }
                });
            } else {
                holder.libraryBottomContainer.setOnTouchListener(null);
                holder.libraryBottomContainer.setOnClickListener(null);
                holder.libraryBottomContainer.setOnLongClickListener(null);
            }
        }
    }

    private void openAuthorWebsite(Context ctx, String authorWebsite) {
        try {
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)authorWebsite));
            ctx.startActivity(browserIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openLibraryWebsite(Context ctx, String libraryWebsite) {
        try {
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)libraryWebsite));
            ctx.startActivity(browserIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openLicense(Context ctx, LibsBuilder libsBuilder, Library library) {
        try {
            if (libsBuilder.showLicenseDialog.booleanValue() && !TextUtils.isEmpty((CharSequence)library.getLicense().getLicenseDescription())) {
                AlertDialog.Builder builder = new AlertDialog.Builder(ctx);
                builder.setMessage((CharSequence)Html.fromHtml((String)library.getLicense().getLicenseDescription()));
                builder.create().show();
            } else {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)library.getLicense().getLicenseWebsite()));
                ctx.startActivity(browserIntent);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.header) {
            return 0;
        }
        return 1;
    }

    public int getItemCount() {
        return this.libs == null ? 0 : this.libs.size();
    }

    public Library getItem(int pos) {
        return this.libs.get(pos);
    }

    public long getItemId(int pos) {
        return pos;
    }

    public void setLibs(List<Library> libs) {
        this.libs = libs;
        this.notifyItemRangeInserted(0, libs.size() - 1);
    }

    public void addLibs(List<Library> libs) {
        this.libs.addAll(libs);
    }

    public void setHeader(String aboutVersionName, Integer aboutVersionCode, Drawable aboutIcon) {
        this.header = true;
        this.libs.add(0, null);
        this.aboutVersionName = aboutVersionName;
        this.aboutVersionCode = aboutVersionCode;
        this.aboutIcon = aboutIcon;
        this.notifyItemInserted(0);
    }

    public void deleteHeader() {
        if (this.header && this.libs.size() > 0) {
            this.libs.remove(0);
        }
        this.header = false;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        CardView card;
        TextView libraryName;
        TextView libraryCreator;
        View libraryDescriptionDivider;
        TextView libraryDescription;
        View libraryBottomDivider;
        View libraryBottomContainer;
        TextView libraryVersion;
        TextView libraryLicense;

        public ViewHolder(View itemView) {
            super(itemView);
            this.card = (CardView)itemView;
            this.card.setCardBackgroundColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_card, R.color.about_libraries_card));
            this.libraryName = (TextView)itemView.findViewById(R.id.libraryName);
            this.libraryName.setTextColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_title_openSource, R.color.about_libraries_title_openSource));
            this.libraryCreator = (TextView)itemView.findViewById(R.id.libraryCreator);
            this.libraryCreator.setTextColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_text_openSource, R.color.about_libraries_text_openSource));
            this.libraryDescriptionDivider = itemView.findViewById(R.id.libraryDescriptionDivider);
            this.libraryDescriptionDivider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_dividerLight_openSource, R.color.about_libraries_dividerLight_openSource));
            this.libraryDescription = (TextView)itemView.findViewById(R.id.libraryDescription);
            this.libraryDescription.setTextColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_text_openSource, R.color.about_libraries_text_openSource));
            this.libraryBottomDivider = itemView.findViewById(R.id.libraryBottomDivider);
            this.libraryDescriptionDivider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_dividerLight_openSource, R.color.about_libraries_dividerLight_openSource));
            this.libraryBottomContainer = itemView.findViewById(R.id.libraryBottomContainer);
            this.libraryVersion = (TextView)itemView.findViewById(R.id.libraryVersion);
            this.libraryVersion.setTextColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_text_openSource, R.color.about_libraries_text_openSource));
            this.libraryLicense = (TextView)itemView.findViewById(R.id.libraryLicense);
            this.libraryLicense.setTextColor(UIUtils.getThemeColorFromAttrOrRes(itemView.getContext(), R.attr.about_libraries_text_openSource, R.color.about_libraries_text_openSource));
        }
    }

    public static class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        ImageView aboutIcon;
        TextView aboutAppName;
        View aboutSpecialContainer;
        Button aboutSpecial1;
        Button aboutSpecial2;
        Button aboutSpecial3;
        TextView aboutVersion;
        View aboutDivider;
        TextView aboutAppDescription;

        public HeaderViewHolder(View headerView) {
            super(headerView);
            this.aboutIcon = (ImageView)headerView.findViewById(R.id.aboutIcon);
            this.aboutAppName = (TextView)headerView.findViewById(R.id.aboutName);
            this.aboutAppName.setTextColor(UIUtils.getThemeColorFromAttrOrRes(headerView.getContext(), R.attr.about_libraries_title_openSource, R.color.about_libraries_title_openSource));
            this.aboutSpecialContainer = headerView.findViewById(R.id.aboutSpecialContainer);
            this.aboutSpecial1 = (Button)headerView.findViewById(R.id.aboutSpecial1);
            this.aboutSpecial2 = (Button)headerView.findViewById(R.id.aboutSpecial2);
            this.aboutSpecial3 = (Button)headerView.findViewById(R.id.aboutSpecial3);
            this.aboutVersion = (TextView)headerView.findViewById(R.id.aboutVersion);
            this.aboutVersion.setTextColor(UIUtils.getThemeColorFromAttrOrRes(headerView.getContext(), R.attr.about_libraries_text_openSource, R.color.about_libraries_text_openSource));
            this.aboutDivider = headerView.findViewById(R.id.aboutDivider);
            this.aboutDivider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes(headerView.getContext(), R.attr.about_libraries_dividerDark_openSource, R.color.about_libraries_dividerDark_openSource));
            this.aboutAppDescription = (TextView)headerView.findViewById(R.id.aboutDescription);
            this.aboutAppDescription.setTextColor(UIUtils.getThemeColorFromAttrOrRes(headerView.getContext(), R.attr.about_libraries_text_openSource, R.color.about_libraries_text_openSource));
        }
    }
}

