/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.corekit.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.midtrans.sdk.analytics.MixpanelAnalyticsManager;
import com.midtrans.sdk.corekit.R;
import com.midtrans.sdk.corekit.core.LocalDataHandler;
import com.midtrans.sdk.corekit.core.Logger;
import com.midtrans.sdk.corekit.core.TransactionRequest;
import com.midtrans.sdk.corekit.core.c;
import com.midtrans.sdk.corekit.core.e;
import com.midtrans.sdk.corekit.core.f;
import com.midtrans.sdk.corekit.core.h;
import com.midtrans.sdk.corekit.models.BCABankTransfer;
import com.midtrans.sdk.corekit.models.BCAKlikPayDescriptionModel;
import com.midtrans.sdk.corekit.models.BCAKlikPayModel;
import com.midtrans.sdk.corekit.models.BankTransfer;
import com.midtrans.sdk.corekit.models.BillingAddress;
import com.midtrans.sdk.corekit.models.CIMBClickPayModel;
import com.midtrans.sdk.corekit.models.CardPaymentDetails;
import com.midtrans.sdk.corekit.models.CardTransfer;
import com.midtrans.sdk.corekit.models.CstoreEntity;
import com.midtrans.sdk.corekit.models.CustomerDetails;
import com.midtrans.sdk.corekit.models.DescriptionModel;
import com.midtrans.sdk.corekit.models.EpayBriTransfer;
import com.midtrans.sdk.corekit.models.IndomaretRequestModel;
import com.midtrans.sdk.corekit.models.IndosatDompetkuRequest;
import com.midtrans.sdk.corekit.models.KlikBCADescriptionModel;
import com.midtrans.sdk.corekit.models.KlikBCAModel;
import com.midtrans.sdk.corekit.models.MandiriBillPayTransferModel;
import com.midtrans.sdk.corekit.models.MandiriClickPayModel;
import com.midtrans.sdk.corekit.models.MandiriClickPayRequestModel;
import com.midtrans.sdk.corekit.models.MandiriECashModel;
import com.midtrans.sdk.corekit.models.PaymentMethodsModel;
import com.midtrans.sdk.corekit.models.PermataBankTransfer;
import com.midtrans.sdk.corekit.models.ShippingAddress;
import com.midtrans.sdk.corekit.models.SnapTransactionDetails;
import com.midtrans.sdk.corekit.models.TokenRequestModel;
import com.midtrans.sdk.corekit.models.TransactionDetails;
import com.midtrans.sdk.corekit.models.UserAddress;
import com.midtrans.sdk.corekit.models.UserDetail;
import com.midtrans.sdk.corekit.models.promo.Promo;
import com.midtrans.sdk.corekit.models.snap.CreditCardPaymentModel;
import com.midtrans.sdk.corekit.models.snap.params.CreditCardPaymentParams;
import com.midtrans.sdk.corekit.models.snap.params.GCIPaymentParams;
import com.midtrans.sdk.corekit.models.snap.params.KlikBcaPaymentParams;
import com.midtrans.sdk.corekit.models.snap.params.MandiriClickPayPaymentParams;
import com.midtrans.sdk.corekit.models.snap.params.PromoDetails;
import com.midtrans.sdk.corekit.models.snap.payment.BankTransferPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.CreditCardPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.CustomerDetailRequest;
import com.midtrans.sdk.corekit.models.snap.payment.DanamonOnlinePaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.GCIPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.GoPayAuthorizationRequest;
import com.midtrans.sdk.corekit.models.snap.payment.GoPayPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.KlikBCAPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.MandiriClickPayPaymentRequest;
import com.midtrans.sdk.corekit.utilities.Installation;
import com.securepreferences.SecurePreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SdkUtil {
    private static final String UNIT_MINUTES = "minutes";

    protected static MandiriBillPayTransferModel getMandiriBillPayModel(TransactionRequest transactionRequest) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        MandiriBillPayTransferModel mandiriBillPayTransferModel = new MandiriBillPayTransferModel(transactionRequest.getBillInfoModel(), transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return mandiriBillPayTransferModel;
    }

    protected static MandiriClickPayRequestModel getMandiriClickPayRequestModel(TransactionRequest transactionRequest, MandiriClickPayModel mandiriClickPayModel) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        MandiriClickPayRequestModel mandiriClickPayRequestModel = new MandiriClickPayRequestModel(mandiriClickPayModel, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return mandiriClickPayRequestModel;
    }

    protected static KlikBCAModel getKlikBCAModel(TransactionRequest transactionRequest, KlikBCADescriptionModel klikBCADescriptionModel) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        return new KlikBCAModel(klikBCADescriptionModel, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
    }

    protected static BCAKlikPayModel getBCAKlikPayModel(TransactionRequest transactionRequest, BCAKlikPayDescriptionModel bCAKlikPayDescriptionModel) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        return new BCAKlikPayModel(bCAKlikPayDescriptionModel, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
    }

    protected static PermataBankTransfer getPermataBankModel(TransactionRequest transactionRequest) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        BankTransfer bankTransfer = new BankTransfer();
        bankTransfer.setBank("permata");
        return new PermataBankTransfer(bankTransfer, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
    }

    protected static BCABankTransfer getBcaBankTransferRequest(TransactionRequest transactionRequest) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        BankTransfer bankTransfer = new BankTransfer();
        bankTransfer.setBank("bca");
        BCABankTransfer bCABankTransfer = new BCABankTransfer(bankTransfer, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return bCABankTransfer;
    }

    protected static IndomaretRequestModel getIndomaretRequestModel(TransactionRequest transactionRequest, CstoreEntity cstoreEntity) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        IndomaretRequestModel indomaretRequestModel = new IndomaretRequestModel();
        indomaretRequestModel.setPaymentType("cstore");
        indomaretRequestModel.setItem_details(transactionRequest.getItemDetails());
        indomaretRequestModel.setCustomerDetails(transactionRequest.getCustomerDetails());
        indomaretRequestModel.setTransactionDetails(transactionDetails);
        indomaretRequestModel.setCstore(cstoreEntity);
        return indomaretRequestModel;
    }

    protected static CIMBClickPayModel getCIMBClickPayModel(TransactionRequest transactionRequest, DescriptionModel descriptionModel) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        CIMBClickPayModel cIMBClickPayModel = new CIMBClickPayModel(descriptionModel, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return cIMBClickPayModel;
    }

    protected static MandiriECashModel getMandiriECashModel(TransactionRequest transactionRequest, DescriptionModel descriptionModel) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        MandiriECashModel mandiriECashModel = new MandiriECashModel(descriptionModel, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return mandiriECashModel;
    }

    public static CardTransfer getCardTransferModel(TransactionRequest transactionRequest, CardPaymentDetails cardPaymentDetails) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        CardTransfer cardTransfer = new CardTransfer(cardPaymentDetails, transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return cardTransfer;
    }

    protected static EpayBriTransfer getEpayBriBankModel(TransactionRequest transactionRequest) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        EpayBriTransfer epayBriTransfer = new EpayBriTransfer(transactionDetails, transactionRequest.getItemDetails(), transactionRequest.getBillingAddressArrayList(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getCustomerDetails());
        return epayBriTransfer;
    }

    protected static IndosatDompetkuRequest getIndosatDompetkuRequestModel(TransactionRequest transactionRequest, String string2) {
        TransactionDetails transactionDetails = new TransactionDetails("" + transactionRequest.getAmount(), transactionRequest.getOrderId());
        transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        IndosatDompetkuRequest indosatDompetkuRequest = new IndosatDompetkuRequest();
        indosatDompetkuRequest.setCustomerDetails(transactionRequest.getCustomerDetails(), transactionRequest.getShippingAddressArrayList(), transactionRequest.getBillingAddressArrayList());
        indosatDompetkuRequest.setPaymentType("indosat_dompetku");
        IndosatDompetkuRequest.IndosatDompetkuEntity indosatDompetkuEntity = new IndosatDompetkuRequest.IndosatDompetkuEntity();
        indosatDompetkuEntity.setMsisdn("" + string2);
        indosatDompetkuRequest.setIndosatDompetku(indosatDompetkuEntity);
        indosatDompetkuRequest.setItemDetails(transactionRequest.getItemDetails());
        indosatDompetkuRequest.setTransactionDetails(transactionDetails);
        return indosatDompetkuRequest;
    }

    protected static TransactionRequest initializeUserInfo(TransactionRequest transactionRequest) {
        transactionRequest = SdkUtil.getUserDetails(transactionRequest);
        return transactionRequest;
    }

    static TransactionRequest getUserDetails(TransactionRequest transactionRequest) {
        UserDetail userDetail = null;
        CustomerDetails customerDetails = null;
        try {
            userDetail = LocalDataHandler.readObject("user_details", UserDetail.class);
            if (userDetail != null && !TextUtils.isEmpty((CharSequence)userDetail.getUserFullName())) {
                ArrayList<UserAddress> arrayList = userDetail.getUserAddresses();
                if (arrayList != null && !arrayList.isEmpty()) {
                    Logger.i("Found " + arrayList.size() + " user addresses.");
                    customerDetails = new CustomerDetails();
                    customerDetails.setPhone(userDetail.getPhoneNumber());
                    customerDetails.setFirstName(userDetail.getUserFullName());
                    customerDetails.setLastName(null);
                    customerDetails.setEmail(userDetail.getEmail());
                    transactionRequest.setCustomerDetails(customerDetails);
                    transactionRequest = SdkUtil.extractUserAddress(userDetail, arrayList, transactionRequest);
                }
            } else {
                Logger.e("User details not available.");
            }
        }
        catch (Exception exception) {
            Logger.e("Error while fetching user details : " + exception.getMessage());
        }
        return transactionRequest;
    }

    static TransactionRequest extractUserAddress(UserDetail userDetail, ArrayList<UserAddress> arrayList, TransactionRequest transactionRequest) {
        ArrayList<BillingAddress> arrayList2 = new ArrayList<BillingAddress>();
        ArrayList<ShippingAddress> arrayList3 = new ArrayList<ShippingAddress>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            UserAddress userAddress = arrayList.get(i);
            if (userAddress.getAddressType() == 3) {
                object = SdkUtil.getBillingAddress(userDetail, userAddress);
                arrayList2.add((BillingAddress)object);
                ShippingAddress shippingAddress = SdkUtil.getShippingAddress(userDetail, userAddress);
                arrayList3.add(shippingAddress);
                continue;
            }
            if (userAddress.getAddressType() == 2) {
                object = SdkUtil.getShippingAddress(userDetail, userAddress);
                arrayList3.add((ShippingAddress)object);
                continue;
            }
            object = SdkUtil.getBillingAddress(userDetail, userAddress);
            arrayList2.add((BillingAddress)object);
        }
        transactionRequest.setBillingAddressArrayList(arrayList2);
        transactionRequest.setShippingAddressArrayList(arrayList3);
        CustomerDetails customerDetails = transactionRequest.getCustomerDetails();
        if (customerDetails != null) {
            if (arrayList2.size() > 0 && arrayList2.get(0) != null) {
                customerDetails.setBillingAddress(arrayList2.get(0));
            }
            if (arrayList3.size() > 0 && arrayList3.get(0) != null) {
                customerDetails.setShippingAddress(arrayList3.get(0));
            }
            transactionRequest.setCustomerDetails(customerDetails);
        }
        return transactionRequest;
    }

    @NonNull
    private static BillingAddress getBillingAddress(UserDetail userDetail, UserAddress userAddress) {
        BillingAddress billingAddress = new BillingAddress();
        billingAddress.setCity(userAddress.getCity());
        billingAddress.setFirstName(userDetail.getUserFullName());
        billingAddress.setLastName("");
        billingAddress.setPhone(userDetail.getPhoneNumber());
        billingAddress.setCountryCode(userAddress.getCountry());
        billingAddress.setPostalCode(userAddress.getZipcode());
        billingAddress.setAddress(userAddress.getAddress());
        return billingAddress;
    }

    @NonNull
    private static ShippingAddress getShippingAddress(UserDetail userDetail, UserAddress userAddress) {
        ShippingAddress shippingAddress = new ShippingAddress();
        shippingAddress.setCity(userAddress.getCity());
        shippingAddress.setFirstName(userDetail.getUserFullName());
        shippingAddress.setLastName("");
        shippingAddress.setPhone(userDetail.getPhoneNumber());
        shippingAddress.setCountryCode(userAddress.getCountry());
        shippingAddress.setPostalCode(userAddress.getZipcode());
        shippingAddress.setAddress(userAddress.getAddress());
        return shippingAddress;
    }

    public static String getDeviceId(Context context) {
        String string2 = "UNKNOWN";
        try {
            string2 = Installation.id(context);
        }
        catch (Exception exception) {
            Logger.e(exception.toString());
        }
        return string2;
    }

    public static TokenRequestModel getSnapTokenRequestModel(TransactionRequest transactionRequest) {
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        SnapTransactionDetails snapTransactionDetails = new SnapTransactionDetails(transactionRequest.getOrderId(), (int)transactionRequest.getAmount());
        TokenRequestModel tokenRequestModel = new TokenRequestModel(snapTransactionDetails, transactionRequest.getItemDetails(), transactionRequest.getCustomerDetails(), transactionRequest.getCreditCard());
        tokenRequestModel.setExpiry(transactionRequest.getExpiry());
        if (transactionRequest.getExpiry() != null) {
            tokenRequestModel.setExpiry(transactionRequest.getExpiry());
        }
        if (transactionRequest.getCustomField1() != null && !TextUtils.isEmpty((CharSequence)transactionRequest.getCustomField1())) {
            tokenRequestModel.setCustomField1(transactionRequest.getCustomField1());
        }
        if (transactionRequest.getCustomField2() != null && !TextUtils.isEmpty((CharSequence)transactionRequest.getCustomField2())) {
            tokenRequestModel.setCustomField2(transactionRequest.getCustomField2());
        }
        if (transactionRequest.getCustomField3() != null && !TextUtils.isEmpty((CharSequence)transactionRequest.getCustomField3())) {
            tokenRequestModel.setCustomField3(transactionRequest.getCustomField3());
        }
        if (transactionRequest.getPermataVa() != null) {
            tokenRequestModel.setPermataVa(transactionRequest.getPermataVa());
        }
        if (transactionRequest.getBcaVa() != null) {
            tokenRequestModel.setBcaVa(transactionRequest.getBcaVa());
        }
        if (transactionRequest.getBniVa() != null) {
            tokenRequestModel.setBcaVa(transactionRequest.getBniVa());
        }
        if (transactionRequest.getEnabledPayments() != null && !transactionRequest.getEnabledPayments().isEmpty()) {
            tokenRequestModel.setEnabledPayments(transactionRequest.getEnabledPayments());
        }
        return tokenRequestModel;
    }

    public static CustomerDetailRequest initializePaymentDetails(TransactionRequest transactionRequest) {
        CustomerDetailRequest customerDetailRequest = new CustomerDetailRequest();
        customerDetailRequest.setFullName(transactionRequest.getCustomerDetails().getFirstName());
        customerDetailRequest.setPhone(transactionRequest.getCustomerDetails().getPhone());
        customerDetailRequest.setEmail(transactionRequest.getCustomerDetails().getEmail());
        return customerDetailRequest;
    }

    public static CreditCardPaymentRequest getCreditCardPaymentRequest(CreditCardPaymentModel creditCardPaymentModel, TransactionRequest transactionRequest) {
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        CustomerDetailRequest customerDetailRequest = SdkUtil.initializePaymentDetails(transactionRequest);
        CreditCardPaymentParams creditCardPaymentParams = new CreditCardPaymentParams(creditCardPaymentModel.getCardToken(), creditCardPaymentModel.isSavecard(), creditCardPaymentModel.getMaskedCardNumber(), creditCardPaymentModel.getInstallment());
        creditCardPaymentParams.setPointRedeemed(creditCardPaymentModel.getPointRedeemed());
        if (creditCardPaymentModel.getBank() != null && creditCardPaymentModel.getBank().equalsIgnoreCase("mandiri")) {
            creditCardPaymentParams.setBank(creditCardPaymentModel.getBank());
        }
        creditCardPaymentParams.setFromBankPoint(creditCardPaymentModel.isFromBankPoint());
        CreditCardPaymentRequest creditCardPaymentRequest = new CreditCardPaymentRequest("credit_card", creditCardPaymentParams, customerDetailRequest);
        Promo promo = creditCardPaymentModel.getPromoSelected();
        if (promo != null) {
            PromoDetails promoDetails = new PromoDetails(promo.getId(), promo.getDiscountedGrossAmount());
            creditCardPaymentRequest.setPromoDetails(promoDetails);
        }
        return creditCardPaymentRequest;
    }

    public static CreditCardPaymentRequest getCreditCardPaymentRequest(String string2, Long l, CreditCardPaymentModel creditCardPaymentModel, TransactionRequest transactionRequest) {
        if (transactionRequest.isUiEnabled()) {
            transactionRequest = SdkUtil.initializeUserInfo(transactionRequest);
        }
        CustomerDetailRequest customerDetailRequest = SdkUtil.initializePaymentDetails(transactionRequest);
        CreditCardPaymentParams creditCardPaymentParams = new CreditCardPaymentParams(creditCardPaymentModel.getCardToken(), creditCardPaymentModel.isSavecard(), creditCardPaymentModel.getMaskedCardNumber(), creditCardPaymentModel.getInstallment());
        CreditCardPaymentRequest creditCardPaymentRequest = new CreditCardPaymentRequest("credit_card", creditCardPaymentParams, customerDetailRequest);
        return creditCardPaymentRequest;
    }

    public static BankTransferPaymentRequest getBankTransferPaymentRequest(String string2, String string3) {
        CustomerDetailRequest customerDetailRequest = new CustomerDetailRequest();
        customerDetailRequest.setEmail(string2);
        BankTransferPaymentRequest bankTransferPaymentRequest = new BankTransferPaymentRequest(string3, customerDetailRequest);
        return bankTransferPaymentRequest;
    }

    public static KlikBCAPaymentRequest getKlikBCAPaymentRequest(String string2, String string3) {
        KlikBCAPaymentRequest klikBCAPaymentRequest = new KlikBCAPaymentRequest(string3, new KlikBcaPaymentParams(string2));
        return klikBCAPaymentRequest;
    }

    public static String getEmailAddress(TransactionRequest transactionRequest) {
        return transactionRequest.getCustomerDetails().getEmail();
    }

    public static GCIPaymentRequest getGCIPaymentRequest(String string2, String string3) {
        GCIPaymentParams gCIPaymentParams = new GCIPaymentParams(string2, string3);
        GCIPaymentRequest gCIPaymentRequest = new GCIPaymentRequest(gCIPaymentParams, "gci");
        return gCIPaymentRequest;
    }

    public static MandiriClickPayPaymentRequest getMandiriClickPaymentRequest(String string2, String string3, String string4, String string5) {
        MandiriClickPayPaymentParams mandiriClickPayPaymentParams = new MandiriClickPayPaymentParams(string2, string4, string3);
        MandiriClickPayPaymentRequest mandiriClickPayPaymentRequest = new MandiriClickPayPaymentRequest(string5, mandiriClickPayPaymentParams);
        return mandiriClickPayPaymentRequest;
    }

    public static GoPayPaymentRequest getGoPayPaymentRequest() {
        return new GoPayPaymentRequest("gopay");
    }

    public static GoPayAuthorizationRequest getGoPayAuthorizationRequest(String string2) {
        return new GoPayAuthorizationRequest(string2);
    }

    public static DanamonOnlinePaymentRequest getDanamonOnlinePaymentRequest() {
        return new DanamonOnlinePaymentRequest("danamon_online");
    }

    public static void sortPaymentMethodsByPriority(ArrayList<PaymentMethodsModel> arrayList) {
        Collections.sort(arrayList, new Comparator<PaymentMethodsModel>(){

            public int a(PaymentMethodsModel paymentMethodsModel, PaymentMethodsModel paymentMethodsModel2) {
                return paymentMethodsModel.getPriority().compareTo(paymentMethodsModel2.getPriority());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((PaymentMethodsModel)object, (PaymentMethodsModel)object2);
            }
        });
    }

    public static SecurePreferences newPreferences(Context context, String string2) {
        int n;
        SecurePreferences securePreferences = new SecurePreferences(context, context.getString(R.string.PREFERENCE_PASSWORD), string2);
        try {
            n = securePreferences.getInt("preferences.version", 0);
        }
        catch (ClassCastException classCastException) {
            n = 0;
        }
        if (n == 0 || n < 1) {
            SecurePreferences.Editor editor = securePreferences.edit();
            editor.clear();
            editor.putInt("preferences.version", 1);
            editor.apply();
        }
        return securePreferences;
    }

    public static h newSnapServiceManager(int n) {
        return new h(e.b(n));
    }

    public static f newMidtransServiceManager(int n) {
        return new f(e.a(n));
    }

    public static c newMerchantServiceManager(String string2, int n) {
        return new c(e.a(string2, n));
    }

    public static MixpanelAnalyticsManager newMixpanelAnalyticsManager(String string2, String string3, String string4, String string5, String string6, boolean bl, Context context) {
        return new MixpanelAnalyticsManager(string2, string3, string4, string5, string6, bl, context);
    }
}

