/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.corekit.core;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.midtrans.sdk.analytics.MixpanelAnalyticsManager;
import com.midtrans.sdk.corekit.callback.BankBinsCallback;
import com.midtrans.sdk.corekit.callback.BanksPointCallback;
import com.midtrans.sdk.corekit.callback.CardRegistrationCallback;
import com.midtrans.sdk.corekit.callback.CardTokenCallback;
import com.midtrans.sdk.corekit.callback.CheckoutCallback;
import com.midtrans.sdk.corekit.callback.DeleteCardCallback;
import com.midtrans.sdk.corekit.callback.GetCardCallback;
import com.midtrans.sdk.corekit.callback.GetTransactionStatusCallback;
import com.midtrans.sdk.corekit.callback.SaveCardCallback;
import com.midtrans.sdk.corekit.callback.TransactionCallback;
import com.midtrans.sdk.corekit.callback.TransactionFinishedCallback;
import com.midtrans.sdk.corekit.callback.TransactionOptionsCallback;
import com.midtrans.sdk.corekit.core.BaseSdkBuilder;
import com.midtrans.sdk.corekit.core.IScanner;
import com.midtrans.sdk.corekit.core.ISdkFlow;
import com.midtrans.sdk.corekit.core.Logger;
import com.midtrans.sdk.corekit.core.PaymentMethod;
import com.midtrans.sdk.corekit.core.SdkUtil;
import com.midtrans.sdk.corekit.core.TransactionRequest;
import com.midtrans.sdk.corekit.core.UIKitCustomSetting;
import com.midtrans.sdk.corekit.core.c;
import com.midtrans.sdk.corekit.core.f;
import com.midtrans.sdk.corekit.core.h;
import com.midtrans.sdk.corekit.core.themes.BaseColorTheme;
import com.midtrans.sdk.corekit.models.CardTokenRequest;
import com.midtrans.sdk.corekit.models.PaymentDetails;
import com.midtrans.sdk.corekit.models.PaymentMethodsModel;
import com.midtrans.sdk.corekit.models.SaveCardRequest;
import com.midtrans.sdk.corekit.models.TokenRequestModel;
import com.midtrans.sdk.corekit.models.snap.CreditCard;
import com.midtrans.sdk.corekit.models.snap.CreditCardPaymentModel;
import com.midtrans.sdk.corekit.models.snap.MerchantData;
import com.midtrans.sdk.corekit.models.snap.PromoResponse;
import com.midtrans.sdk.corekit.models.snap.Transaction;
import com.midtrans.sdk.corekit.models.snap.TransactionResult;
import com.midtrans.sdk.corekit.models.snap.params.IndosatDompetkuPaymentParams;
import com.midtrans.sdk.corekit.models.snap.params.NewMandiriClickPaymentParams;
import com.midtrans.sdk.corekit.models.snap.params.TelkomselCashPaymentParams;
import com.midtrans.sdk.corekit.models.snap.payment.BasePaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.IndosatDompetkuPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.NewMandiriClickPayPaymentRequest;
import com.midtrans.sdk.corekit.models.snap.payment.TelkomselEcashPaymentRequest;
import com.midtrans.sdk.corekit.utilities.Utils;
import java.util.ArrayList;
import java.util.List;

public class MidtransSDK {
    private static final String TAG = "MidtransSDK";
    private static final String ADD_TRANSACTION_DETAILS = "Add transaction request details.";
    private static final String LOCAL_DATA_PREFERENCES = "local.data";
    private static SharedPreferences mPreferences = null;
    private static volatile MidtransSDK midtransSDK;
    private static BaseSdkBuilder sdkBuilder;
    private static boolean sdkNotAvailable;
    ISdkFlow uiflow;
    private UIKitCustomSetting UIKitCustomSetting;
    private boolean isLogEnabled = false;
    private TransactionFinishedCallback transactionFinishedCallback;
    private MixpanelAnalyticsManager mMixpanelAnalyticsManager;
    private Context context = null;
    private String clientKey = null;
    private String merchantServerUrl = null;
    private String defaultText = null;
    private String boldText = null;
    private String semiBoldText = null;
    private String merchantName = null;
    private IScanner externalScanner;
    private h snapServiceManager;
    private c merchantServiceManager;
    private f midtransServiceManager;
    private String merchantLogo = null;
    private TransactionRequest transactionRequest = null;
    private ArrayList<PaymentMethodsModel> selectedPaymentMethods = new ArrayList();
    private boolean enableBuiltInTokenStorage;
    private String sdkBaseUrl = "";
    private int requestTimeOut = 30;
    private String flow = null;
    private List<PromoResponse> promoResponses = new ArrayList<PromoResponse>();
    private BaseColorTheme colorTheme;
    private Transaction transaction;
    private CardRegistrationCallback cardRegistrationCallback;
    private PaymentDetails paymentDetails;
    private String authenticationToken;

    private MidtransSDK() {
    }

    private MidtransSDK(@NonNull BaseSdkBuilder baseSdkBuilder) {
        this.context = baseSdkBuilder.context;
        this.clientKey = baseSdkBuilder.clientKey;
        this.merchantServerUrl = baseSdkBuilder.merchantServerUrl;
        this.sdkBaseUrl = "https://app.midtrans.com/snap/";
        this.defaultText = baseSdkBuilder.defaultText;
        this.semiBoldText = baseSdkBuilder.semiBoldText;
        this.boldText = baseSdkBuilder.boldText;
        this.uiflow = baseSdkBuilder.sdkFlow;
        this.transactionFinishedCallback = baseSdkBuilder.transactionFinishedCallback;
        this.externalScanner = baseSdkBuilder.externalScanner;
        this.isLogEnabled = baseSdkBuilder.enableLog;
        Logger.enabled = baseSdkBuilder.enableLog;
        this.enableBuiltInTokenStorage = baseSdkBuilder.enableBuiltInTokenStorage;
        this.UIKitCustomSetting = baseSdkBuilder.UIKitCustomSetting == null ? new UIKitCustomSetting() : baseSdkBuilder.UIKitCustomSetting;
        this.flow = baseSdkBuilder.flow;
        if (baseSdkBuilder.colorTheme != null) {
            this.colorTheme = baseSdkBuilder.colorTheme;
        }
        String string2 = null;
        if (this.context != null) {
            mPreferences = SdkUtil.newPreferences(this.context, LOCAL_DATA_PREFERENCES);
            if (this.context instanceof Activity) {
                string2 = Utils.getDeviceType((Activity)this.context);
            }
        }
        this.mMixpanelAnalyticsManager = SdkUtil.newMixpanelAnalyticsManager("1.18.0", SdkUtil.getDeviceId(this.context), this.merchantName, this.getFlow(this.flow), string2 == null ? "" : string2, this.isLogEnabled, this.context);
        this.snapServiceManager = SdkUtil.newSnapServiceManager(this.requestTimeOut);
        this.midtransServiceManager = SdkUtil.newMidtransServiceManager(this.requestTimeOut);
        this.merchantServiceManager = SdkUtil.newMerchantServiceManager(this.merchantServerUrl, this.requestTimeOut);
    }

    protected static MidtransSDK delegateInstance(@NonNull BaseSdkBuilder baseSdkBuilder) {
        if (baseSdkBuilder != null) {
            midtransSDK = new MidtransSDK(baseSdkBuilder);
            sdkBuilder = baseSdkBuilder;
        } else {
            Logger.e("sdk is not initialized.");
        }
        return midtransSDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MidtransSDK getInstance() {
        if (midtransSDK == null) {
            Class<MidtransSDK> clazz = MidtransSDK.class;
            synchronized (MidtransSDK.class) {
                if (midtransSDK == null) {
                    if (sdkBuilder != null) {
                        midtransSDK = new MidtransSDK(sdkBuilder);
                        sdkNotAvailable = false;
                    } else {
                        midtransSDK = new MidtransSDK();
                        sdkNotAvailable = true;
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        } else {
            sdkNotAvailable = false;
        }
        return midtransSDK;
    }

    public static SharedPreferences getmPreferences() {
        return mPreferences;
    }

    static void setmPreferences(SharedPreferences sharedPreferences) {
        mPreferences = sharedPreferences;
    }

    public boolean isSdkNotAvailable() {
        return sdkNotAvailable;
    }

    private String getFlow(String string2) {
        if (string2.equalsIgnoreCase("core")) {
            return "Core";
        }
        if (string2.equalsIgnoreCase("ui")) {
            return "UI";
        }
        return "Widget";
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string2) {
        this.defaultText = string2;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String string2) {
        this.merchantName = string2;
    }

    public String getMerchantLogo() {
        return this.merchantLogo;
    }

    public void setMerchantLogo(String string2) {
        this.merchantLogo = string2;
    }

    public String getBoldText() {
        return this.boldText;
    }

    public void setBoldText(String string2) {
        this.boldText = string2;
    }

    public String getSemiBoldText() {
        return this.semiBoldText;
    }

    public void setSemiBoldText(String string2) {
        this.semiBoldText = string2;
    }

    public boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String string2) {
        this.flow = string2;
    }

    public Context getContext() {
        return this.context;
    }

    public MixpanelAnalyticsManager getmMixpanelAnalyticsManager() {
        String string2 = null;
        if (this.context != null && this.context instanceof Activity) {
            string2 = Utils.getDeviceType((Activity)this.context);
        }
        if (this.mMixpanelAnalyticsManager == null) {
            this.mMixpanelAnalyticsManager = SdkUtil.newMixpanelAnalyticsManager("1.18.0", SdkUtil.getDeviceId(this.context), this.merchantName, this.getFlow(this.flow), string2 == null ? "" : string2, this.isLogEnabled, this.context);
        }
        return this.mMixpanelAnalyticsManager;
    }

    public String readAuthenticationToken() {
        return this.authenticationToken;
    }

    public void setAuthenticationToken(String string2) {
        this.authenticationToken = string2;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public String getMerchantServerUrl() {
        return this.merchantServerUrl;
    }

    @Deprecated
    public ArrayList<PaymentMethodsModel> getSelectedPaymentMethods() {
        return this.selectedPaymentMethods;
    }

    @Deprecated
    public void setSelectedPaymentMethods(ArrayList<PaymentMethodsModel> arrayList) {
        this.selectedPaymentMethods = arrayList;
    }

    public TransactionRequest getTransactionRequest() {
        return this.transactionRequest;
    }

    public void setTransactionRequest(TransactionRequest transactionRequest) {
        if (transactionRequest != null) {
            this.transactionRequest = transactionRequest;
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    public void getCardToken(CardTokenRequest cardTokenRequest, CardTokenCallback cardTokenCallback) {
        if (cardTokenCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (cardTokenRequest != null) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.midtransServiceManager.a(cardTokenRequest, cardTokenCallback);
            } else {
                cardTokenCallback.onError(new Throwable("Failed to connect to server."));
                Logger.e("Failed to connect to server.");
            }
        } else {
            Logger.e("Invalid data supplied to SDK.");
            cardTokenCallback.onError(new Throwable("Invalid data supplied to SDK."));
        }
    }

    public void UiCardRegistration(@NonNull Context context, @NonNull CardRegistrationCallback cardRegistrationCallback) {
        if (this.uiflow != null) {
            this.cardRegistrationCallback = cardRegistrationCallback;
            this.uiflow.runCardRegistration(context, cardRegistrationCallback);
        } else {
            Logger.e(TAG, "uikit sdk is needed to use this feature");
        }
    }

    public void startPaymentUiFlow(Context context, PaymentMethod paymentMethod) {
        if (this.merchantBaseUrlAvailable()) {
            this.runDirectPaymentUiSdk(context, paymentMethod, null);
        }
    }

    public void startPaymentUiFlow(Context context, PaymentMethod paymentMethod, String string2) {
        if (this.snapTokenAvailable(string2)) {
            this.runDirectPaymentUiSdk(context, paymentMethod, string2);
        }
    }

    private void runDirectPaymentUiSdk(Context context, PaymentMethod paymentMethod, String string2) {
        if (paymentMethod.equals((Object)PaymentMethod.CREDIT_CARD)) {
            this.startCreditCardUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BANK_TRANSFER)) {
            this.startBankTransferUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BANK_TRANSFER_BCA)) {
            this.startBCABankTransferUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BANK_TRANSFER_PERMATA)) {
            this.startPermataBankTransferUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BANK_TRANSFER_MANDIRI)) {
            this.startMandiriBankTransferUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BANK_TRANSFER_BNI)) {
            this.startBniBankTransferUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BANK_TRANSFER_OTHER)) {
            this.startOtherBankTransferUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.GO_PAY)) {
            this.startGoPayUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.BCA_KLIKPAY)) {
            this.startBCAKlikPayUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.KLIKBCA)) {
            this.startKlikBCAUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.MANDIRI_CLICKPAY)) {
            this.startMandiriClickpayUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.MANDIRI_ECASH)) {
            this.startMandiriECashUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.EPAY_BRI)) {
            this.startBRIEpayUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.CIMB_CLICKS)) {
            this.startCIMBClicksUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.TELKOMSEL_CASH)) {
            this.startTelkomselCashUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.INDOSAT_DOMPETKU)) {
            this.startIndosatDompetkuUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.XL_TUNAI)) {
            this.startXlTunaiUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.INDOMARET)) {
            this.startIndomaretUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.KIOSON)) {
            this.startKiosonUIFlow(context, string2);
        } else if (paymentMethod.equals((Object)PaymentMethod.GIFT_CARD_INDONESIA)) {
            this.startGiftCardUIFlow(context, string2);
        } else if (TextUtils.isEmpty((CharSequence)string2)) {
            this.startPaymentUiFlow(context);
        } else {
            this.startPaymentUiFlow(context, string2);
        }
    }

    public void startPaymentUiFlow(Context context) {
        if (this.merchantBaseUrlAvailable()) {
            this.runUiSdk(context, null);
        }
    }

    public void startPaymentUiFlow(Context context, String string2) {
        if (this.snapTokenAvailable(string2)) {
            this.runUiSdk(context, string2);
        }
    }

    private void runUiSdk(Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runUIFlow(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private boolean snapTokenAvailable(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = "snap token cannot be null or empty, please checkout transaction to get snapToken";
            Logger.e(TAG, string3);
            if (this.transactionFinishedCallback != null) {
                this.transactionFinishedCallback.onTransactionFinished(new TransactionResult("invalid", string3));
            }
            return false;
        }
        return true;
    }

    private boolean merchantBaseUrlAvailable() {
        if (TextUtils.isEmpty((CharSequence)this.merchantServerUrl)) {
            String string2 = "merchant base url is required if you want to do checkout from SDK, please set merchant base url on Midtrans SDK";
            Logger.e(TAG, string2);
            if (this.transactionFinishedCallback != null) {
                this.transactionFinishedCallback.onTransactionFinished(new TransactionResult("invalid", string2));
            }
            return false;
        }
        return true;
    }

    private void startCreditCardUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runCreditCard(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startBankTransferUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runBankTransfer(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startPermataBankTransferUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runPermataBankTransfer(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startMandiriBankTransferUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runMandiriBankTransfer(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startBniBankTransferUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runBniBankTransfer(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startBCABankTransferUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runBCABankTransfer(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startOtherBankTransferUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runOtherBankTransfer(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startGoPayUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runGoPay(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startBCAKlikPayUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            this.transactionRequest.enableUi(true);
            if (this.uiflow != null) {
                this.uiflow.runBCAKlikPay(context, string2);
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startKlikBCAUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runKlikBCA(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startMandiriClickpayUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runMandiriClickpay(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startMandiriECashUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runMandiriECash(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startCIMBClicksUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runCIMBClicks(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startBRIEpayUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runBRIEpay(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startTelkomselCashUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runTelkomselCash(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startIndosatDompetkuUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runIndosatDompetku(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startIndomaretUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runIndomaret(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startKiosonUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runKioson(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startXlTunaiUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runXlTunai(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    private void startGiftCardUIFlow(@NonNull Context context, String string2) {
        if (this.isTransactionRequestAvailable()) {
            if (this.transactionRequest.getPaymentMethod() == -1) {
                this.transactionRequest.enableUi(true);
                if (this.uiflow != null) {
                    this.uiflow.runGci(context, string2);
                }
            }
        } else {
            Logger.e(TAG, ADD_TRANSACTION_DETAILS);
        }
    }

    public void getTransactionOptions(@NonNull String string2, @NonNull TransactionOptionsCallback transactionOptionsCallback) {
        if (transactionOptionsCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, transactionOptionsCallback);
            } else {
                transactionOptionsCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionOptionsCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void checkout(@NonNull String string2, @NonNull CheckoutCallback checkoutCallback) {
        if (checkoutCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                TokenRequestModel tokenRequestModel = SdkUtil.getSnapTokenRequestModel(this.transactionRequest);
                if (this.isEnableBuiltInTokenStorage()) {
                    tokenRequestModel.setUserId(string2);
                }
                this.merchantServiceManager.a(tokenRequestModel, checkoutCallback);
            } else {
                checkoutCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            checkoutCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void checkout(@NonNull CheckoutCallback checkoutCallback) {
        if (checkoutCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.transactionRequest != null) {
            if (Utils.isNetworkAvailable(this.context)) {
                TokenRequestModel tokenRequestModel = SdkUtil.getSnapTokenRequestModel(this.transactionRequest);
                this.merchantServiceManager.a(tokenRequestModel, checkoutCallback);
            } else {
                checkoutCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            checkoutCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingCard(@NonNull String string2, CreditCardPaymentModel creditCardPaymentModel, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, SdkUtil.getCreditCardPaymentRequest(creditCardPaymentModel, this.transactionRequest), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingBankTransferBCA(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, SdkUtil.getBankTransferPaymentRequest(string3, "bca_va"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingBankTransferBni(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, SdkUtil.getBankTransferPaymentRequest(string3, "bni_va"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingBankTransferPermata(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, SdkUtil.getBankTransferPaymentRequest(string3, "permata_va"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingKlikBCA(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, SdkUtil.getKlikBCAPaymentRequest(string3, "bca_klikbca"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingBCAKlikpay(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("bca_klikpay"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingMandiriBillPay(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, SdkUtil.getBankTransferPaymentRequest(string3, "echannel"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingMandiriClickPay(String string2, NewMandiriClickPaymentParams newMandiriClickPaymentParams, TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new NewMandiriClickPayPaymentRequest("mandiri_clickpay", newMandiriClickPaymentParams), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingCIMBClick(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("cimb_clicks"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingMandiriEcash(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("mandiri_ecash"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingTelkomselEcash(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (this.isNetworkAvailable()) {
                this.snapServiceManager.a(string2, new TelkomselEcashPaymentRequest("telkomsel_cash", new TelkomselCashPaymentParams(string3)), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingXLTunai(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("xl_tunai"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingIndomaret(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("indomaret"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingIndosatDompetku(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new IndosatDompetkuPaymentRequest("indosat_dompetku", new IndosatDompetkuPaymentParams(string3)), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingKiosan(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("kioson"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingEpayBRI(@NonNull String string2, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (this.isNetworkAvailable()) {
                this.snapServiceManager.a(string2, new BasePaymentRequest("bri_epay"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingBankTransferAllBank(@NonNull String string2, @NonNull String string3, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isTransactionRequestAvailable()) {
            if (this.isNetworkAvailable()) {
                this.snapServiceManager.a(string2, SdkUtil.getBankTransferPaymentRequest(string3, "other_va"), transactionCallback);
            } else {
                transactionCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingGCI(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isNetworkAvailable()) {
            this.snapServiceManager.a(string2, SdkUtil.getGCIPaymentRequest(string3, string4), transactionCallback);
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingGoPay(String string2, TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isNetworkAvailable()) {
            this.snapServiceManager.a(string2, SdkUtil.getGoPayPaymentRequest(), transactionCallback);
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void paymentUsingDanamonOnline(String string2, TransactionCallback transactionCallback) {
        if (transactionCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isNetworkAvailable()) {
            this.snapServiceManager.a(string2, SdkUtil.getDanamonOnlinePaymentRequest(), transactionCallback);
        } else {
            transactionCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void cardRegistration(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @NonNull CardRegistrationCallback cardRegistrationCallback) {
        if (cardRegistrationCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (this.isNetworkAvailable()) {
            this.midtransServiceManager.a(string2, string3, string4, string5, this.clientKey, cardRegistrationCallback);
        } else {
            Logger.e("Failed to connect to server.");
            cardRegistrationCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void saveCards(@NonNull String string2, @NonNull ArrayList<SaveCardRequest> arrayList, @NonNull SaveCardCallback saveCardCallback) {
        if (saveCardCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (arrayList != null) {
            if (Utils.isNetworkAvailable(this.context)) {
                this.merchantServiceManager.a(string2, arrayList, saveCardCallback);
            } else {
                saveCardCallback.onError(new Throwable("Failed to connect to server."));
            }
        } else {
            saveCardCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void getCards(@NonNull String string2, GetCardCallback getCardCallback) {
        if (getCardCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (Utils.isNetworkAvailable(this.context)) {
            this.merchantServiceManager.a(string2, getCardCallback);
        } else {
            getCardCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void getBankBins(@NonNull BankBinsCallback bankBinsCallback) {
        if (bankBinsCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (Utils.isNetworkAvailable(this.context)) {
            this.snapServiceManager.a(bankBinsCallback);
        } else {
            bankBinsCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void getBanksPoint(String string2, @NonNull BanksPointCallback banksPointCallback) {
        if (banksPointCallback == null) {
            Logger.e(TAG, "Callback Unimplemented");
            return;
        }
        if (Utils.isNetworkAvailable(this.context)) {
            this.snapServiceManager.a(this.readAuthenticationToken(), string2, banksPointCallback);
        } else {
            banksPointCallback.onError(new Throwable("Failed to connect to server."));
        }
    }

    public void deleteCard(@NonNull String string2, String string3, DeleteCardCallback deleteCardCallback) {
        if (this.isNetworkAvailable()) {
            this.snapServiceManager.a(string2, string3, deleteCardCallback);
        } else {
            deleteCardCallback.onError(new RuntimeException("Failed to connect to server."));
        }
    }

    public void getTransactionStatus(String string2, GetTransactionStatusCallback getTransactionStatusCallback) {
        if (this.isNetworkAvailable()) {
            this.snapServiceManager.a(string2, getTransactionStatusCallback);
        } else {
            getTransactionStatusCallback.onError(new RuntimeException("Failed to connect to server."));
        }
    }

    public void changeSdkConfig(String string2, String string3, String string4, int n) {
        this.sdkBaseUrl = string2;
        this.merchantServerUrl = string3;
        this.clientKey = string4;
        this.requestTimeOut = n;
    }

    public void notifyTransactionFinished(TransactionResult transactionResult) {
        if (this.transactionFinishedCallback != null) {
            this.transactionFinishedCallback.onTransactionFinished(transactionResult);
        } else {
            Logger.e(TAG, "Callback Unimplemented");
        }
    }

    public IScanner getExternalScanner() {
        return this.externalScanner;
    }

    boolean isNetworkAvailable() {
        return Utils.isNetworkAvailable(this.context);
    }

    public String getSdkBaseUrl() {
        return this.sdkBaseUrl;
    }

    public int getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public boolean isEnableBuiltInTokenStorage() {
        return this.enableBuiltInTokenStorage;
    }

    public UIKitCustomSetting getUIKitCustomSetting() {
        if (this.UIKitCustomSetting == null) {
            this.UIKitCustomSetting = new UIKitCustomSetting();
        }
        return this.UIKitCustomSetting;
    }

    public void setUIKitCustomSetting(UIKitCustomSetting uIKitCustomSetting) {
        if (uIKitCustomSetting != null) {
            this.UIKitCustomSetting = uIKitCustomSetting;
        }
    }

    public CreditCard getCreditCard() {
        Transaction transaction = this.getTransaction();
        if (transaction.getCreditCard() == null) {
            transaction.setCreditCard(new CreditCard());
        }
        return transaction.getCreditCard();
    }

    public void setCreditCard(CreditCard creditCard) {
        if (creditCard != null) {
            this.getTransaction().setCreditCard(creditCard);
        }
    }

    public List<PromoResponse> getPromoResponses() {
        return this.promoResponses;
    }

    public void setPromoResponses(List<PromoResponse> list) {
        this.promoResponses = list;
    }

    public BaseColorTheme getColorTheme() {
        return this.colorTheme;
    }

    public void setColorTheme(BaseColorTheme baseColorTheme) {
        this.colorTheme = baseColorTheme;
    }

    public ArrayList<String> getBanksPointEnabled() {
        MerchantData merchantData = this.getMerchantData();
        if (merchantData.getPointBanks() == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            merchantData.setPointBanks(arrayList);
        }
        return merchantData.getPointBanks();
    }

    public void setTransactionFinishedCallback(TransactionFinishedCallback transactionFinishedCallback) {
        this.transactionFinishedCallback = transactionFinishedCallback;
    }

    public MerchantData getMerchantData() {
        Transaction transaction = this.getTransaction();
        if (transaction.getMerchantData() == null) {
            transaction.setMerchantData(new MerchantData());
        }
        return transaction.getMerchantData();
    }

    public Transaction getTransaction() {
        if (this.transaction == null) {
            this.transaction = new Transaction();
        }
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        }
    }

    public CardRegistrationCallback getUiCardRegistrationCallback() {
        return this.cardRegistrationCallback;
    }

    public PaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(PaymentDetails paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

    public void resetPaymentDetails() {
        this.paymentDetails = new PaymentDetails(this.getTransaction().getTransactionDetails(), this.getTransaction().getItemDetails());
    }

    public void setSnapServiceManager(h h2) {
        this.snapServiceManager = h2;
    }

    public void setMerchantServiceManager(c c2) {
        this.merchantServiceManager = c2;
    }

    public void setMidtransServiceManager(f f2) {
        this.midtransServiceManager = f2;
    }

    public h getSnapServiceManager() {
        return this.snapServiceManager;
    }

    public c getMerchantServiceManager() {
        return this.merchantServiceManager;
    }

    public f getMidtransServiceManager() {
        return this.midtransServiceManager;
    }

    private boolean isTransactionRequestAvailable() {
        return this.transactionRequest != null;
    }

    static {
        sdkNotAvailable = false;
    }
}

