/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.corekit.core;

import android.content.Context;
import android.text.TextUtils;
import com.midtrans.sdk.corekit.callback.TransactionFinishedCallback;
import com.midtrans.sdk.corekit.core.IScanner;
import com.midtrans.sdk.corekit.core.ISdkFlow;
import com.midtrans.sdk.corekit.core.Logger;
import com.midtrans.sdk.corekit.core.MidtransSDK;
import com.midtrans.sdk.corekit.core.UIKitCustomSetting;
import com.midtrans.sdk.corekit.core.themes.BaseColorTheme;
import com.midtrans.sdk.corekit.models.PaymentMethodsModel;
import java.util.ArrayList;

public abstract class BaseSdkBuilder<T> {
    public static final String CORE_FLOW = "core";
    public static final String UI_FLOW = "ui";
    public static final String WIDGET = "widget";
    private static final String TAG = "BaseSdkBuilder";
    protected String clientKey = null;
    protected Context context = null;
    protected boolean enableLog = false;
    protected boolean enableBuiltInTokenStorage = true;
    protected String merchantServerUrl = null;
    protected String merchantName = null;
    protected ISdkFlow sdkFlow;
    protected String defaultText;
    protected String boldText;
    protected String semiBoldText;
    protected ArrayList<PaymentMethodsModel> selectedPaymentMethods;
    protected IScanner externalScanner;
    protected TransactionFinishedCallback transactionFinishedCallback;
    protected UIKitCustomSetting UIKitCustomSetting;
    protected String flow;
    protected BaseColorTheme colorTheme;

    public abstract T enableLog(boolean var1);

    public MidtransSDK buildSDK() {
        if (this.isValidData()) {
            MidtransSDK midtransSDK = MidtransSDK.delegateInstance(this);
            return midtransSDK;
        }
        Logger.e("already performing an transaction");
        return null;
    }

    public boolean isValidData() {
        RuntimeException runtimeException;
        String string;
        if (this.clientKey == null || this.context == null) {
            string = "Client key  and context cannot be null or empty. Please set the client key and context";
            runtimeException = new RuntimeException(string);
            Logger.e(string, runtimeException);
        }
        if (!this.enableBuiltInTokenStorage && TextUtils.isEmpty((CharSequence)this.merchantServerUrl)) {
            string = "Merchant base url cannot be null or empty (required) if you implement your own token storage. Please set your merchant base url to enable your own token storage";
            runtimeException = new RuntimeException(string);
            Logger.e(string, runtimeException);
        }
        return true;
    }
}

