/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AASAttestationParameters;
import com.microsoft.sqlserver.jdbc.AASAttestationResponse;
import com.microsoft.sqlserver.jdbc.EnclaveCacheEntry;
import com.microsoft.sqlserver.jdbc.EnclaveSession;
import com.microsoft.sqlserver.jdbc.EnclaveSessionCache;
import com.microsoft.sqlserver.jdbc.ISQLServerEnclaveProvider;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class SQLServerAASEnclaveProvider
implements ISQLServerEnclaveProvider {
    private static EnclaveSessionCache enclaveCache = new EnclaveSessionCache();
    private AASAttestationParameters aasParams = null;
    private AASAttestationResponse hgsResponse = null;
    private String attestationURL = null;
    private EnclaveSession enclaveSession = null;

    @Override
    public void getAttestationParameters(String url) throws SQLServerException {
        if (null == this.aasParams) {
            this.attestationURL = url;
            try {
                this.aasParams = new AASAttestationParameters(this.attestationURL);
            }
            catch (IOException e) {
                SQLServerException.makeFromDriverError(null, this, e.getLocalizedMessage(), "0", false);
            }
        }
    }

    @Override
    public ArrayList<byte[]> createEnclaveSession(SQLServerConnection connection, String userSql, String preparedTypeDefinitions, Parameter[] params, ArrayList<String> parameterNames) throws SQLServerException {
        ArrayList<byte[]> b = this.describeParameterEncryption(connection, userSql, preparedTypeDefinitions, params, parameterNames);
        if (null != this.hgsResponse && !connection.enclaveEstablished()) {
            EnclaveCacheEntry entry = enclaveCache.getSession(connection.getServerName() + this.attestationURL);
            if (null != entry) {
                this.enclaveSession = entry.getEnclaveSession();
                this.aasParams = (AASAttestationParameters)entry.getBaseAttestationRequest();
                return b;
            }
            try {
                this.enclaveSession = new EnclaveSession(this.hgsResponse.getSessionID(), this.aasParams.createSessionSecret(this.hgsResponse.getDHpublicKey()));
                enclaveCache.addEntry(connection.getServerName(), connection.enclaveAttestationUrl, this.aasParams, this.enclaveSession);
            }
            catch (GeneralSecurityException e) {
                SQLServerException.makeFromDriverError(connection, this, e.getLocalizedMessage(), "0", false);
            }
        }
        return b;
    }

    @Override
    public void invalidateEnclaveSession() {
        if (null != this.enclaveSession) {
            enclaveCache.removeEntry(this.enclaveSession);
        }
        this.enclaveSession = null;
        this.aasParams = null;
        this.attestationURL = null;
    }

    @Override
    public EnclaveSession getEnclaveSession() {
        return this.enclaveSession;
    }

    private AASAttestationResponse validateAttestationResponse(AASAttestationResponse ar) throws SQLServerException {
        try {
            ar.validateToken(this.attestationURL, this.aasParams.getNonce());
            ar.validateDHPublicKey(this.aasParams.getNonce());
        }
        catch (GeneralSecurityException e) {
            SQLServerException.makeFromDriverError(null, this, e.getLocalizedMessage(), "0", false);
        }
        return ar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<byte[]> describeParameterEncryption(SQLServerConnection connection, String userSql, String preparedTypeDefinitions, Parameter[] params, ArrayList<String> parameterNames) throws SQLServerException {
        ArrayList<byte[]> enclaveRequestedCEKs = new ArrayList<byte[]>();
        ResultSet rs = null;
        try (PreparedStatement stmt = connection.prepareStatement("EXEC sp_describe_parameter_encryption ?,?,?");){
            rs = this.executeProc(stmt, userSql, preparedTypeDefinitions, this.aasParams);
            if (null == rs) {
                ArrayList<byte[]> arrayList = enclaveRequestedCEKs;
                return arrayList;
            }
            this.processAev1SPDE(userSql, preparedTypeDefinitions, params, parameterNames, connection, stmt, rs, enclaveRequestedCEKs);
            if (connection.isAEv2() && stmt.getMoreResults()) {
                rs = (SQLServerResultSet)stmt.getResultSet();
                while (rs.next()) {
                    this.hgsResponse = new AASAttestationResponse(rs.getBytes(1));
                    if (connection.enclaveEstablished()) continue;
                    this.hgsResponse = this.validateAttestationResponse(this.hgsResponse);
                }
            }
            rs.close();
            return enclaveRequestedCEKs;
        }
        catch (SQLException e) {
            if (!(e instanceof SQLServerException)) throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
            throw (SQLServerException)e;
        }
    }
}

