/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.ThreePartName;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.ZeroFixupFilter;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SQLServerParameterMetaData
implements ParameterMetaData {
    private static final int SQL_SERVER_2012_VERSION = 11;
    private final SQLServerPreparedStatement stmtParent;
    private SQLServerConnection con;
    private List<Map<String, Object>> procMetadata;
    protected boolean procedureIsFound;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerParameterMetaData");
    private static final AtomicInteger baseID = new AtomicInteger(0);
    private final String traceID;
    boolean isTVP;
    private String stringToParse;
    private int indexToBeginParse;
    Map<Integer, QueryMeta> queryMetaMap;

    private static int nextInstanceID() {
        return baseID.incrementAndGet();
    }

    public final String toString() {
        return this.traceID;
    }

    private String parseColumns(String columnSet, String columnStartToken) throws SQLServerException {
        StringTokenizer st = new StringTokenizer(columnSet, " =?<>!\r\n\t\f", true);
        boolean START = false;
        boolean PARAMNAME = true;
        int PARAMVALUE = 2;
        int nState = 0;
        String sLastField = null;
        StringBuilder sb = new StringBuilder();
        int sTokenIndex = 0;
        while (st.hasMoreTokens()) {
            String paramN;
            String sToken = st.nextToken();
            sTokenIndex += sToken.length();
            if (sToken.equalsIgnoreCase(columnStartToken)) {
                nState = 1;
                continue;
            }
            if (nState == 0) continue;
            if (sToken.charAt(0) == '=' || sToken.equalsIgnoreCase("is") || sToken.charAt(0) == '<' || sToken.charAt(0) == '>' || sToken.equalsIgnoreCase("like") || sToken.equalsIgnoreCase("not") || sToken.equalsIgnoreCase("in") || sToken.charAt(0) == '!') {
                nState = 2;
                continue;
            }
            if (sToken.charAt(0) == '?' && sLastField != null) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(sLastField);
                nState = 1;
                sLastField = null;
                continue;
            }
            if (nState != 1 || sToken.equals(" ") || (paramN = this.escapeParse(st, sToken)).length() <= 0) continue;
            sLastField = paramN;
        }
        this.indexToBeginParse = sTokenIndex;
        return sb.toString();
    }

    private String parseInsertColumns(String sql, String columnMarker) throws SQLServerException {
        StringTokenizer st = new StringTokenizer(sql, " (),", true);
        int nState = 0;
        String sLastField = null;
        StringBuilder sb = new StringBuilder();
        int sTokenIndex = 0;
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken();
            sTokenIndex += sToken.length();
            if (sToken.equalsIgnoreCase(columnMarker)) {
                nState = 1;
                continue;
            }
            if (nState == 0) continue;
            if (sToken.charAt(0) == '=') {
                nState = 2;
                continue;
            }
            if ((sToken.charAt(0) == ',' || sToken.charAt(0) == ')' || sToken.charAt(0) == ' ') && sLastField != null) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(sLastField);
                nState = 1;
                sLastField = null;
            }
            if (sToken.charAt(0) == ')') {
                nState = 0;
                break;
            }
            if (nState != 1 || sToken.trim().length() <= 0 || sToken.charAt(0) == ',') continue;
            sLastField = this.escapeParse(st, sToken);
            sTokenIndex += sLastField.length() - sToken.length();
        }
        this.indexToBeginParse = sTokenIndex;
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseQueryMeta(ResultSet rsQueryMeta) throws SQLServerException {
        Pattern datatypePattern = Pattern.compile("(.*)\\((.*)(\\)|,(.*)\\))");
        try {
            if (null == rsQueryMeta) return;
            while (rsQueryMeta.next()) {
                int paramOrdinal;
                SSType ssType;
                QueryMeta qm;
                block38: {
                    block41: {
                        String typename;
                        block39: {
                            Matcher matcher;
                            block40: {
                                qm = new QueryMeta();
                                ssType = null;
                                paramOrdinal = rsQueryMeta.getInt("parameter_ordinal");
                                typename = rsQueryMeta.getString("suggested_system_type_name");
                                if (null == typename) {
                                    typename = rsQueryMeta.getString("suggested_user_type_name");
                                    try (SQLServerPreparedStatement pstmt = (SQLServerPreparedStatement)this.con.prepareStatement("select max_length, precision, scale, is_nullable from sys.assembly_types where name = ?");){
                                        pstmt.setNString(1, typename);
                                        try (ResultSet assemblyRs = pstmt.executeQuery();){
                                            if (assemblyRs.next()) {
                                                qm.parameterTypeName = typename;
                                                qm.precision = assemblyRs.getInt("max_length");
                                                qm.scale = assemblyRs.getInt("scale");
                                                ssType = SSType.UDT;
                                            }
                                            break block38;
                                        }
                                    }
                                }
                                qm.precision = rsQueryMeta.getInt("suggested_precision");
                                qm.scale = rsQueryMeta.getInt("suggested_scale");
                                matcher = datatypePattern.matcher(typename);
                                if (!matcher.matches()) break block39;
                                ssType = SSType.of(matcher.group(1));
                                if (!typename.equalsIgnoreCase("varchar(max)") && !typename.equalsIgnoreCase("varbinary(max)")) break block40;
                                qm.precision = Integer.MAX_VALUE;
                                break block41;
                            }
                            if (typename.equalsIgnoreCase("nvarchar(max)")) {
                                qm.precision = 0x3FFFFFFF;
                                break block41;
                            } else if (SSType.Category.CHARACTER == ssType.category || SSType.Category.BINARY == ssType.category || SSType.Category.NCHARACTER == ssType.category) {
                                try {
                                    qm.precision = Integer.parseInt(matcher.group(2));
                                }
                                catch (NumberFormatException e) {
                                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_metaDataErrorForParameter"));
                                    Object[] msgArgs = new Object[]{paramOrdinal};
                                    SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs) + " " + e.getMessage(), null, false);
                                }
                            }
                            break block41;
                        }
                        ssType = SSType.of(typename);
                    }
                    if (SSType.FLOAT == ssType) {
                        qm.precision = 15;
                    } else if (SSType.REAL == ssType) {
                        qm.precision = 7;
                    } else if (SSType.TEXT == ssType) {
                        qm.precision = Integer.MAX_VALUE;
                    } else if (SSType.NTEXT == ssType) {
                        qm.precision = 0x3FFFFFFF;
                    } else if (SSType.IMAGE == ssType) {
                        qm.precision = Integer.MAX_VALUE;
                    } else if (SSType.GUID == ssType) {
                        qm.precision = 36;
                    } else if (SSType.TIMESTAMP == ssType) {
                        qm.precision = 8;
                    } else if (SSType.XML == ssType) {
                        qm.precision = 0x3FFFFFFF;
                    }
                    qm.parameterTypeName = ssType.toString();
                }
                if (null == ssType) {
                    throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), null);
                }
                JDBCType jdbcType = ssType.getJDBCType();
                qm.parameterClassName = jdbcType.className();
                qm.parameterType = jdbcType.getIntValue();
                qm.isSigned = SSType.Category.NUMERIC == ssType.category && SSType.BIT != ssType && SSType.TINYINT != ssType;
                this.queryMetaMap.put(paramOrdinal, qm);
            }
            return;
        }
        catch (SQLException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), e);
        }
    }

    private void parseQueryMetaFor2008(ResultSet rsQueryMeta) throws SQLServerException {
        try {
            if (null != rsQueryMeta) {
                ResultSetMetaData md = rsQueryMeta.getMetaData();
                for (int i = 1; i <= md.getColumnCount(); ++i) {
                    QueryMeta qm = new QueryMeta();
                    qm.parameterClassName = md.getColumnClassName(i);
                    qm.parameterType = md.getColumnType(i);
                    qm.parameterTypeName = md.getColumnTypeName(i);
                    qm.precision = md.getPrecision(i);
                    qm.scale = md.getScale(i);
                    qm.isNullable = md.isNullable(i);
                    qm.isSigned = md.isSigned(i);
                    this.queryMetaMap.put(i, qm);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), e);
        }
    }

    private String escapeParse(StringTokenizer st, String firstToken) throws SQLServerException {
        if (null == firstToken) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_NullValue"));
            Object[] msgArgs1 = new Object[]{"firstToken"};
            throw new SQLServerException(form.format(msgArgs1), null);
        }
        while (0 == firstToken.trim().length() && st.hasMoreTokens()) {
            firstToken = st.nextToken();
        }
        String fullName = firstToken;
        if (firstToken.charAt(0) == '[' && firstToken.charAt(firstToken.length() - 1) != ']') {
            while (st.hasMoreTokens()) {
                firstToken = st.nextToken();
                fullName = fullName.concat(firstToken);
                if (firstToken.charAt(firstToken.length() - 1) != ']') continue;
            }
        }
        fullName = fullName.trim();
        return fullName;
    }

    private MetaInfo parseStatement(String sql, String sTableMarker) throws SQLServerException {
        StringTokenizer st = new StringTokenizer(sql, " ,\r\n\t\f(", true);
        String metaTable = null;
        String metaFields = "";
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken().trim();
            if (sToken.contains("*/")) {
                sToken = this.removeCommentsInTheBeginning(sToken, 0, 0, "/*", "*/");
            }
            if (!sToken.equalsIgnoreCase(sTableMarker) || !st.hasMoreTokens()) continue;
            metaTable = this.escapeParse(st, st.nextToken());
            break;
        }
        if (null != metaTable) {
            if (sTableMarker.equalsIgnoreCase("UPDATE")) {
                metaFields = this.parseColumns(sql, "SET");
                this.stringToParse = "";
            } else if (sTableMarker.equalsIgnoreCase("INTO")) {
                metaFields = this.parseInsertColumns(sql, "(");
                this.stringToParse = sql.substring(this.indexToBeginParse);
                if (this.stringToParse.trim().toLowerCase().startsWith("values")) {
                    this.parseInsertColumns(this.stringToParse, "(");
                    this.stringToParse = this.stringToParse.substring(this.indexToBeginParse);
                }
            } else {
                metaFields = this.parseColumns(sql, "WHERE");
                this.stringToParse = "";
            }
            return new MetaInfo(metaTable, metaFields);
        }
        return null;
    }

    private MetaInfo parseStatement(String sql) throws SQLServerException {
        StringTokenizer st = new StringTokenizer(sql, " \r\n\t\f");
        if (st.hasMoreTokens()) {
            String sToken = st.nextToken().trim();
            if (sToken.contains("/*")) {
                String sqlWithoutCommentsInBeginning = this.removeCommentsInTheBeginning(sql, 0, 0, "/*", "*/");
                return this.parseStatement(sqlWithoutCommentsInBeginning);
            }
            if (sToken.contains("--")) {
                String sqlWithoutCommentsInBeginning = this.removeCommentsInTheBeginning(sql, 0, 0, "--", "\n");
                return this.parseStatement(sqlWithoutCommentsInBeginning);
            }
            if (sToken.equalsIgnoreCase("INSERT")) {
                return this.parseStatement(sql, "INTO");
            }
            if (sToken.equalsIgnoreCase("UPDATE")) {
                return this.parseStatement(sql, "UPDATE");
            }
            if (sToken.equalsIgnoreCase("SELECT")) {
                return this.parseStatement(sql, "FROM");
            }
            if (sToken.equalsIgnoreCase("DELETE")) {
                return this.parseStatement(sql, "FROM");
            }
        }
        return null;
    }

    private String removeCommentsInTheBeginning(String sql, int startCommentMarkCount, int endCommentMarkCount, String startMark, String endMark) {
        int startCommentMarkIndex = sql.indexOf(startMark);
        int endCommentMarkIndex = sql.indexOf(endMark);
        if (-1 == startCommentMarkIndex) {
            startCommentMarkIndex = Integer.MAX_VALUE;
        }
        if (-1 == endCommentMarkIndex) {
            endCommentMarkIndex = Integer.MAX_VALUE;
        }
        if (startCommentMarkCount == endCommentMarkCount && startCommentMarkCount != 0 && endCommentMarkCount != 0) {
            return sql;
        }
        if (startCommentMarkIndex < endCommentMarkIndex) {
            String sqlWithoutCommentsInBeginning = sql.substring(startCommentMarkIndex + startMark.length());
            return this.removeCommentsInTheBeginning(sqlWithoutCommentsInBeginning, ++startCommentMarkCount, endCommentMarkCount, startMark, endMark);
        }
        if (Integer.MAX_VALUE == endCommentMarkIndex) {
            return sql;
        }
        String sqlWithoutCommentsInBeginning = sql.substring(endCommentMarkIndex + endMark.length());
        return this.removeCommentsInTheBeginning(sqlWithoutCommentsInBeginning, startCommentMarkCount, ++endCommentMarkCount, startMark, endMark);
    }

    String parseProcIdentifier(String procIdentifier) throws SQLServerException {
        ThreePartName threePartName = ThreePartName.parse(procIdentifier);
        StringBuilder sb = new StringBuilder();
        if (threePartName.getDatabasePart() != null) {
            sb.append("@procedure_qualifier=");
            sb.append(threePartName.getDatabasePart());
            sb.append(", ");
        }
        if (threePartName.getOwnerPart() != null) {
            sb.append("@procedure_owner=");
            sb.append(threePartName.getOwnerPart());
            sb.append(", ");
        }
        if (threePartName.getProcedurePart() != null) {
            sb.append("@procedure_name=");
            sb.append(threePartName.getProcedurePart());
        } else {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
        return sb.toString();
    }

    private void checkClosed() throws SQLServerException {
        this.con.checkClosed();
    }

    SQLServerParameterMetaData(SQLServerPreparedStatement st, String sProcString) throws SQLServerException {
        block46: {
            this.procedureIsFound = false;
            this.traceID = " SQLServerParameterMetaData:" + SQLServerParameterMetaData.nextInstanceID();
            this.isTVP = false;
            this.stringToParse = null;
            this.indexToBeginParse = -1;
            this.queryMetaMap = null;
            assert (null != st);
            this.stmtParent = st;
            this.con = st.connection;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toString() + " created by (" + st.toString() + ")");
            }
            try {
                if (null != st.procedureName) {
                    String sProc = this.parseProcIdentifier(st.procedureName);
                    try (SQLServerStatement s = (SQLServerStatement)this.con.createStatement(1004, 1007);
                         final SQLServerResultSet rsProcedureMeta = s.executeQueryInternal(this.con.isKatmaiOrLater() ? "exec sp_sproc_columns_100 " + sProc + ", @ODBCVer=3" : "exec sp_sproc_columns " + sProc + ", @ODBCVer=3");){
                        this.procedureIsFound = rsProcedureMeta.next();
                        rsProcedureMeta.beforeFirst();
                        rsProcedureMeta.getColumn(6).setFilter(new DataTypeFilter());
                        if (this.con.isKatmaiOrLater()) {
                            rsProcedureMeta.getColumn(8).setFilter(new ZeroFixupFilter());
                            rsProcedureMeta.getColumn(9).setFilter(new ZeroFixupFilter());
                            rsProcedureMeta.getColumn(17).setFilter(new ZeroFixupFilter());
                        }
                        this.procMetadata = new ArrayList<Map<String, Object>>();
                        while (rsProcedureMeta.next()) {
                            this.procMetadata.add((Map<String, Object>)new HashMap<String, Object>(){
                                {
                                    this.put("DATA_TYPE", rsProcedureMeta.getShort("DATA_TYPE"));
                                    this.put("COLUMN_TYPE", rsProcedureMeta.getInt("COLUMN_TYPE"));
                                    this.put("TYPE_NAME", rsProcedureMeta.getString("TYPE_NAME"));
                                    this.put("PRECISION", rsProcedureMeta.getInt("PRECISION"));
                                    this.put("SCALE", rsProcedureMeta.getInt("SCALE"));
                                    this.put("NULLABLE", rsProcedureMeta.getInt("NULLABLE"));
                                    this.put("SS_TYPE_SCHEMA_NAME", rsProcedureMeta.getString("SS_TYPE_SCHEMA_NAME"));
                                }
                            });
                        }
                        break block46;
                    }
                }
                this.queryMetaMap = new HashMap<Integer, QueryMeta>();
                if (this.con.getServerMajorVersion() >= 11) {
                    String preparedSQL = this.con.replaceParameterMarkers(this.stmtParent.userSQL, this.stmtParent.userSQLParamPositions, this.stmtParent.inOutParam, this.stmtParent.bReturnValueSyntax);
                    try (SQLServerCallableStatement cstmt = (SQLServerCallableStatement)this.con.prepareCall("exec sp_describe_undeclared_parameters ?");){
                        cstmt.setNString(1, preparedSQL);
                        this.parseQueryMeta(cstmt.executeQueryInternal());
                        break block46;
                    }
                }
                this.stringToParse = sProcString;
                ArrayList<MetaInfo> metaInfoList = new ArrayList<MetaInfo>();
                while (this.stringToParse.length() > 0) {
                    MetaInfo metaInfo = this.parseStatement(this.stringToParse);
                    if (null == metaInfo) {
                        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_cantIdentifyTableMetadata"));
                        Object[] msgArgs = new Object[]{this.stringToParse};
                        SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs), null, false);
                    }
                    metaInfoList.add(metaInfo);
                }
                if (metaInfoList.size() <= 0 || ((MetaInfo)metaInfoList.get((int)0)).fields.length() <= 0) {
                    return;
                }
                StringBuilder sbColumns = new StringBuilder();
                for (MetaInfo mi : metaInfoList) {
                    sbColumns = sbColumns.append(mi.fields).append(",");
                }
                sbColumns.deleteCharAt(sbColumns.length() - 1);
                String columns = sbColumns.toString();
                StringBuilder sbTablesAndJoins = new StringBuilder();
                for (int i = 0; i < metaInfoList.size(); ++i) {
                    if (i == 0) {
                        sbTablesAndJoins = sbTablesAndJoins.append(((MetaInfo)metaInfoList.get((int)i)).table);
                        continue;
                    }
                    if (((MetaInfo)metaInfoList.get((int)i)).table.equals(((MetaInfo)metaInfoList.get((int)(i - 1))).table) && ((MetaInfo)metaInfoList.get((int)i)).fields.equals(((MetaInfo)metaInfoList.get((int)(i - 1))).fields)) continue;
                    sbTablesAndJoins = sbTablesAndJoins.append(" LEFT JOIN ").append(((MetaInfo)metaInfoList.get((int)i)).table).append(" ON ").append(((MetaInfo)metaInfoList.get((int)(i - 1))).table).append(".").append(((MetaInfo)metaInfoList.get((int)(i - 1))).fields).append("=").append(((MetaInfo)metaInfoList.get((int)i)).table).append(".").append(((MetaInfo)metaInfoList.get((int)i)).fields);
                }
                String sCom = "sp_executesql N'SET FMTONLY ON SELECT " + columns + " FROM " + Util.escapeSingleQuotes(sbTablesAndJoins.toString()) + " '";
                try (SQLServerStatement stmt = (SQLServerStatement)this.con.createStatement();
                     ResultSet rs = stmt.executeQuery(sCom);){
                    this.parseQueryMetaFor2008(rs);
                }
            }
            catch (SQLServerException e) {
                throw e;
            }
            catch (SQLException e) {
                SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.getMessage(), null, false);
            }
            catch (StringIndexOutOfBoundsException e) {
                SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.getMessage(), null, false);
            }
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean f = iface.isInstance(this);
        return f;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T t;
        try {
            t = iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        return t;
    }

    private Map<String, Object> getParameterInfo(int param) {
        if (this.stmtParent.bReturnValueSyntax && this.isTVP) {
            return this.procMetadata.get(param - 1);
        }
        return this.procMetadata.get(param);
    }

    private boolean isValidParamProc(int n) {
        return this.stmtParent.bReturnValueSyntax && this.isTVP && this.procMetadata.size() >= n || this.procMetadata.size() > n;
    }

    private boolean isValidParamQuery(int n) {
        return null != this.queryMetaMap && this.queryMetaMap.containsKey(n);
    }

    private void checkParam(int param) throws SQLServerException {
        if (null == this.procMetadata) {
            if (!this.isValidParamQuery(param)) {
                SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
            }
        } else if (!this.isValidParamProc(param)) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidParameterNumber"));
            Object[] msgArgs = new Object[]{param};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs), null, false);
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        try {
            if (null == this.procMetadata) {
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).parameterClassName;
            }
            return JDBCType.of(((Short)this.getParameterInfo(param).get("DATA_TYPE")).shortValue()).className();
        }
        catch (SQLServerException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.getMessage(), null, false);
            return null;
        }
    }

    @Override
    public int getParameterCount() throws SQLServerException {
        this.checkClosed();
        if (null == this.procMetadata) {
            return this.queryMetaMap.size();
        }
        return this.procMetadata.size() == 0 ? 0 : this.procMetadata.size() - 1;
    }

    @Override
    public int getParameterMode(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        if (null == this.procMetadata) {
            return 1;
        }
        int n = (Integer)this.getParameterInfo(param).get("COLUMN_TYPE");
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        int parameterType = 0;
        parameterType = null == this.procMetadata ? this.queryMetaMap.get((Object)Integer.valueOf((int)param)).parameterType : (int)((Short)this.getParameterInfo(param).get("DATA_TYPE")).shortValue();
        if (0 != parameterType) {
            switch (parameterType) {
                case -151: 
                case -150: {
                    parameterType = SSType.DATETIME2.getJDBCType().asJavaSqlType();
                    break;
                }
                case -148: 
                case -146: {
                    parameterType = SSType.DECIMAL.getJDBCType().asJavaSqlType();
                    break;
                }
                case -145: {
                    parameterType = SSType.CHAR.getJDBCType().asJavaSqlType();
                    break;
                }
            }
        }
        return parameterType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        if (null == this.procMetadata) {
            return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).parameterTypeName;
        }
        return this.getParameterInfo(param).get("TYPE_NAME").toString();
    }

    @Override
    public int getPrecision(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        if (null == this.procMetadata) {
            return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).precision;
        }
        return (Integer)this.getParameterInfo(param).get("PRECISION");
    }

    @Override
    public int getScale(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        if (null == this.procMetadata) {
            return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).scale;
        }
        return (Integer)this.getParameterInfo(param).get("SCALE");
    }

    @Override
    public int isNullable(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        if (this.procMetadata == null) {
            return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).isNullable;
        }
        return (Integer)this.getParameterInfo(param).get("NULLABLE");
    }

    @Override
    public boolean isSigned(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        try {
            if (null == this.procMetadata) {
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).isSigned;
            }
            return JDBCType.of(((Short)this.getParameterInfo(param).get("DATA_TYPE")).shortValue()).isSigned();
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.getMessage(), null, false);
            return false;
        }
    }

    String getTVPSchemaFromStoredProcedure(int param) throws SQLServerException {
        this.checkClosed();
        this.checkParam(param);
        return (String)this.getParameterInfo(param).get("SS_TYPE_SCHEMA_NAME");
    }

    private class MetaInfo {
        String table;
        String fields;

        MetaInfo(String table, String fields) {
            this.table = table;
            this.fields = fields;
        }
    }

    class QueryMeta {
        String parameterClassName = null;
        int parameterType = 0;
        String parameterTypeName = null;
        int precision = 0;
        int scale = 0;
        int isNullable = 2;
        boolean isSigned = false;

        QueryMeta() {
        }
    }
}

