/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.ISQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.ISQLServerDataRecord;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLServerStatementColumnEncryptionSetting;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.ThreePartName;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import microsoft.sql.DateTimeOffset;

public class SQLServerCallableStatement
extends SQLServerPreparedStatement
implements ISQLServerCallableStatement {
    private ArrayList<String> paramNames;
    int nOutParams = 0;
    int nOutParamsAssigned = 0;
    private int outParamIndex = -1;
    private Parameter lastParamAccessed;
    private Closeable activeStream;

    @Override
    String getClassNameInternal() {
        return "SQLServerCallableStatement";
    }

    SQLServerCallableStatement(SQLServerConnection connection, String sql, int nRSType, int nRSConcur, SQLServerStatementColumnEncryptionSetting stmtColEncSetting) throws SQLServerException {
        super(connection, sql, nRSType, nRSConcur, stmtColEncSetting);
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLServerException {
        Object[] msgArgs;
        MessageFormat form;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{index, sqlType});
        }
        this.checkClosed();
        if (index < 1 || index > this.inOutParam.length) {
            form = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            msgArgs = new Object[]{index};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "7009", false);
        }
        if (2012 == sqlType) {
            form = new MessageFormat(SQLServerException.getErrString("R_featureNotSupported"));
            msgArgs = new Object[]{"REF_CURSOR"};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
        }
        JDBCType jdbcType = JDBCType.of(sqlType);
        this.discardLastExecutionResults();
        if (jdbcType.isUnsupported()) {
            jdbcType = JDBCType.BINARY;
        }
        Parameter param = this.inOutParam[index - 1];
        assert (null != param);
        if (!param.isOutput()) {
            ++this.nOutParams;
        }
        param.registerForOutput(jdbcType, this.connection);
        switch (sqlType) {
            case -151: {
                param.setOutScale(3);
                break;
            }
            case -155: 
            case 92: 
            case 93: {
                param.setOutScale(7);
                break;
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    private Parameter getOutParameter(int i) throws SQLServerException {
        this.processResults();
        if (this.inOutParam[i - 1] == this.lastParamAccessed || this.inOutParam[i - 1].isValueGotten()) {
            return this.inOutParam[i - 1];
        }
        while (this.outParamIndex != i - 1) {
            this.skipOutParameters(1, false);
        }
        return this.inOutParam[i - 1];
    }

    @Override
    void startResults() {
        super.startResults();
        this.outParamIndex = -1;
        this.nOutParamsAssigned = 0;
        this.lastParamAccessed = null;
        assert (null == this.activeStream);
    }

    @Override
    void processBatch() throws SQLServerException {
        this.processResults();
        assert (this.nOutParams >= 0);
        if (this.nOutParams > 0) {
            this.processOutParameters();
            this.processBatchRemainder();
        }
    }

    final void processOutParameters() throws SQLServerException {
        assert (this.nOutParams > 0);
        assert (null != this.inOutParam);
        this.closeActiveStream();
        if (this.outParamIndex >= 0) {
            for (int index = 0; index < this.inOutParam.length; ++index) {
                if (index == this.outParamIndex || !this.inOutParam[index].isValueGotten()) continue;
                assert (this.inOutParam[index].isOutput());
                this.inOutParam[index].resetOutputValue();
            }
        }
        assert (this.nOutParamsAssigned <= this.nOutParams);
        if (this.nOutParamsAssigned < this.nOutParams) {
            this.skipOutParameters(this.nOutParams - this.nOutParamsAssigned, true);
        }
        if (this.outParamIndex >= 0) {
            this.inOutParam[this.outParamIndex].skipValue(this.resultsReader(), true);
            this.inOutParam[this.outParamIndex].resetOutputValue();
            this.outParamIndex = -1;
        }
    }

    private void processBatchRemainder() throws SQLServerException {
        final class ExecDoneHandler
        extends TDSTokenHandler {
            ExecDoneHandler() {
                super("ExecDoneHandler");
            }

            @Override
            boolean onDone(TDSReader tdsReader) throws SQLServerException {
                StreamDone doneToken = new StreamDone();
                doneToken.setFromTDS(tdsReader);
                if (doneToken.wasRPCInBatch()) {
                    SQLServerCallableStatement.this.startResults();
                    return false;
                }
                return true;
            }
        }
        ExecDoneHandler execDoneHandler = new ExecDoneHandler();
        TDSParser.parse(this.resultsReader(), execDoneHandler);
    }

    private void skipOutParameters(int numParamsToSkip, boolean discardValues) throws SQLServerException {
        final class OutParamHandler
        extends TDSTokenHandler {
            final StreamRetValue srv;
            private boolean foundParam;

            final boolean foundParam() {
                return this.foundParam;
            }

            OutParamHandler() {
                super("OutParamHandler");
                this.srv = new StreamRetValue();
            }

            final void reset() {
                this.foundParam = false;
            }

            @Override
            boolean onRetValue(TDSReader tdsReader) throws SQLServerException {
                this.srv.setFromTDS(tdsReader);
                this.foundParam = true;
                return false;
            }
        }
        OutParamHandler outParamHandler = new OutParamHandler();
        assert (numParamsToSkip <= this.nOutParams - this.nOutParamsAssigned);
        for (int paramsSkipped = 0; paramsSkipped < numParamsToSkip; ++paramsSkipped) {
            if (-1 != this.outParamIndex) {
                this.inOutParam[this.outParamIndex].skipValue(this.resultsReader(), discardValues);
                if (discardValues) {
                    this.inOutParam[this.outParamIndex].resetOutputValue();
                }
            }
            outParamHandler.reset();
            TDSParser.parse(this.resultsReader(), outParamHandler);
            if (!outParamHandler.foundParam()) {
                if (discardValues) break;
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] msgArgs = new Object[]{this.outParamIndex + 1};
                SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
            }
            this.outParamIndex = outParamHandler.srv.getOrdinalOrLength();
            this.outParamIndex -= this.outParamIndexAdjustment;
            if (this.outParamIndex < 0 || this.outParamIndex >= this.inOutParam.length || !this.inOutParam[this.outParamIndex].isOutput()) {
                this.getStatementLogger().info(this.toString() + " Unexpected outParamIndex: " + this.outParamIndex + "; adjustment: " + this.outParamIndexAdjustment);
                this.connection.throwInvalidTDS();
            }
            ++this.nOutParamsAssigned;
        }
    }

    @Override
    public void registerOutParameter(int index, int sqlType, String typeName) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{index, sqlType, typeName});
        }
        this.checkClosed();
        this.registerOutParameter(index, sqlType);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(int index, int sqlType, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{index, sqlType, scale});
        }
        this.checkClosed();
        this.registerOutParameter(index, sqlType);
        this.inOutParam[index - 1].setOutScale(scale);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(int index, int sqlType, int precision, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{index, sqlType, scale, precision});
        }
        this.checkClosed();
        this.registerOutParameter(index, sqlType);
        this.inOutParam[index - 1].setValueLength(precision);
        this.inOutParam[index - 1].setOutScale(scale);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    private Parameter getterGetParam(int index) throws SQLServerException {
        Object[] msgArgs;
        MessageFormat form;
        this.checkClosed();
        if (index < 1 || index > this.inOutParam.length) {
            form = new MessageFormat(SQLServerException.getErrString("R_invalidOutputParameter"));
            msgArgs = new Object[]{index};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "07009", false);
        }
        if (!this.inOutParam[index - 1].isOutput()) {
            form = new MessageFormat(SQLServerException.getErrString("R_outputParameterNotRegisteredForOutput"));
            msgArgs = new Object[]{index};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "07009", true);
        }
        if (!this.wasExecuted()) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), "07009", false);
        }
        this.resultsReader().getCommand().checkForInterrupt();
        this.closeActiveStream();
        if (this.getStatementLogger().isLoggable(Level.FINER)) {
            this.getStatementLogger().finer(this.toString() + " Getting Param:" + index);
        }
        this.lastParamAccessed = this.getOutParameter(index);
        return this.lastParamAccessed;
    }

    private Object getValue(int parameterIndex, JDBCType jdbcType) throws SQLServerException {
        return this.getterGetParam(parameterIndex).getValue(jdbcType, null, null, this.resultsReader());
    }

    private Object getValue(int parameterIndex, JDBCType jdbcType, Calendar cal) throws SQLServerException {
        return this.getterGetParam(parameterIndex).getValue(jdbcType, null, cal, this.resultsReader());
    }

    private Object getStream(int parameterIndex, StreamType streamType) throws SQLServerException {
        Object value = this.getterGetParam(parameterIndex).getValue(streamType.getJDBCType(), new InputStreamGetterArgs(streamType, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toString()), null, this.resultsReader());
        this.activeStream = (Closeable)value;
        return value;
    }

    private Object getSQLXMLInternal(int parameterIndex) throws SQLServerException {
        SQLServerSQLXML value = (SQLServerSQLXML)this.getterGetParam(parameterIndex).getValue(JDBCType.SQLXML, new InputStreamGetterArgs(StreamType.SQLXML, this.getIsResponseBufferingAdaptive(), this.getIsResponseBufferingAdaptive(), this.toString()), null, this.resultsReader());
        if (null != value) {
            this.activeStream = value.getStream();
        }
        return value;
    }

    @Override
    public int getInt(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getInt", index);
        this.checkClosed();
        Integer value = (Integer)this.getValue(index, JDBCType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "getInt", value);
        return null != value ? value : 0;
    }

    @Override
    public int getInt(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getInt", sCol);
        this.checkClosed();
        Integer value = (Integer)this.getValue(this.findColumn(sCol), JDBCType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "getInt", value);
        return null != value ? value : 0;
    }

    @Override
    public String getString(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getString", index);
        this.checkClosed();
        String value = null;
        Object objectValue = this.getValue(index, JDBCType.CHAR);
        if (null != objectValue) {
            value = objectValue.toString();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getString", value);
        return value;
    }

    @Override
    public String getString(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getString", sCol);
        this.checkClosed();
        String value = null;
        Object objectValue = this.getValue(this.findColumn(sCol), JDBCType.CHAR);
        if (null != objectValue) {
            value = objectValue.toString();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getString", value);
        return value;
    }

    @Override
    public final String getNString(int parameterIndex) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNString", parameterIndex);
        this.checkClosed();
        String value = (String)this.getValue(parameterIndex, JDBCType.NCHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getNString", value);
        return value;
    }

    @Override
    public final String getNString(String parameterName) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNString", parameterName);
        this.checkClosed();
        String value = (String)this.getValue(this.findColumn(parameterName), JDBCType.NCHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getNString", value);
        return value;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", new Object[]{parameterIndex, scale});
        }
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(parameterIndex, JDBCType.DECIMAL);
        if (null != value) {
            value = value.setScale(scale, 1);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", value);
        return value;
    }

    @Deprecated
    public BigDecimal getBigDecimal(String parameterName, int scale) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", new Object[]{parameterName, scale});
        }
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(this.findColumn(parameterName), JDBCType.DECIMAL);
        if (null != value) {
            value = value.setScale(scale, 1);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", value);
        return value;
    }

    @Override
    public boolean getBoolean(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBoolean", index);
        this.checkClosed();
        Boolean value = (Boolean)this.getValue(index, JDBCType.BIT);
        loggerExternal.exiting(this.getClassNameLogging(), "getBoolean", value);
        return null != value ? value : false;
    }

    @Override
    public boolean getBoolean(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBoolean", sCol);
        this.checkClosed();
        Boolean value = (Boolean)this.getValue(this.findColumn(sCol), JDBCType.BIT);
        loggerExternal.exiting(this.getClassNameLogging(), "getBoolean", value);
        return null != value ? value : false;
    }

    @Override
    public byte getByte(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getByte", index);
        this.checkClosed();
        Short shortValue = (Short)this.getValue(index, JDBCType.TINYINT);
        byte byteValue = null != shortValue ? shortValue.byteValue() : (byte)0;
        loggerExternal.exiting(this.getClassNameLogging(), "getByte", byteValue);
        return byteValue;
    }

    @Override
    public byte getByte(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getByte", sCol);
        this.checkClosed();
        Short shortValue = (Short)this.getValue(this.findColumn(sCol), JDBCType.TINYINT);
        byte byteValue = null != shortValue ? shortValue.byteValue() : (byte)0;
        loggerExternal.exiting(this.getClassNameLogging(), "getByte", byteValue);
        return byteValue;
    }

    @Override
    public byte[] getBytes(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBytes", index);
        this.checkClosed();
        byte[] value = (byte[])this.getValue(index, JDBCType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBytes", value);
        return value;
    }

    @Override
    public byte[] getBytes(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBytes", sCol);
        this.checkClosed();
        byte[] value = (byte[])this.getValue(this.findColumn(sCol), JDBCType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBytes", value);
        return value;
    }

    @Override
    public Date getDate(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDate", index);
        this.checkClosed();
        Date value = (Date)this.getValue(index, JDBCType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", value);
        return value;
    }

    @Override
    public Date getDate(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDate", sCol);
        this.checkClosed();
        Date value = (Date)this.getValue(this.findColumn(sCol), JDBCType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", value);
        return value;
    }

    @Override
    public Date getDate(int index, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDate", new Object[]{index, cal});
        }
        this.checkClosed();
        Date value = (Date)this.getValue(index, JDBCType.DATE, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", value);
        return value;
    }

    @Override
    public Date getDate(String sCol, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDate", new Object[]{sCol, cal});
        }
        this.checkClosed();
        Date value = (Date)this.getValue(this.findColumn(sCol), JDBCType.DATE, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", value);
        return value;
    }

    @Override
    public double getDouble(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDouble", index);
        this.checkClosed();
        Double value = (Double)this.getValue(index, JDBCType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDouble", value);
        return null != value ? value : 0.0;
    }

    @Override
    public double getDouble(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDouble", sCol);
        this.checkClosed();
        Double value = (Double)this.getValue(this.findColumn(sCol), JDBCType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDouble", value);
        return null != value ? value : 0.0;
    }

    @Override
    public float getFloat(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFloat", index);
        this.checkClosed();
        Float value = (Float)this.getValue(index, JDBCType.REAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", value);
        return null != value ? value.floatValue() : 0.0f;
    }

    @Override
    public float getFloat(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFloat", sCol);
        this.checkClosed();
        Float value = (Float)this.getValue(this.findColumn(sCol), JDBCType.REAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", value);
        return null != value ? value.floatValue() : 0.0f;
    }

    @Override
    public long getLong(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLong", index);
        this.checkClosed();
        Long value = (Long)this.getValue(index, JDBCType.BIGINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getLong", value);
        return null != value ? value : 0L;
    }

    @Override
    public long getLong(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLong", sCol);
        this.checkClosed();
        Long value = (Long)this.getValue(this.findColumn(sCol), JDBCType.BIGINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getLong", value);
        return null != value ? value : 0L;
    }

    @Override
    public Object getObject(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", index);
        this.checkClosed();
        Object value = this.getValue(index, this.getterGetParam(index).getJdbcTypeSetByUser() != null ? this.getterGetParam(index).getJdbcTypeSetByUser() : this.getterGetParam(index).getJdbcType());
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", value);
        return value;
    }

    @Override
    public <T> T getObject(int index, Class<T> type) throws SQLException {
        Object returnValue;
        loggerExternal.entering(this.getClassNameLogging(), "getObject", index);
        this.checkClosed();
        if (type == String.class) {
            returnValue = this.getString(index);
        } else if (type == Byte.class) {
            byte byteValue = this.getByte(index);
            returnValue = this.wasNull() ? null : Byte.valueOf(byteValue);
        } else if (type == Short.class) {
            short shortValue = this.getShort(index);
            returnValue = this.wasNull() ? null : Short.valueOf(shortValue);
        } else if (type == Integer.class) {
            int intValue = this.getInt(index);
            returnValue = this.wasNull() ? null : Integer.valueOf(intValue);
        } else if (type == Long.class) {
            long longValue = this.getLong(index);
            returnValue = this.wasNull() ? null : Long.valueOf(longValue);
        } else if (type == BigDecimal.class) {
            returnValue = this.getBigDecimal(index);
        } else if (type == Boolean.class) {
            boolean booleanValue = this.getBoolean(index);
            returnValue = this.wasNull() ? null : Boolean.valueOf(booleanValue);
        } else if (type == Date.class) {
            returnValue = this.getDate(index);
        } else if (type == Time.class) {
            returnValue = this.getTime(index);
        } else if (type == Timestamp.class) {
            returnValue = this.getTimestamp(index);
        } else if (type == DateTimeOffset.class) {
            returnValue = this.getDateTimeOffset(index);
        } else if (type == UUID.class) {
            byte[] guid = this.getBytes(index);
            returnValue = guid != null ? Util.readGUIDtoUUID(guid) : null;
        } else if (type == SQLXML.class) {
            returnValue = this.getSQLXML(index);
        } else if (type == Blob.class) {
            returnValue = this.getBlob(index);
        } else if (type == Clob.class) {
            returnValue = this.getClob(index);
        } else if (type == NClob.class) {
            returnValue = this.getNClob(index);
        } else if (type == byte[].class) {
            returnValue = this.getBytes(index);
        } else if (type == Float.class) {
            float floatValue = this.getFloat(index);
            returnValue = this.wasNull() ? null : Float.valueOf(floatValue);
        } else if (type == Double.class) {
            double doubleValue = this.getDouble(index);
            returnValue = this.wasNull() ? null : Double.valueOf(doubleValue);
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionTo"));
            Object[] msgArgs = new Object[]{type};
            throw new SQLServerException(form.format(msgArgs), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", index);
        return type.cast(returnValue);
    }

    @Override
    public Object getObject(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", sCol);
        this.checkClosed();
        int parameterIndex = this.findColumn(sCol);
        Object value = this.getValue(parameterIndex, this.getterGetParam(parameterIndex).getJdbcTypeSetByUser() != null ? this.getterGetParam(parameterIndex).getJdbcTypeSetByUser() : this.getterGetParam(parameterIndex).getJdbcType());
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", value);
        return value;
    }

    @Override
    public <T> T getObject(String sCol, Class<T> type) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", sCol);
        this.checkClosed();
        int parameterIndex = this.findColumn(sCol);
        T value = this.getObject(parameterIndex, type);
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", value);
        return value;
    }

    @Override
    public short getShort(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getShort", index);
        this.checkClosed();
        Short value = (Short)this.getValue(index, JDBCType.SMALLINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getShort", value);
        return null != value ? value : (short)0;
    }

    @Override
    public short getShort(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getShort", sCol);
        this.checkClosed();
        Short value = (Short)this.getValue(this.findColumn(sCol), JDBCType.SMALLINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getShort", value);
        return null != value ? value : (short)0;
    }

    @Override
    public Time getTime(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTime", index);
        this.checkClosed();
        Time value = (Time)this.getValue(index, JDBCType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", value);
        return value;
    }

    @Override
    public Time getTime(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTime", sCol);
        this.checkClosed();
        Time value = (Time)this.getValue(this.findColumn(sCol), JDBCType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", value);
        return value;
    }

    @Override
    public Time getTime(int index, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTime", new Object[]{index, cal});
        }
        this.checkClosed();
        Time value = (Time)this.getValue(index, JDBCType.TIME, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", value);
        return value;
    }

    @Override
    public Time getTime(String sCol, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTime", new Object[]{sCol, cal});
        }
        this.checkClosed();
        Time value = (Time)this.getValue(this.findColumn(sCol), JDBCType.TIME, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", value);
        return value;
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", index);
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(index, JDBCType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", value);
        return value;
    }

    @Override
    public Timestamp getTimestamp(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", sCol);
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(this.findColumn(sCol), JDBCType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", value);
        return value;
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", new Object[]{index, cal});
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(index, JDBCType.TIMESTAMP, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", value);
        return value;
    }

    @Override
    public Timestamp getTimestamp(String name, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", new Object[]{name, cal});
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(this.findColumn(name), JDBCType.TIMESTAMP, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", value);
        return value;
    }

    public Timestamp getDateTime(int index) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDateTime", index);
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(index, JDBCType.DATETIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTime", value);
        return value;
    }

    public Timestamp getDateTime(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDateTime", sCol);
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(this.findColumn(sCol), JDBCType.DATETIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTime", value);
        return value;
    }

    public Timestamp getDateTime(int index, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDateTime", new Object[]{index, cal});
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(index, JDBCType.DATETIME, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTime", value);
        return value;
    }

    public Timestamp getDateTime(String name, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDateTime", new Object[]{name, cal});
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(this.findColumn(name), JDBCType.DATETIME, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTime", value);
        return value;
    }

    public Timestamp getSmallDateTime(int index) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getSmallDateTime", index);
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(index, JDBCType.SMALLDATETIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getSmallDateTime", value);
        return value;
    }

    public Timestamp getSmallDateTime(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getSmallDateTime", sCol);
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(this.findColumn(sCol), JDBCType.SMALLDATETIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getSmallDateTime", value);
        return value;
    }

    public Timestamp getSmallDateTime(int index, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getSmallDateTime", new Object[]{index, cal});
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(index, JDBCType.SMALLDATETIME, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getSmallDateTime", value);
        return value;
    }

    public Timestamp getSmallDateTime(String name, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getSmallDateTime", new Object[]{name, cal});
        }
        this.checkClosed();
        Timestamp value = (Timestamp)this.getValue(this.findColumn(name), JDBCType.SMALLDATETIME, cal);
        loggerExternal.exiting(this.getClassNameLogging(), "getSmallDateTime", value);
        return value;
    }

    @Override
    public DateTimeOffset getDateTimeOffset(int index) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDateTimeOffset", index);
        }
        this.checkClosed();
        if (!this.connection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        DateTimeOffset value = (DateTimeOffset)this.getValue(index, JDBCType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTimeOffset", value);
        return value;
    }

    @Override
    public DateTimeOffset getDateTimeOffset(String sCol) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getDateTimeOffset", sCol);
        this.checkClosed();
        if (!this.connection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        DateTimeOffset value = (DateTimeOffset)this.getValue(this.findColumn(sCol), JDBCType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTimeOffset", value);
        return value;
    }

    @Override
    public boolean wasNull() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "wasNull");
        this.checkClosed();
        boolean bWasNull = false;
        if (null != this.lastParamAccessed) {
            bWasNull = this.lastParamAccessed.isNull();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "wasNull", bWasNull);
        return bWasNull;
    }

    public final InputStream getAsciiStream(int paramIndex) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getAsciiStream", paramIndex);
        this.checkClosed();
        InputStream value = (InputStream)this.getStream(paramIndex, StreamType.ASCII);
        loggerExternal.exiting(this.getClassNameLogging(), "getAsciiStream", value);
        return value;
    }

    public final InputStream getAsciiStream(String paramName) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getAsciiStream", paramName);
        this.checkClosed();
        InputStream value = (InputStream)this.getStream(this.findColumn(paramName), StreamType.ASCII);
        loggerExternal.exiting(this.getClassNameLogging(), "getAsciiStream", value);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", index);
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(index, JDBCType.DECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", value);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", sCol);
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(this.findColumn(sCol), JDBCType.DECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", value);
        return value;
    }

    public BigDecimal getMoney(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMoney", index);
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(index, JDBCType.MONEY);
        loggerExternal.exiting(this.getClassNameLogging(), "getMoney", value);
        return value;
    }

    public BigDecimal getMoney(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMoney", sCol);
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(this.findColumn(sCol), JDBCType.MONEY);
        loggerExternal.exiting(this.getClassNameLogging(), "getMoney", value);
        return value;
    }

    public BigDecimal getSmallMoney(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getSmallMoney", index);
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(index, JDBCType.SMALLMONEY);
        loggerExternal.exiting(this.getClassNameLogging(), "getSmallMoney", value);
        return value;
    }

    public BigDecimal getSmallMoney(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getSmallMoney", sCol);
        this.checkClosed();
        BigDecimal value = (BigDecimal)this.getValue(this.findColumn(sCol), JDBCType.SMALLMONEY);
        loggerExternal.exiting(this.getClassNameLogging(), "getSmallMoney", value);
        return value;
    }

    public final InputStream getBinaryStream(int paramIndex) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBinaryStream", paramIndex);
        this.checkClosed();
        InputStream value = (InputStream)this.getStream(paramIndex, StreamType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBinaryStream", value);
        return value;
    }

    public final InputStream getBinaryStream(String paramName) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBinaryStream", paramName);
        this.checkClosed();
        InputStream value = (InputStream)this.getStream(this.findColumn(paramName), StreamType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBinaryStream", value);
        return value;
    }

    @Override
    public Blob getBlob(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBlob", index);
        this.checkClosed();
        Blob value = (Blob)this.getValue(index, JDBCType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getBlob", value);
        return value;
    }

    @Override
    public Blob getBlob(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBlob", sCol);
        this.checkClosed();
        Blob value = (Blob)this.getValue(this.findColumn(sCol), JDBCType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getBlob", value);
        return value;
    }

    @Override
    public final Reader getCharacterStream(int paramIndex) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCharacterStream", paramIndex);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(paramIndex, StreamType.CHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getCharacterStream", reader);
        return reader;
    }

    @Override
    public final Reader getCharacterStream(String parameterName) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getCharacterStream", parameterName);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(this.findColumn(parameterName), StreamType.CHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getCharacterSream", reader);
        return reader;
    }

    @Override
    public final Reader getNCharacterStream(int parameterIndex) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNCharacterStream", parameterIndex);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(parameterIndex, StreamType.NCHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getNCharacterStream", reader);
        return reader;
    }

    @Override
    public final Reader getNCharacterStream(String parameterName) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNCharacterStream", parameterName);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(this.findColumn(parameterName), StreamType.NCHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getNCharacterStream", reader);
        return reader;
    }

    void closeActiveStream() throws SQLServerException {
        if (null != this.activeStream) {
            try {
                this.activeStream.close();
            }
            catch (IOException e) {
                SQLServerException.makeFromDriverError(null, null, e.getMessage(), null, true);
            }
            finally {
                this.activeStream = null;
            }
        }
    }

    @Override
    public Clob getClob(int index) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getClob", index);
        this.checkClosed();
        Clob clob = (Clob)this.getValue(index, JDBCType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getClob", clob);
        return clob;
    }

    @Override
    public Clob getClob(String sCol) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getClob", sCol);
        this.checkClosed();
        Clob clob = (Clob)this.getValue(this.findColumn(sCol), JDBCType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getClob", clob);
        return clob;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNClob", parameterIndex);
        this.checkClosed();
        NClob nClob = (NClob)this.getValue(parameterIndex, JDBCType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getNClob", nClob);
        return nClob;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNClob", parameterName);
        this.checkClosed();
        NClob nClob = (NClob)this.getValue(this.findColumn(parameterName), JDBCType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getNClob", nClob);
        return nClob;
    }

    @Override
    public Object getObject(int index, Map<String, Class<?>> map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Object getObject(String sCol, Map<String, Class<?>> m) throws SQLServerException {
        this.checkClosed();
        return this.getObject(this.findColumn(sCol), m);
    }

    @Override
    public Ref getRef(int i) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Ref getRef(String sCol) throws SQLServerException {
        this.checkClosed();
        return this.getRef(this.findColumn(sCol));
    }

    @Override
    public Array getArray(int i) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Array getArray(String sCol) throws SQLServerException {
        this.checkClosed();
        return this.getArray(this.findColumn(sCol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findColumn(String columnName) throws SQLServerException {
        String sParam;
        int i;
        if (this.paramNames == null) {
            SQLServerStatement s = null;
            try {
                s = (SQLServerStatement)this.connection.createStatement();
                ThreePartName threePartName = ThreePartName.parse(this.procedureName);
                StringBuilder metaQuery = new StringBuilder("exec sp_sproc_columns ");
                if (null != threePartName.getDatabasePart()) {
                    metaQuery.append("@procedure_qualifier=");
                    metaQuery.append(threePartName.getDatabasePart());
                    metaQuery.append(", ");
                }
                if (null != threePartName.getOwnerPart()) {
                    metaQuery.append("@procedure_owner=");
                    metaQuery.append(threePartName.getOwnerPart());
                    metaQuery.append(", ");
                }
                if (null != threePartName.getProcedurePart()) {
                    metaQuery.append("@procedure_name=");
                    metaQuery.append(threePartName.getProcedurePart());
                    metaQuery.append(" , @ODBCVer=3");
                } else {
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
                    Object[] msgArgs = new Object[]{columnName, ""};
                    SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "07009", false);
                }
                SQLServerResultSet rs = s.executeQueryInternal(metaQuery.toString());
                this.paramNames = new ArrayList();
                while (rs.next()) {
                    String sCol = rs.getString(4);
                    this.paramNames.add(sCol.trim());
                }
            }
            catch (SQLException e) {
                SQLServerException.makeFromDriverError(this.connection, this, e.toString(), null, false);
            }
            finally {
                if (null != s) {
                    s.close();
                }
            }
        }
        int l = 0;
        if (this.paramNames != null) {
            l = this.paramNames.size();
        }
        if (l == 0) {
            return 1;
        }
        String columnNameWithoutAtSign = null;
        columnNameWithoutAtSign = columnName.startsWith("@") ? columnName.substring(1, columnName.length()) : columnName;
        int matchPos = -1;
        for (i = 0; i < l; ++i) {
            sParam = this.paramNames.get(i);
            if (!(sParam = sParam.substring(1, sParam.length())).equals(columnNameWithoutAtSign)) continue;
            matchPos = i;
            break;
        }
        if (-1 == matchPos) {
            for (i = 0; i < l; ++i) {
                sParam = this.paramNames.get(i);
                if (!(sParam = sParam.substring(1, sParam.length())).equalsIgnoreCase(columnNameWithoutAtSign)) continue;
                matchPos = i;
                break;
            }
        }
        if (-1 == matchPos) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
            Object[] msgArgs = new Object[]{columnName, this.procedureName};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "07009", false);
        }
        if (this.bReturnValueSyntax) {
            return matchPos + 1;
        }
        return matchPos;
    }

    @Override
    public void setTimestamp(String sCol, Timestamp x, Calendar c) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimeStamp", new Object[]{sCol, x, c});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIMESTAMP, x, JavaType.TIMESTAMP, c, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimeStamp");
    }

    public void setTimestamp(String sCol, Timestamp x, Calendar c, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimeStamp", new Object[]{sCol, x, c, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIMESTAMP, x, JavaType.TIMESTAMP, c, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimeStamp");
    }

    @Override
    public void setTime(String sCol, Time x, Calendar c) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{sCol, x, c});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIME, x, JavaType.TIME, c, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public void setTime(String sCol, Time x, Calendar c, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{sCol, x, c, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIME, x, JavaType.TIME, c, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public void setDate(String sCol, Date x, Calendar c) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{sCol, x, c});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATE, x, JavaType.DATE, c, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    public void setDate(String sCol, Date x, Calendar c, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{sCol, x, c, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATE, x, JavaType.DATE, c, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{parameterName, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader value, int length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{parameterName, value, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.CHARACTER, value, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{parameterName, reader, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.CHARACTER, reader, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{parameterName, value});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.NCHARACTER, value, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{parameterName, value, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.NCHARACTER, value, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setClob(String parameterName, Clob x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{parameterName, x});
        }
        this.checkClosed();
        this.setValue(this.findColumn(parameterName), JDBCType.CLOB, (Object)x, JavaType.CLOB, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(String parameterName, Reader reader) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{parameterName, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(String parameterName, Reader value, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{parameterName, value, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.CHARACTER, value, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setNClob(String parameterName, NClob value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{parameterName, value});
        }
        this.checkClosed();
        this.setValue(this.findColumn(parameterName), JDBCType.NCLOB, (Object)value, JavaType.NCLOB, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(String parameterName, Reader reader) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{parameterName, reader});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{parameterName, reader, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.NCHARACTER, reader, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNString(String parameterName, String value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNString", new Object[]{parameterName, value});
        }
        this.checkClosed();
        this.setValue(this.findColumn(parameterName), JDBCType.NVARCHAR, (Object)value, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setNString");
    }

    public final void setNString(String parameterName, String value, boolean forceEncrypt) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNString", new Object[]{parameterName, value, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(parameterName), JDBCType.NVARCHAR, (Object)value, JavaType.STRING, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setNString");
    }

    @Override
    public void setObject(String sCol, Object o) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{sCol, o});
        }
        this.checkClosed();
        this.setObjectNoType(this.findColumn(sCol), o, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public void setObject(String sCol, Object o, int n) throws SQLServerException {
        String tvpName = null;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{sCol, o, n});
        }
        this.checkClosed();
        if (-153 == n) {
            tvpName = this.getTVPNameIfNull(this.findColumn(sCol), null);
            this.setObject(this.setterGetParam(this.findColumn(sCol)), o, JavaType.TVP, JDBCType.TVP, null, null, false, this.findColumn(sCol), tvpName);
        } else {
            this.setObject(this.setterGetParam(this.findColumn(sCol)), o, JavaType.of(o), JDBCType.of(n), null, null, false, this.findColumn(sCol), tvpName);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public void setObject(String sCol, Object o, int n, int m) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{sCol, o, n, m});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(sCol)), o, JavaType.of(o), JDBCType.of(n), m, null, false, this.findColumn(sCol), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    public void setObject(String sCol, Object o, int n, int m, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{sCol, o, n, m, forceEncrypt});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(sCol)), o, JavaType.of(o), JDBCType.of(n), 2 == n || 3 == n ? Integer.valueOf(m) : null, null, forceEncrypt, this.findColumn(sCol), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    public final void setObject(String sCol, Object x, int targetSqlType, Integer precision, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{sCol, x, targetSqlType, precision, scale});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(sCol)), x, JavaType.of(x), JDBCType.of(targetSqlType), 2 == targetSqlType || 3 == targetSqlType || InputStream.class.isInstance(x) || Reader.class.isInstance(x) ? Integer.valueOf(scale) : null, precision, false, this.findColumn(sCol), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{parameterName, x});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.ASCII, x, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream value, int length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{parameterName, value, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.ASCII, value, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{parameterName, x, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.ASCII, x, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{parameterName, x});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.BINARY, x, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream value, int length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{parameterName, value, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.BINARY, value, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{parameterName, x, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.BINARY, x, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBlob(String parameterName, Blob inputStream) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{parameterName, inputStream});
        }
        this.checkClosed();
        this.setValue(this.findColumn(parameterName), JDBCType.BLOB, (Object)inputStream, JavaType.BLOB, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(String parameterName, InputStream value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{parameterName, value});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.BINARY, value, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{parameterName, inputStream, length});
        }
        this.checkClosed();
        this.setStream(this.findColumn(parameterName), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public void setTimestamp(String sCol, Timestamp t) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{sCol, t});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIMESTAMP, (Object)t, JavaType.TIMESTAMP, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    public void setTimestamp(String sCol, Timestamp t, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{sCol, t});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIMESTAMP, t, JavaType.TIMESTAMP, null, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    public void setTimestamp(String sCol, Timestamp t, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{sCol, t, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIMESTAMP, t, JavaType.TIMESTAMP, null, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    @Override
    public void setDateTimeOffset(String sCol, DateTimeOffset t) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{sCol, t});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATETIMEOFFSET, (Object)t, JavaType.DATETIMEOFFSET, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    public void setDateTimeOffset(String sCol, DateTimeOffset t, int scale) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{sCol, t});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATETIMEOFFSET, t, JavaType.DATETIMEOFFSET, null, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    public void setDateTimeOffset(String sCol, DateTimeOffset t, int scale, boolean forceEncrypt) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{sCol, t, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATETIMEOFFSET, t, JavaType.DATETIMEOFFSET, null, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    @Override
    public void setDate(String sCol, Date d) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{sCol, d});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATE, (Object)d, JavaType.DATE, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    public void setTime(String sCol, Time t) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{sCol, t});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIME, (Object)t, JavaType.TIME, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public void setTime(String sCol, Time t, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{sCol, t});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIME, t, JavaType.TIME, null, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public void setTime(String sCol, Time t, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{sCol, t, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TIME, t, JavaType.TIME, null, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public void setDateTime(String sCol, Timestamp x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTime", new Object[]{sCol, x});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATETIME, (Object)x, JavaType.TIMESTAMP, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTime");
    }

    public void setDateTime(String sCol, Timestamp x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTime", new Object[]{sCol, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DATETIME, (Object)x, JavaType.TIMESTAMP, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTime");
    }

    public void setSmallDateTime(String sCol, Timestamp x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallDateTime", new Object[]{sCol, x});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.SMALLDATETIME, (Object)x, JavaType.TIMESTAMP, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallDateTime");
    }

    public void setSmallDateTime(String sCol, Timestamp x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallDateTime", new Object[]{sCol, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.SMALLDATETIME, (Object)x, JavaType.TIMESTAMP, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallDateTime");
    }

    public void setUniqueIdentifier(String sCol, String guid) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setUniqueIdentifier", new Object[]{sCol, guid});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.GUID, (Object)guid, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setUniqueIdentifier");
    }

    public void setUniqueIdentifier(String sCol, String guid, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setUniqueIdentifier", new Object[]{sCol, guid, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.GUID, (Object)guid, JavaType.STRING, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setUniqueIdentifier");
    }

    @Override
    public void setBytes(String sCol, byte[] b) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBytes", new Object[]{sCol, b});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.BINARY, (Object)b, JavaType.BYTEARRAY, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBytes");
    }

    public void setBytes(String sCol, byte[] b, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBytes", new Object[]{sCol, b, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.BINARY, (Object)b, JavaType.BYTEARRAY, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setBytes");
    }

    @Override
    public void setByte(String sCol, byte b) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setByte", new Object[]{sCol, b});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TINYINT, (Object)b, JavaType.BYTE, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setByte");
    }

    public void setByte(String sCol, byte b, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setByte", new Object[]{sCol, b, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TINYINT, (Object)b, JavaType.BYTE, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setByte");
    }

    @Override
    public void setString(String sCol, String s) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setString", new Object[]{sCol, s});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.VARCHAR, (Object)s, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setString");
    }

    public void setString(String sCol, String s, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setString", new Object[]{sCol, s, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.VARCHAR, (Object)s, JavaType.STRING, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setString");
    }

    public void setMoney(String sCol, BigDecimal bd) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setMoney", new Object[]{sCol, bd});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.MONEY, (Object)bd, JavaType.BIGDECIMAL, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setMoney");
    }

    public void setMoney(String sCol, BigDecimal bd, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setMoney", new Object[]{sCol, bd, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.MONEY, (Object)bd, JavaType.BIGDECIMAL, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setMoney");
    }

    public void setSmallMoney(String sCol, BigDecimal bd) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallMoney", new Object[]{sCol, bd});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.SMALLMONEY, (Object)bd, JavaType.BIGDECIMAL, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallMoney");
    }

    public void setSmallMoney(String sCol, BigDecimal bd, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallMoney", new Object[]{sCol, bd, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.SMALLMONEY, (Object)bd, JavaType.BIGDECIMAL, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallMoney");
    }

    @Override
    public void setBigDecimal(String sCol, BigDecimal bd) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{sCol, bd});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DECIMAL, (Object)bd, JavaType.BIGDECIMAL, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    public void setBigDecimal(String sCol, BigDecimal bd, int precision, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{sCol, bd, precision, scale});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DECIMAL, bd, JavaType.BIGDECIMAL, precision, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    public void setBigDecimal(String sCol, BigDecimal bd, int precision, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{sCol, bd, precision, scale, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DECIMAL, bd, JavaType.BIGDECIMAL, precision, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    @Override
    public void setDouble(String sCol, double d) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDouble", new Object[]{sCol, d});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DOUBLE, (Object)d, JavaType.DOUBLE, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDouble");
    }

    public void setDouble(String sCol, double d, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDouble", new Object[]{sCol, d, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.DOUBLE, (Object)d, JavaType.DOUBLE, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDouble");
    }

    @Override
    public void setFloat(String sCol, float f) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFloat", new Object[]{sCol, Float.valueOf(f)});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.REAL, (Object)Float.valueOf(f), JavaType.FLOAT, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setFloat");
    }

    public void setFloat(String sCol, float f, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFloat", new Object[]{sCol, Float.valueOf(f), forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.REAL, (Object)Float.valueOf(f), JavaType.FLOAT, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setFloat");
    }

    @Override
    public void setInt(String sCol, int i) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setInt", new Object[]{sCol, i});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.INTEGER, (Object)i, JavaType.INTEGER, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setInt");
    }

    public void setInt(String sCol, int i, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setInt", new Object[]{sCol, i, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.INTEGER, (Object)i, JavaType.INTEGER, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setInt");
    }

    @Override
    public void setLong(String sCol, long l) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLong", new Object[]{sCol, l});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.BIGINT, (Object)l, JavaType.LONG, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setLong");
    }

    public void setLong(String sCol, long l, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLong", new Object[]{sCol, l, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.BIGINT, (Object)l, JavaType.LONG, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setLong");
    }

    @Override
    public void setShort(String sCol, short s) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setShort", new Object[]{sCol, s});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.SMALLINT, (Object)s, JavaType.SHORT, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setShort");
    }

    public void setShort(String sCol, short s, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setShort", new Object[]{sCol, s, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.SMALLINT, (Object)s, JavaType.SHORT, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setShort");
    }

    @Override
    public void setBoolean(String sCol, boolean b) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBoolean", new Object[]{sCol, b});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.BIT, (Object)b, JavaType.BOOLEAN, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBoolean");
    }

    public void setBoolean(String sCol, boolean b, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBoolean", new Object[]{sCol, b, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.BIT, (Object)b, JavaType.BOOLEAN, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setBoolean");
    }

    @Override
    public void setNull(String sCol, int nType) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{sCol, nType});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(sCol)), null, JavaType.OBJECT, JDBCType.of(nType), null, null, false, this.findColumn(sCol), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    @Override
    public void setNull(String sCol, int nType, String sTypeName) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{sCol, nType, sTypeName});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(this.findColumn(sCol)), null, JavaType.OBJECT, JDBCType.of(nType), null, null, false, this.findColumn(sCol), sTypeName);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    @Override
    public void setURL(String sCol, URL u) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setURL", sCol);
        this.checkClosed();
        this.setURL(this.findColumn(sCol), u);
        loggerExternal.exiting(this.getClassNameLogging(), "setURL");
    }

    public final void setStructured(String sCol, String tvpName, SQLServerDataTable tvpDataTable) throws SQLServerException {
        tvpName = this.getTVPNameIfNull(this.findColumn(sCol), tvpName);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setStructured", new Object[]{sCol, tvpName, tvpDataTable});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TVP, (Object)tvpDataTable, JavaType.TVP, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setStructured");
    }

    public final void setStructured(String sCol, String tvpName, ResultSet tvpResultSet) throws SQLServerException {
        tvpName = this.getTVPNameIfNull(this.findColumn(sCol), tvpName);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setStructured", new Object[]{sCol, tvpName, tvpResultSet});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TVP, (Object)tvpResultSet, JavaType.TVP, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setStructured");
    }

    public final void setStructured(String sCol, String tvpName, ISQLServerDataRecord tvpDataRecord) throws SQLServerException {
        tvpName = this.getTVPNameIfNull(this.findColumn(sCol), tvpName);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setStructured", new Object[]{sCol, tvpName, tvpDataRecord});
        }
        this.checkClosed();
        this.setValue(this.findColumn(sCol), JDBCType.TVP, (Object)tvpDataRecord, JavaType.TVP, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setStructured");
    }

    @Override
    public URL getURL(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public URL getURL(String s) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public final void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSQLXML", new Object[]{parameterName, xmlObject});
        }
        this.checkClosed();
        this.setSQLXMLInternal(this.findColumn(parameterName), xmlObject);
        loggerExternal.exiting(this.getClassNameLogging(), "setSQLXML");
    }

    @Override
    public final SQLXML getSQLXML(int parameterIndex) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getSQLXML", parameterIndex);
        this.checkClosed();
        SQLServerSQLXML value = (SQLServerSQLXML)this.getSQLXMLInternal(parameterIndex);
        loggerExternal.exiting(this.getClassNameLogging(), "getSQLXML", value);
        return value;
    }

    @Override
    public final SQLXML getSQLXML(String parameterName) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getSQLXML", parameterName);
        this.checkClosed();
        SQLServerSQLXML value = (SQLServerSQLXML)this.getSQLXMLInternal(this.findColumn(parameterName));
        loggerExternal.exiting(this.getClassNameLogging(), "getSQLXML", value);
        return value;
    }

    @Override
    public final void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final RowId getRowId(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final RowId getRowId(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void registerOutParameter(String s, int n, String s1) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{s, n, s1});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(s), n, s1);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{parameterName, sqlType, scale});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(parameterName), sqlType, scale);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    public void registerOutParameter(String parameterName, int sqlType, int precision, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{parameterName, sqlType, scale});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(parameterName), sqlType, precision, scale);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String s, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "registerOutParameter", new Object[]{s, n});
        }
        this.checkClosed();
        this.registerOutParameter(this.findColumn(s), n);
        loggerExternal.exiting(this.getClassNameLogging(), "registerOutParameter");
    }
}

