/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityCorrelator;
import com.microsoft.sqlserver.jdbc.CekTableEntry;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DescribeParameterEncryptionResultSet1;
import com.microsoft.sqlserver.jdbc.DescribeParameterEncryptionResultSet2;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.Geography;
import com.microsoft.sqlserver.jdbc.Geometry;
import com.microsoft.sqlserver.jdbc.ISQLServerDataRecord;
import com.microsoft.sqlserver.jdbc.ISQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParsedSQLCacheItem;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLServerStatementColumnEncryptionSetting;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import microsoft.sql.DateTimeOffset;

public class SQLServerPreparedStatement
extends SQLServerStatement
implements ISQLServerPreparedStatement {
    boolean isInternalEncryptionQuery = false;
    private static final int BATCH_STATEMENT_DELIMITER_TDS_71 = 128;
    private static final int BATCH_STATEMENT_DELIMITER_TDS_72 = 255;
    final int nBatchStatementDelimiter = 255;
    private String preparedTypeDefinitions;
    final String userSQL;
    private String preparedSQL;
    private boolean isExecutedAtLeastOnce = false;
    private SQLServerConnection.PreparedStatementHandle cachedPreparedStatementHandle;
    private SQLServerConnection.Sha1HashKey sqlTextCacheKey;
    private ArrayList<String> parameterNames;
    final boolean bReturnValueSyntax;
    int outParamIndexAdjustment;
    ArrayList<Parameter[]> batchParamValues;
    private int prepStmtHandle = 0;
    String handleDBName = null;
    private SQLServerStatement internalStmt = null;
    private boolean expectPrepStmtHandle = false;
    private boolean encryptionMetadataIsRetrieved = false;

    private void setPreparedStatementHandle(int handle) {
        this.prepStmtHandle = handle;
    }

    public int getPreparedStatementHandle() throws SQLServerException {
        this.checkClosed();
        return this.prepStmtHandle;
    }

    private boolean hasPreparedStatementHandle() {
        return 0 < this.prepStmtHandle;
    }

    private void resetPrepStmtHandle() {
        this.prepStmtHandle = 0;
    }

    @Override
    String getClassNameInternal() {
        return "SQLServerPreparedStatement";
    }

    SQLServerPreparedStatement(SQLServerConnection conn, String sql, int nRSType, int nRSConcur, SQLServerStatementColumnEncryptionSetting stmtColEncSetting) throws SQLServerException {
        super(conn, nRSType, nRSConcur, stmtColEncSetting);
        if (null == sql) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_NullValue"));
            Object[] msgArgs1 = new Object[]{"Statement SQL"};
            throw new SQLServerException(form.format(msgArgs1), null);
        }
        this.stmtPoolable = true;
        this.sqlTextCacheKey = new SQLServerConnection.Sha1HashKey(sql);
        ParsedSQLCacheItem parsedSQL = SQLServerConnection.getCachedParsedSQL(this.sqlTextCacheKey);
        if (null != parsedSQL) {
            if (null != this.connection && this.connection.isStatementPoolingEnabled()) {
                this.isExecutedAtLeastOnce = true;
            }
        } else {
            parsedSQL = SQLServerConnection.parseAndCacheSQL(this.sqlTextCacheKey, sql);
        }
        this.procedureName = parsedSQL.procedureName;
        this.bReturnValueSyntax = parsedSQL.bReturnValueSyntax;
        this.userSQL = parsedSQL.processedSQL;
        this.initParams(parsedSQL.parameterCount);
    }

    private void closePreparedHandle() {
        if (!this.hasPreparedStatementHandle()) {
            return;
        }
        if (this.connection.isSessionUnAvailable()) {
            if (loggerExternal.isLoggable(Level.FINER)) {
                loggerExternal.finer(this + ": Not closing PreparedHandle:" + this.prepStmtHandle + "; connection is already closed.");
            }
        } else {
            this.isExecutedAtLeastOnce = false;
            final int handleToClose = this.prepStmtHandle;
            this.resetPrepStmtHandle();
            if (null != this.cachedPreparedStatementHandle) {
                this.connection.returnCachedPreparedStatementHandle(this.cachedPreparedStatementHandle);
            } else if (this.connection.isPreparedStatementUnprepareBatchingEnabled()) {
                SQLServerConnection sQLServerConnection = this.connection;
                Objects.requireNonNull(sQLServerConnection);
                this.connection.enqueueUnprepareStatementHandle(sQLServerConnection.new SQLServerConnection.PreparedStatementHandle(null, handleToClose, this.executedSqlDirectly, true));
            } else {
                block12: {
                    if (loggerExternal.isLoggable(Level.FINER)) {
                        loggerExternal.finer(this + ": Closing PreparedHandle:" + handleToClose);
                    }
                    try {
                        final class PreparedHandleClose
                        extends UninterruptableTDSCommand {
                            PreparedHandleClose() {
                                super("closePreparedHandle");
                            }

                            @Override
                            final boolean doExecute() throws SQLServerException {
                                TDSWriter tdsWriter = this.startRequest((byte)3);
                                tdsWriter.writeShort((short)-1);
                                tdsWriter.writeShort(SQLServerPreparedStatement.this.executedSqlDirectly ? (short)15 : 6);
                                tdsWriter.writeByte((byte)0);
                                tdsWriter.writeByte((byte)0);
                                tdsWriter.writeRPCInt(null, handleToClose, false);
                                TDSParser.parse(this.startResponse(), this.getLogContext());
                                return true;
                            }
                        }
                        this.executeCommand(new PreparedHandleClose());
                    }
                    catch (SQLServerException e) {
                        if (!loggerExternal.isLoggable(Level.FINER)) break block12;
                        loggerExternal.log(Level.FINER, this + ": Error (ignored) closing PreparedHandle:" + handleToClose, e);
                    }
                }
                if (loggerExternal.isLoggable(Level.FINER)) {
                    loggerExternal.finer(this + ": Closed PreparedHandle:" + handleToClose);
                }
            }
            this.connection.unprepareUnreferencedPreparedStatementHandles(false);
        }
    }

    @Override
    final void closeInternal() {
        super.closeInternal();
        this.closePreparedHandle();
        try {
            if (null != this.internalStmt) {
                this.internalStmt.close();
            }
        }
        catch (SQLServerException e) {
            if (loggerExternal.isLoggable(Level.FINER)) {
                loggerExternal.finer("Ignored error closing internal statement: " + e.getErrorCode() + " " + e.getMessage());
            }
        }
        finally {
            this.internalStmt = null;
        }
        this.batchParamValues = null;
    }

    final void initParams(int nParams) {
        this.inOutParam = new Parameter[nParams];
        for (int i = 0; i < nParams; ++i) {
            this.inOutParam[i] = new Parameter(Util.shouldHonorAEForParameters(this.stmtColumnEncriptionSetting, this.connection));
        }
    }

    @Override
    public final void clearParameters() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearParameters");
        this.checkClosed();
        this.encryptionMetadataIsRetrieved = false;
        if (this.inOutParam == null) {
            return;
        }
        for (int i = 0; i < this.inOutParam.length; ++i) {
            this.inOutParam[i].clearInputValue();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "clearParameters");
    }

    private boolean buildPreparedStrings(Parameter[] params, boolean renewDefinition) throws SQLServerException {
        String newTypeDefinitions = this.buildParamTypeDefinitions(params, renewDefinition);
        if (null != this.preparedTypeDefinitions && newTypeDefinitions.equals(this.preparedTypeDefinitions)) {
            return false;
        }
        this.preparedTypeDefinitions = newTypeDefinitions;
        this.preparedSQL = this.connection.replaceParameterMarkers(this.userSQL, params, this.bReturnValueSyntax);
        if (this.bRequestedGeneratedKeys) {
            this.preparedSQL = this.preparedSQL + " select SCOPE_IDENTITY() AS GENERATED_KEYS";
        }
        return true;
    }

    private String buildParamTypeDefinitions(Parameter[] params, boolean renewDefinition) throws SQLServerException {
        StringBuilder sb = new StringBuilder();
        int nCols = params.length;
        char[] cParamName = new char[10];
        this.parameterNames = new ArrayList();
        for (int i = 0; i < nCols; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            int l = SQLServerConnection.makeParamName(i, cParamName, 0);
            for (int j = 0; j < l; ++j) {
                sb.append(cParamName[j]);
            }
            sb.append(' ');
            this.parameterNames.add(i, new String(cParamName).trim());
            params[i].renewDefinition = renewDefinition;
            String typeDefinition = params[i].getTypeDefinition(this.connection, this.resultsReader());
            if (null == typeDefinition) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] msgArgs = new Object[]{i + 1};
                SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
            }
            sb.append(typeDefinition);
            if (!params[i].isOutput()) continue;
            sb.append(" OUTPUT");
        }
        return sb.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeQuery");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 1));
        loggerExternal.exiting(this.getClassNameLogging(), "executeQuery");
        return this.resultSet;
    }

    final ResultSet executeQueryInternal() throws SQLServerException, SQLTimeoutException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 5));
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeUpdate");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 2));
        if (this.updateCount < Integer.MIN_VALUE || this.updateCount > Integer.MAX_VALUE) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_updateCountOutofRange"), null, true);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", this.updateCount);
        return (int)this.updateCount;
    }

    @Override
    public long executeLargeUpdate() throws SQLServerException, SQLTimeoutException {
        DriverJDBCVersion.checkSupportsJDBC42();
        loggerExternal.entering(this.getClassNameLogging(), "executeLargeUpdate");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "executeLargeUpdate", this.updateCount);
        return this.updateCount;
    }

    @Override
    public boolean execute() throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "execute");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 3));
        loggerExternal.exiting(this.getClassNameLogging(), "execute", null != this.resultSet);
        return null != this.resultSet;
    }

    final void doExecutePreparedStatement(PrepStmtExecCmd command) throws SQLServerException {
        this.resetForReexecute();
        this.setMaxRowsAndMaxFieldSize();
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        boolean hasExistingTypeDefinitions = this.preparedTypeDefinitions != null;
        boolean hasNewTypeDefinitions = true;
        if (!this.encryptionMetadataIsRetrieved) {
            hasNewTypeDefinitions = this.buildPreparedStrings(this.inOutParam, false);
        }
        if (Util.shouldHonorAEForParameters(this.stmtColumnEncriptionSetting, this.connection) && 0 < this.inOutParam.length && !this.isInternalEncryptionQuery) {
            if (!this.encryptionMetadataIsRetrieved) {
                this.getParameterEncryptionMetadata(this.inOutParam);
                this.encryptionMetadataIsRetrieved = true;
                this.setMaxRowsAndMaxFieldSize();
            }
            hasNewTypeDefinitions = this.buildPreparedStrings(this.inOutParam, true);
        }
        String dbName = this.connection.getSCatalog();
        boolean needsPrepare = true;
        for (int attempt = 1; attempt <= 2; ++attempt) {
            try {
                if (this.reuseCachedHandle(hasNewTypeDefinitions, 1 < attempt, dbName)) {
                    hasNewTypeDefinitions = false;
                }
                TDSWriter tdsWriter = command.startRequest((byte)3);
                needsPrepare = this.doPrepExec(tdsWriter, this.inOutParam, hasNewTypeDefinitions, hasExistingTypeDefinitions);
                this.ensureExecuteResultsReader(command.startResponse(this.getIsResponseBufferingAdaptive()));
                this.startResults();
                this.getNextResult();
                break;
            }
            catch (SQLException e) {
                if (this.retryBasedOnFailedReuseOfCachedHandle(e, attempt, needsPrepare)) continue;
                throw e;
            }
        }
        if (1 == this.executeMethod && null == this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
        } else if (2 == this.executeMethod && null != this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    private boolean retryBasedOnFailedReuseOfCachedHandle(SQLException e, int attempt, boolean needsPrepare) {
        if (needsPrepare) {
            return false;
        }
        return 1 == attempt && (586 == e.getErrorCode() || 8179 == e.getErrorCode()) && this.connection.isStatementPoolingEnabled();
    }

    @Override
    boolean consumeExecOutParam(TDSReader tdsReader) throws SQLServerException {
        if (this.expectPrepStmtHandle || this.expectCursorOutParams) {
            final class PrepStmtExecOutParamHandler
            extends SQLServerStatement.StmtExecOutParamHandler {
                PrepStmtExecOutParamHandler() {
                    super(SQLServerPreparedStatement.this);
                }

                @Override
                boolean onRetValue(TDSReader tdsReader) throws SQLServerException {
                    if (!SQLServerPreparedStatement.this.expectPrepStmtHandle) {
                        return super.onRetValue(tdsReader);
                    }
                    SQLServerPreparedStatement.this.expectPrepStmtHandle = false;
                    Parameter param = new Parameter(Util.shouldHonorAEForParameters(SQLServerPreparedStatement.this.stmtColumnEncriptionSetting, SQLServerPreparedStatement.this.connection));
                    param.skipRetValStatus(tdsReader);
                    SQLServerPreparedStatement.this.setPreparedStatementHandle(param.getInt(tdsReader));
                    if (null == SQLServerPreparedStatement.this.cachedPreparedStatementHandle && !SQLServerPreparedStatement.this.isCursorable(SQLServerPreparedStatement.this.executeMethod)) {
                        String dbName = SQLServerPreparedStatement.this.connection.getSCatalog();
                        if (null != SQLServerPreparedStatement.this.handleDBName) {
                            dbName = SQLServerPreparedStatement.this.handleDBName;
                        }
                        SQLServerPreparedStatement.this.cachedPreparedStatementHandle = SQLServerPreparedStatement.this.connection.registerCachedPreparedStatementHandle(new SQLServerConnection.Sha1HashKey(SQLServerPreparedStatement.this.preparedSQL, SQLServerPreparedStatement.this.preparedTypeDefinitions, dbName), SQLServerPreparedStatement.this.prepStmtHandle, SQLServerPreparedStatement.this.executedSqlDirectly);
                    }
                    param.skipValue(tdsReader, true);
                    if (SQLServerPreparedStatement.this.getStatementLogger().isLoggable(Level.FINER)) {
                        SQLServerPreparedStatement.this.getStatementLogger().finer(this.toString() + ": Setting PreparedHandle:" + SQLServerPreparedStatement.this.prepStmtHandle);
                    }
                    return true;
                }
            }
            TDSParser.parse(tdsReader, new PrepStmtExecOutParamHandler());
            return true;
        }
        return false;
    }

    void sendParamsByRPC(TDSWriter tdsWriter, Parameter[] params) throws SQLServerException {
        for (int index = 0; index < params.length; ++index) {
            if (JDBCType.TVP == params[index].getJdbcType()) {
                char[] cParamName = new char[10];
                int paramNameLen = SQLServerConnection.makeParamName(index, cParamName, 0);
                tdsWriter.writeByte((byte)paramNameLen);
                tdsWriter.writeString(new String(cParamName, 0, paramNameLen));
            }
            params[index].sendByRPC(tdsWriter, this.connection);
        }
    }

    private void buildServerCursorPrepExecParams(TDSWriter tdsWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_cursorprepexec: PreparedHandle:" + this.getPreparedStatementHandle() + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = true;
        this.executedSqlDirectly = false;
        this.expectCursorOutParams = true;
        this.outParamIndexAdjustment = 7;
        tdsWriter.writeShort((short)-1);
        tdsWriter.writeShort((short)5);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeRPCInt(null, this.getPreparedStatementHandle(), true);
        this.resetPrepStmtHandle();
        tdsWriter.writeRPCInt(null, 0, true);
        tdsWriter.writeRPCStringUnicode(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tdsWriter.writeRPCStringUnicode(this.preparedSQL);
        tdsWriter.writeRPCInt(null, this.getResultSetScrollOpt() & ~(0 == this.preparedTypeDefinitions.length() ? 4096 : 0), false);
        tdsWriter.writeRPCInt(null, this.getResultSetCCOpt(), false);
        tdsWriter.writeRPCInt(null, 0, true);
    }

    private void buildPrepExecParams(TDSWriter tdsWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_prepexec: PreparedHandle:" + this.getPreparedStatementHandle() + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = true;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 3;
        tdsWriter.writeShort((short)-1);
        tdsWriter.writeShort((short)13);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeRPCInt(null, this.getPreparedStatementHandle(), true);
        this.resetPrepStmtHandle();
        tdsWriter.writeRPCStringUnicode(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tdsWriter.writeRPCStringUnicode(this.preparedSQL);
    }

    private void buildExecSQLParams(TDSWriter tdsWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_executesql: SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 2;
        tdsWriter.writeShort((short)-1);
        tdsWriter.writeShort((short)10);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeByte((byte)0);
        this.resetPrepStmtHandle();
        tdsWriter.writeRPCStringUnicode(this.preparedSQL);
        if (this.preparedTypeDefinitions.length() > 0) {
            tdsWriter.writeRPCStringUnicode(this.preparedTypeDefinitions);
        }
    }

    private void buildServerCursorExecParams(TDSWriter tdsWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_cursorexecute: PreparedHandle:" + this.getPreparedStatementHandle() + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.executedSqlDirectly = false;
        this.expectCursorOutParams = true;
        this.outParamIndexAdjustment = 5;
        tdsWriter.writeShort((short)-1);
        tdsWriter.writeShort((short)4);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeByte((byte)0);
        assert (this.hasPreparedStatementHandle());
        tdsWriter.writeRPCInt(null, this.getPreparedStatementHandle(), false);
        tdsWriter.writeRPCInt(null, 0, true);
        tdsWriter.writeRPCInt(null, this.getResultSetScrollOpt() & 0xFFFFEFFF, false);
        tdsWriter.writeRPCInt(null, this.getResultSetCCOpt(), false);
        tdsWriter.writeRPCInt(null, 0, true);
    }

    private void buildExecParams(TDSWriter tdsWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_execute: PreparedHandle:" + this.getPreparedStatementHandle() + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 1;
        tdsWriter.writeShort((short)-1);
        tdsWriter.writeShort((short)12);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeByte((byte)0);
        assert (this.hasPreparedStatementHandle());
        tdsWriter.writeRPCInt(null, this.getPreparedStatementHandle(), false);
    }

    private void getParameterEncryptionMetadata(Parameter[] params) throws SQLServerException {
        SQLServerResultSet rs = null;
        SQLServerCallableStatement stmt = null;
        assert (this.connection != null) : "Connection should not be null";
        try {
            if (this.getStatementLogger().isLoggable(Level.FINE)) {
                this.getStatementLogger().fine("Calling stored procedure sp_describe_parameter_encryption to get parameter encryption information.");
            }
            stmt = (SQLServerCallableStatement)this.connection.prepareCall("exec sp_describe_parameter_encryption ?,?");
            stmt.isInternalEncryptionQuery = true;
            stmt.setNString(1, this.preparedSQL);
            stmt.setNString(2, this.preparedTypeDefinitions);
            rs = (SQLServerResultSet)stmt.executeQueryInternal();
        }
        catch (SQLException e) {
            if (e instanceof SQLServerException) {
                throw (SQLServerException)e;
            }
            throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
        }
        if (null == rs) {
            return;
        }
        HashMap<Integer, CekTableEntry> cekList = new HashMap<Integer, CekTableEntry>();
        CekTableEntry cekEntry = null;
        try {
            while (rs.next()) {
                int currentOrdinal = rs.getInt(DescribeParameterEncryptionResultSet1.KeyOrdinal.value());
                if (!cekList.containsKey(currentOrdinal)) {
                    cekEntry = new CekTableEntry(currentOrdinal);
                    cekList.put(cekEntry.ordinal, cekEntry);
                } else {
                    cekEntry = (CekTableEntry)cekList.get(currentOrdinal);
                }
                cekEntry.add(rs.getBytes(DescribeParameterEncryptionResultSet1.EncryptedKey.value()), rs.getInt(DescribeParameterEncryptionResultSet1.DbId.value()), rs.getInt(DescribeParameterEncryptionResultSet1.KeyId.value()), rs.getInt(DescribeParameterEncryptionResultSet1.KeyVersion.value()), rs.getBytes(DescribeParameterEncryptionResultSet1.KeyMdVersion.value()), rs.getString(DescribeParameterEncryptionResultSet1.KeyPath.value()), rs.getString(DescribeParameterEncryptionResultSet1.ProviderName.value()), rs.getString(DescribeParameterEncryptionResultSet1.KeyEncryptionAlgorithm.value()));
            }
            if (this.getStatementLogger().isLoggable(Level.FINE)) {
                this.getStatementLogger().fine("Matadata of CEKs is retrieved.");
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLServerException) {
                throw (SQLServerException)e;
            }
            throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
        }
        if (!stmt.getMoreResults()) {
            throw new SQLServerException((Object)this, SQLServerException.getErrString("R_UnexpectedDescribeParamFormat"), null, 0, false);
        }
        int paramCount = 0;
        try {
            rs = (SQLServerResultSet)stmt.getResultSet();
            while (rs.next()) {
                ++paramCount;
                String paramName = rs.getString(DescribeParameterEncryptionResultSet2.ParameterName.value());
                int paramIndex = this.parameterNames.indexOf(paramName);
                int cekOrdinal = rs.getInt(DescribeParameterEncryptionResultSet2.ColumnEncryptionKeyOrdinal.value());
                cekEntry = (CekTableEntry)cekList.get(cekOrdinal);
                if (null != cekEntry && cekList.size() < cekOrdinal) {
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidEncryptionKeyOridnal"));
                    Object[] msgArgs = new Object[]{cekOrdinal, cekEntry.getSize()};
                    throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
                }
                SQLServerEncryptionType encType = SQLServerEncryptionType.of((byte)rs.getInt(DescribeParameterEncryptionResultSet2.ColumnEncrytionType.value()));
                if (SQLServerEncryptionType.PlainText != encType) {
                    params[paramIndex].cryptoMeta = new CryptoMetadata(cekEntry, (short)cekOrdinal, (byte)rs.getInt(DescribeParameterEncryptionResultSet2.ColumnEncryptionAlgorithm.value()), null, encType.value, (byte)rs.getInt(DescribeParameterEncryptionResultSet2.NormalizationRuleVersion.value()));
                    SQLServerSecurityUtility.decryptSymmetricKey(params[paramIndex].cryptoMeta, this.connection);
                    continue;
                }
                if (!params[paramIndex].getForceEncryption()) continue;
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn"));
                Object[] msgArgs = new Object[]{this.userSQL, paramIndex + 1};
                SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
            }
            if (this.getStatementLogger().isLoggable(Level.FINE)) {
                this.getStatementLogger().fine("Parameter encryption metadata is set.");
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLServerException) {
                throw (SQLServerException)e;
            }
            throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
        }
        if (paramCount != params.length) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MissingParamEncryptionMetadata"));
            Object[] msgArgs = new Object[]{this.userSQL};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        rs.close();
        if (null != stmt) {
            stmt.close();
        }
        this.connection.resetCurrentCommand();
    }

    private boolean reuseCachedHandle(boolean hasNewTypeDefinitions, boolean discardCurrentCacheItem, String dbName) {
        SQLServerConnection.PreparedStatementHandle cachedHandle;
        if (this.isCursorable(this.executeMethod)) {
            return false;
        }
        if (discardCurrentCacheItem && null != this.cachedPreparedStatementHandle) {
            this.cachedPreparedStatementHandle.removeReference();
            this.resetPrepStmtHandle();
            this.cachedPreparedStatementHandle.setIsExplicitlyDiscarded();
            this.cachedPreparedStatementHandle = null;
            return false;
        }
        if (hasNewTypeDefinitions) {
            if (null != this.cachedPreparedStatementHandle && this.hasPreparedStatementHandle() && this.prepStmtHandle == this.cachedPreparedStatementHandle.getHandle()) {
                this.cachedPreparedStatementHandle.removeReference();
                this.cachedPreparedStatementHandle.setIsExplicitlyDiscarded();
            }
            this.cachedPreparedStatementHandle = null;
        }
        if (null == this.cachedPreparedStatementHandle && null != (cachedHandle = this.connection.getCachedPreparedStatementHandle(new SQLServerConnection.Sha1HashKey(this.preparedSQL, this.preparedTypeDefinitions, dbName))) && (!this.connection.isColumnEncryptionSettingEnabled() || this.connection.isColumnEncryptionSettingEnabled() && this.encryptionMetadataIsRetrieved) && cachedHandle.tryAddReference()) {
            this.setPreparedStatementHandle(cachedHandle.getHandle());
            this.cachedPreparedStatementHandle = cachedHandle;
            return true;
        }
        return false;
    }

    private boolean doPrepExec(TDSWriter tdsWriter, Parameter[] params, boolean hasNewTypeDefinitions, boolean hasExistingTypeDefinitions) throws SQLServerException {
        boolean needsPrepare;
        boolean bl = needsPrepare = hasNewTypeDefinitions && hasExistingTypeDefinitions || !this.hasPreparedStatementHandle();
        if (this.isCursorable(this.executeMethod)) {
            if (needsPrepare) {
                this.buildServerCursorPrepExecParams(tdsWriter);
            } else {
                this.buildServerCursorExecParams(tdsWriter);
            }
        } else if (needsPrepare && !this.connection.getEnablePrepareOnFirstPreparedStatementCall() && !this.isExecutedAtLeastOnce) {
            this.buildExecSQLParams(tdsWriter);
            this.isExecutedAtLeastOnce = true;
        } else if (needsPrepare) {
            this.buildPrepExecParams(tdsWriter);
        } else {
            this.buildExecParams(tdsWriter);
        }
        this.sendParamsByRPC(tdsWriter, params);
        return needsPrepare;
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMetaData");
        this.checkClosed();
        boolean rsclosed = false;
        ResultSetMetaData rsmd = null;
        try {
            if (this.resultSet != null) {
                this.resultSet.checkClosed();
            }
        }
        catch (SQLServerException e) {
            rsclosed = true;
        }
        if (this.resultSet == null || rsclosed) {
            SQLServerResultSet emptyResultSet = (SQLServerResultSet)this.buildExecuteMetaData();
            if (null != emptyResultSet) {
                rsmd = emptyResultSet.getMetaData();
            }
        } else if (this.resultSet != null) {
            rsmd = this.resultSet.getMetaData();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMetaData", rsmd);
        return rsmd;
    }

    private ResultSet buildExecuteMetaData() throws SQLServerException {
        SQLServerResultSet emptyResultSet;
        block2: {
            String fmtSQL = this.userSQL;
            emptyResultSet = null;
            try {
                fmtSQL = SQLServerPreparedStatement.replaceMarkerWithNull(fmtSQL);
                this.internalStmt = (SQLServerStatement)this.connection.createStatement();
                emptyResultSet = this.internalStmt.executeQueryInternal("set fmtonly on " + fmtSQL + "\nset fmtonly off");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().equals(SQLServerException.getErrString("R_noResultset"))) break block2;
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_processingError"));
                Object[] msgArgs = new Object[]{sqle.getMessage()};
                SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
            }
        }
        return emptyResultSet;
    }

    final Parameter setterGetParam(int index) throws SQLServerException {
        if (index < 1 || index > this.inOutParam.length) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] msgArgs = new Object[]{index};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "07009", false);
        }
        return this.inOutParam[index - 1];
    }

    final void setValue(int parameterIndex, JDBCType jdbcType, Object value, JavaType javaType, String tvpName) throws SQLServerException {
        this.setterGetParam(parameterIndex).setValue(jdbcType, value, javaType, null, null, null, null, this.connection, false, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, tvpName);
    }

    final void setValue(int parameterIndex, JDBCType jdbcType, Object value, JavaType javaType, boolean forceEncrypt) throws SQLServerException {
        this.setterGetParam(parameterIndex).setValue(jdbcType, value, javaType, null, null, null, null, this.connection, forceEncrypt, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, null);
    }

    final void setValue(int parameterIndex, JDBCType jdbcType, Object value, JavaType javaType, Integer precision, Integer scale, boolean forceEncrypt) throws SQLServerException {
        this.setterGetParam(parameterIndex).setValue(jdbcType, value, javaType, null, null, precision, scale, this.connection, forceEncrypt, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, null);
    }

    final void setValue(int parameterIndex, JDBCType jdbcType, Object value, JavaType javaType, Calendar cal, boolean forceEncrypt) throws SQLServerException {
        this.setterGetParam(parameterIndex).setValue(jdbcType, value, javaType, null, cal, null, null, this.connection, forceEncrypt, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, null);
    }

    final void setStream(int parameterIndex, StreamType streamType, Object streamValue, JavaType javaType, long length) throws SQLServerException {
        this.setterGetParam(parameterIndex).setValue(streamType.getJDBCType(), streamValue, javaType, new StreamSetterArgs(streamType, length), null, null, null, this.connection, false, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, null);
    }

    final void setSQLXMLInternal(int parameterIndex, SQLXML value) throws SQLServerException {
        this.setterGetParam(parameterIndex).setValue(JDBCType.SQLXML, value, JavaType.SQLXML, new StreamSetterArgs(StreamType.SQLXML, -1L), null, null, null, this.connection, false, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, null);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{parameterIndex, x});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.ASCII, x, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(int n, InputStream x, int length) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{n, x, length});
        }
        this.checkClosed();
        this.setStream(n, StreamType.ASCII, x, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{parameterIndex, x, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.ASCII, x, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    private Parameter getParam(int index) throws SQLServerException {
        if (--index < 0 || index >= this.inOutParam.length) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] msgArgs = new Object[]{index + 1};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), "07009", false);
        }
        return this.inOutParam[index];
    }

    @Override
    public final void setBigDecimal(int n, BigDecimal x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DECIMAL, (Object)x, JavaType.BIGDECIMAL, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    public final void setBigDecimal(int n, BigDecimal x, int precision, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{n, x, precision, scale});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DECIMAL, x, JavaType.BIGDECIMAL, precision, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    public final void setBigDecimal(int n, BigDecimal x, int precision, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{n, x, precision, scale, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DECIMAL, x, JavaType.BIGDECIMAL, precision, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    public final void setMoney(int n, BigDecimal x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setMoney", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.MONEY, (Object)x, JavaType.BIGDECIMAL, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setMoney");
    }

    public final void setMoney(int n, BigDecimal x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setMoney", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.MONEY, (Object)x, JavaType.BIGDECIMAL, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setMoney");
    }

    public final void setSmallMoney(int n, BigDecimal x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallMoney", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.SMALLMONEY, (Object)x, JavaType.BIGDECIMAL, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallMoney");
    }

    public final void setSmallMoney(int n, BigDecimal x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallMoney", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.SMALLMONEY, (Object)x, JavaType.BIGDECIMAL, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallMoney");
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStreaml", new Object[]{parameterIndex, x});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.BINARY, x, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(int n, InputStream x, int length) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{n, x, length});
        }
        this.checkClosed();
        this.setStream(n, StreamType.BINARY, x, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{parameterIndex, x, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.BINARY, x, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBoolean(int n, boolean x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBoolean", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BIT, (Object)x, JavaType.BOOLEAN, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBoolean");
    }

    public final void setBoolean(int n, boolean x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBoolean", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BIT, (Object)x, JavaType.BOOLEAN, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setBoolean");
    }

    @Override
    public final void setByte(int n, byte x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setByte", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TINYINT, (Object)x, JavaType.BYTE, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setByte");
    }

    public final void setByte(int n, byte x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setByte", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TINYINT, (Object)x, JavaType.BYTE, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setByte");
    }

    @Override
    public final void setBytes(int n, byte[] x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBytes", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BINARY, (Object)x, JavaType.BYTEARRAY, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBytes");
    }

    public final void setBytes(int n, byte[] x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBytes", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BINARY, (Object)x, JavaType.BYTEARRAY, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setBytes");
    }

    public final void setUniqueIdentifier(int index, String guid) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setUniqueIdentifier", new Object[]{index, guid});
        }
        this.checkClosed();
        this.setValue(index, JDBCType.GUID, (Object)guid, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setUniqueIdentifier");
    }

    public final void setUniqueIdentifier(int index, String guid, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setUniqueIdentifier", new Object[]{index, guid, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(index, JDBCType.GUID, (Object)guid, JavaType.STRING, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setUniqueIdentifier");
    }

    @Override
    public final void setDouble(int n, double x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDouble", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DOUBLE, (Object)x, JavaType.DOUBLE, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDouble");
    }

    public final void setDouble(int n, double x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDouble", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DOUBLE, (Object)x, JavaType.DOUBLE, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDouble");
    }

    @Override
    public final void setFloat(int n, float x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFloat", new Object[]{n, Float.valueOf(x)});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.REAL, (Object)Float.valueOf(x), JavaType.FLOAT, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setFloat");
    }

    public final void setFloat(int n, float x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFloat", new Object[]{n, Float.valueOf(x), forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.REAL, (Object)Float.valueOf(x), JavaType.FLOAT, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setFloat");
    }

    public final void setGeometry(int n, Geometry x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setGeometry", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.GEOMETRY, (Object)x, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setGeometry");
    }

    public final void setGeography(int n, Geography x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setGeography", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.GEOGRAPHY, (Object)x, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setGeography");
    }

    @Override
    public final void setInt(int n, int value) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setInt", new Object[]{n, value});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.INTEGER, (Object)value, JavaType.INTEGER, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setInt");
    }

    public final void setInt(int n, int value, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setInt", new Object[]{n, value, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.INTEGER, (Object)value, JavaType.INTEGER, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setInt");
    }

    @Override
    public final void setLong(int n, long x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLong", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BIGINT, (Object)x, JavaType.LONG, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setLong");
    }

    public final void setLong(int n, long x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLong", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BIGINT, (Object)x, JavaType.LONG, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setLong");
    }

    @Override
    public final void setNull(int index, int jdbcType) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{index, jdbcType});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(index), null, JavaType.OBJECT, JDBCType.of(jdbcType), null, null, false, index, null);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    final void setObjectNoType(int index, Object obj, boolean forceEncrypt) throws SQLServerException {
        Parameter param = this.setterGetParam(index);
        JDBCType targetJDBCType = param.getJdbcType();
        String tvpName = null;
        if (null == obj) {
            if (JDBCType.UNKNOWN == targetJDBCType) {
                targetJDBCType = JDBCType.CHAR;
            }
            this.setObject(param, null, JavaType.OBJECT, targetJDBCType, null, null, forceEncrypt, index, null);
        } else {
            JavaType javaType = JavaType.of(obj);
            if (JavaType.TVP == javaType && null == (tvpName = this.getTVPNameIfNull(index, null)) && obj instanceof ResultSet) {
                throw new SQLServerException(SQLServerException.getErrString("R_TVPnotWorkWithSetObjectResultSet"), null);
            }
            if (JDBCType.UNKNOWN == (targetJDBCType = javaType.getJDBCType(SSType.UNKNOWN, targetJDBCType)) && obj instanceof UUID) {
                javaType = JavaType.STRING;
                targetJDBCType = JDBCType.GUID;
            }
            this.setObject(param, obj, javaType, targetJDBCType, null, null, forceEncrypt, index, tvpName);
        }
    }

    @Override
    public final void setObject(int index, Object obj) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{index, obj});
        }
        this.checkClosed();
        this.setObjectNoType(index, obj, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public final void setObject(int n, Object obj, int jdbcType) throws SQLServerException {
        String tvpName = null;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{n, obj, jdbcType});
        }
        this.checkClosed();
        if (-153 == jdbcType) {
            tvpName = this.getTVPNameIfNull(n, null);
        }
        this.setObject(this.setterGetParam(n), obj, JavaType.of(obj), JDBCType.of(jdbcType), null, null, false, n, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{parameterIndex, x, targetSqlType, scaleOrLength});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(parameterIndex), x, JavaType.of(x), JDBCType.of(targetSqlType), 2 == targetSqlType || 3 == targetSqlType || 93 == targetSqlType || 92 == targetSqlType || -155 == targetSqlType || InputStream.class.isInstance(x) || Reader.class.isInstance(x) ? Integer.valueOf(scaleOrLength) : null, null, false, parameterIndex, null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    public final void setObject(int parameterIndex, Object x, int targetSqlType, Integer precision, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{parameterIndex, x, targetSqlType, precision, scale});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(parameterIndex), x, JavaType.of(x), JDBCType.of(targetSqlType), 2 == targetSqlType || 3 == targetSqlType || InputStream.class.isInstance(x) || Reader.class.isInstance(x) ? Integer.valueOf(scale) : null, precision, false, parameterIndex, null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    public final void setObject(int parameterIndex, Object x, int targetSqlType, Integer precision, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{parameterIndex, x, targetSqlType, precision, scale, forceEncrypt});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(parameterIndex), x, JavaType.of(x), JDBCType.of(targetSqlType), 2 == targetSqlType || 3 == targetSqlType || InputStream.class.isInstance(x) || Reader.class.isInstance(x) ? Integer.valueOf(scale) : null, precision, forceEncrypt, parameterIndex, null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    final void setObject(Parameter param, Object obj, JavaType javaType, JDBCType jdbcType, Integer scale, Integer precision, boolean forceEncrypt, int parameterIndex, String tvpName) throws SQLServerException {
        assert (JDBCType.UNKNOWN != jdbcType);
        if (null != obj || JavaType.TVP == javaType) {
            JDBCType objectJDBCType = javaType.getJDBCType(SSType.UNKNOWN, jdbcType);
            if (!objectJDBCType.convertsTo(jdbcType)) {
                DataTypes.throwConversionError(objectJDBCType.toString(), jdbcType.toString());
            }
            StreamSetterArgs streamSetterArgs = null;
            switch (javaType) {
                case READER: {
                    streamSetterArgs = new StreamSetterArgs(StreamType.CHARACTER, -1L);
                    break;
                }
                case INPUTSTREAM: {
                    streamSetterArgs = new StreamSetterArgs(jdbcType.isTextual() ? StreamType.CHARACTER : StreamType.BINARY, -1L);
                    break;
                }
                case SQLXML: {
                    streamSetterArgs = new StreamSetterArgs(StreamType.SQLXML, -1L);
                    break;
                }
            }
            param.setValue(jdbcType, obj, javaType, streamSetterArgs, null, precision, scale, this.connection, forceEncrypt, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, tvpName);
        } else {
            assert (JavaType.OBJECT == javaType);
            if (jdbcType.isUnsupported()) {
                jdbcType = JDBCType.BINARY;
            }
            param.setValue(jdbcType, null, JavaType.OBJECT, null, null, precision, scale, this.connection, false, this.stmtColumnEncriptionSetting, parameterIndex, this.userSQL, tvpName);
        }
    }

    @Override
    public final void setShort(int index, short x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setShort", new Object[]{index, x});
        }
        this.checkClosed();
        this.setValue(index, JDBCType.SMALLINT, (Object)x, JavaType.SHORT, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setShort");
    }

    public final void setShort(int index, short x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setShort", new Object[]{index, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(index, JDBCType.SMALLINT, (Object)x, JavaType.SHORT, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setShort");
    }

    @Override
    public final void setString(int index, String str) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setString", new Object[]{index, str});
        }
        this.checkClosed();
        this.setValue(index, JDBCType.VARCHAR, (Object)str, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setString");
    }

    public final void setString(int index, String str, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setString", new Object[]{index, str, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(index, JDBCType.VARCHAR, (Object)str, JavaType.STRING, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setString");
    }

    @Override
    public final void setNString(int parameterIndex, String value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNString", new Object[]{parameterIndex, value});
        }
        this.checkClosed();
        this.setValue(parameterIndex, JDBCType.NVARCHAR, (Object)value, JavaType.STRING, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setNString");
    }

    public final void setNString(int parameterIndex, String value, boolean forceEncrypt) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNString", new Object[]{parameterIndex, value, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(parameterIndex, JDBCType.NVARCHAR, (Object)value, JavaType.STRING, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setNString");
    }

    @Override
    public final void setTime(int n, Time x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, (Object)x, JavaType.TIME, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public final void setTime(int n, Time x, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, x, scale});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, x, JavaType.TIME, null, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public final void setTime(int n, Time x, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, x, scale, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, x, JavaType.TIME, null, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public final void setTimestamp(int n, Timestamp x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, (Object)x, JavaType.TIMESTAMP, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    public final void setTimestamp(int n, Timestamp x, int scale) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, x, scale});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, x, JavaType.TIMESTAMP, null, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    public final void setTimestamp(int n, Timestamp x, int scale, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, x, scale, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, x, JavaType.TIMESTAMP, null, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    @Override
    public final void setDateTimeOffset(int n, DateTimeOffset x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATETIMEOFFSET, (Object)x, JavaType.DATETIMEOFFSET, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    public final void setDateTimeOffset(int n, DateTimeOffset x, int scale) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{n, x, scale});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATETIMEOFFSET, x, JavaType.DATETIMEOFFSET, null, scale, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    public final void setDateTimeOffset(int n, DateTimeOffset x, int scale, boolean forceEncrypt) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTimeOffset", new Object[]{n, x, scale, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATETIMEOFFSET, x, JavaType.DATETIMEOFFSET, null, scale, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTimeOffset");
    }

    @Override
    public final void setDate(int n, Date x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATE, (Object)x, JavaType.DATE, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    public final void setDateTime(int n, Timestamp x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTime", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATETIME, (Object)x, JavaType.TIMESTAMP, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTime");
    }

    public final void setDateTime(int n, Timestamp x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDateTime", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATETIME, (Object)x, JavaType.TIMESTAMP, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDateTime");
    }

    public final void setSmallDateTime(int n, Timestamp x) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallDateTime", new Object[]{n, x});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.SMALLDATETIME, (Object)x, JavaType.TIMESTAMP, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallDateTime");
    }

    public final void setSmallDateTime(int n, Timestamp x, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSmallDateTime", new Object[]{n, x, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.SMALLDATETIME, (Object)x, JavaType.TIMESTAMP, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setSmallDateTime");
    }

    public final void setStructured(int n, String tvpName, SQLServerDataTable tvpDataTable) throws SQLServerException {
        tvpName = this.getTVPNameIfNull(n, tvpName);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setStructured", new Object[]{n, tvpName, tvpDataTable});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TVP, (Object)tvpDataTable, JavaType.TVP, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setStructured");
    }

    public final void setStructured(int n, String tvpName, ResultSet tvpResultSet) throws SQLServerException {
        tvpName = this.getTVPNameIfNull(n, tvpName);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setStructured", new Object[]{n, tvpName, tvpResultSet});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TVP, (Object)tvpResultSet, JavaType.TVP, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setStructured");
    }

    public final void setStructured(int n, String tvpName, ISQLServerDataRecord tvpBulkRecord) throws SQLServerException {
        tvpName = this.getTVPNameIfNull(n, tvpName);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setStructured", new Object[]{n, tvpName, tvpBulkRecord});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TVP, (Object)tvpBulkRecord, JavaType.TVP, tvpName);
        loggerExternal.exiting(this.getClassNameLogging(), "setStructured");
    }

    String getTVPNameIfNull(int n, String tvpName) throws SQLServerException {
        if ((null == tvpName || 0 == tvpName.length()) && null != this.procedureName) {
            SQLServerParameterMetaData pmd = (SQLServerParameterMetaData)this.getParameterMetaData();
            pmd.isTVP = true;
            if (!pmd.procedureIsFound) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_StoredProcedureNotFound"));
                Object[] msgArgs = new Object[]{this.procedureName};
                SQLServerException.makeFromDriverError(this.connection, pmd, form.format(msgArgs), null, false);
            }
            try {
                String tvpNameWithoutSchema = pmd.getParameterTypeName(n);
                String tvpSchema = pmd.getTVPSchemaFromStoredProcedure(n);
                tvpName = null != tvpSchema ? "[" + tvpSchema + "].[" + tvpNameWithoutSchema + "]" : tvpNameWithoutSchema;
            }
            catch (SQLException e) {
                throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), null, 0, (Throwable)e);
            }
        }
        return tvpName;
    }

    @Override
    @Deprecated
    public final void setUnicodeStream(int n, InputStream x, int length) throws SQLException {
        this.NotImplemented();
    }

    @Override
    public final void addBatch() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "addBatch");
        this.checkClosed();
        if (this.batchParamValues == null) {
            this.batchParamValues = new ArrayList();
        }
        int numParams = this.inOutParam.length;
        Parameter[] paramValues = new Parameter[numParams];
        for (int i = 0; i < numParams; ++i) {
            paramValues[i] = this.inOutParam[i].cloneForBatch();
        }
        this.batchParamValues.add(paramValues);
        loggerExternal.exiting(this.getClassNameLogging(), "addBatch");
    }

    @Override
    public final void clearBatch() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearBatch");
        this.checkClosed();
        this.batchParamValues = null;
        loggerExternal.exiting(this.getClassNameLogging(), "clearBatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLServerException, BatchUpdateException, SQLTimeoutException {
        int[] updateCounts;
        loggerExternal.entering(this.getClassNameLogging(), "executeBatch");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.discardLastExecutionResults();
        if (this.batchParamValues == null) {
            updateCounts = new int[]{};
        } else {
            try {
                for (Parameter[] paramValues : this.batchParamValues) {
                    for (Parameter paramValue : paramValues) {
                        if (!paramValue.isOutput()) continue;
                        throw new BatchUpdateException(SQLServerException.getErrString("R_outParamsNotPermittedinBatch"), null, 0, null);
                    }
                }
                PrepStmtBatchExecCmd batchCommand = new PrepStmtBatchExecCmd(this);
                this.executeStatement(batchCommand);
                updateCounts = new int[batchCommand.updateCounts.length];
                for (int i = 0; i < batchCommand.updateCounts.length; ++i) {
                    updateCounts[i] = (int)batchCommand.updateCounts[i];
                }
                if (null != batchCommand.batchException) {
                    throw new BatchUpdateException(batchCommand.batchException.getMessage(), batchCommand.batchException.getSQLState(), batchCommand.batchException.getErrorCode(), updateCounts);
                }
            }
            finally {
                this.batchParamValues = null;
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "executeBatch", updateCounts);
        return updateCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLServerException, BatchUpdateException, SQLTimeoutException {
        long[] updateCounts;
        DriverJDBCVersion.checkSupportsJDBC42();
        loggerExternal.entering(this.getClassNameLogging(), "executeLargeBatch");
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.discardLastExecutionResults();
        if (this.batchParamValues == null) {
            updateCounts = new long[]{};
        } else {
            try {
                for (Parameter[] paramValues : this.batchParamValues) {
                    for (Parameter paramValue : paramValues) {
                        if (!paramValue.isOutput()) continue;
                        throw new BatchUpdateException(SQLServerException.getErrString("R_outParamsNotPermittedinBatch"), null, 0, null);
                    }
                }
                PrepStmtBatchExecCmd batchCommand = new PrepStmtBatchExecCmd(this);
                this.executeStatement(batchCommand);
                updateCounts = new long[batchCommand.updateCounts.length];
                System.arraycopy(batchCommand.updateCounts, 0, updateCounts, 0, batchCommand.updateCounts.length);
                if (null != batchCommand.batchException) {
                    DriverJDBCVersion.throwBatchUpdateException(batchCommand.batchException, updateCounts);
                }
            }
            finally {
                this.batchParamValues = null;
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "executeLargeBatch", updateCounts);
        return updateCounts;
    }

    final void doExecutePreparedStatementBatch(PrepStmtBatchExecCmd batchCommand) throws SQLServerException {
        this.executeMethod = 4;
        batchCommand.batchException = null;
        int numBatches = this.batchParamValues.size();
        batchCommand.updateCounts = new long[numBatches];
        for (int i = 0; i < numBatches; ++i) {
            batchCommand.updateCounts[i] = -3L;
        }
        int numBatchesPrepared = 0;
        int numBatchesExecuted = 0;
        Vector<CryptoMetadata> cryptoMetaBatch = new Vector<CryptoMetadata>();
        if (this.isSelect(this.userSQL)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_selectNotPermittedinBatch"), null, true);
        }
        this.connection.setMaxRows(0);
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        Parameter[] batchParam = new Parameter[this.inOutParam.length];
        TDSWriter tdsWriter = null;
        block5: while (numBatchesExecuted < numBatches) {
            Parameter[] paramValues = this.batchParamValues.get(numBatchesPrepared);
            assert (paramValues.length == batchParam.length);
            System.arraycopy(paramValues, 0, batchParam, 0, paramValues.length);
            boolean hasExistingTypeDefinitions = this.preparedTypeDefinitions != null;
            boolean hasNewTypeDefinitions = this.buildPreparedStrings(batchParam, false);
            if (0 == numBatchesExecuted && Util.shouldHonorAEForParameters(this.stmtColumnEncriptionSetting, this.connection) && 0 < batchParam.length && !this.isInternalEncryptionQuery && !this.encryptionMetadataIsRetrieved) {
                this.getParameterEncryptionMetadata(batchParam);
                this.buildPreparedStrings(batchParam, true);
                for (Parameter aBatchParam : batchParam) {
                    cryptoMetaBatch.add(aBatchParam.cryptoMeta);
                }
            }
            if (0 < numBatchesExecuted) {
                for (int i = 0; i < cryptoMetaBatch.size(); ++i) {
                    batchParam[i].cryptoMeta = (CryptoMetadata)cryptoMetaBatch.get(i);
                }
            }
            String dbName = this.connection.getSCatalog();
            boolean needsPrepare = true;
            for (int attempt = 1; attempt <= 2; ++attempt) {
                try {
                    if (this.reuseCachedHandle(hasNewTypeDefinitions, 1 < attempt, dbName)) {
                        hasNewTypeDefinitions = false;
                    }
                    if (numBatchesExecuted < numBatchesPrepared) {
                        tdsWriter.writeByte((byte)-1);
                    } else {
                        this.resetForReexecute();
                        tdsWriter = batchCommand.startRequest((byte)3);
                    }
                    if (!(needsPrepare = this.doPrepExec(tdsWriter, batchParam, hasNewTypeDefinitions, hasExistingTypeDefinitions)) && ++numBatchesPrepared != numBatches) continue block5;
                    this.ensureExecuteResultsReader(batchCommand.startResponse(this.getIsResponseBufferingAdaptive()));
                    boolean retry = false;
                    while (numBatchesExecuted < numBatchesPrepared) {
                        block25: {
                            this.startResults();
                            try {
                                if (!this.getNextResult()) {
                                    return;
                                }
                                if (null != this.resultSet) {
                                    SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
                                }
                            }
                            catch (SQLServerException e) {
                                if (this.connection.isSessionUnAvailable() || this.connection.rolledBackTransaction()) {
                                    throw e;
                                }
                                if (this.retryBasedOnFailedReuseOfCachedHandle(e, attempt, needsPrepare)) {
                                    numBatchesPrepared = numBatchesExecuted;
                                    retry = true;
                                    break;
                                }
                                this.updateCount = -3L;
                                if (null != batchCommand.batchException) break block25;
                                batchCommand.batchException = e;
                            }
                        }
                        batchCommand.updateCounts[numBatchesExecuted] = -1L == this.updateCount ? -2L : this.updateCount;
                        this.processBatch();
                        ++numBatchesExecuted;
                    }
                    if (retry) continue;
                    assert (numBatchesExecuted == numBatchesPrepared);
                    continue block5;
                }
                catch (SQLException e) {
                    if (this.retryBasedOnFailedReuseOfCachedHandle(e, attempt, needsPrepare) && this.connection.isStatementPoolingEnabled()) {
                        numBatchesPrepared = numBatchesExecuted;
                        continue;
                    }
                    if (null != batchCommand.batchException) {
                        numBatchesExecuted = numBatchesPrepared;
                        ++attempt;
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{parameterIndex, reader});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(int n, Reader reader, int length) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{n, reader, length});
        }
        this.checkClosed();
        this.setStream(n, StreamType.CHARACTER, reader, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{parameterIndex, reader, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.CHARACTER, reader, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{parameterIndex, value});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.NCHARACTER, value, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{parameterIndex, value, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.NCHARACTER, value, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setRef(int i, Ref x) throws SQLServerException {
        this.NotImplemented();
    }

    @Override
    public final void setBlob(int i, Blob x) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{i, x});
        }
        this.checkClosed();
        this.setValue(i, JDBCType.BLOB, (Object)x, JavaType.BLOB, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{parameterIndex, inputStream});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{parameterIndex, inputStream, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setClob(int parameterIndex, Clob clobValue) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{parameterIndex, clobValue});
        }
        this.checkClosed();
        this.setValue(parameterIndex, JDBCType.CLOB, (Object)clobValue, JavaType.CLOB, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{parameterIndex, reader});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{parameterIndex, reader, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.CHARACTER, reader, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{parameterIndex, value});
        }
        this.checkClosed();
        this.setValue(parameterIndex, JDBCType.NCLOB, (Object)value, JavaType.NCLOB, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{parameterIndex, reader});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{parameterIndex, reader, length});
        }
        this.checkClosed();
        this.setStream(parameterIndex, StreamType.NCHARACTER, reader, JavaType.READER, length);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setArray(int i, Array x) throws SQLServerException {
        this.NotImplemented();
    }

    @Override
    public final void setDate(int n, Date x, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{n, x, cal});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATE, x, JavaType.DATE, cal, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    public final void setDate(int n, Date x, Calendar cal, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{n, x, cal, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATE, x, JavaType.DATE, cal, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    public final void setTime(int n, Time x, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, x, cal});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, x, JavaType.TIME, cal, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    public final void setTime(int n, Time x, Calendar cal, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, x, cal, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, x, JavaType.TIME, cal, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public final void setTimestamp(int n, Timestamp x, Calendar cal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, x, cal});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, x, JavaType.TIMESTAMP, cal, false);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    public final void setTimestamp(int n, Timestamp x, Calendar cal, boolean forceEncrypt) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, x, cal, forceEncrypt});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, x, JavaType.TIMESTAMP, cal, forceEncrypt);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    @Override
    public final void setNull(int paramIndex, int sqlType, String typeName) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{paramIndex, sqlType, typeName});
        }
        this.checkClosed();
        if (-153 == sqlType) {
            this.setObject(this.setterGetParam(paramIndex), null, JavaType.TVP, JDBCType.of(sqlType), null, null, false, paramIndex, typeName);
        } else {
            this.setObject(this.setterGetParam(paramIndex), null, JavaType.OBJECT, JDBCType.of(sqlType), null, null, false, paramIndex, typeName);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    public final ParameterMetaData getParameterMetaData(boolean forceRefresh) throws SQLServerException {
        SQLServerParameterMetaData pmd = this.connection.getCachedParameterMetadata(this.sqlTextCacheKey);
        if (!forceRefresh && null != pmd) {
            return pmd;
        }
        loggerExternal.entering(this.getClassNameLogging(), "getParameterMetaData");
        this.checkClosed();
        pmd = new SQLServerParameterMetaData(this, this.userSQL);
        this.connection.registerCachedParameterMetadata(this.sqlTextCacheKey, pmd);
        loggerExternal.exiting(this.getClassNameLogging(), "getParameterMetaData", pmd);
        return pmd;
    }

    @Override
    public final ParameterMetaData getParameterMetaData() throws SQLServerException {
        return this.getParameterMetaData(false);
    }

    @Override
    public final void setURL(int parameterIndex, URL x) throws SQLServerException {
        this.NotImplemented();
    }

    @Override
    public final void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setSQLXML", new Object[]{parameterIndex, xmlObject});
        }
        this.checkClosed();
        this.setSQLXMLInternal(parameterIndex, xmlObject);
        loggerExternal.exiting(this.getClassNameLogging(), "setSQLXML");
    }

    @Override
    public final int executeUpdate(String sql) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", sql);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] msgArgs = new Object[]{"executeUpdate()"};
        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
    }

    @Override
    public final boolean execute(String sql) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "execute", sql);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] msgArgs = new Object[]{"execute()"};
        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeQuery", sql);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] msgArgs = new Object[]{"executeQuery()"};
        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
    }

    @Override
    public void addBatch(String sql) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "addBatch", sql);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] msgArgs = new Object[]{"addBatch()"};
        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
    }

    private final class PrepStmtBatchExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;
        SQLServerException batchException;
        long[] updateCounts;

        PrepStmtBatchExecCmd(SQLServerPreparedStatement stmt) {
            super(stmt.toString() + " executeBatch", SQLServerPreparedStatement.this.queryTimeout, SQLServerPreparedStatement.this.cancelQueryTimeoutSeconds);
            this.stmt = stmt;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatementBatch(this);
            return true;
        }

        @Override
        final void processResponse(TDSReader tdsReader) throws SQLServerException {
            SQLServerPreparedStatement.this.ensureExecuteResultsReader(tdsReader);
            SQLServerPreparedStatement.this.processExecuteResults();
        }
    }

    private final class PrepStmtExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;

        PrepStmtExecCmd(SQLServerPreparedStatement stmt, int executeMethod) {
            super(stmt.toString() + " executeXXX", SQLServerPreparedStatement.this.queryTimeout, SQLServerPreparedStatement.this.cancelQueryTimeoutSeconds);
            this.stmt = stmt;
            stmt.executeMethod = executeMethod;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatement(this);
            return false;
        }

        @Override
        final void processResponse(TDSReader tdsReader) throws SQLServerException {
            SQLServerPreparedStatement.this.ensureExecuteResultsReader(tdsReader);
            SQLServerPreparedStatement.this.processExecuteResults();
        }
    }
}

