/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TimeoutCommand;
import java.util.logging.Level;

class TdsTimeoutCommand
extends TimeoutCommand<TDSCommand> {
    protected TdsTimeoutCommand(int timeout, TDSCommand command, SQLServerConnection sqlServerConnection) {
        super(timeout, command, sqlServerConnection);
    }

    @Override
    protected void interrupt() throws Exception {
        TDSCommand command = (TDSCommand)this.getCommand();
        SQLServerConnection sqlServerConnection = this.getSqlServerConnection();
        try {
            if (null == command && null != sqlServerConnection) {
                sqlServerConnection.terminate(3, SQLServerException.getErrString("R_connectionIsClosed"));
            } else {
                command.interrupt(SQLServerException.getErrString("R_queryTimedOut"));
            }
        }
        catch (SQLServerException e) {
            if (null != command) {
                command.log(Level.FINE, "Command could not be timed out. Reason: " + e.getMessage());
            }
            throw new SQLServerException(SQLServerException.getErrString("R_crCommandCannotTimeOut"), e);
        }
    }
}

