/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint.http;

import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.sharepoint.http.Request;
import com.microsoft.services.sharepoint.http.Response;
import com.microsoft.services.sharepoint.http.StreamResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class NetworkRunnable
implements Runnable {
    HttpURLConnection mConnection = null;
    InputStream mResponseStream = null;
    Request mRequest;
    SettableFuture<Response> mFuture;
    final Object mCloseLock = new Object();

    public NetworkRunnable(Request request, SettableFuture<Response> future) {
        this.mRequest = request;
        this.mFuture = future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int responseCode;
            block15: {
                responseCode = -1;
                Object object = this.mCloseLock;
                synchronized (object) {
                    block13: {
                        if (this.mFuture.isCancelled()) break block15;
                        if (this.mRequest != null) break block13;
                        this.mFuture.setException((Throwable)new IllegalArgumentException("request"));
                        return;
                    }
                    this.mConnection = NetworkRunnable.createHttpURLConnection(this.mRequest);
                    responseCode = this.mConnection.getResponseCode();
                    this.mResponseStream = responseCode >= 400 ? this.mConnection.getErrorStream() : this.mConnection.getInputStream();
                }
            }
            if (this.mResponseStream != null && !this.mFuture.isCancelled()) {
                this.mFuture.set((Object)new StreamResponse(this.mResponseStream, responseCode, this.mConnection.getHeaderFields()));
            }
        }
        catch (Throwable e) {
            if (!this.mFuture.isCancelled()) {
                if (this.mConnection != null) {
                    this.mConnection.disconnect();
                }
                this.mFuture.setException(e);
            }
        }
        finally {
            this.closeStreamAndConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStreamAndConnection() {
        Object object = this.mCloseLock;
        synchronized (object) {
            if (this.mResponseStream != null) {
                try {
                    this.mResponseStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
    }

    static HttpURLConnection createHttpURLConnection(Request request) throws IOException {
        URL url = new URL(request.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(request.getVerb());
        Map<String, String> headers = request.getHeaders();
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key));
        }
        if (request.getContent() != null) {
            connection.setDoOutput(true);
            byte[] requestContent = request.getContent();
            OutputStream stream = connection.getOutputStream();
            stream.write(requestContent, 0, requestContent.length);
            stream.close();
        }
        return connection;
    }
}

