/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint.http;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.sharepoint.Platform;
import com.microsoft.services.sharepoint.http.HttpConnection;
import com.microsoft.services.sharepoint.http.NetworkRunnable;
import com.microsoft.services.sharepoint.http.NetworkThread;
import com.microsoft.services.sharepoint.http.Request;
import com.microsoft.services.sharepoint.http.Response;

public class JavaHttpConnection
implements HttpConnection {
    private static final String USER_AGENT_HEADER = "User-Agent";

    @Override
    public ListenableFuture<Response> execute(Request request) {
        request.addHeader(USER_AGENT_HEADER, Platform.getUserAgent());
        SettableFuture future = SettableFuture.create();
        final NetworkRunnable target = new NetworkRunnable(request, (SettableFuture<Response>)future);
        final NetworkThread networkThread = new NetworkThread((Runnable)target){

            @Override
            void releaseAndStop() {
                try {
                    target.closeStreamAndConnection();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Response>(){

            public void onFailure(Throwable arg0) {
                networkThread.releaseAndStop();
            }

            public void onSuccess(Response response) {
            }
        });
        networkThread.start();
        return future;
    }
}

