/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.sharepoint.Credentials;
import com.microsoft.services.sharepoint.LogLevel;
import com.microsoft.services.sharepoint.Logger;
import com.microsoft.services.sharepoint.OfficeClient;
import com.microsoft.services.sharepoint.Platform;
import com.microsoft.services.sharepoint.http.HttpConnection;
import com.microsoft.services.sharepoint.http.Request;
import com.microsoft.services.sharepoint.http.Response;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SharePointClient
extends OfficeClient {
    private String mServerUrl;
    private String mSiteRelativeUrl;

    protected String getSiteUrl() {
        return this.mServerUrl + this.mSiteRelativeUrl;
    }

    protected String getServerUrl() {
        return this.mServerUrl;
    }

    protected String getSiteRelativeUrl() {
        return this.mSiteRelativeUrl;
    }

    public SharePointClient(String serverUrl, String siteRelativeUrl, Credentials credentials) {
        this(serverUrl, siteRelativeUrl, credentials, null);
    }

    public SharePointClient(String serverUrl, String siteRelativeUrl, Credentials credentials, Logger logger) {
        super(credentials, logger);
        if (serverUrl == null) {
            throw new IllegalArgumentException("serverUrl must not be null");
        }
        if (siteRelativeUrl == null) {
            throw new IllegalArgumentException("siteRelativeUrl must not be null");
        }
        this.mServerUrl = serverUrl;
        this.mSiteRelativeUrl = siteRelativeUrl;
        if (!this.mServerUrl.endsWith("/")) {
            this.mServerUrl = this.mServerUrl + "/";
        }
        if (this.mSiteRelativeUrl.startsWith("/")) {
            this.mSiteRelativeUrl = this.mSiteRelativeUrl.substring(1);
        }
        if (!this.mSiteRelativeUrl.endsWith("/") && this.mSiteRelativeUrl.length() > 0) {
            this.mSiteRelativeUrl = this.mSiteRelativeUrl + "/";
        }
    }

    protected ListenableFuture<String> getFormDigest() {
        HttpConnection connection = Platform.createHttpConnection();
        Request request = new Request("POST");
        request.setUrl(this.getSiteUrl() + "_api/contextinfo");
        this.prepareRequest(request);
        this.log("Generate request for getFormDigest", LogLevel.Verbose);
        request.log(this.getLogger());
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<Response> future = connection.execute(request);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Response>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(Response response) {
                try {
                    int statusCode = response.getStatus();
                    if (OfficeClient.isValidStatus(statusCode)) {
                        String responseContent = response.readToEnd();
                        JSONObject json = new JSONObject(responseContent);
                        result.set((Object)json.getJSONObject("d").getJSONObject("GetContextWebInformation").getString("FormDigestValue"));
                    } else {
                        result.setException((Throwable)new Exception("Invalid status code " + statusCode + ": " + response.readToEnd()));
                    }
                }
                catch (Exception e) {
                    SharePointClient.this.log(e);
                }
            }
        });
        return result;
    }

    protected ListenableFuture<JSONObject> executeRequestJsonWithDigest(final String url, final String method, final Map<String, String> headers, final byte[] payload) {
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<String> digestFuture = this.getFormDigest();
        Futures.addCallback(digestFuture, (FutureCallback)new FutureCallback<String>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(String digest) {
                HashMap<String, String> finalHeaders = new HashMap<String, String>();
                if (headers != null) {
                    for (String key : headers.keySet()) {
                        finalHeaders.put(key, (String)headers.get(key));
                    }
                }
                finalHeaders.put("Content-Type", "application/json;odata=verbose");
                finalHeaders.put("X-RequestDigest", digest);
                ListenableFuture<JSONObject> request = SharePointClient.this.executeRequestJson(url, method, finalHeaders, payload);
                Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

                    public void onFailure(Throwable t) {
                        result.setException(t);
                    }

                    public void onSuccess(JSONObject json) {
                        result.set((Object)json);
                    }
                });
            }
        });
        return result;
    }

    public ListenableFuture<String> getWebTitle() {
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<JSONObject> request = this.executeRequestJson(this.mServerUrl + "_api/web/title", "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    result.set((Object)json.getJSONObject("d").getString("Title"));
                }
                catch (JSONException e) {
                    SharePointClient.this.log(e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<JSONObject> getUserByID(String id) {
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<JSONObject> request = this.executeRequestJson(this.mServerUrl + "_api/web/getuserbyid(" + id + ")", "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                result.set((Object)json);
            }
        });
        return result;
    }
}

