/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.microsoft.services.sharepoint.OfficeEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SPListItem
extends OfficeEntity {
    private Map<String, Object> mValues = new HashMap<String, Object>();

    public static List<SPListItem> listFromJson(JSONObject json) throws JSONException {
        return SPListItem.listFromJson(json, SPListItem.class);
    }

    public void setData(String key, Object data) {
        this.mValues.put(key, data);
    }

    Map<String, Object> getValues() {
        return new HashMap<String, Object>(this.mValues);
    }

    public int getId() {
        return (Integer)this.getData("Id");
    }

    public String getTitle() {
        return this.getData("Title").toString();
    }

    public String getGUID() {
        return this.getData("GUID").toString();
    }

    public List<SPListItem> getSubItems(String field) {
        JSONObject subItemsJson = (JSONObject)this.getData(field);
        try {
            return SPListItem.listFromJson(subItemsJson, SPListItem.class);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cant get sub items from field " + field, e);
        }
    }

    @Override
    public Object getData(String field) {
        if (this.mValues.containsKey(field)) {
            return this.mValues.get(field);
        }
        return super.getData(field);
    }
}

