/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.microsoft.services.sharepoint.Query;
import java.security.InvalidParameterException;
import java.util.Locale;

public class QueryOperations {
    private static Query function(String functionName, Query ... parameters) {
        Query query = new Query();
        query.setQueryText(functionName);
        for (Query p : parameters) {
            query.addInternalValue(p);
        }
        return query;
    }

    private static Query simpleOperator(Query otherQuery, String operator) {
        Query query = new Query();
        query.setQueryText(operator + " ");
        if (otherQuery != null) {
            query.addInternalValue(otherQuery);
        }
        return query;
    }

    private static String sanitize(String s) {
        if (s != null) {
            return s.replace("'", "''");
        }
        return null;
    }

    public static Query query(Query subQuery) {
        Query query = new Query();
        query.addInternalValue(subQuery);
        return query;
    }

    public static Query field(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new InvalidParameterException("fieldName cannot be null or empty");
        }
        Query query = new Query();
        query.setQueryText(fieldName);
        return query;
    }

    public static Query val(Number number) {
        Query query = new Query();
        if (number == null) {
            query.setQueryText("null");
        } else {
            query.setQueryText(number.toString());
        }
        return query;
    }

    public static Query val(boolean val) {
        Query query = new Query();
        query.setQueryText(Boolean.valueOf(val).toString().toLowerCase(Locale.getDefault()));
        return query;
    }

    public static Query val(String s) {
        Query query = new Query();
        if (s == null) {
            query.setQueryText("null");
        } else {
            query.setQueryText("'" + QueryOperations.sanitize(s) + "'");
        }
        return query;
    }

    public static Query and() {
        return QueryOperations.and(null);
    }

    public static Query and(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "and");
    }

    public static Query or() {
        return QueryOperations.or(null);
    }

    public static Query or(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "or");
    }

    public static Query not() {
        return QueryOperations.not(null);
    }

    public static Query not(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "not");
    }

    public static Query not(boolean booleanValue) {
        return QueryOperations.not(QueryOperations.val(booleanValue));
    }

    public static Query ge() {
        Query nullQuery = null;
        return QueryOperations.ge(nullQuery);
    }

    public static Query ge(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "ge");
    }

    public static Query ge(Number numberValue) {
        return QueryOperations.ge(QueryOperations.val(numberValue));
    }

    public static Query le() {
        Query nullQuery = null;
        return QueryOperations.le(nullQuery);
    }

    public static Query le(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "le");
    }

    public static Query le(Number numberValue) {
        return QueryOperations.le(QueryOperations.val(numberValue));
    }

    public static Query gt() {
        Query nullQuery = null;
        return QueryOperations.gt(nullQuery);
    }

    public static Query gt(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "gt");
    }

    public static Query gt(Number numberValue) {
        return QueryOperations.gt(QueryOperations.val(numberValue));
    }

    public static Query lt() {
        Query nullQuery = null;
        return QueryOperations.lt(nullQuery);
    }

    public static Query lt(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "lt");
    }

    public static Query lt(Number numberValue) {
        return QueryOperations.lt(QueryOperations.val(numberValue));
    }

    public static Query eq() {
        Query nullQuery = null;
        return QueryOperations.eq(nullQuery);
    }

    public static Query eq(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "eq");
    }

    public static Query eq(Number numberValue) {
        return QueryOperations.eq(QueryOperations.val(numberValue));
    }

    public static Query eq(boolean booleanValue) {
        return QueryOperations.eq(QueryOperations.val(booleanValue));
    }

    public static Query eq(String stringValue) {
        return QueryOperations.eq(QueryOperations.val(stringValue));
    }

    public static Query ne() {
        Query nullQuery = null;
        return QueryOperations.ne(nullQuery);
    }

    public static Query ne(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "ne");
    }

    public static Query ne(Number numberValue) {
        return QueryOperations.ne(QueryOperations.val(numberValue));
    }

    public static Query ne(boolean booleanValue) {
        return QueryOperations.ne(QueryOperations.val(booleanValue));
    }

    public static Query ne(String stringValue) {
        return QueryOperations.ne(QueryOperations.val(stringValue));
    }

    public static Query add() {
        Query nullQuery = null;
        return QueryOperations.add(nullQuery);
    }

    public static Query add(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "add");
    }

    public static Query add(Number val) {
        return QueryOperations.add(QueryOperations.val(val));
    }

    public static Query sub() {
        Query nullQuery = null;
        return QueryOperations.sub(nullQuery);
    }

    public static Query sub(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "sub");
    }

    public static Query sub(Number val) {
        return QueryOperations.sub(QueryOperations.val(val));
    }

    public static Query mul() {
        Query nullQuery = null;
        return QueryOperations.mul(nullQuery);
    }

    public static Query mul(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "mul");
    }

    public static Query mul(Number val) {
        return QueryOperations.mul(QueryOperations.val(val));
    }

    public static Query div() {
        Query nullQuery = null;
        return QueryOperations.div(nullQuery);
    }

    public static Query div(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "div");
    }

    public static Query div(Number val) {
        return QueryOperations.div(QueryOperations.val(val));
    }

    public static Query mod() {
        Query nullQuery = null;
        return QueryOperations.mod(nullQuery);
    }

    public static Query mod(Query otherQuery) {
        return QueryOperations.simpleOperator(otherQuery, "mod");
    }

    public static Query mod(Number val) {
        return QueryOperations.mod(QueryOperations.val(val));
    }

    public static Query year(Query exp) {
        return QueryOperations.function("year", exp);
    }

    public static Query year(String field) {
        return QueryOperations.function("year", QueryOperations.field(field));
    }

    public static Query month(Query exp) {
        return QueryOperations.function("month", exp);
    }

    public static Query month(String field) {
        return QueryOperations.function("month", QueryOperations.field(field));
    }

    public static Query day(Query exp) {
        return QueryOperations.function("day", exp);
    }

    public static Query day(String field) {
        return QueryOperations.function("day", QueryOperations.field(field));
    }

    public static Query hour(Query exp) {
        return QueryOperations.function("hour", exp);
    }

    public static Query hour(String field) {
        return QueryOperations.function("hour", QueryOperations.field(field));
    }

    public static Query minute(Query exp) {
        return QueryOperations.function("minute", exp);
    }

    public static Query minute(String field) {
        return QueryOperations.function("minute", QueryOperations.field(field));
    }

    public static Query second(Query exp) {
        return QueryOperations.function("second", exp);
    }

    public static Query second(String field) {
        return QueryOperations.function("second", QueryOperations.field(field));
    }

    public static Query floor(Query exp) {
        return QueryOperations.function("floor", exp);
    }

    public static Query ceiling(Query exp) {
        return QueryOperations.function("ceiling", exp);
    }

    public static Query round(Query exp) {
        return QueryOperations.function("round", exp);
    }

    public static Query toLower(Query exp) {
        return QueryOperations.function("tolower", exp);
    }

    public static Query toLower(String field) {
        return QueryOperations.toLower(QueryOperations.field(field));
    }

    public static Query toUpper(Query exp) {
        return QueryOperations.function("toupper", exp);
    }

    public static Query toUpper(String field) {
        return QueryOperations.toUpper(QueryOperations.field(field));
    }

    public static Query length(Query exp) {
        return QueryOperations.function("length", exp);
    }

    public static Query length(String field) {
        return QueryOperations.length(QueryOperations.field(field));
    }

    public static Query trim(Query exp) {
        return QueryOperations.function("trim", exp);
    }

    public static Query trim(String field) {
        return QueryOperations.trim(QueryOperations.field(field));
    }

    public static Query startsWith(Query field, Query start) {
        return QueryOperations.function("startswith", field, start);
    }

    public static Query startsWith(String field, String start) {
        return QueryOperations.startsWith(QueryOperations.field(field), QueryOperations.val(start));
    }

    public static Query endsWith(Query field, Query end) {
        return QueryOperations.function("endsWith", field, end);
    }

    public static Query endsWith(String field, String end) {
        return QueryOperations.endsWith(QueryOperations.field(field), QueryOperations.val(end));
    }

    public static Query subStringOf(Query str1, Query str2) {
        return QueryOperations.function("substringof", str1, str2);
    }

    public static Query subStringOf(String str, String field) {
        return QueryOperations.subStringOf(QueryOperations.val(str), QueryOperations.field(field));
    }

    public static Query concat(Query str1, Query str2) {
        return QueryOperations.function("concat", str1, str2);
    }

    public static Query indexOf(Query haystack, Query needle) {
        return QueryOperations.function("indexof", haystack, needle);
    }

    public static Query indexOf(String field, String str) {
        return QueryOperations.indexOf(QueryOperations.field(field), QueryOperations.val(str));
    }

    public static Query subString(Query str, Query pos) {
        return QueryOperations.function("substring", str, pos);
    }

    public static Query subString(String field, int pos) {
        return QueryOperations.subString(QueryOperations.field(field), QueryOperations.val(pos));
    }

    public static Query subString(Query str, Query pos, Query length) {
        return QueryOperations.function("substring", str, pos, length);
    }

    public static Query subString(String field, int pos, int length) {
        return QueryOperations.subString(QueryOperations.field(field), QueryOperations.val(pos), QueryOperations.val(length));
    }

    public static Query replace(Query str, Query find, Query replace) {
        return QueryOperations.function("replace", str, find, replace);
    }

    public static Query replace(String field, String find, String replace) {
        return QueryOperations.replace(QueryOperations.field(field), QueryOperations.val(find), QueryOperations.val(replace));
    }
}

