/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class OfficeEntity {
    private JSONObject mJsonData;

    protected JSONObject getJsonData() {
        return this.mJsonData;
    }

    protected static <E extends OfficeEntity> List<E> listFromJson(JSONObject json, Class<E> clazz) throws JSONException {
        ArrayList<OfficeEntity> list = new ArrayList<OfficeEntity>();
        JSONArray results = json.has("d") ? json.getJSONObject("d").getJSONArray("results") : json.getJSONArray("results");
        for (int i = 0; i < results.length(); ++i) {
            JSONObject result = results.getJSONObject(i);
            OfficeEntity item = null;
            try {
                item = (OfficeEntity)clazz.newInstance();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (item == null) continue;
            item.loadFromJson(result);
            list.add(item);
        }
        return list;
    }

    public void loadFromJson(JSONObject json) {
        this.mJsonData = json;
    }

    public void loadFromJson(JSONObject json, boolean isPlainItem) {
        if (isPlainItem) {
            this.loadFromJson(json);
        } else {
            try {
                JSONObject innerJson = json.getJSONObject("d");
                this.loadFromJson(innerJson);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Expected 'd' element", e);
            }
        }
    }

    public Object getData(String field) {
        try {
            if (this.mJsonData.has("d")) {
                JSONObject innerJson = this.mJsonData.getJSONObject("d");
                return innerJson.get(field);
            }
            return this.mJsonData.get(field);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid field name " + field, e);
        }
    }

    public String toString() {
        if (this.mJsonData != null) {
            return this.mJsonData.toString();
        }
        return super.toString();
    }
}

