/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.text.TextUtils;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.OAuth;
import com.microsoft.services.msa.OAuthResponse;
import com.microsoft.services.msa.OAuthResponseVisitor;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class OAuthSuccessfulResponse
implements OAuthResponse {
    private static final int UNINITIALIZED = -1;
    private final String accessToken;
    private final String authenticationToken;
    private final int expiresIn;
    private final String refreshToken;
    private final String scope;
    private final OAuth.TokenType tokenType;

    public static OAuthSuccessfulResponse createFromFragment(Map<String, String> fragmentParameters) throws LiveAuthException {
        String scope;
        String expiresInString;
        OAuth.TokenType tokenType;
        String accessToken = fragmentParameters.get("access_token");
        String tokenTypeString = fragmentParameters.get("token_type");
        if (accessToken == null) {
            throw new AssertionError();
        }
        if (tokenTypeString == null) {
            throw new AssertionError();
        }
        try {
            tokenType = OAuth.TokenType.valueOf(tokenTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        Builder builder = new Builder(accessToken, tokenType);
        String authenticationToken = fragmentParameters.get("authentication_token");
        if (authenticationToken != null) {
            builder.authenticationToken(authenticationToken);
        }
        if ((expiresInString = fragmentParameters.get("expires_in")) != null) {
            int expiresIn;
            try {
                expiresIn = Integer.parseInt(expiresInString);
            }
            catch (NumberFormatException e) {
                throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
            }
            builder.expiresIn(expiresIn);
        }
        if ((scope = fragmentParameters.get("scope")) != null) {
            builder.scope(scope);
        }
        return builder.build();
    }

    public static OAuthSuccessfulResponse createFromJson(JSONObject response) throws LiveAuthException {
        OAuth.TokenType tokenType;
        String tokenTypeString;
        String accessToken;
        if (!OAuthSuccessfulResponse.validOAuthSuccessfulResponse(response)) {
            throw new AssertionError();
        }
        try {
            accessToken = response.getString("access_token");
        }
        catch (JSONException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        try {
            tokenTypeString = response.getString("token_type");
        }
        catch (JSONException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        try {
            tokenType = OAuth.TokenType.valueOf(tokenTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        catch (NullPointerException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        Builder builder = new Builder(accessToken, tokenType);
        if (response.has("authentication_token")) {
            String authenticationToken;
            try {
                authenticationToken = response.getString("authentication_token");
            }
            catch (JSONException e) {
                throw new LiveAuthException("An error occured on the client during the operation.", e);
            }
            builder.authenticationToken(authenticationToken);
        }
        if (response.has("refresh_token")) {
            String refreshToken;
            try {
                refreshToken = response.getString("refresh_token");
            }
            catch (JSONException e) {
                throw new LiveAuthException("An error occured on the client during the operation.", e);
            }
            builder.refreshToken(refreshToken);
        }
        if (response.has("expires_in")) {
            int expiresIn;
            try {
                expiresIn = response.getInt("expires_in");
            }
            catch (JSONException e) {
                throw new LiveAuthException("An error occured on the client during the operation.", e);
            }
            builder.expiresIn(expiresIn);
        }
        if (response.has("scope")) {
            String scope;
            try {
                scope = response.getString("scope");
            }
            catch (JSONException e) {
                throw new LiveAuthException("An error occured on the client during the operation.", e);
            }
            builder.scope(scope);
        }
        return builder.build();
    }

    public static boolean validOAuthSuccessfulResponse(JSONObject response) {
        return response.has("access_token") && response.has("token_type");
    }

    private OAuthSuccessfulResponse(Builder builder) {
        this.accessToken = builder.accessToken;
        this.authenticationToken = builder.authenticationToken;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.expiresIn = builder.expiresIn;
        this.scope = builder.scope;
    }

    @Override
    public void accept(OAuthResponseVisitor visitor) {
        visitor.visit(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public OAuth.TokenType getTokenType() {
        return this.tokenType;
    }

    public boolean hasAuthenticationToken() {
        return this.authenticationToken != null && !TextUtils.isEmpty((CharSequence)this.authenticationToken);
    }

    public boolean hasExpiresIn() {
        return this.expiresIn != -1;
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null && !TextUtils.isEmpty((CharSequence)this.refreshToken);
    }

    public boolean hasScope() {
        return this.scope != null && !TextUtils.isEmpty((CharSequence)this.scope);
    }

    public String toString() {
        return String.format("OAuthSuccessfulResponse [accessToken=%s, authenticationToken=%s, tokenType=%s, refreshToken=%s, expiresIn=%s, scope=%s]", new Object[]{this.accessToken, this.authenticationToken, this.tokenType, this.refreshToken, this.expiresIn, this.scope});
    }

    public static class Builder {
        private final String accessToken;
        private String authenticationToken;
        private int expiresIn = -1;
        private String refreshToken;
        private String scope;
        private final OAuth.TokenType tokenType;

        public Builder(String accessToken, OAuth.TokenType tokenType) {
            if (accessToken == null) {
                throw new AssertionError();
            }
            if (TextUtils.isEmpty((CharSequence)accessToken)) {
                throw new AssertionError();
            }
            if (tokenType == null) {
                throw new AssertionError();
            }
            this.accessToken = accessToken;
            this.tokenType = tokenType;
        }

        public Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public OAuthSuccessfulResponse build() {
            return new OAuthSuccessfulResponse(this);
        }

        public Builder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }
    }
}

