/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.microsoft.services.msa.AccessTokenRequest;
import com.microsoft.services.msa.DefaultObservableOAuthRequest;
import com.microsoft.services.msa.DeviceType;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.OAuth;
import com.microsoft.services.msa.OAuthConfig;
import com.microsoft.services.msa.OAuthRequestObserver;
import com.microsoft.services.msa.OAuthResponse;
import com.microsoft.services.msa.OAuthSuccessfulResponse;
import com.microsoft.services.msa.ObservableOAuthRequest;
import com.microsoft.services.msa.ScreenSize;
import com.microsoft.services.msa.TokenRequestAsync;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;

class AuthorizationRequest
implements ObservableOAuthRequest,
OAuthRequestObserver {
    private static final String AMPERSAND = "&";
    private static final String EQUALS = "=";
    private final Activity activity;
    private final HttpClient client;
    private final String clientId;
    private final DefaultObservableOAuthRequest observable;
    private final String scope;
    private final String loginHint;
    private final OAuthConfig mOAuthConfig;

    private static Map<String, String> getFragmentParametersMap(Uri uri) {
        String fragment = uri.getFragment();
        String[] keyValuePairs = TextUtils.split((String)fragment, (String)AMPERSAND);
        HashMap<String, String> fragementParameters = new HashMap<String, String>();
        for (String keyValuePair : keyValuePairs) {
            int index = keyValuePair.indexOf(EQUALS);
            String key = keyValuePair.substring(0, index);
            String value = keyValuePair.substring(index + 1);
            fragementParameters.put(key, value);
        }
        return fragementParameters;
    }

    public AuthorizationRequest(Activity activity, HttpClient client, String clientId, String scope, String loginHint, OAuthConfig oAuthConfig) {
        if (activity == null) {
            throw new AssertionError();
        }
        if (client == null) {
            throw new AssertionError();
        }
        if (TextUtils.isEmpty((CharSequence)clientId)) {
            throw new AssertionError();
        }
        if (TextUtils.isEmpty((CharSequence)scope)) {
            throw new AssertionError();
        }
        this.activity = activity;
        this.client = client;
        this.clientId = clientId;
        this.mOAuthConfig = oAuthConfig;
        this.observable = new DefaultObservableOAuthRequest();
        this.scope = scope;
        this.loginHint = loginHint;
    }

    @Override
    public void addObserver(OAuthRequestObserver observer) {
        this.observable.addObserver(observer);
    }

    public void execute() {
        String displayType = this.getDisplayParameter();
        String responseType = OAuth.ResponseType.CODE.toString().toLowerCase(Locale.US);
        String locale = Locale.getDefault().toString();
        Uri.Builder requestUriBuilder = this.mOAuthConfig.getAuthorizeUri().buildUpon().appendQueryParameter("client_id", this.clientId).appendQueryParameter("scope", this.scope).appendQueryParameter("display", displayType).appendQueryParameter("response_type", responseType).appendQueryParameter("locale", locale).appendQueryParameter("redirect_uri", this.mOAuthConfig.getDesktopUri().toString());
        if (this.loginHint != null) {
            requestUriBuilder.appendQueryParameter("login_hint", this.loginHint);
        }
        Uri requestUri = requestUriBuilder.build();
        OAuthDialog oAuthDialog = new OAuthDialog(requestUri);
        oAuthDialog.show();
    }

    @Override
    public void onException(LiveAuthException exception) {
        this.observable.notifyObservers(exception);
    }

    @Override
    public void onResponse(OAuthResponse response) {
        this.observable.notifyObservers(response);
    }

    @Override
    public boolean removeObserver(OAuthRequestObserver observer) {
        return this.observable.removeObserver(observer);
    }

    private String getDisplayParameter() {
        ScreenSize screenSize = ScreenSize.determineScreenSize(this.activity);
        DeviceType deviceType = screenSize.getDeviceType();
        return deviceType.getDisplayParameter().toString().toLowerCase(Locale.US);
    }

    private void onAccessTokenResponse(Map<String, String> fragmentParameters) {
        OAuthSuccessfulResponse response;
        if (fragmentParameters == null) {
            throw new AssertionError();
        }
        try {
            response = OAuthSuccessfulResponse.createFromFragment(fragmentParameters);
        }
        catch (LiveAuthException e) {
            this.onException(e);
            return;
        }
        this.onResponse(response);
    }

    private void onAuthorizationResponse(String code) {
        if (TextUtils.isEmpty((CharSequence)code)) {
            throw new AssertionError();
        }
        AccessTokenRequest request = new AccessTokenRequest(this.client, this.clientId, code, this.mOAuthConfig);
        TokenRequestAsync requestAsync = new TokenRequestAsync(request);
        requestAsync.addObserver(this);
        requestAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void onEndUri(Uri endUri) {
        boolean invalidUri;
        boolean hasFragment = endUri.getFragment() != null;
        boolean hasQueryParameters = endUri.getQuery() != null;
        boolean bl = invalidUri = !hasFragment && !hasQueryParameters;
        if (invalidUri) {
            this.onInvalidUri();
            return;
        }
        if (hasFragment) {
            boolean isSuccessfulResponse;
            Map<String, String> fragmentParameters = AuthorizationRequest.getFragmentParametersMap(endUri);
            boolean bl2 = isSuccessfulResponse = fragmentParameters.containsKey("access_token") && fragmentParameters.containsKey("token_type");
            if (isSuccessfulResponse) {
                this.onAccessTokenResponse(fragmentParameters);
                return;
            }
            String error = fragmentParameters.get("error");
            if (error != null) {
                String errorDescription = fragmentParameters.get("error_description");
                String errorUri = fragmentParameters.get("error_uri");
                this.onError(error, errorDescription, errorUri);
                return;
            }
        }
        if (hasQueryParameters) {
            String code = endUri.getQueryParameter("code");
            if (code != null) {
                this.onAuthorizationResponse(code);
                return;
            }
            String error = endUri.getQueryParameter("error");
            if (error != null) {
                String errorDescription = endUri.getQueryParameter("error_description");
                String errorUri = endUri.getQueryParameter("error_uri");
                this.onError(error, errorDescription, errorUri);
                return;
            }
        }
        this.onInvalidUri();
    }

    private void onError(String error, String errorDescription, String errorUri) {
        LiveAuthException exception = new LiveAuthException(error, errorDescription, errorUri);
        this.onException(exception);
    }

    private void onInvalidUri() {
        LiveAuthException exception = new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.");
        this.onException(exception);
    }

    private static enum UriComparator implements Comparator<Uri>
    {
        INSTANCE;


        @Override
        public int compare(Uri lhs, Uri rhs) {
            String[] lhsParts = new String[]{lhs.getScheme(), lhs.getAuthority(), lhs.getPath()};
            String[] rhsParts = new String[]{rhs.getScheme(), rhs.getAuthority(), rhs.getPath()};
            if (lhsParts.length != rhsParts.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < lhsParts.length; ++i) {
                int compare = lhsParts[i].compareTo(rhsParts[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }

    private class OAuthDialog
    extends Dialog
    implements DialogInterface.OnCancelListener {
        private final Uri requestUri;

        public OAuthDialog(Uri requestUri) {
            super((Context)AuthorizationRequest.this.activity, 0x1030010);
            this.setOwnerActivity(AuthorizationRequest.this.activity);
            if (requestUri == null) {
                throw new AssertionError();
            }
            this.requestUri = requestUri;
        }

        public void onCancel(DialogInterface dialog) {
            LiveAuthException exception = new LiveAuthException("The user cancelled the login operation.");
            AuthorizationRequest.this.onException(exception);
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setOnCancelListener(this);
            FrameLayout content = new FrameLayout(this.getContext());
            LinearLayout webViewContainer = new LinearLayout(this.getContext());
            WebView webView = new WebView(this.getContext());
            webView.setWebViewClient((WebViewClient)new AuthorizationWebViewClient());
            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webView.loadUrl(this.requestUri.toString());
            webView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            webView.setVisibility(0);
            webViewContainer.addView((View)webView);
            webViewContainer.setVisibility(0);
            content.addView((View)webViewContainer);
            content.setVisibility(0);
            content.forceLayout();
            webViewContainer.forceLayout();
            this.addContentView((View)content, new ViewGroup.LayoutParams(-1, -1));
        }

        private class AuthorizationWebViewClient
        extends WebViewClient {
            private final CookieManager cookieManager;
            private final Set<String> cookieKeys;

            public AuthorizationWebViewClient() {
                CookieSyncManager.createInstance((Context)OAuthDialog.this.getContext());
                this.cookieManager = CookieManager.getInstance();
                this.cookieKeys = new HashSet<String>();
            }

            public void onPageFinished(WebView view, String url) {
                Uri endUri;
                boolean isEndUri;
                Uri uri = Uri.parse((String)url);
                if (uri.getHost().equals(AuthorizationRequest.this.mOAuthConfig.getLogoutUri().getHost())) {
                    this.saveCookiesInMemory(this.cookieManager.getCookie(url));
                }
                boolean bl = isEndUri = UriComparator.INSTANCE.compare(uri, endUri = AuthorizationRequest.this.mOAuthConfig.getDesktopUri()) == 0;
                if (!isEndUri) {
                    return;
                }
                this.saveCookiesToPreferences();
                AuthorizationRequest.this.onEndUri(uri);
                OAuthDialog.this.dismiss();
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                AuthorizationRequest.this.onError("", description, failingUrl);
                OAuthDialog.this.dismiss();
            }

            private void saveCookiesInMemory(String cookie) {
                String[] pairs;
                if (TextUtils.isEmpty((CharSequence)cookie)) {
                    return;
                }
                for (String pair : pairs = TextUtils.split((String)cookie, (String)"; ")) {
                    int index = pair.indexOf(AuthorizationRequest.EQUALS);
                    String key = pair.substring(0, index);
                    this.cookieKeys.add(key);
                }
            }

            private void saveCookiesToPreferences() {
                SharedPreferences preferences = OAuthDialog.this.getContext().getSharedPreferences("com.microsoft.live", 0);
                String value = preferences.getString("cookies", "");
                String[] valueSplit = TextUtils.split((String)value, (String)",");
                this.cookieKeys.addAll(Arrays.asList(valueSplit));
                SharedPreferences.Editor editor = preferences.edit();
                value = TextUtils.join((CharSequence)",", this.cookieKeys);
                editor.putString("cookies", value);
                editor.commit();
                this.cookieKeys.clear();
            }
        }
    }
}

