/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.OAuthRequestObserver;
import com.microsoft.services.msa.OAuthResponse;
import com.microsoft.services.msa.ObservableOAuthRequest;
import java.util.ArrayList;
import java.util.List;

class DefaultObservableOAuthRequest
implements ObservableOAuthRequest {
    private final List<OAuthRequestObserver> observers = new ArrayList<OAuthRequestObserver>();

    @Override
    public void addObserver(OAuthRequestObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObservers(LiveAuthException exception) {
        for (OAuthRequestObserver observer : this.observers) {
            observer.onException(exception);
        }
    }

    public void notifyObservers(OAuthResponse response) {
        for (OAuthRequestObserver observer : this.observers) {
            observer.onResponse(response);
        }
    }

    @Override
    public boolean removeObserver(OAuthRequestObserver observer) {
        return this.observers.remove(observer);
    }
}

