/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.microsoft.services.msa.AuthorizationRequest;
import com.microsoft.services.msa.Config;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.LiveAuthListener;
import com.microsoft.services.msa.LiveConnectSession;
import com.microsoft.services.msa.LiveConnectUtils;
import com.microsoft.services.msa.LiveStatus;
import com.microsoft.services.msa.OAuth;
import com.microsoft.services.msa.OAuthErrorResponse;
import com.microsoft.services.msa.OAuthRequestObserver;
import com.microsoft.services.msa.OAuthResponse;
import com.microsoft.services.msa.OAuthResponseVisitor;
import com.microsoft.services.msa.OAuthSuccessfulResponse;
import com.microsoft.services.msa.RefreshAccessTokenRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public class LiveAuthClient {
    private static final String TAG = "LiveAuthClient";
    private static final LiveAuthListener NULL_LISTENER = new LiveAuthListener(){

        @Override
        public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object sender) {
        }

        @Override
        public void onAuthError(LiveAuthException exception, Object sender) {
        }
    };
    private final Context applicationContext;
    private final String clientId;
    private boolean hasPendingLoginRequest = false;
    private HttpClient httpClient = new DefaultHttpClient();
    private Set<String> baseScopes;
    private final LiveConnectSession session = new LiveConnectSession(this);

    public LiveAuthClient(Context context, String clientId, Iterable<String> scopes) {
        LiveConnectUtils.assertNotNull(context, "context");
        LiveConnectUtils.assertNotNullOrEmpty(clientId, "clientId");
        this.applicationContext = context.getApplicationContext();
        this.clientId = clientId;
        if (scopes == null) {
            scopes = Arrays.asList(new String[0]);
        }
        this.baseScopes = new HashSet<String>();
        for (String scope : scopes) {
            this.baseScopes.add(scope);
        }
        this.baseScopes = Collections.unmodifiableSet(this.baseScopes);
    }

    public LiveAuthClient(Context context, String clientId) {
        this(context, clientId, null);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void login(Activity activity, LiveAuthListener listener) {
        this.login(activity, null, null, listener);
    }

    public void login(Activity activity, Iterable<String> scopes, LiveAuthListener listener) {
        this.login(activity, scopes, null, listener);
    }

    public void login(Activity activity, Iterable<String> scopes, Object userState, LiveAuthListener listener) {
        LiveConnectUtils.assertNotNull(activity, "activity");
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        if (this.hasPendingLoginRequest) {
            throw new IllegalStateException("Another login operation is already in progress.");
        }
        if (scopes == null) {
            scopes = this.baseScopes == null ? Arrays.asList(new String[0]) : this.baseScopes;
        }
        if (this.loginSilent(scopes, userState, listener).booleanValue()) {
            Log.i((String)TAG, (String)"Interactive login not required.");
            return;
        }
        String scope = TextUtils.join((CharSequence)" ", scopes);
        String redirectUri = Config.INSTANCE.getOAuthDesktopUri().toString();
        AuthorizationRequest request = new AuthorizationRequest(activity, this.httpClient, this.clientId, redirectUri, scope);
        request.addObserver(new ListenerCallerObserver(listener, userState));
        request.addObserver(new RefreshTokenWriter());
        request.addObserver(new OAuthRequestObserver(){

            @Override
            public void onException(LiveAuthException exception) {
                LiveAuthClient.this.hasPendingLoginRequest = false;
            }

            @Override
            public void onResponse(OAuthResponse response) {
                LiveAuthClient.this.hasPendingLoginRequest = false;
            }
        });
        this.hasPendingLoginRequest = true;
        request.execute();
    }

    public Boolean loginSilent(LiveAuthListener listener) {
        return this.loginSilent(null, null, listener);
    }

    public Boolean loginSilent(Iterable<String> scopes, LiveAuthListener listener) {
        return this.loginSilent(scopes, null, listener);
    }

    public Boolean loginSilent(Object userState, LiveAuthListener listener) {
        return this.loginSilent(null, userState, listener);
    }

    public Boolean loginSilent(Iterable<String> scopes, Object userState, LiveAuthListener listener) {
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        if (this.hasPendingLoginRequest) {
            throw new IllegalStateException("Another login operation is already in progress.");
        }
        if (scopes == null) {
            scopes = this.baseScopes == null ? Arrays.asList(new String[0]) : this.baseScopes;
        }
        boolean needNewAccessToken = this.session.isExpired() || !this.session.contains(scopes);
        boolean silentLoginSucceeded = false;
        if (!needNewAccessToken) {
            Log.i((String)TAG, (String)"Access token still valid, so using it.");
            listener.onAuthComplete(LiveStatus.CONNECTED, this.session, userState);
            silentLoginSucceeded = true;
        } else if (this.tryRefresh(scopes).booleanValue()) {
            Log.i((String)TAG, (String)"Used refresh token to refresh access and refresh tokens.");
            listener.onAuthComplete(LiveStatus.CONNECTED, this.session, userState);
            silentLoginSucceeded = true;
        } else {
            Log.i((String)TAG, (String)"All tokens expired, you need to call login() to initiate interactive logon");
            silentLoginSucceeded = false;
        }
        return silentLoginSucceeded;
    }

    public void logout(LiveAuthListener listener) {
        this.logout(null, listener);
    }

    public void logout(Object userState, LiveAuthListener listener) {
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        this.session.setAccessToken(null);
        this.session.setAuthenticationToken(null);
        this.session.setRefreshToken(null);
        this.session.setScopes(null);
        this.session.setTokenType(null);
        this.clearRefreshTokenFromPreferences();
        CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)this.applicationContext);
        CookieManager manager = CookieManager.getInstance();
        Uri logoutUri = Config.INSTANCE.getOAuthLogoutUri();
        String url = logoutUri.toString();
        String domain = logoutUri.getHost();
        List<String> cookieKeys = this.getCookieKeysFromPreferences();
        for (String cookieKey : cookieKeys) {
            String value = TextUtils.join((CharSequence)"", (Object[])new String[]{cookieKey, "=; expires=Thu, 30-Oct-1980 16:00:00 GMT;domain=", domain, ";path=/;version=1"});
            manager.setCookie(url, value);
        }
        cookieSyncManager.sync();
        listener.onAuthComplete(LiveStatus.UNKNOWN, null, userState);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    LiveConnectSession getSession() {
        return this.session;
    }

    Boolean tryRefresh(Iterable<String> scopes) {
        OAuthResponse response;
        String scope = TextUtils.join((CharSequence)" ", scopes);
        String refreshToken = this.session.getRefreshToken();
        if (TextUtils.isEmpty((CharSequence)refreshToken)) {
            Log.i((String)TAG, (String)"No refresh token available, sorry!");
            return false;
        }
        Log.i((String)TAG, (String)"Refresh token found, attempting to refresh access and refresh tokens.");
        RefreshAccessTokenRequest request = new RefreshAccessTokenRequest(this.httpClient, this.clientId, refreshToken, scope);
        try {
            response = request.execute();
        }
        catch (LiveAuthException e) {
            return false;
        }
        SessionRefresher refresher = new SessionRefresher(this.session);
        response.accept(refresher);
        response.accept(new RefreshTokenWriter());
        return refresher.visitedSuccessfulResponse();
    }

    void setHttpClient(HttpClient client) {
        assert (client != null);
        this.httpClient = client;
    }

    private boolean clearRefreshTokenFromPreferences() {
        SharedPreferences settings = this.getSharedPreferences();
        SharedPreferences.Editor editor = settings.edit();
        editor.remove("refresh_token");
        return editor.commit();
    }

    private SharedPreferences getSharedPreferences() {
        return this.applicationContext.getSharedPreferences("com.microsoft.live", 0);
    }

    private List<String> getCookieKeysFromPreferences() {
        SharedPreferences settings = this.getSharedPreferences();
        String cookieKeys = settings.getString("cookies", "");
        return Arrays.asList(TextUtils.split((String)cookieKeys, (String)","));
    }

    private String getRefreshTokenFromPreferences() {
        SharedPreferences settings = this.getSharedPreferences();
        return settings.getString("refresh_token", null);
    }

    private static class SessionRefresher
    implements OAuthResponseVisitor {
        private final LiveConnectSession session;
        private boolean visitedSuccessfulResponse;

        public SessionRefresher(LiveConnectSession session) {
            assert (session != null);
            this.session = session;
            this.visitedSuccessfulResponse = false;
        }

        @Override
        public void visit(OAuthErrorResponse response) {
            this.visitedSuccessfulResponse = false;
        }

        @Override
        public void visit(OAuthSuccessfulResponse response) {
            this.session.loadFromOAuthResponse(response);
            this.visitedSuccessfulResponse = true;
        }

        public boolean visitedSuccessfulResponse() {
            return this.visitedSuccessfulResponse;
        }
    }

    private class RefreshTokenWriter
    implements OAuthRequestObserver,
    OAuthResponseVisitor {
        private RefreshTokenWriter() {
        }

        @Override
        public void onException(LiveAuthException exception) {
        }

        @Override
        public void onResponse(OAuthResponse response) {
            response.accept(this);
        }

        @Override
        public void visit(OAuthErrorResponse response) {
            if (response.getError() == OAuth.ErrorType.INVALID_GRANT) {
                LiveAuthClient.this.clearRefreshTokenFromPreferences();
            }
        }

        @Override
        public void visit(OAuthSuccessfulResponse response) {
            String refreshToken = response.getRefreshToken();
            if (!TextUtils.isEmpty((CharSequence)refreshToken)) {
                this.saveRefreshTokenToPreferences(refreshToken);
            }
        }

        private boolean saveRefreshTokenToPreferences(String refreshToken) {
            assert (!TextUtils.isEmpty((CharSequence)refreshToken));
            SharedPreferences settings = LiveAuthClient.this.applicationContext.getSharedPreferences("com.microsoft.live", 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("refresh_token", refreshToken);
            return editor.commit();
        }
    }

    private class ListenerCallerObserver
    extends AuthListenerCaller
    implements OAuthRequestObserver,
    OAuthResponseVisitor {
        public ListenerCallerObserver(LiveAuthListener listener, Object userState) {
            super(listener, userState);
        }

        @Override
        public void onException(LiveAuthException exception) {
            new AuthErrorRunnable(this.listener, this.userState, exception).run();
        }

        @Override
        public void onResponse(OAuthResponse response) {
            response.accept(this);
        }

        @Override
        public void visit(OAuthErrorResponse response) {
            String error = response.getError().toString().toLowerCase(Locale.US);
            String errorDescription = response.getErrorDescription();
            String errorUri = response.getErrorUri();
            LiveAuthException exception = new LiveAuthException(error, errorDescription, errorUri);
            new AuthErrorRunnable(this.listener, this.userState, exception).run();
        }

        @Override
        public void visit(OAuthSuccessfulResponse response) {
            LiveAuthClient.this.session.loadFromOAuthResponse(response);
            new AuthCompleteRunnable(this.listener, this.userState, LiveStatus.CONNECTED, LiveAuthClient.this.session).run();
        }
    }

    private static abstract class AuthListenerCaller {
        protected final LiveAuthListener listener;
        protected final Object userState;

        public AuthListenerCaller(LiveAuthListener listener, Object userState) {
            this.listener = listener;
            this.userState = userState;
        }
    }

    private static class AuthErrorRunnable
    extends AuthListenerCaller
    implements Runnable {
        private final LiveAuthException exception;

        public AuthErrorRunnable(LiveAuthListener listener, Object userState, LiveAuthException exception) {
            super(listener, userState);
            this.exception = exception;
        }

        @Override
        public void run() {
            this.listener.onAuthError(this.exception, this.userState);
        }
    }

    private static class AuthCompleteRunnable
    extends AuthListenerCaller
    implements Runnable {
        private final LiveStatus status;
        private final LiveConnectSession session;

        public AuthCompleteRunnable(LiveAuthListener listener, Object userState, LiveStatus status, LiveConnectSession session) {
            super(listener, userState);
            this.status = status;
            this.session = session;
        }

        @Override
        public void run() {
            this.listener.onAuthComplete(this.status, this.session, this.userState);
        }
    }
}

