/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.Item;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.ODataOperations;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.Request;
import java.util.HashMap;

public class ItemCollectionOperations
extends ODataOperations {
    public ItemCollectionOperations(String urlComponent, ODataExecutable parent) {
        super(urlComponent, parent);
    }

    public ItemCollectionOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    public ItemCollectionOperations addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ListenableFuture<Item> getByPath(String path) {
        SettableFuture result = SettableFuture.create();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", path);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(Helpers.serializeToJsonByteArray(map, (DependencyResolver)this.getResolver()));
        String parameters = Helpers.getFunctionParameters(map);
        request.getUrl().appendPathComponent("getByPath(" + parameters + ")");
        ListenableFuture future = this.oDataExecute(request);
        this.addEntityResultCallback(result, future, Item.class);
        return result;
    }
}

