/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.Folder;
import com.microsoft.fileservices.odata.ItemOperations;
import com.microsoft.fileservices.odata.ODataExecutable;
import com.microsoft.services.odata.EntityFetcherHelper;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataURL;
import java.util.HashMap;

public class FolderOperations
extends ItemOperations {
    public FolderOperations(String urlComponent, ODataExecutable parent) {
        super(urlComponent, parent);
    }

    @Override
    public FolderOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    public ListenableFuture<Folder> copy(String destFolderId, String destFolderPath, String newName) {
        SettableFuture result = SettableFuture.create();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("destFolderId", destFolderId);
        map.put("destFolderPath", destFolderPath);
        map.put("newName", newName);
        ODataURL url = this.getResolver().createODataURL();
        url.appendPathComponent("copy");
        ListenableFuture<byte[]> future = this.oDataExecute(url, Helpers.serializeToJsonByteArray(map, (DependencyResolver)this.getResolver()), HttpVerb.POST, this.getCustomHeaders());
        EntityFetcherHelper.addEntityResultCallback((SettableFuture)result, future, (DependencyResolver)this.getResolver(), Folder.class);
        return result;
    }
}

