/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.odata.ODataExecutable;
import com.microsoft.fileservices.odata.Readable;
import com.microsoft.services.odata.EntityFetcherHelper;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataURL;
import java.util.HashMap;
import java.util.Map;

public abstract class ODataEntityFetcher<E, V>
extends ODataExecutable
implements Readable<E> {
    protected String urlComponent;
    protected ODataExecutable parent;
    private Class<E> clazz;
    private V operations;

    public ODataEntityFetcher(String urlComponent, ODataExecutable parent, Class<E> clazz, Class<V> operationClazz) {
        this.urlComponent = urlComponent;
        this.parent = parent;
        this.clazz = clazz;
        try {
            this.operations = operationClazz.getConstructor(String.class, ODataExecutable.class).newInstance("", this);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    public ODataEntityFetcher<E, V> addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    @Override
    ListenableFuture<byte[]> oDataExecute(ODataURL path, byte[] content, HttpVerb verb, Map<String, String> headers) {
        path.prependPathComponent(this.urlComponent);
        Helpers.addCustomParametersToODataURL((ODataURL)path, this.getCustomParameters(), (DependencyResolver)this.getResolver());
        HashMap<String, String> newHeaders = new HashMap<String, String>(this.getCustomHeaders());
        newHeaders.putAll(headers);
        return this.parent.oDataExecute(path, content, verb, newHeaders);
    }

    @Override
    DependencyResolver getResolver() {
        return this.parent.getResolver();
    }

    public ListenableFuture<E> update(E updatedEntity) {
        SettableFuture result = SettableFuture.create();
        byte[] payloadBytes = Helpers.serializeToJsonByteArray(updatedEntity, (DependencyResolver)this.getResolver());
        ListenableFuture<byte[]> future = this.oDataExecute(this.getResolver().createODataURL(), payloadBytes, HttpVerb.PATCH, this.getCustomHeaders());
        EntityFetcherHelper.addEntityResultCallback((SettableFuture)result, future, (DependencyResolver)this.getResolver(), this.clazz);
        return result;
    }

    public ListenableFuture delete() {
        SettableFuture result = SettableFuture.create();
        ListenableFuture<byte[]> future = this.oDataExecute(this.getResolver().createODataURL(), null, HttpVerb.DELETE, this.getCustomHeaders());
        EntityFetcherHelper.addNullResultCallback((SettableFuture)result, future);
        return result;
    }

    @Override
    public ListenableFuture<E> read() {
        SettableFuture result = SettableFuture.create();
        ListenableFuture<byte[]> future = this.oDataExecute(this.getResolver().createODataURL(), null, HttpVerb.GET, this.getCustomHeaders());
        EntityFetcherHelper.addEntityResultCallback((SettableFuture)result, future, (DependencyResolver)this.getResolver(), this.clazz);
        return result;
    }

    public V getOperations() {
        return this.operations;
    }
}

