/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.stepwiseplanner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StepwisePlannerConfig {
    public double relevancyThreshold;
    private int maxRelevantFunctions = 100;
    private final Set<String> excludedSkills = new HashSet<String>();
    private final Set<String> excludedFunctions = new HashSet<String>();
    private Set<String> includedFunctions = new HashSet<String>();
    private int maxTokens = 1024;
    private int maxIterations = 100;
    private int minIterationTimeMs = 0;

    public void addExcludedSkills(String restrictedSkillName) {
        this.excludedSkills.add(restrictedSkillName);
    }

    public void addExcludedFunctions(String restrictedFunctionName) {
        this.excludedFunctions.add(restrictedFunctionName);
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public Set<String> getExcludedSkills() {
        return Collections.unmodifiableSet(this.excludedSkills);
    }

    public Set<String> getExcludedFunctions() {
        return Collections.unmodifiableSet(this.excludedFunctions);
    }

    public int getMinIterationTimeMs() {
        return this.minIterationTimeMs;
    }

    public int getMaxRelevantFunctions() {
        return this.maxRelevantFunctions;
    }

    public double getRelevancyThreshold() {
        return this.relevancyThreshold;
    }

    public Set<String> getIncludedFunctions() {
        return Collections.unmodifiableSet(this.includedFunctions);
    }
}

